/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.listener;

import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.wallet.listener.TransactionCreatedListener;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.test.BaseWalletTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TransactionCreatedListenerTest
extends BaseWalletTest {
    @Mock
    private WalletTransactionService walletTransactionService;
    @Mock
    private ListenerService listenerService;
    private TransactionCreatedListener listener;
    private Event<Object, TransactionDetail> event;
    private TransactionDetail transactionDetail;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.transactionDetail = new TransactionDetail();
        this.listener = new TransactionCreatedListener(this.listenerService, this.walletTransactionService);
        this.event = new Event("exo.wallet.transaction.mined", (Object)this.transactionDetail, (Object)this.transactionDetail);
    }

    @Test
    public void testOnEventForInternalWalletWithPendingTransaction() throws Exception {
        this.transactionDetail.setRawTransaction("RawTransaction");
        this.transactionDetail.setPending(true);
        this.listener.onEvent(this.event);
        ((WalletTransactionService)Mockito.verify((Object)this.walletTransactionService, (VerificationMode)Mockito.times((int)1))).cancelTransactionsWithSameNonce(this.transactionDetail);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
    }

    @Test
    public void testOnEventForInternalWalletWithNonPendingTransaction() throws Exception {
        this.transactionDetail.setRawTransaction("RawTransaction");
        this.transactionDetail.setPending(false);
        this.listener.onEvent(this.event);
        ((WalletTransactionService)Mockito.verify((Object)this.walletTransactionService, (VerificationMode)Mockito.times((int)1))).cancelTransactionsWithSameNonce(this.transactionDetail);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
    }

    @Test
    public void testOnEventForExternalWalletWithPendingTransaction() throws Exception {
        this.transactionDetail.setPending(true);
        this.listener.onEvent(this.event);
        ((WalletTransactionService)Mockito.verify((Object)this.walletTransactionService, (VerificationMode)Mockito.times((int)1))).cancelTransactionsWithSameNonce(this.transactionDetail);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.wallet.transaction.sent", (Object)this.transactionDetail, (Object)this.transactionDetail);
    }

    @Test
    public void testOnEventForExternalWalletWithNotPendingTransaction() throws Exception {
        this.transactionDetail.setPending(false);
        this.listener.onEvent(this.event);
        ((WalletTransactionService)Mockito.verify((Object)this.walletTransactionService, (VerificationMode)Mockito.times((int)1))).cancelTransactionsWithSameNonce(this.transactionDetail);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
    }
}

