/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.dao;

import java.util.Collections;
import java.util.List;
import org.exoplatform.wallet.dao.WalletAccountBackupDAO;
import org.exoplatform.wallet.dao.WalletAccountDAO;
import org.exoplatform.wallet.entity.WalletBackupEntity;
import org.exoplatform.wallet.entity.WalletEntity;
import org.exoplatform.wallet.model.WalletProvider;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.test.BaseWalletTest;
import org.junit.Test;

public class WalletAccountBackupDAOTest
extends BaseWalletTest {
    @Test
    public void testServiceInstantiated() {
        WalletAccountBackupDAO walletAccountBackupDAO = this.getService(WalletAccountBackupDAO.class);
        WalletAccountBackupDAOTest.assertNotNull((Object)walletAccountBackupDAO);
        List allBackupWallets = walletAccountBackupDAO.findAll();
        WalletAccountBackupDAOTest.assertNotNull((String)"Returned wallets list shouldn't be null", (Object)allBackupWallets);
        WalletAccountBackupDAOTest.assertEquals((String)"Returned wallets should be empty", (int)0, (int)allBackupWallets.size());
    }

    @Test
    public void testWalletMassiveDeletionDeny() {
        WalletAccountBackupDAO walletAccountBackupDAO = this.getService(WalletAccountBackupDAO.class);
        try {
            walletAccountBackupDAO.deleteAll();
            WalletAccountBackupDAOTest.fail((String)"Shouldn't be able to delete all wallets");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            walletAccountBackupDAO.deleteAll(Collections.emptyList());
            WalletAccountBackupDAOTest.fail((String)"Shouldn't be able to delete multiple wallets in single operation");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testFindByWalletId() {
        WalletAccountBackupDAO walletAccountBackupDAO = this.getService(WalletAccountBackupDAO.class);
        WalletAccountDAO walletAccountDAO = this.getService(WalletAccountDAO.class);
        WalletEntity walletEntity = new WalletEntity();
        String address = "0xc76987D43b77C45d51653b6eB110b9174aCCE8fb";
        walletEntity.setId(Long.valueOf(1L));
        walletEntity.setAddress(address);
        walletEntity.setPassPhrase("passphrase");
        walletEntity.setType(WalletType.USER);
        walletEntity.setProvider(WalletProvider.INTERNAL_WALLET);
        walletEntity = (WalletEntity)walletAccountDAO.create((Object)walletEntity);
        this.entitiesToClean.add(walletEntity);
        WalletAccountBackupDAOTest.assertEquals((Object)WalletProvider.INTERNAL_WALLET, (Object)walletEntity.getProvider());
        WalletBackupEntity walletBackupEntity = new WalletBackupEntity();
        walletBackupEntity.setId(null);
        walletBackupEntity.setWallet(walletEntity);
        walletBackupEntity.setAddress("0x1111111111111111111111111111111111111111");
        walletBackupEntity = (WalletBackupEntity)walletAccountBackupDAO.create((Object)walletBackupEntity);
        this.entitiesToClean.add(walletBackupEntity);
        WalletBackupEntity savedBackupWallet = walletAccountBackupDAO.findByWalletId(walletBackupEntity.getWallet().getId().longValue());
        WalletAccountBackupDAOTest.assertNotNull((Object)savedBackupWallet);
        WalletAccountBackupDAOTest.assertEquals((String)savedBackupWallet.getAddress(), (String)walletBackupEntity.getAddress());
        WalletAccountBackupDAOTest.assertEquals((Object)savedBackupWallet.getWallet().getId(), (Object)walletBackupEntity.getWallet().getId());
    }
}

