/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.service;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Objects;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.wallet.blockchain.BlockchainRequestException;
import org.exoplatform.wallet.blockchain.MaxRequestRateReachedException;
import org.exoplatform.wallet.blockchain.service.EthereumBlockchainTransactionService;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.wallet.model.ContractTransactionEvent;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.test.BaseWalletTest;
import org.exoplatform.wallet.utils.WalletUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

@RunWith(value=MockitoJUnitRunner.class)
public class EthereumBlockchainTransactionServiceTest
extends BaseWalletTest {
    @Mock
    private WalletAccountService accountService;
    @Mock
    private WalletTransactionService transactionService;
    @Mock
    private ListenerService listenerService;
    @Mock
    private SettingService settingService;
    @Mock
    private EthereumClientConnector ethereumClientConnector;
    private EthereumBlockchainTransactionService service;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new EthereumBlockchainTransactionService(this.container, null, this.settingService, this.ethereumClientConnector, this.transactionService, this.accountService, this.listenerService);
    }

    @Test
    public void testOnServiceStartWhenNotPermanentListeningAndNoPendingTransactions() throws Exception {
        long blockNumber = 2559L;
        Mockito.when((Object)this.ethereumClientConnector.getLastestBlockNumber()).thenReturn((Object)blockNumber);
        Mockito.when((Object)this.transactionService.countTransactions()).thenReturn((Object)1L);
        this.service.startAsync();
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.times((int)1))).setLastWatchedBlockNumber(ArgumentMatchers.anyLong());
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SettingValue)ArgumentMatchers.argThat(value -> Objects.equal((Object)value.getValue(), (Object)blockNumber)));
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.times((int)1))).setLastWatchedBlockNumber(blockNumber);
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.never())).renewTransactionListeningSubscription(ArgumentMatchers.anyLong());
    }

    @Test
    public void testOnServiceStartWhenPermanentListening() throws Exception {
        long blockNumber = 2559L;
        SettingValue value = SettingValue.create((Long)blockNumber);
        Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)value);
        Mockito.when((Object)this.ethereumClientConnector.isPermanentlyScanBlockchain()).thenReturn((Object)true);
        Mockito.when((Object)this.ethereumClientConnector.getLastestBlockNumber()).thenReturn((Object)blockNumber);
        Mockito.when((Object)this.transactionService.countTransactions()).thenReturn((Object)1L);
        this.service.startAsync();
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.atLeast((int)1))).setLastWatchedBlockNumber(blockNumber);
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.times((int)1))).renewTransactionListeningSubscription(ArgumentMatchers.anyLong());
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ADDONS_ETHEREUM_LAST_BLOCK_NUMBER0"), (SettingValue)ArgumentMatchers.any());
    }

    @Test
    public void testOnServiceStartWhenNotPermanentListeningButHavePendingTransactions() throws Exception {
        Mockito.when((Object)this.transactionService.countContractPendingTransactionsSent()).thenReturn((Object)1L);
        this.service.startAsync();
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.times((int)1))).renewTransactionListeningSubscription(ArgumentMatchers.anyLong());
    }

    @Test
    public void testHasManagedWalletInTransactionWhenNoTopics() throws Exception {
        ContractTransactionEvent contractTransactionEvent = this.newContractTransactionEvent();
        contractTransactionEvent.setTopics(Collections.emptyList());
        EthereumBlockchainTransactionServiceTest.assertFalse((boolean)this.service.hasManagedWalletInTransaction(contractTransactionEvent));
    }

    @Test
    public void testHasManagedWalletInTransactionWhenNoWalletsAndHavingTopics() throws Exception {
        EthereumBlockchainTransactionServiceTest.assertFalse((boolean)this.service.hasManagedWalletInTransaction(this.newContractTransactionEvent()));
    }

    @Test
    public void testHasManagedWalletInTransactionWhenKnownSenderWallet() throws Exception {
        String fromAddress = "0x2b7e115f52171d164529fdb1ac72571e608a474e";
        Mockito.when((Object)this.accountService.getWalletByAddress((String)ArgumentMatchers.argThat(address -> StringUtils.equalsIgnoreCase((CharSequence)fromAddress, (CharSequence)address)))).thenReturn((Object)new Wallet());
        EthereumBlockchainTransactionServiceTest.assertTrue((boolean)this.service.hasManagedWalletInTransaction(this.newContractTransactionEvent()));
    }

    @Test
    public void testHasManagedWalletInTransactionWhenKnownReceiverWallet() throws Exception {
        String toAddress = "0x1d94f732223996e9f773261e82340889934a6c03";
        Mockito.when((Object)this.accountService.getWalletByAddress((String)ArgumentMatchers.argThat(address -> StringUtils.equalsIgnoreCase((CharSequence)toAddress, (CharSequence)address)))).thenReturn((Object)new Wallet());
        EthereumBlockchainTransactionServiceTest.assertTrue((boolean)this.service.hasManagedWalletInTransaction(this.newContractTransactionEvent()));
    }

    @Test
    public void testRefreshTransactionFromBlockchainWhenTransactionNotFoundOnBlockchainNorDB() throws Exception {
        Assert.assertThrows(IllegalStateException.class, () -> this.service.refreshTransactionFromBlockchain("transactionHash"));
    }

    @Test
    public void testRefreshTransactionFromBlockchainWhenTransactionFoundOnBlockchainButDB() throws Exception {
        String transactionHash = "transactionHash";
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.ethereumClientConnector.getTransaction(transactionHash)).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.getHash()).thenReturn((Object)transactionHash);
        Assert.assertThrows(IllegalStateException.class, () -> this.service.refreshTransactionFromBlockchain(transactionHash));
        Mockito.when((Object)transaction.getBlockHash()).thenReturn((Object)"0x0000000000000000000000000000000000000000000000000000000000000000");
        Assert.assertThrows(IllegalStateException.class, () -> this.service.refreshTransactionFromBlockchain(transactionHash));
        Mockito.when((Object)transaction.getBlockHash()).thenReturn((Object)"blockHash");
        Mockito.when((Object)transaction.getBlockNumber()).thenReturn((Object)BigInteger.TEN);
        this.service.refreshTransactionFromBlockchain(transactionHash);
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.never())).getTransactionReceipt((String)ArgumentMatchers.any());
    }

    @Test
    public void testRefreshTransactionFromBlockchainWhenTransactionFoundOnDBButBlockchain_NoTimeoutNoSendingAttempt() throws Exception {
        String transactionHash = "transactionHash";
        TransactionDetail transactionDetail = new TransactionDetail();
        Mockito.when((Object)this.transactionService.getTransactionByHash(transactionHash)).thenReturn((Object)transactionDetail);
        transactionDetail.setHash(transactionHash);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setNonce(0L);
        transactionDetail.setSendingAttemptCount(0L);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        this.service.refreshTransactionFromBlockchain(transactionHash);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testRefreshTransactionFromBlockchainWhenTransactionFoundOnDBButBlockchain_WithTimeoutNoSendingAttemptMaxReached() throws Exception {
        String transactionHash = "transactionHash";
        TransactionDetail transactionDetail = new TransactionDetail();
        Mockito.when((Object)this.transactionService.getTransactionByHash(transactionHash)).thenReturn((Object)transactionDetail);
        transactionDetail.setHash(transactionHash);
        transactionDetail.setTimestamp(System.currentTimeMillis() - 86400000L - 1L);
        transactionDetail.setPending(true);
        transactionDetail.setRawTransaction(null);
        transactionDetail.setNonce(25L);
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        this.service.refreshTransactionFromBlockchain(transactionHash);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        this.service.refreshTransactionFromBlockchain(transactionHash);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).saveTransactionDetail((TransactionDetail)ArgumentMatchers.argThat(transaction -> !transaction.isPending() && !transaction.isSucceeded() && transaction.getNonce() == 0L), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void testRefreshTransactionFromBlockchainWhenTransactionFoundOnDBButBlockchain_NoTimeoutWithSendingAttemptMaxReached() throws Exception {
        String transactionHash = "transactionHash";
        TransactionDetail transactionDetail = new TransactionDetail();
        Mockito.when((Object)this.transactionService.getTransactionByHash(transactionHash)).thenReturn((Object)transactionDetail);
        transactionDetail.setHash(transactionHash);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setSentTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setNonce(25L);
        transactionDetail.setSendingAttemptCount(1L);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)transactionDetail.getSendingAttemptCount());
        this.service.refreshTransactionFromBlockchain(transactionHash);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testRefreshTransactionFromBlockchainWhenTransactionFoundOnDBButBlockchain_NoTimeoutWithSendingAttemptMaxAndInvalidNonce() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        long nonce = 25L;
        TransactionDetail transactionDetail = new TransactionDetail();
        Mockito.when((Object)this.transactionService.getTransactionByHash(transactionHash)).thenReturn((Object)transactionDetail);
        transactionDetail.setHash(transactionHash);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setSentTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setNonce(nonce);
        transactionDetail.setSendingAttemptCount(0L);
        transactionDetail.setFrom(fromAddress);
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)3L);
        Mockito.when((Object)this.ethereumClientConnector.getNonce(fromAddress)).thenReturn((Object)BigInteger.valueOf(nonce));
        this.service.refreshTransactionFromBlockchain(transactionHash);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        transactionDetail.setSendingAttemptCount(this.transactionService.getMaxAttemptsToSend());
        this.service.refreshTransactionFromBlockchain(transactionHash);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)this.ethereumClientConnector.getNonce(fromAddress)).thenReturn((Object)BigInteger.valueOf(nonce + 2L));
        this.service.refreshTransactionFromBlockchain(transactionHash);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).saveTransactionDetail((TransactionDetail)ArgumentMatchers.argThat(transaction -> !transaction.isPending() && !transaction.isSucceeded() && transaction.getNonce() == 0L), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void testRefreshTransactionFromBlockchainWhenTransactionFoundOnDBAndBlockchain_EtherTransaction() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        String toAddress = "toAddress";
        long nonce = 25L;
        BigInteger transactionNonce = BigInteger.valueOf(nonce);
        TransactionDetail transactionDetail = new TransactionDetail();
        Mockito.when((Object)this.transactionService.getTransactionByHash(transactionHash)).thenReturn((Object)transactionDetail);
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.ethereumClientConnector.getTransaction(transactionHash)).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.getHash()).thenReturn((Object)transactionHash);
        Mockito.when((Object)transaction.getBlockHash()).thenReturn((Object)"blockHash");
        Mockito.when((Object)transaction.getBlockNumber()).thenReturn((Object)BigInteger.TEN);
        Assert.assertThrows(IllegalStateException.class, () -> this.service.refreshTransactionFromBlockchain(transactionHash));
        transactionDetail.setHash(transactionHash);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setSentTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setNonce(nonce);
        transactionDetail.setSendingAttemptCount(1L);
        transactionDetail.setFrom(fromAddress);
        Assert.assertThrows(IllegalStateException.class, () -> this.service.refreshTransactionFromBlockchain(transactionHash));
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        TransactionReceipt transactionReceipt = (TransactionReceipt)Mockito.mock(TransactionReceipt.class);
        Mockito.when((Object)this.ethereumClientConnector.getTransactionReceipt(transactionHash)).thenReturn((Object)transactionReceipt);
        BigInteger gasUsed = BigInteger.ONE;
        BigInteger gasPrice = BigInteger.TWO;
        BigInteger etherValue = BigInteger.valueOf(4L);
        Mockito.when((Object)transactionReceipt.getGasUsed()).thenReturn((Object)gasUsed);
        Mockito.when((Object)transaction.getGasPrice()).thenReturn((Object)gasPrice);
        Mockito.when((Object)transaction.getNonce()).thenReturn((Object)transactionNonce);
        Mockito.when((Object)transaction.getValue()).thenReturn((Object)etherValue);
        Mockito.when((Object)transaction.getFrom()).thenReturn((Object)fromAddress);
        Mockito.when((Object)transaction.getTo()).thenReturn((Object)toAddress);
        this.service.refreshTransactionFromBlockchain(transactionHash);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).saveTransactionDetail((TransactionDetail)ArgumentMatchers.argThat(transactionTmp -> {
            EthereumBlockchainTransactionServiceTest.assertFalse((boolean)transactionTmp.isPending());
            EthereumBlockchainTransactionServiceTest.assertFalse((boolean)transactionTmp.isSucceeded());
            EthereumBlockchainTransactionServiceTest.assertTrue((boolean)StringUtils.isBlank((CharSequence)transactionTmp.getContractAddress()));
            EthereumBlockchainTransactionServiceTest.assertTrue((boolean)StringUtils.isBlank((CharSequence)transactionTmp.getContractMethodName()));
            EthereumBlockchainTransactionServiceTest.assertEquals((double)0.0, (double)transactionTmp.getContractAmount(), (double)0.0);
            EthereumBlockchainTransactionServiceTest.assertEquals((double)gasPrice.doubleValue(), (double)transactionTmp.getGasPrice(), (double)0.0);
            EthereumBlockchainTransactionServiceTest.assertEquals((int)gasUsed.intValue(), (int)transactionTmp.getGasUsed());
            EthereumBlockchainTransactionServiceTest.assertEquals((long)transactionNonce.longValue(), (long)transactionTmp.getNonce());
            EthereumBlockchainTransactionServiceTest.assertEquals((String)toAddress, (String)transactionTmp.getTo());
            EthereumBlockchainTransactionServiceTest.assertEquals((String)fromAddress, (String)transactionTmp.getFrom());
            EthereumBlockchainTransactionServiceTest.assertEquals((double)WalletUtils.convertFromDecimals((BigInteger)etherValue, (int)18), (double)transactionTmp.getValue(), (double)0.0);
            return true;
        }), ArgumentMatchers.eq((boolean)true));
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).cancelTransactionsWithSameNonce((TransactionDetail)ArgumentMatchers.any());
        Mockito.when((Object)transactionReceipt.isStatusOK()).thenReturn((Object)true);
        this.service.refreshTransactionFromBlockchain(transactionHash);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).cancelTransactionsWithSameNonce(transactionDetail);
    }

    @Test
    public void testRefreshTransactionFromBlockchainWhenTransactionFoundOnDBAndBlockchain_ContractTransaction() throws Exception {
        ContractTransactionEvent contractTransactionEvent = this.newContractTransactionEvent();
        String transactionHash = contractTransactionEvent.getTransactionHash();
        String fromAddress = "0x2b7e115f52171d164529fdb1ac72571e608a474e";
        long nonce = 25L;
        BigInteger transactionNonce = BigInteger.valueOf(nonce);
        String contractAddress = WalletUtils.getContractAddress();
        TransactionDetail transactionDetail = new TransactionDetail();
        Mockito.when((Object)this.transactionService.getTransactionByHash(transactionHash)).thenReturn((Object)transactionDetail);
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.ethereumClientConnector.getTransaction(transactionHash)).thenReturn((Object)transaction);
        TransactionReceipt transactionReceipt = (TransactionReceipt)Mockito.mock(TransactionReceipt.class);
        Mockito.when((Object)this.ethereumClientConnector.getTransactionReceipt(transactionHash)).thenReturn((Object)transactionReceipt);
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)log.getTopics()).thenReturn((Object)contractTransactionEvent.getTopics());
        Mockito.when((Object)log.getData()).thenReturn((Object)contractTransactionEvent.getData());
        BigInteger gasUsed = BigInteger.ONE;
        BigInteger gasPrice = BigInteger.TWO;
        BigInteger etherValue = BigInteger.valueOf(4L);
        transactionDetail.setHash(transactionHash);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setSentTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setNonce(nonce);
        transactionDetail.setSendingAttemptCount(1L);
        transactionDetail.setFrom(fromAddress);
        Mockito.when((Object)transactionReceipt.getGasUsed()).thenReturn((Object)gasUsed);
        Mockito.when((Object)transactionReceipt.isStatusOK()).thenReturn((Object)true);
        Mockito.when((Object)transactionReceipt.getLogs()).thenReturn(Collections.singletonList(log));
        Mockito.when((Object)transaction.getGasPrice()).thenReturn((Object)gasPrice);
        Mockito.when((Object)transaction.getNonce()).thenReturn((Object)transactionNonce);
        Mockito.when((Object)transaction.getValue()).thenReturn((Object)etherValue);
        Mockito.when((Object)transaction.getFrom()).thenReturn((Object)fromAddress);
        Mockito.when((Object)transaction.getTo()).thenReturn((Object)contractAddress);
        Mockito.when((Object)transaction.getHash()).thenReturn((Object)transactionHash);
        Mockito.when((Object)transaction.getBlockHash()).thenReturn((Object)"blockHash");
        Mockito.when((Object)transaction.getBlockNumber()).thenReturn((Object)BigInteger.TEN);
        this.service.refreshTransactionFromBlockchain(transactionHash);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).saveTransactionDetail((TransactionDetail)ArgumentMatchers.argThat(transactionTmp -> {
            EthereumBlockchainTransactionServiceTest.assertFalse((boolean)transactionTmp.isPending());
            EthereumBlockchainTransactionServiceTest.assertTrue((boolean)transactionTmp.isSucceeded());
            EthereumBlockchainTransactionServiceTest.assertEquals((double)gasPrice.doubleValue(), (double)transactionTmp.getGasPrice(), (double)0.0);
            EthereumBlockchainTransactionServiceTest.assertEquals((int)gasUsed.intValue(), (int)transactionTmp.getGasUsed());
            EthereumBlockchainTransactionServiceTest.assertEquals((long)transactionNonce.longValue(), (long)transactionTmp.getNonce());
            EthereumBlockchainTransactionServiceTest.assertEquals((String)fromAddress, (String)transactionTmp.getFrom());
            EthereumBlockchainTransactionServiceTest.assertEquals((double)WalletUtils.convertFromDecimals((BigInteger)etherValue, (int)18), (double)transactionTmp.getValue(), (double)0.0);
            EthereumBlockchainTransactionServiceTest.assertEquals((String)"transfer", (String)transactionTmp.getContractMethodName());
            EthereumBlockchainTransactionServiceTest.assertTrue((transactionTmp.getContractAmount() > 0.0 ? 1 : 0) != 0);
            EthereumBlockchainTransactionServiceTest.assertEquals((String)contractAddress, (String)transactionTmp.getContractAddress());
            return true;
        }), ArgumentMatchers.eq((boolean)true));
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).cancelTransactionsWithSameNonce(transactionDetail);
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_NoTransactions() throws Exception {
        this.service.sendPendingTransactionsToBlockchain();
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.never())).sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any());
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_TimedOutPendingTransaction() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis() - 86400000L - 1L);
        transactionDetail.setPending(true);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setNonce(25L);
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        List sentTransactions = this.service.sendPendingTransactionsToBlockchain();
        EthereumBlockchainTransactionServiceTest.assertNotNull((Object)sentTransactions);
        EthereumBlockchainTransactionServiceTest.assertEquals((int)0, (int)sentTransactions.size());
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.never())).sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService)).saveTransactionDetail((TransactionDetail)ArgumentMatchers.argThat(t -> !t.isPending() && !t.isSucceeded()), ArgumentMatchers.anyBoolean());
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        this.service.sendPendingTransactionsToBlockchain();
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector)).sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any());
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_MaxAttemptsToSendReachedButNotSentToBlockchain() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setNonce(25L);
        transactionDetail.setSendingAttemptCount(0L);
        TransactionDetail originalTransactionDetail = transactionDetail.clone();
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CompletableFuture resultFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AtomicReference handler = new AtomicReference();
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any())).thenReturn((Object)future);
        Mockito.when((Object)future.handle((BiFunction)ArgumentMatchers.any())).thenAnswer(invocation -> {
            handler.set((BiFunction)invocation.getArgument(0, BiFunction.class));
            return resultFuture;
        });
        Mockito.when((Object)((TransactionDetail)resultFuture.get())).thenAnswer(invocation -> ((BiFunction)handler.get()).apply((EthSendTransaction)Mockito.mock(EthSendTransaction.class), new IOException()));
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        Assert.assertThrows(BlockchainRequestException.class, () -> this.service.sendPendingTransactionsToBlockchain());
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.times((int)1))).sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        EthereumBlockchainTransactionServiceTest.assertEquals((Object)originalTransactionDetail, (Object)transactionDetail);
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_MaxAttemptsToSendReachedAndAlreadySentToBlockchain() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setNonce(25L);
        transactionDetail.setSendingAttemptCount(1L);
        transactionDetail.setSentTimestamp(System.currentTimeMillis());
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        this.service.sendPendingTransactionsToBlockchain();
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.never())).sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_IsNotBoostAndIsMaxParallelRequestsReached() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setNonce(25L);
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        TransactionDetail originalTransactionDetail = transactionDetail.clone();
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.lenient().when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)false);
        this.service.sendPendingTransactionsToBlockchain();
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.never())).sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast((String)ArgumentMatchers.any(), ArgumentMatchers.any(), ArgumentMatchers.any());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        EthereumBlockchainTransactionServiceTest.assertEquals((Object)originalTransactionDetail, (Object)transactionDetail);
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_IsBoostAndIsMaxParallelRequestsReached() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setBoost(true);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setNonce(25L);
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        TransactionDetail originalTransactionDetail = transactionDetail.clone();
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.lenient().when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CompletableFuture resultFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AtomicReference handler = new AtomicReference();
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any())).thenReturn((Object)future);
        Mockito.when((Object)future.handle((BiFunction)ArgumentMatchers.any())).thenAnswer(invocation -> {
            handler.set((BiFunction)invocation.getArgument(0, BiFunction.class));
            return resultFuture;
        });
        Mockito.when((Object)((TransactionDetail)resultFuture.get())).thenAnswer(invocation -> ((BiFunction)handler.get()).apply((EthSendTransaction)Mockito.mock(EthSendTransaction.class), new IOException()));
        Assert.assertThrows(BlockchainRequestException.class, () -> this.service.sendPendingTransactionsToBlockchain());
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.times((int)1))).sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        EthereumBlockchainTransactionServiceTest.assertEquals((Object)originalTransactionDetail, (Object)transactionDetail);
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_IsSendingBlockchainRequestFutureNull() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setNonce(25L);
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        TransactionDetail originalTransactionDetail = transactionDetail.clone();
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain(transactionDetail)).thenReturn(null);
        this.service.sendPendingTransactionsToBlockchain();
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.times((int)1))).sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        EthereumBlockchainTransactionServiceTest.assertEquals((Object)originalTransactionDetail, (Object)transactionDetail);
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_CancelModificationsWhenSendingException() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setNonce(25L);
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain(transactionDetail)).thenThrow(new Throwable[]{new IOException()});
        Assert.assertThrows(BlockchainRequestException.class, () -> this.service.sendPendingTransactionsToBlockchain());
        ((EthereumClientConnector)Mockito.verify((Object)this.ethereumClientConnector, (VerificationMode)Mockito.times((int)1))).sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_ResentWithAttemptIncrementWhenIOExceptionFromWeb3() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setSendingAttemptCount(0L);
        TransactionDetail transactionDetail2 = transactionDetail.clone();
        transactionDetail2.setHash(transactionHash + "2");
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Arrays.asList(transactionDetail, transactionDetail2));
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CompletableFuture resultFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AtomicReference handler = new AtomicReference();
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any())).thenReturn((Object)future);
        Mockito.when((Object)future.handle((BiFunction)ArgumentMatchers.any())).thenAnswer(invocation -> {
            handler.set((BiFunction)invocation.getArgument(0, BiFunction.class));
            return resultFuture;
        });
        Mockito.when((Object)((TransactionDetail)resultFuture.get())).thenAnswer(invocation -> ((BiFunction)handler.get()).apply((EthSendTransaction)Mockito.mock(EthSendTransaction.class), new IOException()));
        Assert.assertThrows(BlockchainRequestException.class, () -> this.service.sendPendingTransactionsToBlockchain());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_ResentWithAttemptIncrementWhenSentTransactionIsNull() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setNonce(10L);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CompletableFuture resultFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AtomicReference handler = new AtomicReference();
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any())).thenReturn((Object)future);
        Mockito.when((Object)future.handle((BiFunction)ArgumentMatchers.any())).thenAnswer(invocation -> {
            handler.set((BiFunction)invocation.getArgument(0, BiFunction.class));
            return resultFuture;
        });
        Mockito.when((Object)((TransactionDetail)resultFuture.get())).thenAnswer(invocation -> ((BiFunction)handler.get()).apply(null, null));
        List pendingTransactions = this.service.sendPendingTransactionsToBlockchain();
        EthereumBlockchainTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        EthereumBlockchainTransactionServiceTest.assertEquals((int)0, (int)pendingTransactions.size());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).saveTransactionDetail((TransactionDetail)ArgumentMatchers.argThat(transaction -> transaction.isPending() && !transaction.isSucceeded() && transaction.getNonce() == 10L), ArgumentMatchers.eq((boolean)false));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.wallet.transaction.sent"), ArgumentMatchers.any(), ArgumentMatchers.any());
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_ResentWithAttemptIncrementWhenSentTransactionHasDiffrentHash() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setNonce(10L);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CompletableFuture resultFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AtomicReference handler = new AtomicReference();
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any())).thenReturn((Object)future);
        Mockito.when((Object)future.handle((BiFunction)ArgumentMatchers.any())).thenAnswer(invocation -> {
            handler.set((BiFunction)invocation.getArgument(0, BiFunction.class));
            return resultFuture;
        });
        this.service.sendPendingTransactionsToBlockchain();
        EthSendTransaction ethTransaction = (EthSendTransaction)Mockito.mock(EthSendTransaction.class);
        String newHash = "transactionHash2";
        Mockito.when((Object)ethTransaction.getTransactionHash()).thenReturn((Object)newHash);
        Mockito.when((Object)((TransactionDetail)resultFuture.get())).thenAnswer(invocation -> ((BiFunction)handler.get()).apply(ethTransaction, null));
        List pendingTransactions = this.service.sendPendingTransactionsToBlockchain();
        EthereumBlockchainTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        EthereumBlockchainTransactionServiceTest.assertEquals((int)1, (int)pendingTransactions.size());
        TransactionDetail handledTransactionDetail = (TransactionDetail)pendingTransactions.get(0);
        EthereumBlockchainTransactionServiceTest.assertNotNull((Object)handledTransactionDetail);
        EthereumBlockchainTransactionServiceTest.assertTrue((handledTransactionDetail.getSentTimestamp() > 0L ? 1 : 0) != 0);
        EthereumBlockchainTransactionServiceTest.assertEquals((long)-200L, (long)handledTransactionDetail.getSendingAttemptCount());
        EthereumBlockchainTransactionServiceTest.assertEquals((String)newHash, (String)handledTransactionDetail.getHash());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).saveTransactionDetail((TransactionDetail)ArgumentMatchers.argThat(transaction -> transaction.isPending() && !transaction.isSucceeded() && transaction.getNonce() == 10L), ArgumentMatchers.eq((boolean)false));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.wallet.transaction.sent", (Object)handledTransactionDetail, (Object)handledTransactionDetail);
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_ResentWithAttemptIncrementWhenSentTransactionHasError() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setNonce(10L);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CompletableFuture resultFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AtomicReference handler = new AtomicReference();
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any())).thenReturn((Object)future);
        Mockito.when((Object)future.handle((BiFunction)ArgumentMatchers.any())).thenAnswer(invocation -> {
            handler.set((BiFunction)invocation.getArgument(0, BiFunction.class));
            return resultFuture;
        });
        this.service.sendPendingTransactionsToBlockchain();
        EthSendTransaction ethTransaction = (EthSendTransaction)Mockito.mock(EthSendTransaction.class);
        Response.Error transactionError = (Response.Error)Mockito.mock(Response.Error.class);
        Mockito.when((Object)ethTransaction.getError()).thenReturn((Object)transactionError);
        Mockito.when((Object)((TransactionDetail)resultFuture.get())).thenAnswer(invocation -> ((BiFunction)handler.get()).apply(ethTransaction, null));
        List pendingTransactions = this.service.sendPendingTransactionsToBlockchain();
        EthereumBlockchainTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        EthereumBlockchainTransactionServiceTest.assertEquals((int)0, (int)pendingTransactions.size());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).saveTransactionDetail((TransactionDetail)ArgumentMatchers.argThat(transaction -> transaction.isPending() && !transaction.isSucceeded() && transaction.getNonce() == 10L), ArgumentMatchers.eq((boolean)false));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_RefreshWhenSentTransactionHasNonceTooLowErrorAndReceipt() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setNonce(10L);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CompletableFuture resultFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AtomicReference handler = new AtomicReference();
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any())).thenReturn((Object)future);
        Mockito.when((Object)future.handle((BiFunction)ArgumentMatchers.any())).thenAnswer(invocation -> {
            handler.set((BiFunction)invocation.getArgument(0, BiFunction.class));
            return resultFuture;
        });
        EthSendTransaction ethTransaction = (EthSendTransaction)Mockito.mock(EthSendTransaction.class);
        Response.Error transactionError = (Response.Error)Mockito.mock(Response.Error.class);
        Mockito.when((Object)ethTransaction.getError()).thenReturn((Object)transactionError);
        TransactionReceipt receipt = (TransactionReceipt)Mockito.mock(TransactionReceipt.class);
        Mockito.when((Object)this.ethereumClientConnector.getTransactionReceipt(transactionHash)).thenReturn((Object)receipt);
        Mockito.when((Object)transactionError.getMessage()).thenReturn((Object)"Error: nonce too low");
        Mockito.when((Object)((TransactionDetail)resultFuture.get())).thenAnswer(invocation -> ((BiFunction)handler.get()).apply(ethTransaction, null));
        List pendingTransactions = this.service.sendPendingTransactionsToBlockchain();
        EthereumBlockchainTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        EthereumBlockchainTransactionServiceTest.assertEquals((int)0, (int)pendingTransactions.size());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_StopSendingWhenRequestRateLimitReached() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setNonce(10L);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CompletableFuture resultFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AtomicReference handler = new AtomicReference();
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any())).thenReturn((Object)future);
        Mockito.when((Object)future.handle((BiFunction)ArgumentMatchers.any())).thenAnswer(invocation -> {
            handler.set((BiFunction)invocation.getArgument(0, BiFunction.class));
            return resultFuture;
        });
        EthSendTransaction ethTransaction = (EthSendTransaction)Mockito.mock(EthSendTransaction.class);
        Response.Error transactionError = (Response.Error)Mockito.mock(Response.Error.class);
        Mockito.when((Object)ethTransaction.getError()).thenReturn((Object)transactionError);
        Mockito.when((Object)transactionError.getCode()).thenReturn((Object)429);
        Mockito.when((Object)((TransactionDetail)resultFuture.get())).thenAnswer(invocation -> ((BiFunction)handler.get()).apply(ethTransaction, null));
        Assert.assertThrows(MaxRequestRateReachedException.class, () -> this.service.sendPendingTransactionsToBlockchain());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_ResentWithAttemptIncrementWhenSentTransactionHasUnrecoverableError() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setNonce(10L);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CompletableFuture resultFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AtomicReference handler = new AtomicReference();
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any())).thenReturn((Object)future);
        Mockito.when((Object)future.handle((BiFunction)ArgumentMatchers.any())).thenAnswer(invocation -> {
            handler.set((BiFunction)invocation.getArgument(0, BiFunction.class));
            return resultFuture;
        });
        EthSendTransaction ethTransaction = (EthSendTransaction)Mockito.mock(EthSendTransaction.class);
        Response.Error transactionError = (Response.Error)Mockito.mock(Response.Error.class);
        Mockito.when((Object)ethTransaction.getError()).thenReturn((Object)transactionError);
        Mockito.when((Object)transactionError.getMessage()).thenReturn((Object)"Error: insufficient funds");
        Mockito.when((Object)((TransactionDetail)resultFuture.get())).thenAnswer(invocation -> ((BiFunction)handler.get()).apply(ethTransaction, null));
        List pendingTransactions = this.service.sendPendingTransactionsToBlockchain();
        EthereumBlockchainTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        EthereumBlockchainTransactionServiceTest.assertEquals((int)0, (int)pendingTransactions.size());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).saveTransactionDetail((TransactionDetail)ArgumentMatchers.argThat(transaction -> !transaction.isPending() && !transaction.isSucceeded() && transaction.getNonce() == 0L), ArgumentMatchers.eq((boolean)true));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
    }

    @Test
    public void testSendPendingTransactionsToBlockchain_AvoidBroadcastingTransactionWhenAlreadySentToBlockchain() throws Exception {
        String transactionHash = "transactionHash";
        String fromAddress = "fromAddress";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(fromAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setPending(true);
        transactionDetail.setNonce(10L);
        transactionDetail.setRawTransaction("RAW_TRANSACTION");
        transactionDetail.setSendingAttemptCount(0L);
        Mockito.when((Object)this.transactionService.getTransactionsToSend()).thenReturn(Collections.singletonList(transactionDetail));
        Mockito.when((Object)this.transactionService.getPendingTransactionMaxDays()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.getMaxAttemptsToSend()).thenReturn((Object)1L);
        Mockito.when((Object)this.transactionService.canSendTransactionToBlockchain(fromAddress)).thenReturn((Object)true);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CompletableFuture resultFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        AtomicReference handler = new AtomicReference();
        Mockito.when((Object)this.ethereumClientConnector.sendTransactionToBlockchain((TransactionDetail)ArgumentMatchers.any())).thenReturn((Object)future);
        Mockito.when((Object)future.handle((BiFunction)ArgumentMatchers.any())).thenAnswer(invocation -> {
            handler.set((BiFunction)invocation.getArgument(0, BiFunction.class));
            return resultFuture;
        });
        EthSendTransaction ethTransaction = (EthSendTransaction)Mockito.mock(EthSendTransaction.class);
        Response.Error transactionError = (Response.Error)Mockito.mock(Response.Error.class);
        Mockito.when((Object)ethTransaction.getError()).thenReturn((Object)transactionError);
        Mockito.when((Object)transactionError.getMessage()).thenReturn((Object)"Error: Already known");
        Mockito.when((Object)((TransactionDetail)resultFuture.get())).thenAnswer(invocation -> ((BiFunction)handler.get()).apply(ethTransaction, null));
        List pendingTransactions = this.service.sendPendingTransactionsToBlockchain();
        EthereumBlockchainTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        EthereumBlockchainTransactionServiceTest.assertEquals((int)1, (int)pendingTransactions.size());
        TransactionDetail handledTransactionDetail = (TransactionDetail)pendingTransactions.get(0);
        EthereumBlockchainTransactionServiceTest.assertNotNull((Object)handledTransactionDetail);
        EthereumBlockchainTransactionServiceTest.assertTrue((handledTransactionDetail.getSentTimestamp() > 0L ? 1 : 0) != 0);
        EthereumBlockchainTransactionServiceTest.assertEquals((long)-200L, (long)handledTransactionDetail.getSendingAttemptCount());
        EthereumBlockchainTransactionServiceTest.assertTrue((boolean)handledTransactionDetail.isPending());
        EthereumBlockchainTransactionServiceTest.assertFalse((boolean)handledTransactionDetail.isSucceeded());
        EthereumBlockchainTransactionServiceTest.assertEquals((long)10L, (long)handledTransactionDetail.getNonce());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).saveTransactionDetail((TransactionDetail)ArgumentMatchers.argThat(transaction -> transaction.isPending() && !transaction.isSucceeded() && transaction.getNonce() == 10L), ArgumentMatchers.eq((boolean)false));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.wallet.transaction.sent", (Object)handledTransactionDetail, (Object)handledTransactionDetail);
    }
}

