/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.service;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.model.transaction.TransactionStatistics;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.test.BaseWalletTest;
import org.junit.Assert;
import org.junit.Test;

public class WalletTransactionServiceTest
extends BaseWalletTest {
    @Test
    public void testContainerStart() {
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        WalletTransactionServiceTest.assertNotNull((Object)walletTransactionService);
    }

    @Test
    public void testSaveTransactionDetail() {
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        TransactionDetail transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", "0x3333333333333333333333333333333333333333", 9L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, null, System.currentTimeMillis());
        walletTransactionService.saveTransactionDetail(transactionDetail, true);
        TransactionDetail storedTransactionDetail = walletTransactionService.getTransactionByHash(transactionDetail.getHash());
        WalletTransactionServiceTest.assertNotNull((Object)storedTransactionDetail);
        WalletTransactionServiceTest.assertEquals((Object)transactionDetail, (Object)storedTransactionDetail);
        this.entitiesToClean.add(storedTransactionDetail);
    }

    @Test
    public void testCancelTransactionDetail() {
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        TransactionDetail transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", "0x3333333333333333333333333333333333333333", 9L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, null, System.currentTimeMillis());
        walletTransactionService.saveTransactionDetail(transactionDetail, true);
        TransactionDetail storedTransactionDetail = walletTransactionService.getTransactionByHash(transactionDetail.getHash());
        TransactionDetail transactionDetailReplacement = storedTransactionDetail.clone();
        transactionDetailReplacement.setHash(this.generateTransactionHash());
        transactionDetailReplacement.setId(0L);
        transactionDetailReplacement.setPending(true);
        walletTransactionService.saveTransactionDetail(transactionDetailReplacement, true);
        TransactionDetail storedTransactionDetailReplacement = walletTransactionService.getTransactionByHash(transactionDetailReplacement.getHash());
        this.entitiesToClean.add(storedTransactionDetail);
        this.entitiesToClean.add(storedTransactionDetailReplacement);
        WalletTransactionServiceTest.assertNotNull((Object)storedTransactionDetail);
        WalletTransactionServiceTest.assertNotNull((Object)storedTransactionDetailReplacement);
        WalletTransactionServiceTest.assertEquals((long)storedTransactionDetail.getNonce(), (long)storedTransactionDetailReplacement.getNonce());
        Assert.assertNotEquals((Object)storedTransactionDetail.getHash(), (Object)storedTransactionDetailReplacement.getHash());
        final AtomicBoolean listenerInvoked = new AtomicBoolean(false);
        ListenerService listenerService = this.getService(ListenerService.class);
        listenerService.addListener("exo.wallet.transaction.replaced", (ListenerBase)new Listener<Object, Object>(this){

            public void onEvent(Event<Object, Object> event) throws Exception {
                listenerInvoked.set(true);
            }
        });
        TransactionDetail errorReplacingTransaction = storedTransactionDetailReplacement.clone();
        errorReplacingTransaction.setFrom("another address");
        walletTransactionService.cancelTransactionsWithSameNonce(errorReplacingTransaction);
        WalletTransactionServiceTest.assertFalse((boolean)listenerInvoked.get());
        storedTransactionDetail.setPending(true);
        walletTransactionService.saveTransactionDetail(storedTransactionDetail, true);
        errorReplacingTransaction = storedTransactionDetailReplacement.clone();
        errorReplacingTransaction.setTo("Another address");
        walletTransactionService.cancelTransactionsWithSameNonce(errorReplacingTransaction);
        storedTransactionDetail = walletTransactionService.getTransactionByHash(transactionDetail.getHash());
        WalletTransactionServiceTest.assertFalse((boolean)storedTransactionDetail.isPending());
        WalletTransactionServiceTest.assertFalse((boolean)storedTransactionDetail.isSucceeded());
        WalletTransactionServiceTest.assertEquals((long)0L, (long)storedTransactionDetail.getNonce());
        WalletTransactionServiceTest.assertFalse((boolean)listenerInvoked.get());
        storedTransactionDetail.setPending(true);
        storedTransactionDetail.setNonce(storedTransactionDetailReplacement.getNonce());
        walletTransactionService.saveTransactionDetail(storedTransactionDetail, true);
        errorReplacingTransaction = storedTransactionDetailReplacement.clone();
        errorReplacingTransaction.setContractAmount(5000.0);
        walletTransactionService.cancelTransactionsWithSameNonce(errorReplacingTransaction);
        storedTransactionDetail = walletTransactionService.getTransactionByHash(transactionDetail.getHash());
        WalletTransactionServiceTest.assertFalse((boolean)storedTransactionDetail.isPending());
        WalletTransactionServiceTest.assertFalse((boolean)storedTransactionDetail.isSucceeded());
        WalletTransactionServiceTest.assertEquals((long)0L, (long)storedTransactionDetail.getNonce());
        WalletTransactionServiceTest.assertFalse((boolean)listenerInvoked.get());
        storedTransactionDetail.setPending(true);
        storedTransactionDetail.setNonce(storedTransactionDetailReplacement.getNonce());
        walletTransactionService.saveTransactionDetail(storedTransactionDetail, true);
        errorReplacingTransaction = storedTransactionDetailReplacement.clone();
        errorReplacingTransaction.setContractAddress("another address");
        walletTransactionService.cancelTransactionsWithSameNonce(errorReplacingTransaction);
        storedTransactionDetail = walletTransactionService.getTransactionByHash(transactionDetail.getHash());
        WalletTransactionServiceTest.assertFalse((boolean)storedTransactionDetail.isPending());
        WalletTransactionServiceTest.assertFalse((boolean)storedTransactionDetail.isSucceeded());
        WalletTransactionServiceTest.assertEquals((long)0L, (long)storedTransactionDetail.getNonce());
        WalletTransactionServiceTest.assertFalse((boolean)listenerInvoked.get());
        storedTransactionDetail.setPending(true);
        storedTransactionDetail.setNonce(storedTransactionDetailReplacement.getNonce());
        walletTransactionService.saveTransactionDetail(storedTransactionDetail, true);
        walletTransactionService.cancelTransactionsWithSameNonce(storedTransactionDetailReplacement);
        WalletTransactionServiceTest.assertTrue((boolean)listenerInvoked.get());
    }

    @Test
    public void testSaveTransactionDetailForCurrentUser() throws IllegalAccessException {
        this.addCurrentUserWallet();
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        ListenerService listenerService = this.getService(ListenerService.class);
        final AtomicInteger createdTriggerCount = new AtomicInteger();
        listenerService.addListener("exo.wallet.transaction.created", (ListenerBase)new Listener<TransactionDetail, TransactionDetail>(this){

            public void onEvent(Event<TransactionDetail, TransactionDetail> event) throws Exception {
                createdTriggerCount.incrementAndGet();
            }
        });
        final AtomicInteger modifiedTriggerCount = new AtomicInteger();
        listenerService.addListener("exo.wallet.transaction.modified", (ListenerBase)new Listener<TransactionDetail, TransactionDetail>(this){

            public void onEvent(Event<TransactionDetail, TransactionDetail> event) throws Exception {
                modifiedTriggerCount.incrementAndGet();
            }
        });
        TransactionDetail transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", null, 1L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, null, System.currentTimeMillis());
        try {
            walletTransactionService.saveTransactionDetail(transactionDetail, "root9");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        WalletTransactionServiceTest.assertEquals((int)1, (int)createdTriggerCount.get());
        WalletTransactionServiceTest.assertEquals((int)0, (int)modifiedTriggerCount.get());
        createdTriggerCount.set(0);
        walletTransactionService.saveTransactionDetail(transactionDetail, "root1");
        WalletTransactionServiceTest.assertEquals((int)0, (int)createdTriggerCount.get());
        WalletTransactionServiceTest.assertEquals((int)1, (int)modifiedTriggerCount.get());
        modifiedTriggerCount.set(0);
        TransactionDetail storedTransactionDetail = walletTransactionService.getTransactionByHash(transactionDetail.getHash());
        WalletTransactionServiceTest.assertNotNull((Object)storedTransactionDetail);
        WalletTransactionServiceTest.assertEquals((Object)transactionDetail, (Object)storedTransactionDetail);
        this.entitiesToClean.add(storedTransactionDetail);
        transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", null, 1L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, "RAW_TRANSACTION", System.currentTimeMillis());
        WalletTransactionServiceTest.assertEquals((int)1, (int)createdTriggerCount.get());
        WalletTransactionServiceTest.assertEquals((int)0, (int)modifiedTriggerCount.get());
        createdTriggerCount.set(0);
        walletTransactionService.saveTransactionDetail(transactionDetail, "root1");
        storedTransactionDetail = walletTransactionService.getTransactionByHash(transactionDetail.getHash());
        WalletTransactionServiceTest.assertNotNull((Object)storedTransactionDetail);
        WalletTransactionServiceTest.assertEquals((Object)transactionDetail, (Object)storedTransactionDetail);
        WalletTransactionServiceTest.assertEquals((int)0, (int)createdTriggerCount.get());
        WalletTransactionServiceTest.assertEquals((int)1, (int)modifiedTriggerCount.get());
        modifiedTriggerCount.set(0);
        transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", null, 1L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, false, false, null, System.currentTimeMillis());
        WalletTransactionServiceTest.assertEquals((int)1, (int)createdTriggerCount.get());
        WalletTransactionServiceTest.assertEquals((int)0, (int)modifiedTriggerCount.get());
        createdTriggerCount.set(0);
        walletTransactionService.saveTransactionDetail(transactionDetail, "root1");
        storedTransactionDetail = walletTransactionService.getTransactionByHash(transactionDetail.getHash());
        WalletTransactionServiceTest.assertNotNull((Object)storedTransactionDetail);
        WalletTransactionServiceTest.assertEquals((Object)transactionDetail, (Object)storedTransactionDetail);
        this.entitiesToClean.add(storedTransactionDetail);
        WalletTransactionServiceTest.assertEquals((int)0, (int)createdTriggerCount.get());
        WalletTransactionServiceTest.assertEquals((int)1, (int)modifiedTriggerCount.get());
    }

    @Test
    public void testGetPendingTransactionMaxDays() {
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        long count = walletTransactionService.getPendingTransactionMaxDays();
        WalletTransactionServiceTest.assertEquals((String)"Wrong default value for 'Pending transaction MaxDays'", (long)1L, (long)count);
    }

    @Test
    public void testGetTransactionByHash() {
        this.addCurrentUserWallet();
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        TransactionDetail transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", "0x3333333333333333333333333333333333333333", 9L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, null, System.currentTimeMillis());
        walletTransactionService.saveTransactionDetail(transactionDetail, true);
        TransactionDetail storedTransactionDetail = walletTransactionService.getTransactionByHash(transactionDetail.getHash());
        WalletTransactionServiceTest.assertNotNull((Object)storedTransactionDetail);
        this.entitiesToClean.add(storedTransactionDetail);
    }

    @Test
    public void testGetPendingTransactionByHash() {
        this.addCurrentUserWallet();
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        TransactionDetail transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", "0x3333333333333333333333333333333333333333", 9L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, null, System.currentTimeMillis());
        walletTransactionService.saveTransactionDetail(transactionDetail, true);
        TransactionDetail storedTransactionDetail = walletTransactionService.getPendingTransactionByHash(transactionDetail.getHash());
        WalletTransactionServiceTest.assertNotNull((Object)storedTransactionDetail);
        this.entitiesToClean.add(storedTransactionDetail);
    }

    @Test
    public void testCountTransactionsByNonce() {
        this.addCurrentUserWallet();
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        TransactionDetail transactionDetail1 = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", "0x3333333333333333333333333333333333333333", 9L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, null, System.currentTimeMillis());
        TransactionDetail transactionDetail2 = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", "0x3333333333333333333333333333333333333333", 9L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, null, System.currentTimeMillis());
        walletTransactionService.saveTransactionDetail(transactionDetail1, true);
        walletTransactionService.saveTransactionDetail(transactionDetail2, true);
        long countOfTransactions = walletTransactionService.countPendingTransactionsWithSameNonce(transactionDetail1.getHash(), transactionDetail1.getFrom(), transactionDetail1.getNonce());
        WalletTransactionServiceTest.assertEquals((long)1L, (long)countOfTransactions);
        this.entitiesToClean.add(transactionDetail1);
        this.entitiesToClean.add(transactionDetail2);
    }

    @Test
    public void testGetNonce() throws Exception {
        this.addCurrentUserWallet();
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        TransactionDetail transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", "0x3333333333333333333333333333333333333333", 9L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, null, System.currentTimeMillis());
        Assert.assertThrows(IllegalAccessException.class, () -> walletTransactionService.getNonce("0x1111111111111111111111111111111111111111", "root9"));
        long nonce = walletTransactionService.getNonce("0x1111111111111111111111111111111111111111", "root1");
        WalletTransactionServiceTest.assertEquals((long)11L, (long)nonce);
        transactionDetail.setNonce(0L);
        walletTransactionService.saveTransactionDetail(transactionDetail, false);
        nonce = walletTransactionService.getNonce("0x1111111111111111111111111111111111111111", "root1");
        WalletTransactionServiceTest.assertEquals((String)"When a pending transaction has nonce 0 (whole first transaction of a wallet, it should return 1 for next nonce to use) ", (long)1L, (long)nonce);
        transactionDetail.setNonce(10L);
        transactionDetail.setPending(false);
        walletTransactionService.saveTransactionDetail(transactionDetail, false);
        nonce = walletTransactionService.getNonce("0x1111111111111111111111111111111111111111", "root1");
        WalletTransactionServiceTest.assertEquals((String)"No Pending transaction of wallet in database, thus the nonce should be retrieved from UI using a dedicated call on blockchain", (long)0L, (long)nonce);
        try {
            nonce = walletTransactionService.getNonce("0x1111111111111111111111111111111111111111", "root1");
            WalletTransactionServiceTest.assertEquals((long)0L, (long)nonce);
        }
        catch (IllegalAccessException e) {
            WalletTransactionServiceTest.fail((String)"Unexpected error while getting nonce of wallet");
        }
    }

    @Test
    public void testGetTransactionStatistics() {
        String YEAR_PERIODICITY = "year";
        String MONTH_PERIODICITY = "month";
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        try {
            walletTransactionService.getTransactionStatistics(null, YEAR_PERIODICITY, "2022-01-14", Locale.ENGLISH);
            WalletTransactionServiceTest.fail((String)"Address should not be empty!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletTransactionService.getTransactionStatistics("0x1111111111111111111111111111111111111111", null, "2022-01-14", Locale.ENGLISH);
            WalletTransactionServiceTest.fail((String)"Periodicity should not be empty!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TransactionStatistics transactionStatistics = walletTransactionService.getTransactionStatistics("0x1111111111111111111111111111111111111111", YEAR_PERIODICITY, "2022-01-14", Locale.ENGLISH);
        WalletTransactionServiceTest.assertNotNull((Object)transactionStatistics);
        transactionStatistics = walletTransactionService.getTransactionStatistics("0x1111111111111111111111111111111111111111", MONTH_PERIODICITY, "2022-01-14", Locale.ENGLISH);
        WalletTransactionServiceTest.assertNotNull((Object)transactionStatistics);
    }

    @Test
    public void testGetTransactionByHashAndUser() {
        this.addCurrentUserWallet();
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        TransactionDetail transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", null, 1L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, null, System.currentTimeMillis());
        walletTransactionService.saveTransactionDetail(transactionDetail, true);
        TransactionDetail storedTransactionDetail = walletTransactionService.getTransactionByHash(transactionDetail.getHash(), "root9");
        WalletTransactionServiceTest.assertNotNull((Object)storedTransactionDetail);
        this.entitiesToClean.add(storedTransactionDetail);
        WalletTransactionServiceTest.assertNull((String)"Other users shouldn't be able to access label of transaction of others", (Object)storedTransactionDetail.getLabel());
        WalletTransactionServiceTest.assertNotNull((String)"Other users should be able to access message of transaction of others", (Object)storedTransactionDetail.getMessage());
        storedTransactionDetail = walletTransactionService.getTransactionByHash(transactionDetail.getHash(), "root1");
        WalletTransactionServiceTest.assertNotNull((Object)storedTransactionDetail);
        WalletTransactionServiceTest.assertNotNull((String)"Current user should be able to access label of his transaction", (Object)storedTransactionDetail.getLabel());
    }

    @Test
    public void testCanSendTransactionToBlockchain() {
        this.addCurrentUserWallet();
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        long maxAttemptsToSend = walletTransactionService.getMaxParallelPendingTransactions();
        int i = 0;
        while ((long)i < maxAttemptsToSend) {
            WalletTransactionServiceTest.assertTrue((boolean)walletTransactionService.canSendTransactionToBlockchain("0x1111111111111111111111111111111111111111"));
            TransactionDetail transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", null, 1L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, "RAW_TRANSACTION", System.currentTimeMillis());
            transactionDetail.setSentTimestamp(System.currentTimeMillis());
            walletTransactionService.saveTransactionDetail(transactionDetail, false);
            this.entitiesToClean.add(transactionDetail);
            ++i;
        }
        WalletTransactionServiceTest.assertFalse((boolean)walletTransactionService.canSendTransactionToBlockchain("0x1111111111111111111111111111111111111111"));
    }

    @Test
    public void testGetTransactionsToSend() {
        this.addCurrentUserWallet();
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        List listOfTransactionsToSend = walletTransactionService.getTransactionsToSend();
        WalletTransactionServiceTest.assertNotNull((Object)listOfTransactionsToSend);
        WalletTransactionServiceTest.assertEquals((int)0, (int)listOfTransactionsToSend.size());
        TransactionDetail transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", null, 1L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, "RAW_TRANSACTION", System.currentTimeMillis());
        walletTransactionService.saveTransactionDetail(transactionDetail, false);
        this.entitiesToClean.add(transactionDetail);
        listOfTransactionsToSend = walletTransactionService.getTransactionsToSend();
        WalletTransactionServiceTest.assertNotNull((Object)listOfTransactionsToSend);
        WalletTransactionServiceTest.assertEquals((int)1, (int)listOfTransactionsToSend.size());
        transactionDetail.setPending(false);
        walletTransactionService.saveTransactionDetail(transactionDetail, false);
        listOfTransactionsToSend = walletTransactionService.getTransactionsToSend();
        WalletTransactionServiceTest.assertNotNull((Object)listOfTransactionsToSend);
        WalletTransactionServiceTest.assertEquals((int)0, (int)listOfTransactionsToSend.size());
    }

    @Test
    public void testGetPendingWalletTransactionsHashes() {
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        List pendingTransactions = walletTransactionService.getPendingWalletTransactionsNotSent("0x1111111111111111111111111111111111111111");
        WalletTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        WalletTransactionServiceTest.assertEquals((int)0, (int)pendingTransactions.size());
        pendingTransactions = walletTransactionService.getPendingWalletTransactionsSent("0x1111111111111111111111111111111111111111");
        WalletTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        WalletTransactionServiceTest.assertEquals((int)0, (int)pendingTransactions.size());
        TransactionDetail pendingTransactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", "0x3333333333333333333333333333333333333333", 9L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, null, System.currentTimeMillis());
        this.entitiesToClean.add(pendingTransactionDetail);
        TransactionDetail transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", "0x3333333333333333333333333333333333333333", 9L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", true, false, true, null, System.currentTimeMillis());
        this.entitiesToClean.add(transactionDetail);
        WalletTransactionServiceTest.assertEquals((long)1L, (long)walletTransactionService.countContractPendingTransactionsSent());
        pendingTransactions = walletTransactionService.getPendingWalletTransactionsSent("0x1111111111111111111111111111111111111111");
        WalletTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        WalletTransactionServiceTest.assertEquals((int)1, (int)pendingTransactions.size());
        WalletTransactionServiceTest.assertEquals((String)pendingTransactionDetail.getHash(), (String)((TransactionDetail)pendingTransactions.iterator().next()).getHash());
        pendingTransactions = walletTransactionService.getPendingWalletTransactionsNotSent("0x1111111111111111111111111111111111111111");
        WalletTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        WalletTransactionServiceTest.assertEquals((int)0, (int)pendingTransactions.size());
        pendingTransactionDetail.setSentTimestamp(0L);
        pendingTransactionDetail.setSendingAttemptCount(0L);
        pendingTransactionDetail.setRawTransaction("RAW_TRANSACTION");
        walletTransactionService.saveTransactionDetail(pendingTransactionDetail, false);
        WalletTransactionServiceTest.assertEquals((long)0L, (long)walletTransactionService.countContractPendingTransactionsSent());
        pendingTransactions = walletTransactionService.getPendingWalletTransactionsSent("0x1111111111111111111111111111111111111111");
        WalletTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        WalletTransactionServiceTest.assertEquals((int)0, (int)pendingTransactions.size());
        pendingTransactions = walletTransactionService.getPendingWalletTransactionsNotSent("0x1111111111111111111111111111111111111111");
        WalletTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        WalletTransactionServiceTest.assertEquals((int)1, (int)pendingTransactions.size());
        WalletTransactionServiceTest.assertEquals((String)pendingTransactionDetail.getHash(), (String)((TransactionDetail)pendingTransactions.iterator().next()).getHash());
    }

    @Test
    public void testCountContractPendingTransactionsToSend() {
        WalletTransactionService walletTransactionService = this.getService(WalletTransactionService.class);
        List pendingTransactions = walletTransactionService.getPendingWalletTransactionsNotSent("0x1111111111111111111111111111111111111111");
        WalletTransactionServiceTest.assertNotNull((Object)pendingTransactions);
        WalletTransactionServiceTest.assertEquals((int)0, (int)pendingTransactions.size());
        TransactionDetail pendingTransactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", "0x3333333333333333333333333333333333333333", 9L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, false, "RAW_TRANSACTION", System.currentTimeMillis());
        pendingTransactionDetail.setSentTimestamp(0L);
        walletTransactionService.saveTransactionDetail(pendingTransactionDetail, false);
        this.entitiesToClean.add(pendingTransactionDetail);
        TransactionDetail transactionDetail = this.createTransactionDetail(this.generateTransactionHash(), "transferFrom", 500.0, 0.001, "0x1111111111111111111111111111111111111111", "0x2222222222222222222222222222222222222222", "0x3333333333333333333333333333333333333333", 9L, "TRANSACTION_LABEL", "TRANSACTION_MESSAGE", false, true, true, "RAW_TRANSACTION", System.currentTimeMillis());
        transactionDetail.setSentTimestamp(System.currentTimeMillis());
        walletTransactionService.saveTransactionDetail(transactionDetail, false);
        this.entitiesToClean.add(transactionDetail);
        WalletTransactionServiceTest.assertEquals((long)1L, (long)walletTransactionService.countContractPendingTransactionsSent());
        WalletTransactionServiceTest.assertEquals((long)1L, (long)walletTransactionService.countContractPendingTransactionsToSend());
    }
}

