/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.wallet.dao.AddressLabelDAO;
import org.exoplatform.wallet.entity.AddressLabelEntity;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.WalletAddressLabel;
import org.exoplatform.wallet.model.WalletProvider;
import org.exoplatform.wallet.model.WalletState;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletAccountServiceImpl;
import org.exoplatform.wallet.service.WalletTokenAdminService;
import org.exoplatform.wallet.storage.AddressLabelStorage;
import org.exoplatform.wallet.storage.WalletStorage;
import org.exoplatform.wallet.test.BaseWalletTest;
import org.exoplatform.wallet.utils.WalletUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class WalletAccountServiceTest
extends BaseWalletTest {
    private static final String NEW = "NEW";

    @Test
    public void testContainerStart() {
        WalletAccountServiceTest.assertNotNull((Object)this.getService(ListenerService.class));
        WalletAccountServiceTest.assertNotNull((Object)this.getService(WalletAccountService.class));
        WalletAccountServiceTest.assertNotNull((Object)this.getService(AddressLabelDAO.class));
    }

    @Test
    public void testDefaultParameters() {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        WalletAccountServiceTest.assertNotNull((String)"Wallet account service shouldn't be null", (Object)walletAccountService);
    }

    @Test
    public void testSaveWalletAddress() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        try {
            Wallet walletTest = new Wallet();
            walletTest.setTechnicalId(1L);
            walletTest.setAddress("");
            walletTest.setPassPhrase("passphrase");
            walletTest.setEnabled(true);
            walletTest.setInitializationState(INITIALIZATION_STATE);
            walletAccountService.saveWalletAddress(walletTest, "root1");
            WalletAccountServiceTest.fail((String)"Wallet address is mandatory");
        }
        catch (Exception walletTest) {
            // empty catch block
        }
        try {
            walletAccountService.saveWalletAddress(null, "root1");
            WalletAccountServiceTest.fail((String)"Wallet shouldn't be null");
        }
        catch (IllegalArgumentException walletTest) {
            // empty catch block
        }
        Wallet wallet = this.newWallet();
        wallet.setPassPhrase("");
        walletAccountService.saveWalletAddress(wallet, "root1");
        this.entitiesToClean.add(wallet);
        Wallet storedWallet = walletAccountService.getWalletByAddress(wallet.getAddress());
        WalletAccountServiceTest.assertNotNull((Object)storedWallet);
        WalletAccountServiceTest.assertNotNull((Object)storedWallet.getPassPhrase());
        String addressTest = storedWallet.getAddress();
        WalletAccountServiceTest.assertEquals((String)"Unexpected wallet address", (String)StringUtils.lowerCase((String)"0x1111111111111111111111111111111111111111"), (String)StringUtils.lowerCase((String)addressTest));
    }

    @Test
    public void testSaveWallet() throws IllegalAccessException {
        String walletAddress = "0x11111111155511111111111111111111111111";
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Wallet userWallet = walletAccountService.createWalletInstance(WalletProvider.METAMASK, walletAddress, 1L);
        this.getService(SettingService.class).remove(Context.USER.id("root1"), WalletUtils.WALLET_SCOPE, "WALLET_INITIALIZED");
        final AtomicInteger increment = new AtomicInteger(0);
        this.getService(ListenerService.class).addListener("exo.wallet.addressAssociation.new", (ListenerBase)new Listener<Object, String>(this){

            public void onEvent(Event<Object, String> event) throws Exception {
                increment.incrementAndGet();
            }
        });
        userWallet = walletAccountService.saveWallet(userWallet, true);
        this.entitiesToClean.add(userWallet);
        Wallet storedWallet = walletAccountService.getWalletByAddress(walletAddress);
        WalletAccountServiceTest.assertNotNull((Object)storedWallet);
        WalletAccountServiceTest.assertNotNull((Object)storedWallet.getPassPhrase());
        WalletAccountServiceTest.assertEquals((String)"Unexpected wallet address", (String)StringUtils.lowerCase((String)walletAddress), (String)StringUtils.lowerCase((String)storedWallet.getAddress()));
        WalletAccountServiceTest.assertEquals((int)1, (int)increment.get());
        increment.set(0);
        walletAccountService.saveWallet(userWallet, true);
        WalletAccountServiceTest.assertEquals((int)0, (int)increment.get());
    }

    @Test
    public void testGetWalletsCount() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        this.entitiesToClean.add(wallet);
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        long walletCount = walletAccountService.getWalletsCount();
        WalletAccountServiceTest.assertEquals((String)"Returned wallets count should be 1", (long)1L, (long)walletCount);
    }

    @Test
    public void testGetWalletByAddress() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        this.entitiesToClean.add(wallet);
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        try {
            String address = null;
            walletAccountService.getWalletByAddress(address);
            WalletAccountServiceTest.fail((String)"Wallet address shouldn't be null");
        }
        catch (Exception address) {
            // empty catch block
        }
        Wallet walletTest = walletAccountService.getWalletByAddress("0x1111111111111111111111111111111111111111");
        WalletAccountServiceTest.assertNotNull((String)"Shouldn't find wallet with not recognized address", (Object)walletTest);
    }

    @Test
    public void testGetWalletByTypeAndIdAndUser() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        this.entitiesToClean.add(wallet);
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Wallet walletTest = walletAccountService.getWalletByTypeAndId(WalletType.USER.name(), "root1", "root1");
        WalletAccountServiceTest.assertNotNull((String)"Shouldn't find wallet with not recognized type and id", (Object)walletTest);
    }

    @Test
    public void testGetWalletByTypeAndId() {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Wallet wallet = this.newWallet();
        try {
            walletAccountService.getWalletByTypeAndId(WalletType.USER.name(), "");
            WalletAccountServiceTest.fail((String)"RemoteId is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        wallet = walletStorage.saveWallet(wallet, true);
        this.entitiesToClean.add(wallet);
        Wallet walletTest = walletAccountService.getWalletByTypeAndId(WalletType.USER.name(), "root1");
        WalletAccountServiceTest.assertNotNull((String)"Shouldn't find wallet with not recognized type and id", (Object)walletTest);
    }

    @Test
    public void testGetAdminWallet() {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Wallet wallet = walletAccountService.getAdminWallet();
        WalletAccountServiceTest.assertNotNull((String)"Shouldn't find null admin wallet", (Object)wallet);
        this.entitiesToClean.add(wallet);
        wallet.setAddress("0x3333333333333333333333333333333333333333");
        wallet.setPassPhrase("passphrase");
        wallet.setInitializationState(INITIALIZATION_STATE);
        walletAccountService.saveWallet(wallet, false);
        WalletAccountServiceTest.assertNull((Object)wallet.getEtherBalance());
        this.restartTransaction();
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        double etherBalance = 5.22;
        double tokenBalance = 655.33;
        wallet.setEtherBalance(Double.valueOf(etherBalance));
        wallet.setTokenBalance(Double.valueOf(tokenBalance));
        walletStorage.saveWalletBlockchainState(wallet, WalletUtils.getContractAddress());
        wallet = walletAccountService.getAdminWallet();
        WalletAccountServiceTest.assertNotNull((String)"Shouldn't find null admin wallet", (Object)wallet);
        WalletAccountServiceTest.assertNotNull((Object)wallet.getEtherBalance());
        WalletAccountServiceTest.assertEquals((Object)etherBalance, (Object)wallet.getEtherBalance());
        WalletAccountServiceTest.assertNotNull((Object)wallet.getTokenBalance());
        WalletAccountServiceTest.assertEquals((Object)tokenBalance, (Object)wallet.getTokenBalance());
    }

    @Test
    public void testIsWalletOwner() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        this.entitiesToClean.add(wallet);
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        WalletAccountServiceTest.assertFalse((boolean)walletAccountService.isWalletOwner(null, "root1"));
        WalletAccountServiceTest.assertTrue((boolean)walletAccountService.isWalletOwner(wallet, "root1"));
    }

    @Test
    public void testSavePrivateKeyByTypeAndIdAndContent() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        try {
            walletAccountService.savePrivateKeyByTypeAndId(WalletType.USER.name(), "root1", "content", "root1");
            WalletAccountServiceTest.fail((String)"Shouldn't be able to save private key of not existant wallet");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Wallet wallet = this.newWallet();
        walletAccountService.saveWalletAddress(wallet, "root1");
        this.entitiesToClean.add(wallet);
        String privateKeyContent = "Private key";
        walletAccountService.savePrivateKeyByTypeAndId(WalletType.USER.name(), "root1", privateKeyContent, "root1");
        String storedPrivateKey = walletAccountService.getPrivateKeyByTypeAndId(WalletType.USER.name(), "root1", "root1");
        WalletAccountServiceTest.assertEquals((String)"Wallet private key should be equal", (String)privateKeyContent, (String)storedPrivateKey);
    }

    @Test
    public void testGetWalletByIdentityId() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        try {
            walletAccountService.getWalletByIdentityId(0L);
            WalletAccountServiceTest.fail((String)"IdentityId is mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Wallet wallet = walletAccountService.getWalletByIdentityId(100L);
        WalletAccountServiceTest.assertNull((Object)wallet);
        wallet = this.newWallet();
        walletAccountService.saveWalletAddress(wallet, "root1");
        this.entitiesToClean.add(wallet);
        wallet = walletAccountService.getWalletByIdentityId(wallet.getTechnicalId());
        WalletAccountServiceTest.assertNotNull((Object)wallet);
    }

    @Test
    public void testListWallets() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Wallet wallet = this.newWallet();
        walletAccountService.saveWalletAddress(wallet, "root1");
        this.entitiesToClean.add(wallet);
        Set wallets = walletAccountService.listWallets();
        WalletAccountServiceTest.assertNotNull((Object)wallets);
        WalletAccountServiceTest.assertEquals((int)1, (int)wallets.size());
    }

    @Test
    public void testRemovePrivateKeyByTypeAndId() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Wallet wallet = this.newWallet();
        walletAccountService.saveWalletAddress(wallet, "root1");
        this.entitiesToClean.add(wallet);
        String content = "Private key";
        walletAccountService.savePrivateKeyByTypeAndId(WalletType.USER.name(), "root1", content, "root1");
        String privateKey = walletAccountService.getPrivateKeyByTypeAndId(WalletType.USER.name(), "root1", "root1");
        WalletAccountServiceTest.assertEquals((String)content, (String)privateKey);
        try {
            walletAccountService.removePrivateKeyByTypeAndId(WalletType.USER.name(), "root1", "root9");
            WalletAccountServiceTest.fail((String)"Should fail: another user attempts to delete a wallet of another user");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        walletAccountService.removePrivateKeyByTypeAndId(WalletType.USER.name(), "root1", "root1");
        String privateKeyTset = walletAccountService.getPrivateKeyByTypeAndId(WalletType.USER.name(), "root1", "root1");
        WalletAccountServiceTest.assertNull((String)"Private key should be null after remove", (Object)privateKeyTset);
    }

    @Test
    public void testSaveOrDeleteAddressLabel() {
        WalletAddressLabel walletAddressLabel2;
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        AddressLabelDAO addressLabelDAO = this.getService(AddressLabelDAO.class);
        try {
            walletAccountService.saveOrDeleteAddressLabel(null, "root1");
            WalletAccountServiceTest.fail((String)"Label is empty");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAddressLabel2 = new WalletAddressLabel();
            String label = "Save address label";
            int identityId = 1;
            walletAddressLabel2.setId(2L);
            walletAddressLabel2.setAddress("0x1111111111111111111111111111111111111111");
            walletAddressLabel2.setIdentityId((long)identityId);
            walletAddressLabel2.setLabel(label);
            walletAccountService.saveOrDeleteAddressLabel(walletAddressLabel2, "user");
            WalletAccountServiceTest.fail((String)"Identity is null, incorrect user");
        }
        catch (Exception walletAddressLabel2) {
            // empty catch block
        }
        walletAddressLabel2 = new WalletAddressLabel();
        int identityId = 2;
        walletAddressLabel2.setAddress("0x1111111111111111111111111111111111111111");
        walletAddressLabel2.setId(1L);
        walletAddressLabel2.setIdentityId((long)identityId);
        WalletAddressLabel labelTest = walletAccountService.saveOrDeleteAddressLabel(walletAddressLabel2, "root1");
        WalletAccountServiceTest.assertNotNull((String)"Wallet address label shouldn't be null", (Object)labelTest);
        AddressLabelEntity labelEntity = (AddressLabelEntity)addressLabelDAO.find((Serializable)Long.valueOf(walletAddressLabel2.getId()));
        this.entitiesToClean.add(labelEntity);
    }

    @Test
    public void testGetAddressesLabelsVisibleBy() {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        WalletAddressLabel walletAddressLabel = new WalletAddressLabel();
        String label = "Save address label";
        int identityId = 1;
        walletAddressLabel.setAddress("0x1111111111111111111111111111111111111111");
        walletAddressLabel.setIdentityId((long)identityId);
        walletAddressLabel.setLabel(label);
        WalletAddressLabel labelTset = walletAccountService.saveOrDeleteAddressLabel(walletAddressLabel, "root1");
        WalletAccountServiceTest.assertNotNull((String)"Wallet address label shouldn't be null", (Object)labelTset);
        Set walletTestLabel = walletAccountService.getAddressesLabelsVisibleBy("root1");
        WalletAccountServiceTest.assertNotNull((String)"Wallet address label Shouldn't be empty", (Object)walletTestLabel);
        this.entitiesToClean.add(labelTset);
    }

    @Test
    public void testGetPrivateKeyByTypeAndIdAndUser() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Wallet wallet = this.newWallet();
        walletAccountService.saveWalletAddress(wallet, "root1");
        this.entitiesToClean.add(wallet);
        String content = "Private key";
        walletAccountService.savePrivateKeyByTypeAndId(WalletType.USER.name(), "root1", content, "root1");
        try {
            walletAccountService.getPrivateKeyByTypeAndId(WalletType.USER.name(), "root0", "root0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.getPrivateKeyByTypeAndId(WalletType.ADMIN.name(), "root1", "root1");
            WalletAccountServiceTest.fail((String)"User is not allowed to access private key of admin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String privateKey = walletAccountService.getPrivateKeyByTypeAndId(WalletType.USER.name(), "root1", "root1");
        WalletAccountServiceTest.assertNotNull((String)"Wallet private key shouldn't be null", (Object)privateKey);
    }

    @Test
    public void testGetPrivateKeyByTypeAndId() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Wallet wallet = this.newWallet();
        String content = "Save private key";
        walletAccountService.saveWalletAddress(wallet, "root1");
        WalletAccountServiceTest.assertNotNull((Object)wallet);
        walletAccountService.savePrivateKeyByTypeAndId(WalletType.USER.name(), "root1", content, "root1");
        String privateKey = walletAccountService.getPrivateKeyByTypeAndId(WalletType.USER.name(), "root1");
        WalletAccountServiceTest.assertNotNull((String)"Wallet private key shouldn't be null", (Object)privateKey);
        this.entitiesToClean.add(wallet);
    }

    @Test
    public void testRemoveWalletByAddress() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        try {
            walletAccountService.removeWalletByAddress(null, "root1");
            WalletAccountServiceTest.fail((String)"Wallet address is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Wallet wallet = this.newWallet();
        walletAccountService.saveWalletAddress(wallet, "root1");
        WalletAccountServiceTest.assertNotNull((Object)wallet);
        this.entitiesToClean.add(wallet);
        try {
            walletAccountService.removeWalletByAddress("", "root1");
            WalletAccountServiceTest.fail((String)"Wallet shouldn't be null");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.removeWalletByAddress("0x1111111111111111111111111111111111111111", "root2");
            WalletAccountServiceTest.fail((String)"User is not user rewarding admin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        walletAccountService.removeWalletByAddress("0x1111111111111111111111111111111111111111", "root1");
        Set wallets = walletAccountService.listWallets();
        WalletAccountServiceTest.assertEquals((String)"Wallet list Should be empty", (int)0, (int)wallets.size());
        this.entitiesToClean.remove(wallet);
    }

    @Test
    public void testRemoveWalletByTypeAndId() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        IdentityRegistry identityRegistry = this.getService(IdentityRegistry.class);
        MembershipEntry entry = new MembershipEntry("/platform/rewarding", "*");
        HashSet<MembershipEntry> entryTest = new HashSet<MembershipEntry>();
        entryTest.add(entry);
        Identity identity = new Identity("root1", entryTest);
        identityRegistry.register(identity);
        Wallet wallet = this.newWallet();
        walletAccountService.saveWalletAddress(wallet, "root1");
        this.entitiesToClean.add(wallet);
        try {
            walletAccountService.removeWalletByTypeAndId("", "root1", "root1");
            WalletAccountServiceTest.fail((String)"Wallet type is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.removeWalletByTypeAndId(wallet.getType(), "", "root1");
            WalletAccountServiceTest.fail((String)"Wallet remoteId is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.removeWalletByTypeAndId(wallet.getType(), "root2", "root2");
            WalletAccountServiceTest.fail((String)"User is not user rewarding admin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.removeWalletByTypeAndId(wallet.getType(), "root3", "root1");
            WalletAccountServiceTest.fail((String)"Can't find wallet with this remoteId");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String type = wallet.getType();
        walletAccountService.removeWalletByTypeAndId(type, "root1", "root1");
        Set wallets = walletAccountService.listWallets();
        WalletAccountServiceTest.assertTrue((String)"Wallet list Should be empty", (boolean)wallets.isEmpty());
    }

    @Test
    public void testEnableWalletByAddress() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        IdentityRegistry identityRegistry = this.getService(IdentityRegistry.class);
        MembershipEntry entry = new MembershipEntry("/platform/rewarding", "*");
        HashSet<MembershipEntry> entryTest = new HashSet<MembershipEntry>();
        entryTest.add(entry);
        Identity identity = new Identity("root1", entryTest);
        identityRegistry.register(identity);
        Wallet wallet = this.newWallet();
        walletAccountService.saveWalletAddress(wallet, "root1");
        WalletAccountServiceTest.assertNotNull((Object)wallet);
        this.entitiesToClean.add(wallet);
        try {
            walletAccountService.enableWalletByAddress(null, true, "root1");
            WalletAccountServiceTest.fail((String)"Wallet address is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.enableWalletByAddress("walletAdressUser", true, "root1");
            WalletAccountServiceTest.fail((String)"Shouldn't enable a wallet with unknown address");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.enableWalletByAddress("0x1111111111111111111111111111111111111111", false, "root2");
            WalletAccountServiceTest.fail((String)"User is not user rewarding admin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        WalletAccountServiceTest.assertTrue((boolean)walletAccountService.enableWalletByAddress("0x1111111111111111111111111111111111111111", false, "root1"));
        wallet = walletAccountService.getWalletByAddress("0x1111111111111111111111111111111111111111");
        WalletAccountServiceTest.assertFalse((boolean)wallet.isEnabled());
        WalletAccountServiceTest.assertFalse((boolean)walletAccountService.enableWalletByAddress("0x1111111111111111111111111111111111111111", false, "root1"));
        wallet = walletAccountService.getWalletByAddress("0x1111111111111111111111111111111111111111");
        WalletAccountServiceTest.assertFalse((boolean)wallet.isEnabled());
        WalletAccountServiceTest.assertTrue((boolean)walletAccountService.enableWalletByAddress("0x1111111111111111111111111111111111111111", true, "root1"));
        wallet = walletAccountService.getWalletByAddress("0x1111111111111111111111111111111111111111");
        WalletAccountServiceTest.assertTrue((boolean)wallet.isEnabled());
    }

    @Test
    public void testSetInitializationStatus() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Wallet wallet = this.newWallet();
        WalletAccountServiceTest.assertNotNull((Object)wallet);
        walletAccountService.saveWalletAddress(wallet, "root1");
        try {
            walletAccountService.setInitializationStatus(null, WalletState.NEW, "root1");
            WalletAccountServiceTest.fail((String)"Wallet address is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.setInitializationStatus("0x1111111111111111111111111111111111111111", WalletState.NEW, "");
            WalletAccountServiceTest.fail((String)"Username is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.setInitializationStatus("0x1111111111111111111111111111111111111111", null, "root1");
            WalletAccountServiceTest.fail((String)"InitializationState is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.setInitializationStatus("walletAdressUser", WalletState.NEW, "root1");
            WalletAccountServiceTest.fail((String)"Can't find wallet associated to address");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.setInitializationStatus("0x1111111111111111111111111111111111111111", WalletState.NEW, "root2");
            WalletAccountServiceTest.fail((String)"User is not user rewarding admin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        walletAccountService.setInitializationStatus("0x1111111111111111111111111111111111111111", WalletState.NEW, "root1");
        WalletAccountServiceTest.assertEquals((String)"Wallet initial status Should be NEW", (String)NEW, (String)wallet.getInitializationState());
        this.entitiesToClean.add(wallet);
    }

    @Test
    public void testSetInitializationStatusWallet() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Wallet wallet = this.newWallet();
        WalletAccountServiceTest.assertNotNull((Object)wallet);
        walletAccountService.saveWalletAddress(wallet, "root1");
        try {
            walletAccountService.setInitializationStatus(null, WalletState.NEW);
            WalletAccountServiceTest.fail((String)"Wallet address is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletAccountService.setInitializationStatus("0x1111111111111111111111111111111111111111", null);
            WalletAccountServiceTest.fail((String)"InitializationState is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        walletAccountService.setInitializationStatus("0x1111111111111111111111111111111111111111", WalletState.NEW);
        WalletAccountServiceTest.assertEquals((String)"Wallet initial status Should be NEW", (String)NEW, (String)wallet.getInitializationState());
        this.entitiesToClean.add(wallet);
    }

    @Test
    public void testGetAdminAccountPassword() {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        String password = walletAccountService.getAdminAccountPassword();
        WalletAccountServiceTest.assertNotNull((Object)password);
    }

    public void testSwitchWalletProvider() {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        String walletAddress = "0x927f51a2996Ff74d1C380F92DC9006b53A225CeF";
        String rawMessage = "-2037692822791791745-3891968992033463560-1384458414145506416";
        String signedMessage = "0x92874882ac3b2292dc4a05af2f0eceac48fee97392a26d8bc9002159c35279ac0b72729cbdd6e864696782176a39a5cdfbca45c3eec5b34e1f82d2a906356a7d1c";
        Wallet wallet = walletAccountService.saveWallet(this.newWallet(), true);
        long technicalId = wallet.getTechnicalId();
        Assert.assertThrows(IllegalStateException.class, () -> walletAccountService.switchWalletProvider(technicalId, WalletProvider.METAMASK, "", rawMessage, signedMessage));
        Assert.assertThrows(IllegalStateException.class, () -> walletAccountService.switchWalletProvider(technicalId, WalletProvider.METAMASK, walletAddress, "", signedMessage));
        Assert.assertThrows(IllegalStateException.class, () -> walletAccountService.switchWalletProvider(technicalId, WalletProvider.METAMASK, walletAddress, rawMessage, "signedMessage"));
        walletAccountService.switchWalletProvider(wallet.getTechnicalId(), WalletProvider.METAMASK, walletAddress, rawMessage, signedMessage);
        Wallet savedWallet = walletAccountService.getWalletByIdentityId(1L);
        WalletAccountServiceTest.assertNotNull((Object)savedWallet);
        WalletAccountServiceTest.assertEquals((String)WalletProvider.METAMASK.name(), (String)savedWallet.getProvider());
        this.entitiesToClean.add(savedWallet);
    }

    @Test
    public void testSwitchToInternalWallet() throws IllegalAccessException {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        String internalWalletAddress = "0x1111111111111111111111111111111111111111";
        String privateKeyContent = "content";
        String walletAddress = "0x927f51a2996Ff74d1C380F92DC9006b53A225CeF";
        String rawMessage = "-2037692822791791745-3891968992033463560-1384458414145506416";
        String signedMessage = "0x92874882ac3b2292dc4a05af2f0eceac48fee97392a26d8bc9002159c35279ac0b72729cbdd6e864696782176a39a5cdfbca45c3eec5b34e1f82d2a906356a7d1c";
        Wallet wallet = this.newWallet();
        wallet.setAddress(internalWalletAddress);
        wallet.setBackedUp(true);
        wallet.setInitializationState(WalletState.INITIALIZED.name());
        wallet.setIsInitialized(Boolean.valueOf(true));
        wallet = walletAccountService.saveWallet(wallet, true);
        this.entitiesToClean.add(wallet);
        walletAccountService.savePrivateKeyByTypeAndId(WalletType.USER.name(), "root1", privateKeyContent, "root1");
        walletAccountService.switchWalletProvider(wallet.getTechnicalId(), WalletProvider.METAMASK, walletAddress, rawMessage, signedMessage);
        wallet = walletAccountService.getWalletByIdentityId(1L);
        WalletAccountServiceTest.assertNotNull((Object)wallet);
        WalletAccountServiceTest.assertEquals((String)WalletProvider.METAMASK.name(), (String)wallet.getProvider());
        WalletAccountServiceTest.assertEquals((String)StringUtils.lowerCase((String)walletAddress), (String)wallet.getAddress());
        WalletAccountServiceTest.assertTrue((boolean)wallet.isBackedUp());
        WalletAccountServiceTest.assertTrue((boolean)wallet.getIsInitialized());
        WalletAccountServiceTest.assertEquals((String)WalletState.INITIALIZED.name(), (String)wallet.getInitializationState());
        walletAccountService.switchToInternalWallet(wallet.getTechnicalId());
        wallet = walletAccountService.getWalletByIdentityId(1L);
        WalletAccountServiceTest.assertNotNull((Object)wallet);
        WalletAccountServiceTest.assertEquals((String)StringUtils.lowerCase((String)internalWalletAddress), (String)wallet.getAddress());
        WalletAccountServiceTest.assertEquals((String)WalletProvider.INTERNAL_WALLET.name(), (String)wallet.getProvider());
        WalletAccountServiceTest.assertTrue((boolean)wallet.isBackedUp());
        WalletAccountServiceTest.assertTrue((boolean)wallet.getIsInitialized());
        WalletAccountServiceTest.assertEquals((String)WalletState.MODIFIED.name(), (String)wallet.getInitializationState());
    }

    @Test
    public void testCreateWalletInstance() {
        String walletAddress = "0x927f51a2996FJ74d1C380F92DC9006b53A225CeF";
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Assert.assertThrows(IllegalArgumentException.class, () -> walletAccountService.createWalletInstance(WalletProvider.METAMASK, null, 1L));
        Assert.assertThrows(IllegalArgumentException.class, () -> walletAccountService.createWalletInstance(null, walletAddress, 1L));
        Wallet wallet = walletAccountService.createWalletInstance(WalletProvider.METAMASK, walletAddress, 1L);
        WalletAccountServiceTest.assertNotNull((Object)wallet);
        WalletAccountServiceTest.assertEquals((String)walletAddress.toLowerCase(), (String)wallet.getAddress().toLowerCase());
        WalletAccountServiceTest.assertEquals((String)WalletProvider.METAMASK.name(), (String)wallet.getProvider());
    }

    @Test
    public void testRefreshWalletFromBlockchain() throws Exception {
        WalletStorage accountStorage = (WalletStorage)Mockito.mock(WalletStorage.class);
        ListenerService listenerService = (ListenerService)Mockito.mock(ListenerService.class);
        WalletTokenAdminService tokenAdminService = (WalletTokenAdminService)Mockito.mock(WalletTokenAdminService.class);
        WalletAccountServiceImpl walletAccountService = new WalletAccountServiceImpl((PortalContainer)Mockito.mock(PortalContainer.class), accountStorage, (AddressLabelStorage)Mockito.mock(AddressLabelStorage.class), (SettingService)Mockito.mock(SettingService.class), (InitParams)Mockito.mock(InitParams.class));
        walletAccountService.setTokenAdminService(tokenAdminService);
        walletAccountService.setListenerService(listenerService);
        String walletAddress = "walletAddress";
        String contractAddress = "contractAddress";
        ContractDetail contractDetail = (ContractDetail)Mockito.mock(ContractDetail.class);
        Mockito.when((Object)contractDetail.getAddress()).thenReturn((Object)contractAddress);
        HashMap walletModifications = new HashMap();
        HashSet modifications = new HashSet();
        walletModifications.put(walletAddress, modifications);
        walletAccountService.refreshWalletFromBlockchain(null, contractDetail, walletModifications);
        Mockito.verifyNoInteractions((Object[])new Object[]{accountStorage, listenerService, tokenAdminService, contractDetail});
        Wallet wallet = new Wallet();
        wallet.setAddress(walletAddress);
        ((WalletStorage)Mockito.doAnswer(invocation -> {
            wallet.setEtherBalance(Double.valueOf(0.02));
            wallet.setTokenBalance(Double.valueOf(3.02));
            return null;
        }).when((Object)accountStorage)).retrieveWalletBlockchainState(wallet, contractAddress);
        ((WalletTokenAdminService)Mockito.doNothing().when((Object)tokenAdminService)).retrieveWalletInformationFromBlockchain(wallet, contractDetail, modifications);
        walletAccountService.refreshWalletFromBlockchain(wallet, contractDetail, walletModifications);
        ((ListenerService)Mockito.verify((Object)listenerService, (VerificationMode)Mockito.never())).broadcast((String)ArgumentMatchers.eq((Object)"exo.wallet.modified"), ArgumentMatchers.eq(null), (Object)((Wallet)ArgumentMatchers.any(Wallet.class)));
        Mockito.reset((Object[])new WalletTokenAdminService[]{tokenAdminService});
        ((WalletTokenAdminService)Mockito.doAnswer(invocation -> {
            wallet.setEtherBalance(Double.valueOf(0.03));
            wallet.setTokenBalance(Double.valueOf(3.05));
            return null;
        }).when((Object)tokenAdminService)).retrieveWalletInformationFromBlockchain(wallet, contractDetail, modifications);
        walletAccountService.refreshWalletFromBlockchain(wallet, contractDetail, walletModifications);
        ((ListenerService)Mockito.verify((Object)listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.wallet.modified"), ArgumentMatchers.eq(null), (Object)((Wallet)ArgumentMatchers.any(Wallet.class)));
    }
}

