/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.listener;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.model.transaction.TransactionNotificationType;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.utils.WalletUtils;

@Asynchronous
public class TransactionNotificationListener
extends Listener<Object, TransactionDetail> {
    private static final Log LOG = ExoLogger.getLogger(TransactionNotificationListener.class);
    private ExoContainer container;
    private WalletTransactionService transactionService;
    private WalletAccountService walletAccountService;

    public TransactionNotificationListener(PortalContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Object, TransactionDetail> event) throws Exception {
        TransactionDetail transactionDetail = (TransactionDetail)event.getData();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String contractAdminAddress;
            String transactionHash = transactionDetail.getHash();
            if (StringUtils.isBlank((CharSequence)transactionHash) || StringUtils.isBlank((CharSequence)transactionDetail.getContractAddress())) {
                return;
            }
            ContractDetail contractDetail = WalletUtils.getContractDetail();
            if (contractDetail == null || !StringUtils.equalsIgnoreCase((CharSequence)contractDetail.getAddress(), (CharSequence)transactionDetail.getContractAddress())) {
                return;
            }
            transactionDetail = this.getTransactionService().getTransactionByHash(transactionHash);
            if (transactionDetail == null || !transactionDetail.isSucceeded()) {
                return;
            }
            if (transactionDetail.isAdminOperation()) {
                return;
            }
            Wallet senderWallet = null;
            String senderAddress = transactionDetail.getFrom();
            String string = contractAdminAddress = contractDetail == null ? null : contractDetail.getOwner();
            if (StringUtils.isNotBlank((CharSequence)senderAddress) && (senderWallet = this.getWalletAccountService().getWalletByAddress(senderAddress)) == null) {
                senderWallet = new Wallet();
                senderWallet.setAddress(senderAddress);
                senderWallet.setAvatar("/platform-ui/skin/images/avatar/DefaultUserAvatar.png");
                if (StringUtils.isNotBlank((CharSequence)contractAdminAddress) && StringUtils.equalsIgnoreCase((CharSequence)contractAdminAddress, (CharSequence)senderAddress)) {
                    senderWallet.setName("Admin");
                } else {
                    senderWallet.setName(senderAddress);
                }
            }
            Wallet receiverWallet = null;
            String receiverAddress = transactionDetail.getTo();
            if (StringUtils.isNotBlank((CharSequence)receiverAddress) && (receiverWallet = this.getWalletAccountService().getWalletByAddress(receiverAddress)) == null) {
                receiverWallet = new Wallet();
                receiverWallet.setAddress(receiverAddress);
                receiverWallet.setAvatar("/platform-ui/skin/images/avatar/DefaultUserAvatar.png");
                if (StringUtils.isNotBlank((CharSequence)contractAdminAddress) && StringUtils.equalsIgnoreCase((CharSequence)contractAdminAddress, (CharSequence)receiverAddress)) {
                    receiverWallet.setName("Admin");
                } else {
                    receiverWallet.setName(receiverAddress);
                }
            }
            if (senderWallet != null && senderWallet.getTechnicalId() > 0L && senderWallet.isEnabled() && !senderWallet.isDeletedUser() && !senderWallet.isDisabledUser()) {
                this.sendNotification(transactionDetail, TransactionNotificationType.SENDER, senderWallet, receiverWallet);
            }
            if (receiverWallet != null && receiverWallet.getTechnicalId() > 0L && receiverWallet.isEnabled() && !receiverWallet.isDeletedUser() && !receiverWallet.isDisabledUser()) {
                this.sendNotification(transactionDetail, TransactionNotificationType.RECEIVER, senderWallet, receiverWallet);
            }
        }
        catch (Exception e) {
            LOG.error("Error processing transaction notification {}", new Object[]{event.getData(), e});
        }
        finally {
            WalletUtils.logStatistics((TransactionDetail)transactionDetail);
            RequestLifeCycle.end();
        }
    }

    private void sendNotification(TransactionDetail transactionDetail, TransactionNotificationType transactionStatus, Wallet senderWallet, Wallet receiverWallet) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(WalletUtils.HASH_PARAMETER, (Object)transactionDetail.getHash());
        ctx.append(WalletUtils.SENDER_ACCOUNT_DETAIL_PARAMETER, (Object)senderWallet);
        ctx.append(WalletUtils.RECEIVER_ACCOUNT_DETAIL_PARAMETER, (Object)receiverWallet);
        ctx.append(WalletUtils.MESSAGE_PARAMETER, (Object)(transactionDetail.getMessage() == null ? "" : transactionDetail.getMessage()));
        ContractDetail contractDetail = WalletUtils.getContractDetail();
        ctx.append(WalletUtils.SYMBOL_PARAMETER, (Object)contractDetail.getSymbol());
        ctx.append(WalletUtils.CONTRACT_ADDRESS_PARAMETER, (Object)contractDetail.getAddress());
        ctx.append(WalletUtils.AMOUNT_PARAMETER, (Object)transactionDetail.getContractAmount());
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)transactionStatus.getNotificationId()))).execute(ctx);
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private WalletAccountService getWalletAccountService() {
        if (this.walletAccountService == null) {
            this.walletAccountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.walletAccountService;
    }
}

