/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.service;

import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.settings.GlobalSettings;
import org.exoplatform.wallet.model.settings.InitialFundsSettings;
import org.exoplatform.wallet.model.settings.NetworkSettings;
import org.exoplatform.wallet.model.settings.UserSettings;
import org.exoplatform.wallet.model.settings.WalletSettings;
import org.exoplatform.wallet.model.transaction.FundsRequest;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletContractService;
import org.exoplatform.wallet.service.WalletService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.test.BaseWalletTest;
import org.exoplatform.wallet.test.mock.IdentityManagerMock;
import org.exoplatform.wallet.utils.WalletUtils;
import org.junit.Test;
import org.picocontainer.Startable;

public class WalletServiceTest
extends BaseWalletTest {
    @Test
    public void testContainerStart() {
        WalletServiceTest.assertNotNull((Object)this.getService(WalletService.class));
        WalletServiceTest.assertNotNull((Object)this.getService(WalletAccountService.class));
        WalletServiceTest.assertNotNull((Object)this.getService(WalletTransactionService.class));
        WalletServiceTest.assertNotNull((Object)this.getService(WalletContractService.class));
    }

    @Test
    public void testDefaultParameters() {
        WalletService walletService = this.getService(WalletService.class);
        GlobalSettings settings = walletService.getSettings();
        WalletServiceTest.assertNotNull((String)"Default settings shouldn't be null", (Object)settings);
        WalletServiceTest.assertNotNull((String)"Contract ABI should have been computed after container startup", (Object)settings.getContractAbi());
        WalletServiceTest.assertNotNull((String)"Contract BIN should have been computed after container startup", (Object)settings.getContractBin());
        WalletServiceTest.assertNotNull((String)"Default contract address shouldn't be null", (Object)settings.getContractAddress());
        NetworkSettings networkSettings = settings.getNetwork();
        WalletServiceTest.assertNotNull((String)"Default blockchain network settings shouldn't be null", (Object)networkSettings);
        WalletServiceTest.assertTrue((String)"Default blockchain network id shouldn't be null", (networkSettings.getId() > 0L ? 1 : 0) != 0);
        WalletServiceTest.assertNotNull((String)"Default blockchain network gas limit shouldn't be null", (Object)networkSettings.getGasLimit());
        WalletServiceTest.assertNotNull((String)"Default blockchain tansaction minimum gas price shouldn't be null", (Object)networkSettings.getMinGasPrice());
        WalletServiceTest.assertNotNull((String)"Default blockchain tansaction normal gas price shouldn't be null", (Object)networkSettings.getNormalGasPrice());
        WalletServiceTest.assertNotNull((String)"Default blockchain tansaction maximum gas price shouldn't be null", (Object)networkSettings.getMaxGasPrice());
        WalletServiceTest.assertNotNull((String)"Default blockchain network http URL shouldn't be null", (Object)networkSettings.getProviderURL());
        WalletServiceTest.assertNotNull((String)"Default blockchain network websocket URL shouldn't be null", (Object)networkSettings.getWebsocketProviderURL());
    }

    @Test
    public void testSaveInitialFundsSettings() {
        WalletService walletService = this.getService(WalletService.class);
        try {
            walletService.saveInitialFundsSettings(null);
            WalletServiceTest.fail((String)"initialFundsSettings parameter is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        InitialFundsSettings initialFundsSettings = new InitialFundsSettings();
        int tokenAmount = 5000;
        String fundsHolder = "root";
        String fundsHolderType = "user";
        initialFundsSettings.setTokenAmount((double)tokenAmount);
        initialFundsSettings.setFundsHolder(fundsHolder);
        initialFundsSettings.setFundsHolderType(fundsHolderType);
        initialFundsSettings.setRequestMessage("Initial fund message");
        walletService.saveInitialFundsSettings(initialFundsSettings);
        this.checkInitialFunds(tokenAmount, fundsHolder, fundsHolderType, walletService);
        tokenAmount = 50;
        initialFundsSettings.setTokenAmount((double)tokenAmount);
        walletService.saveInitialFundsSettings(initialFundsSettings);
        ((Startable)walletService).start();
        this.checkInitialFunds(tokenAmount, fundsHolder, fundsHolderType, walletService);
    }

    @Test
    public void testSaveUserPreferences() {
        WalletService walletService = this.getService(WalletService.class);
        try {
            walletService.saveUserPreferences("root1", null);
            WalletServiceTest.fail((String)"UserPreferences parameter is mandatory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        WalletSettings userPreferences = new WalletSettings();
        Integer dataVersion = 2;
        String phrase = "save User";
        userPreferences.setPhrase(phrase);
        userPreferences.setDataVersion(dataVersion);
        walletService.saveUserPreferences("root1", userPreferences);
        IdentityManagerMock identityManagerMock = this.getService(IdentityManagerMock.class);
        identityManagerMock.getOrCreateIdentity("organization", "root1", false);
        UserSettings userSettings = walletService.getUserSettings(null, "root1", false);
        WalletServiceTest.assertEquals((String)"Data version are not equals", (Object)dataVersion, (Object)userSettings.getUserPreferences().getDataVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetUserSettings() {
        WalletService walletService = this.getService(WalletService.class);
        String currentUser = "root15";
        UserSettings userSettings = walletService.getUserSettings(null, currentUser, false);
        WalletServiceTest.assertNotNull((String)"User settings shouldn't be null", (Object)userSettings);
        WalletServiceTest.assertNotNull((String)"Contract address shouldn't be null", (Object)userSettings.getContractAddress());
        WalletServiceTest.assertNotNull((String)"Contract bin shouldn't be null", (Object)userSettings.getContractBin());
        NetworkSettings networkSettings = userSettings.getNetwork();
        WalletServiceTest.assertNotNull((String)"Default blockchain network settings shouldn't be null", (Object)networkSettings);
        WalletServiceTest.assertTrue((String)"Default blockchain network id shouldn't be null", (networkSettings.getId() > 0L ? 1 : 0) != 0);
        WalletServiceTest.assertNotNull((String)"Default blockchain network gas limit shouldn't be null", (Object)networkSettings.getGasLimit());
        WalletServiceTest.assertNotNull((String)"Default blockchain tansaction minimum gas price shouldn't be null", (Object)networkSettings.getMinGasPrice());
        WalletServiceTest.assertNotNull((String)"Default blockchain tansaction normal gas price shouldn't be null", (Object)networkSettings.getNormalGasPrice());
        WalletServiceTest.assertNotNull((String)"Default blockchain tansaction maximum gas price shouldn't be null", (Object)networkSettings.getMaxGasPrice());
        WalletServiceTest.assertNotNull((String)"Default blockchain network http URL shouldn't be null", (Object)networkSettings.getProviderURL());
        WalletServiceTest.assertNull((String)"Default blockchain network websocket URL must be null", (Object)networkSettings.getWebsocketProviderURL());
        userSettings = walletService.getUserSettings(null, currentUser, true);
        WalletServiceTest.assertNotNull((String)"User settings shouldn't be null", (Object)userSettings);
        WalletServiceTest.assertNotNull((String)"Contract address shouldn't be null", (Object)userSettings.getContractAddress());
        WalletServiceTest.assertNotNull((String)"Contract bin shouldn't be null", (Object)userSettings.getContractBin());
        WalletServiceTest.assertNull((String)"Initial funds should be null when user doesn't belong to rewarding group", (Object)userSettings.getInitialFunds());
        Identity identity = this.buildUserIdentityAsAdmin(currentUser);
        IdentityRegistry identityRegistry = this.getService(IdentityRegistry.class);
        identityRegistry.register(identity);
        try {
            userSettings = walletService.getUserSettings(null, currentUser, true);
            WalletServiceTest.assertNotNull((String)"Initial funds shouldn't be null when user belongs to rewarding group", (Object)userSettings.getInitialFunds());
        }
        finally {
            identityRegistry.unregister(currentUser);
        }
    }

    @Test
    public void testGetSettings() {
        WalletService walletService = this.getService(WalletService.class);
        GlobalSettings globalSettings = walletService.getSettings();
        WalletServiceTest.assertNotNull((String)"Global settings shouldn't be null", (Object)globalSettings);
        WalletServiceTest.assertNotNull((String)"Contract address shouldn't be null", (Object)globalSettings.getContractAddress());
        WalletServiceTest.assertNotNull((String)"Contract bin shouldn't be null", (Object)globalSettings.getContractBin());
    }

    @Test
    public void testRequestFunds() throws IllegalAccessException {
        WalletService walletService = this.getService(WalletService.class);
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        try {
            FundsRequest fundsRequest = new FundsRequest();
            fundsRequest.setAddress("test");
            walletService.requestFunds(fundsRequest, "root1");
            WalletServiceTest.fail((String)"Bad request sent to server with unknown sender address");
        }
        catch (Exception fundsRequest) {
            // empty catch block
        }
        Wallet wallet = this.newWallet();
        walletAccountService.saveWalletAddress(wallet, "root1");
        this.entitiesToClean.add(wallet);
        FundsRequest fundsRequest = new FundsRequest();
        Double amount = 500.0;
        String message = "Funds request";
        fundsRequest.setAmount(amount);
        fundsRequest.setReceipientType("root1");
        fundsRequest.setAddress("0x1111111111111111111111111111111111111111");
        fundsRequest.setContract("No existing address");
        fundsRequest.setReceipient("root1");
        fundsRequest.setMessage(message);
        try {
            walletService.requestFunds(fundsRequest, "root9");
            WalletServiceTest.fail((String)"Expected exception: bad request sent to server with invalid sender type or id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        walletService.requestFunds(fundsRequest, "root1");
    }

    private void checkInitialFunds(int tokenAmount, String fundsHolder, String fundsHolderType, WalletService walletService) {
        GlobalSettings settings = walletService.getSettings();
        WalletServiceTest.assertNotNull((String)"Settings service shouldn't be null", (Object)settings);
        InitialFundsSettings initialFunds = WalletUtils.getWalletService().getInitialFundsSettings();
        WalletServiceTest.assertNotNull((String)"Initial found shouldn't be null", (Object)initialFunds);
        WalletServiceTest.assertEquals((String)"Funds Holder shouldn't be null", (String)fundsHolder, (String)initialFunds.getFundsHolder());
        WalletServiceTest.assertEquals((String)"Token Amount are not equals", (double)tokenAmount, (double)initialFunds.getTokenAmount(), (double)0.0);
        WalletServiceTest.assertEquals((String)"Funds Holder type shouldn't be null", (String)fundsHolderType, (String)initialFunds.getFundsHolderType());
    }

    @Test
    public void testMarkFundRequestAsSent() throws IllegalAccessException {
        WalletService walletService = this.getService(WalletService.class);
        WebNotificationStorage webNotification = this.getService(WebNotificationStorage.class);
        String title = "Notification";
        NotificationInfo notification = new NotificationInfo().key(PluginKey.key((String)"FundsRequestNotificationPlugin"));
        notification.setFrom("root1");
        notification.setTo("root1");
        notification.setTitle(title);
        webNotification.save(notification);
        try {
            walletService.markFundRequestAsSent(notification.getId(), "User");
            WalletServiceTest.fail((String)"Bad request sent to server with invalid contract address");
        }
        catch (Exception exception) {
            // empty catch block
        }
        walletService.markFundRequestAsSent(notification.getId(), "root1");
        WalletServiceTest.assertEquals((String)"root1", (String)notification.getFrom());
        WalletServiceTest.assertEquals((String)"Notification title are not equals", (String)title, (String)notification.getTitle());
        WalletServiceTest.assertEquals((String)"root1", (String)notification.getTo());
    }

    @Test
    public void testIsFundRequestSent() throws IllegalAccessException {
        WalletService walletService = this.getService(WalletService.class);
        WebNotificationStorage webNotification = this.getService(WebNotificationStorage.class);
        String title = "Notification";
        NotificationInfo notification = new NotificationInfo().key(PluginKey.key((String)"FundsRequestNotificationPlugin"));
        notification.setFrom("root1");
        notification.setTo("root1");
        notification.setTitle(title);
        webNotification.save(notification);
        try {
            walletService.isFundRequestSent(notification.getId(), "root0");
            WalletServiceTest.fail((String)"Target user of notification is different from current user");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Boolean isFundsRequestSent = walletService.isFundRequestSent(notification.getId(), "root1");
        WalletServiceTest.assertFalse((String)"ContractType are not equals", (boolean)isFundsRequestSent);
    }
}

