/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.service;

import jakarta.servlet.ServletContext;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.WalletAddressLabel;
import org.exoplatform.wallet.model.WalletProvider;
import org.exoplatform.wallet.model.WalletState;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletAccountServiceImpl$AjcClosure1;
import org.exoplatform.wallet.service.WalletAccountServiceImpl$AjcClosure3;
import org.exoplatform.wallet.service.WalletAccountServiceImpl$AjcClosure5;
import org.exoplatform.wallet.service.WalletTokenAdminService;
import org.exoplatform.wallet.statistic.ExoWalletStatistic;
import org.exoplatform.wallet.statistic.ExoWalletStatisticAspect;
import org.exoplatform.wallet.statistic.ExoWalletStatisticService;
import org.exoplatform.wallet.storage.AddressLabelStorage;
import org.exoplatform.wallet.storage.WalletStorage;
import org.exoplatform.wallet.utils.WalletUtils;
import org.picocontainer.Startable;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public class WalletAccountServiceImpl
implements WalletAccountService,
ExoWalletStatisticService,
Startable {
    private static final String ERROR_BROADCASTING_EVENT_FOR_WALLET = "Error broadcasting event {} for wallet {}";
    private static final Log LOG;
    private static final String USER_MESSAGE_IN_EXCEPTION = "User '";
    private static final String USER_MESSAGE_PREFIX = "User ";
    private static final String CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS = "Can't find wallet associated to address ";
    private static final String ADDRESS_PARAMTER_IS_MANDATORY = "address paramter is mandatory";
    private static final String STATISTIC_OPERATION_INITIALIZATION = "initialization";
    private static final String STATISTIC_OPERATION_CREATE = "create_wallet";
    private static final String STATISTIC_OPERATION_ENABLE = "enable";
    private static final String STATISTIC_OPERATION_DISABLE = "disable";
    private PortalContainer container;
    private WalletTokenAdminService tokenAdminService;
    private SettingService settingService;
    private WalletStorage accountStorage;
    private AddressLabelStorage labelStorage;
    private ListenerService listenerService;
    private String adminAccountPassword;
    private boolean adminAccountEnabled;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public WalletAccountServiceImpl(PortalContainer container, WalletStorage walletAccountStorage, AddressLabelStorage labelStorage, SettingService settingService, InitParams params) {
        this.container = container;
        this.settingService = settingService;
        this.accountStorage = walletAccountStorage;
        this.labelStorage = labelStorage;
        if (params != null && params.containsKey((Object)"admin.wallet.key") && StringUtils.isNotBlank((CharSequence)params.getValueParam("admin.wallet.key").getValue())) {
            this.adminAccountPassword = params.getValueParam("admin.wallet.key").getValue();
        }
    }

    public void start() {
        PortalContainer.addInitTask((ServletContext)this.container.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(ServletContext context, PortalContainer portalContainer) {
                ExoContainerContext.setCurrentContainer((ExoContainer)portalContainer);
                RequestLifeCycle.begin((ExoContainer)portalContainer);
                try {
                    Wallet adminWallet = WalletAccountServiceImpl.this.getAdminWallet();
                    WalletAccountServiceImpl.this.adminAccountEnabled = adminWallet != null && adminWallet.isEnabled();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error starting service", (Throwable)e);
                }
                finally {
                    RequestLifeCycle.end();
                }
            }
        });
    }

    public void stop() {
    }

    public Set<Wallet> listWallets() {
        Set<Wallet> wallets = this.accountStorage.listWallets();
        wallets.forEach(wallet -> {
            this.retrieveWalletBlockchainState((Wallet)wallet);
            WalletUtils.hideWalletOwnerPrivateInformation((Wallet)wallet);
        });
        return wallets;
    }

    public void refreshWalletsFromBlockchain(Map<String, Set<String>> walletsModifications) {
        if (walletsModifications == null) {
            walletsModifications = new HashMap<String, Set<String>>();
        }
        ContractDetail contractDetail = WalletUtils.getContractDetail();
        Set<String> walletAddresses = walletsModifications.keySet();
        for (String walletAddress : walletAddresses) {
            Wallet wallet = this.getWalletByAddress(walletAddress);
            if (wallet == null) continue;
            this.refreshWalletFromBlockchain(wallet, contractDetail, walletsModifications);
        }
    }

    public void refreshWalletFromBlockchain(Wallet wallet, ContractDetail contractDetail, Map<String, Set<String>> walletsModifications) {
        if (wallet == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)wallet.getAddress())) {
            return;
        }
        if (contractDetail == null) {
            contractDetail = WalletUtils.getSettings().getContractDetail();
        }
        if (this.getTokenAdminService() == null) {
            LOG.warn((Object)"Can't refresh wallet from blockchain because TokenAdminService isn't initialized yet");
        } else {
            try {
                Set<String> walletModifications = walletsModifications == null ? null : walletsModifications.get(wallet.getAddress());
                this.accountStorage.retrieveWalletBlockchainState(wallet, contractDetail.getAddress());
                Wallet originalWallet = wallet.clone();
                this.getTokenAdminService().retrieveWalletInformationFromBlockchain(wallet, contractDetail, walletModifications);
                this.saveWalletBlockchainState(wallet, contractDetail.getAddress());
                if (!StringUtils.equalsIgnoreCase((CharSequence)wallet.getInitializationState(), (CharSequence)WalletState.INITIALIZED.name()) && !StringUtils.equalsIgnoreCase((CharSequence)wallet.getInitializationState(), (CharSequence)WalletState.PENDING.name()) && !StringUtils.equalsIgnoreCase((CharSequence)wallet.getInitializationState(), (CharSequence)WalletState.DENIED.name()) && (wallet.getIsInitialized() != null && wallet.getIsInitialized().booleanValue() || wallet.getEtherBalance() > 0.0 && wallet.getTokenBalance() > 0.0)) {
                    wallet.setInitializationState(WalletState.INITIALIZED.name());
                    this.setInitializationStatus(wallet.getAddress(), WalletState.INITIALIZED);
                }
                if (!Objects.equals(originalWallet.getEtherBalance(), wallet.getEtherBalance()) || !Objects.equals(originalWallet.getTokenBalance(), wallet.getTokenBalance())) {
                    this.getListenerService().broadcast("exo.wallet.modified", null, (Object)wallet);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error refreshing wallet state on blockchain", (Throwable)e);
            }
        }
        if (WalletType.isAdmin((String)wallet.getType())) {
            this.adminAccountEnabled = wallet.isEnabled();
        }
    }

    public long getWalletsCount() {
        return this.accountStorage.getWalletsCount();
    }

    public Wallet getWalletByIdentityId(long identityId) {
        if (identityId == 0L) {
            throw new IllegalArgumentException("identityId is mandatory");
        }
        Identity identity = WalletUtils.getIdentityById((long)identityId);
        if (identity == null) {
            LOG.debug("Can't find identity with id {}", new Object[]{identityId});
            return null;
        }
        return this.getWalletOfIdentity(identity);
    }

    public void retrieveWalletBlockchainState(Wallet wallet) {
        if (wallet == null) {
            return;
        }
        String contractAddress = WalletUtils.getContractAddress();
        if (StringUtils.isBlank((CharSequence)contractAddress)) {
            LOG.warn((Object)"Contract address is empty, thus wallets can't be refreshed");
            return;
        }
        if (StringUtils.isBlank((CharSequence)wallet.getAddress())) {
            return;
        }
        this.accountStorage.retrieveWalletBlockchainState(wallet, contractAddress);
        if (wallet.getEtherBalance() == null) {
            this.refreshWalletFromBlockchain(wallet, null, null);
        }
    }

    public Wallet getWalletByTypeAndId(String type, String remoteId, String currentUser) {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet != null) {
            if (WalletType.isSpace((String)wallet.getType())) {
                wallet.setSpaceAdministrator(WalletUtils.isUserSpaceManager((String)wallet.getId(), (String)currentUser));
                if (!wallet.isSpaceAdministrator()) {
                    WalletUtils.hideWalletOwnerPrivateInformation((Wallet)wallet);
                }
            } else if (!StringUtils.equals((CharSequence)wallet.getId(), (CharSequence)currentUser)) {
                WalletUtils.hideWalletOwnerPrivateInformation((Wallet)wallet);
            }
            this.retrieveWalletBlockchainState(wallet);
        }
        return wallet;
    }

    public Wallet getWalletByTypeAndId(String type, String remoteId) {
        Identity identity;
        if (StringUtils.isBlank((CharSequence)remoteId)) {
            throw new IllegalArgumentException("id parameter is mandatory");
        }
        WalletType accountType = WalletType.getType((String)type);
        if (accountType.isSpace()) {
            remoteId = WalletUtils.getSpacePrettyName((String)remoteId);
        }
        if ((identity = WalletUtils.getIdentityByTypeAndId((WalletType)accountType, (String)remoteId)) == null) {
            LOG.debug("Can't find identity with id {} and type {}. It may be removed.", new Object[]{remoteId, accountType.getId()});
            return null;
        }
        return this.getWalletOfIdentity(identity);
    }

    public Wallet getAdminWallet() {
        Wallet adminWallet = this.getWalletByTypeAndId(WalletType.ADMIN.getId(), "admin");
        String contractAddress = WalletUtils.getContractAddress();
        if (adminWallet != null && adminWallet.isEnabled() && StringUtils.isNotBlank((CharSequence)contractAddress)) {
            this.accountStorage.retrieveWalletBlockchainState(adminWallet, contractAddress);
        }
        return adminWallet;
    }

    public void savePrivateKeyByTypeAndId(String type, String remoteId, String content, String currentUser) throws IllegalAccessException {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet == null || wallet.getTechnicalId() < 1L) {
            throw new IllegalStateException("Can't find " + type + " with remote id " + remoteId + ". Wallet private key will not be created.");
        }
        this.checkIsWalletOwner(wallet, currentUser, "save private key of wallet");
        this.accountStorage.saveWalletPrivateKey(wallet.getTechnicalId(), content);
    }

    public String getPrivateKeyByTypeAndId(String type, String remoteId, String currentUser) throws IllegalAccessException {
        if (WalletType.isAdmin((String)type)) {
            throw new IllegalAccessException(USER_MESSAGE_IN_EXCEPTION + currentUser + "' is not allowed to access private key of admin '" + remoteId + "'");
        }
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet == null || wallet.getTechnicalId() < 1L) {
            return null;
        }
        this.checkIsWalletOwner(wallet, currentUser, "get private key of wallet");
        try {
            return this.accountStorage.getWalletPrivateKey(wallet.getTechnicalId());
        }
        catch (Exception e) {
            LOG.warn("Unable to decode private key of {} '{}': {}", new Object[]{type, remoteId, e.getMessage()});
            return null;
        }
    }

    public String getPrivateKeyByTypeAndId(String type, String remoteId) {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet == null || wallet.getTechnicalId() < 1L) {
            return null;
        }
        try {
            return this.accountStorage.getWalletPrivateKey(wallet.getTechnicalId());
        }
        catch (Exception e) {
            LOG.warn("Unable to decode private key of {} '{}': {}", new Object[]{type, remoteId, e.getMessage()});
            return null;
        }
    }

    public void removePrivateKeyByTypeAndId(String type, String remoteId, String currentUser) throws IllegalAccessException {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet == null || wallet.getTechnicalId() < 1L) {
            return;
        }
        this.checkIsWalletOwner(wallet, currentUser, "remove private key of wallet");
        this.accountStorage.removeWalletPrivateKey(wallet.getTechnicalId());
    }

    public Wallet getWalletByAddress(String address, String currentUser) {
        if (address == null) {
            throw new IllegalArgumentException("address is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address, WalletUtils.getContractAddress());
        if (wallet != null) {
            Identity identity = WalletUtils.getIdentityById((long)wallet.getTechnicalId());
            WalletUtils.computeWalletFromIdentity((Wallet)wallet, (Identity)identity);
            if (WalletUtils.canAccessWallet((Wallet)wallet, (String)currentUser)) {
                this.retrieveWalletBlockchainState(wallet);
            }
        }
        return wallet;
    }

    public Wallet getWalletByAddress(String address) {
        return this.getWalletByAddress(address, null);
    }

    public void createAdminAccount(String privateKey, String currentUser) throws IllegalAccessException {
        this.getTokenAdminService().createAdminAccount(privateKey, currentUser);
    }

    public void saveWalletBlockchainState(Wallet wallet, String contractAddress) {
        this.accountStorage.saveWalletBlockchainState(wallet, contractAddress);
    }

    public Wallet saveWalletBackupState(String currentUser, long identityId, boolean backupState) throws IllegalAccessException {
        if (identityId == 0L) {
            throw new IllegalArgumentException("Wallet technical id is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)currentUser)) {
            throw new IllegalArgumentException("User name is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByIdentityId(identityId, WalletUtils.getContractAddress());
        if (wallet == null) {
            throw new IllegalStateException("Can't find wallet with id " + identityId);
        }
        this.checkIsWalletOwner(wallet, currentUser, "save wallet");
        return this.accountStorage.saveWalletBackupState(identityId, backupState);
    }

    @ExoWalletStatistic(local=true, service="wallet", operation="create_wallet")
    public void saveWalletAddress(Wallet wallet, String currentUser) throws IllegalAccessException {
        Wallet wallet2 = wallet;
        String string = currentUser;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)wallet2, (Object)string);
        Object[] objectArray = new Object[]{this, wallet2, string, joinPoint};
        WalletAccountServiceImpl$AjcClosure1 walletAccountServiceImpl$AjcClosure1 = new WalletAccountServiceImpl$AjcClosure1(objectArray);
        ExoWalletStatisticAspect.aspectOf().around(walletAccountServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wallet saveWallet(Wallet wallet, boolean isNew) {
        wallet = this.accountStorage.saveWallet(wallet, isNew);
        if (isNew && !this.isUserWalletInitialized(wallet.getId())) {
            try {
                this.getListenerService().broadcast("exo.wallet.addressAssociation.new", (Object)wallet.clone(), (Object)wallet.getId());
            }
            catch (Exception e) {
                LOG.error(ERROR_BROADCASTING_EVENT_FOR_WALLET, new Object[]{"exo.wallet.addressAssociation.new", wallet, e});
            }
            finally {
                this.setUserWalletAsInitialized(wallet.getId());
            }
        }
        return wallet;
    }

    public void switchToInternalWallet(long identityId) {
        Wallet wallet = this.getWalletByIdentityId(identityId);
        if (wallet == null) {
            throw new IllegalStateException("Identity with Id " + identityId + " doesn't have a wallet yet");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)WalletProvider.INTERNAL_WALLET.name(), (CharSequence)wallet.getProvider())) {
            throw new IllegalStateException("Identity with Id " + identityId + " already have internal wallet as provider");
        }
        if (this.accountStorage.hasWalletBackup(identityId)) {
            this.accountStorage.switchToInternalWallet(identityId);
        } else {
            this.accountStorage.removeWallet(identityId);
        }
        this.setUserWalletAsInitialized(wallet.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchWalletProvider(long identityId, WalletProvider provider, String newAddress, String rawMessage, String signedMessage) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is mandatory");
        }
        try {
            boolean valid = this.validateSignedMessage(newAddress, rawMessage, signedMessage);
            if (!valid) {
                throw new IllegalStateException("Invalid Signed Message");
            }
        }
        catch (SignatureException e) {
            throw new IllegalStateException("Invalid Signed Message", e);
        }
        Wallet existingWallet = this.getWalletByIdentityId(identityId);
        Wallet wallet = null;
        if (this.accountStorage.hasWallet(identityId)) {
            this.accountStorage.switchToWalletProvider(identityId, provider, newAddress);
            wallet = this.accountStorage.getWalletByAddress(newAddress, WalletUtils.getContractAddress());
        } else {
            wallet = new Wallet();
            wallet.setTechnicalId(identityId);
            wallet.setAddress(newAddress);
            wallet.setProvider(provider.name());
            wallet.setEnabled(true);
            wallet.setInitializationState(WalletState.NEW.name());
            wallet.setPassPhrase("");
            WalletUtils.computeWalletIdentity((Wallet)wallet);
            wallet = this.accountStorage.saveWallet(wallet, true);
        }
        this.refreshWalletFromBlockchain(wallet, WalletUtils.getContractDetail(), null);
        boolean isNew = !this.isUserWalletInitialized(wallet.getId()) && !this.accountStorage.hasWalletBackup(identityId) && (existingWallet == null || StringUtils.isBlank((CharSequence)existingWallet.getAddress()) || StringUtils.isNotBlank((CharSequence)existingWallet.getInitializationState()));
        String eventName = isNew ? "exo.wallet.addressAssociation.new" : "exo.wallet.addressAssociation.modification";
        try {
            this.getListenerService().broadcast(eventName, (Object)wallet.clone(), (Object)wallet.getId());
        }
        catch (Exception e) {
            LOG.error(ERROR_BROADCASTING_EVENT_FOR_WALLET, new Object[]{isNew ? "exo.wallet.addressAssociation.new" : "exo.wallet.addressAssociation.modification", wallet, e});
        }
        finally {
            this.setUserWalletAsInitialized(wallet.getId());
        }
    }

    public Wallet createWalletInstance(WalletProvider provider, String address, long identityId) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("Wallet address is mandatory");
        }
        Identity identity = WalletUtils.getIdentityById((long)identityId);
        WalletType type = WalletType.getType((String)identity.getProviderId());
        Wallet wallet = new Wallet();
        wallet.setAddress(address);
        wallet.setTechnicalId(identityId);
        wallet.setType(type.name());
        Wallet oldWallet = this.accountStorage.getWalletByIdentityId(wallet.getTechnicalId(), WalletUtils.getContractAddress());
        boolean isNew = oldWallet == null;
        this.computeWalletProperties(wallet, oldWallet, provider, isNew);
        return wallet;
    }

    public void removeWalletByAddress(String address, String currentUser) throws IllegalAccessException {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMTER_IS_MANDATORY);
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address, WalletUtils.getContractAddress());
        if (wallet == null) {
            throw new IllegalStateException(CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS + address);
        }
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException("Current user " + currentUser + " attempts to delete wallet with address " + address + " of " + wallet.getType() + " " + wallet.getId());
        }
        this.accountStorage.removeWallet(wallet.getTechnicalId());
    }

    public void removeWalletByTypeAndId(String type, String remoteId, String currentUser) throws IllegalAccessException {
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new IllegalArgumentException("wallet type parameter is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)remoteId)) {
            throw new IllegalArgumentException("remote id parameter is mandatory");
        }
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException("Current user " + currentUser + " attempts to delete wallet of " + type + " " + remoteId);
        }
        Identity identity = WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.getType((String)type), (String)remoteId);
        if (identity == null) {
            LOG.debug("Can't find identity with type/id: {}/{}", new Object[]{type, remoteId});
            return;
        }
        long identityId = Long.parseLong(identity.getId());
        Wallet wallet = this.accountStorage.getWalletByIdentityId(identityId, WalletUtils.getContractAddress());
        if (wallet == null) {
            throw new IllegalStateException("Can't find wallet with type/id: " + type + "/" + remoteId);
        }
        this.accountStorage.removeWallet(wallet.getTechnicalId());
    }

    @ExoWalletStatistic(service="wallet", operation="enable", local=true)
    public boolean enableWalletByAddress(String address, boolean enable, String currentUser) throws IllegalAccessException {
        String string = address;
        boolean bl = enable;
        String string2 = currentUser;
        Object[] objectArray = new Object[]{string, Conversions.booleanObject((boolean)bl), string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, Conversions.booleanObject((boolean)bl), string2, joinPoint};
        WalletAccountServiceImpl$AjcClosure3 walletAccountServiceImpl$AjcClosure3 = new WalletAccountServiceImpl$AjcClosure3(objectArray2);
        return Conversions.booleanValue((Object)ExoWalletStatisticAspect.aspectOf().around(walletAccountServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648)));
    }

    @ExoWalletStatistic(local=true, service="wallet", operation="initialization")
    public void setInitializationStatus(String address, WalletState initializationState, String currentUser) throws IllegalAccessException {
        String string = address;
        WalletState walletState = initializationState;
        String string2 = currentUser;
        Object[] objectArray = new Object[]{string, walletState, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, walletState, string2, joinPoint};
        WalletAccountServiceImpl$AjcClosure5 walletAccountServiceImpl$AjcClosure5 = new WalletAccountServiceImpl$AjcClosure5(objectArray2);
        ExoWalletStatisticAspect.aspectOf().around(walletAccountServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public void setInitializationStatus(String address, WalletState initializationState) {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMTER_IS_MANDATORY);
        }
        if (initializationState == null) {
            throw new IllegalArgumentException("Initialization state is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address, WalletUtils.getContractAddress());
        if (wallet == null) {
            LOG.info((Object)(CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS + address));
            return;
        }
        wallet.setInitializationState(initializationState.name());
        this.accountStorage.saveWallet(wallet, false);
    }

    public boolean isWalletOwner(Wallet wallet, String currentUser) {
        if (wallet == null) {
            return false;
        }
        String remoteId = wallet.getId();
        WalletType type = WalletType.getType((String)wallet.getType());
        if (type.isSpace()) {
            return WalletUtils.isUserSpaceManager((String)remoteId, (String)currentUser);
        }
        if (type.isAdmin()) {
            return WalletUtils.isUserRewardingAdmin((String)currentUser);
        }
        if (type.isUser()) {
            return StringUtils.equals((CharSequence)currentUser, (CharSequence)remoteId);
        }
        LOG.warn("Unrecognized wallet type '{}'", new Object[]{type});
        return false;
    }

    public WalletAddressLabel saveOrDeleteAddressLabel(WalletAddressLabel label, String currentUser) {
        if (label == null) {
            throw new IllegalArgumentException("Label is empty");
        }
        long labelId = label.getId();
        if (labelId > 0L) {
            Identity identity = WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.USER, (String)currentUser);
            if (identity == null) {
                throw new IllegalStateException("Can't find identity of user " + currentUser);
            }
            WalletAddressLabel storedLabel = this.labelStorage.getLabel(labelId);
            if (storedLabel == null) {
                label.setId(0L);
            } else if (!StringUtils.equals((CharSequence)identity.getId(), (CharSequence)String.valueOf(storedLabel.getIdentityId()))) {
                LOG.info("{} user modified address {} label from '{}' to '{}'", new Object[]{currentUser, label.getAddress(), storedLabel.getLabel(), label.getLabel()});
            }
        }
        if (StringUtils.isBlank((CharSequence)label.getLabel())) {
            if (labelId > 0L) {
                this.labelStorage.removeLabel(label);
            }
        } else {
            label = this.labelStorage.saveLabel(label);
        }
        return label;
    }

    public Set<WalletAddressLabel> getAddressesLabelsVisibleBy(String currentUser) {
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            return Collections.emptySet();
        }
        return this.labelStorage.getAllLabels();
    }

    public String getAdminAccountPassword() {
        return this.adminAccountPassword;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Map<String, Object> getStatisticParameters(String operation, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (StringUtils.equals((CharSequence)STATISTIC_OPERATION_INITIALIZATION, (CharSequence)operation)) {
            address = (String)methodArgs[0];
            if (StringUtils.isBlank((CharSequence)address)) {
                LOG.debug((Object)"Address parameter is missing. No statistic log will be added");
                return null;
            }
            wallet = this.getWalletByAddress(address);
            if (wallet == null) {
                LOG.debug("Wallet not found for address {}. No statistic log will be added", new Object[]{address});
                return null;
            }
            parameters.put("", wallet);
            WalletState initializationState = (WalletState)methodArgs[1];
            if (initializationState != WalletState.DENIED) {
                LOG.debug("No statistic log is handeled for initialization state modification to {}", new Object[]{initializationState});
                return null;
            }
            parameters.put("operation", "reject");
        } else if (StringUtils.equals((CharSequence)STATISTIC_OPERATION_ENABLE, (CharSequence)operation)) {
            if (result == null) return null;
            if (!((Boolean)result).booleanValue()) {
                return null;
            }
            address = (String)methodArgs[0];
            if (StringUtils.isBlank((CharSequence)address)) {
                LOG.debug((Object)"Address parameter is missing. No statistic log will be added");
                return null;
            }
            wallet = this.getWalletByAddress(address);
            if (wallet == null) {
                LOG.debug("Wallet not found for address {}. No statistic log will be added", new Object[]{address});
                return null;
            }
            parameters.put("", wallet);
            boolean enable = (Boolean)methodArgs[1];
            parameters.put("operation", enable ? STATISTIC_OPERATION_ENABLE : STATISTIC_OPERATION_DISABLE);
        } else {
            if (!StringUtils.equals((CharSequence)STATISTIC_OPERATION_CREATE, (CharSequence)operation)) {
                LOG.warn("Statistic operation type '{}' not handled", new Object[]{operation});
                return null;
            }
            Wallet wallet = (Wallet)methodArgs[0];
            if (wallet == null) {
                LOG.debug((Object)"Wallet not found in parameters. No statistic log will be added");
                return null;
            }
            parameters.put("", wallet);
        }
        String issuer = (String)methodArgs[methodArgs.length - 1];
        if (!StringUtils.isNotBlank((CharSequence)issuer)) return parameters;
        Identity identity = WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.USER, (String)issuer);
        if (identity == null) {
            LOG.debug((Object)("Can't find identity with remote id: {}" + issuer));
            return parameters;
        }
        parameters.put("user_social_id", identity.getId());
        return parameters;
    }

    public boolean isAdminAccountEnabled() {
        return this.adminAccountEnabled;
    }

    public void setTokenAdminService(WalletTokenAdminService tokenAdminService) {
        this.tokenAdminService = tokenAdminService;
    }

    public void setListenerService(ListenerService listenerService) {
        this.listenerService = listenerService;
    }

    private WalletTokenAdminService getTokenAdminService() {
        if (this.tokenAdminService == null) {
            this.tokenAdminService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.tokenAdminService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    private void checkCanSaveWallet(Wallet wallet, Wallet storedWallet, String currentUser) throws IllegalAccessException {
        if (WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            return;
        }
        this.checkIsWalletOwner(wallet, currentUser, "save wallet");
        if (storedWallet != null && !storedWallet.isEnabled()) {
            LOG.error("User '{}' attempts to modify his wallet while it's disabled", new Object[]{currentUser});
            throw new IllegalAccessException();
        }
        Wallet walletByAddress = this.accountStorage.getWalletByAddress(wallet.getAddress(), WalletUtils.getContractAddress());
        if (walletByAddress != null && walletByAddress.getId() != null && !walletByAddress.getId().equals(wallet.getId())) {
            throw new IllegalStateException(USER_MESSAGE_PREFIX + currentUser + " attempts to assign address of wallet of " + String.valueOf(walletByAddress));
        }
    }

    private void checkIsWalletOwner(Wallet wallet, String currentUser, String operationMessage) throws IllegalAccessException {
        String remoteId = wallet.getId();
        WalletType type = WalletType.getType((String)wallet.getType());
        if (type.isSpace()) {
            WalletUtils.checkUserIsSpaceManager((String)remoteId, (String)currentUser, (boolean)true);
        } else if (type.isAdmin()) {
            if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
                throw new IllegalAccessException(USER_MESSAGE_IN_EXCEPTION + currentUser + "' attempts to " + operationMessage + " of admin");
            }
        } else if (type.isUser() && !StringUtils.equals((CharSequence)currentUser, (CharSequence)remoteId)) {
            throw new IllegalAccessException(USER_MESSAGE_IN_EXCEPTION + currentUser + "' attempts to " + operationMessage + " of user '" + remoteId + "'");
        }
    }

    private Wallet getWalletOfIdentity(Identity identity) {
        long identityId = Long.parseLong(identity.getId());
        Wallet wallet = this.accountStorage.getWalletByIdentityId(identityId, WalletUtils.getContractAddress());
        if (wallet == null) {
            wallet = new Wallet();
            wallet.setEnabled(true);
        }
        WalletUtils.computeWalletFromIdentity((Wallet)wallet, (Identity)identity);
        return wallet;
    }

    private void setWalletPassPhrase(Wallet wallet, Wallet oldWallet) {
        if (StringUtils.isBlank((CharSequence)wallet.getPassPhrase())) {
            if (oldWallet == null || StringUtils.isBlank((CharSequence)oldWallet.getPassPhrase())) {
                wallet.setPassPhrase(this.generateSecurityPhrase());
            } else {
                wallet.setPassPhrase(oldWallet.getPassPhrase());
            }
        }
    }

    private String generateSecurityPhrase() {
        return RandomStringUtils.random((int)20, (char[])WalletUtils.SIMPLE_CHARS);
    }

    private boolean validateSignedMessage(String walletAddress, String rawMessage, String signedMessage) throws SignatureException {
        if (StringUtils.isBlank((CharSequence)walletAddress) || StringUtils.isBlank((CharSequence)rawMessage) || StringUtils.isBlank((CharSequence)signedMessage)) {
            return false;
        }
        try {
            String recoveredAddress;
            BigInteger publicKey;
            byte[] signatureBytes = Numeric.hexStringToByteArray((String)signedMessage);
            byte[] r = Arrays.copyOfRange(signatureBytes, 0, 32);
            byte[] s = Arrays.copyOfRange(signatureBytes, 32, 64);
            byte v = signatureBytes[64];
            if (v < 27) {
                v = (byte)(v + 27);
            }
            if ((publicKey = Sign.signedPrefixedMessageToKey((byte[])rawMessage.getBytes(), (Sign.SignatureData)new Sign.SignatureData(v, r, s))) != null && (recoveredAddress = "0x" + Keys.getAddress((BigInteger)publicKey)).equalsIgnoreCase(walletAddress)) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("Error while validating wallet signature. Error: {}", new Object[]{e.getMessage()});
        }
        return false;
    }

    private void computeWalletProperties(Wallet wallet, Wallet oldWallet, WalletProvider provider, boolean isNew) {
        if (isNew) {
            wallet.setInitializationState(WalletState.NEW.name());
        } else if (!StringUtils.equalsIgnoreCase((CharSequence)oldWallet.getAddress(), (CharSequence)wallet.getAddress())) {
            wallet.setInitializationState(WalletState.MODIFIED.name());
        }
        wallet.setProvider(provider.name());
        wallet.setEnabled(isNew || oldWallet.isEnabled());
        this.setWalletPassPhrase(wallet, oldWallet);
    }

    private void setUserWalletAsInitialized(String username) {
        this.settingService.set(Context.USER.id(username), WalletUtils.WALLET_SCOPE, "WALLET_INITIALIZED", SettingValue.create((String)"true"));
    }

    private boolean isUserWalletInitialized(String username) {
        SettingValue value = this.settingService.get(Context.USER.id(username), WalletUtils.WALLET_SCOPE, "WALLET_INITIALIZED");
        return value != null && Boolean.parseBoolean(value.getValue().toString());
    }

    static {
        WalletAccountServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(WalletAccountServiceImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void saveWalletAddress_aroundBody0(WalletAccountServiceImpl ajc$this, Wallet wallet, String currentUser, JoinPoint joinPoint) {
        if (wallet == null) {
            throw new IllegalArgumentException("Wallet is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)wallet.getAddress())) {
            throw new IllegalArgumentException("Wallet address is empty, thus it can't be saved");
        }
        WalletUtils.computeWalletIdentity((Wallet)wallet);
        long identityId = wallet.getTechnicalId();
        Wallet oldWallet = ajc$this.accountStorage.getWalletByIdentityId(identityId, WalletUtils.getContractAddress());
        ajc$this.checkCanSaveWallet(wallet, oldWallet, currentUser);
        if (oldWallet != null && StringUtils.equalsIgnoreCase((CharSequence)oldWallet.getAddress(), (CharSequence)wallet.getAddress())) {
            throw new IllegalAccessException("Can't modify wallet properties once saved");
        }
        WalletProvider provider = oldWallet == null || oldWallet.getProvider() == null ? WalletProvider.INTERNAL_WALLET : WalletProvider.valueOf((String)oldWallet.getProvider());
        ajc$this.computeWalletProperties(wallet, oldWallet, provider, oldWallet == null);
        ajc$this.accountStorage.saveWallet(wallet, oldWallet == null);
        if (oldWallet != null) {
            ajc$this.accountStorage.removeWalletPrivateKey(identityId);
        }
        if (!WalletType.isAdmin((String)wallet.getType())) {
            ajc$this.refreshWalletFromBlockchain(wallet, WalletUtils.getContractDetail(), null);
            boolean isNew = oldWallet == null && !ajc$this.accountStorage.hasWalletBackup(identityId) && !ajc$this.isUserWalletInitialized(wallet.getId());
            String eventName = isNew ? "exo.wallet.addressAssociation.new" : "exo.wallet.addressAssociation.modification";
            try {
                ajc$this.getListenerService().broadcast(eventName, (Object)wallet.clone(), (Object)currentUser);
            }
            catch (Exception e) {
                LOG.error(ERROR_BROADCASTING_EVENT_FOR_WALLET, new Object[]{eventName, wallet, e});
            }
            finally {
                ajc$this.setUserWalletAsInitialized(wallet.getId());
            }
        }
    }

    static /* synthetic */ boolean enableWalletByAddress_aroundBody2(WalletAccountServiceImpl ajc$this, String address, boolean enable, String currentUser, JoinPoint joinPoint) {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMTER_IS_MANDATORY);
        }
        Wallet wallet = ajc$this.accountStorage.getWalletByAddress(address, WalletUtils.getContractAddress());
        if (wallet == null) {
            throw new IllegalStateException(CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS + address);
        }
        boolean walletEnablement = wallet.isEnabled();
        if (walletEnablement != enable) {
            if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
                throw new IllegalAccessException(USER_MESSAGE_PREFIX + currentUser + " attempts to disable wallet with address " + address + " of " + wallet.getType() + " " + wallet.getId());
            }
            wallet.setEnabled(enable);
            ajc$this.accountStorage.saveWallet(wallet, false);
            if (walletEnablement != wallet.isEnabled()) {
                try {
                    ajc$this.getListenerService().broadcast(enable ? "exo.wallet.enabled" : "exo.wallet.disabled", (Object)wallet, (Object)currentUser);
                }
                catch (Exception e) {
                    LOG.error("Error while braodcasting wallet {} enablement modification to {}", new Object[]{wallet, enable});
                }
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ void setInitializationStatus_aroundBody4(WalletAccountServiceImpl ajc$this, String address, WalletState initializationState, String currentUser, JoinPoint joinPoint) {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMTER_IS_MANDATORY);
        }
        if (initializationState == null) {
            throw new IllegalArgumentException("Initialization state is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)currentUser)) {
            throw new IllegalArgumentException("Modifier username is mandatory");
        }
        Wallet wallet = ajc$this.accountStorage.getWalletByAddress(address, WalletUtils.getContractAddress());
        if (wallet == null) {
            throw new IllegalStateException(CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS + address);
        }
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser) && initializationState != WalletState.DELETED) {
            WalletState oldInitializationState = WalletState.valueOf((String)wallet.getInitializationState());
            if (oldInitializationState != WalletState.DENIED || initializationState != WalletState.MODIFIED || !ajc$this.isWalletOwner(wallet, currentUser)) {
                throw new IllegalAccessException(USER_MESSAGE_PREFIX + currentUser + " attempts to change wallet status with address " + address + " to " + initializationState.name());
            }
            if (oldInitializationState == WalletState.INITIALIZED) {
                throw new IllegalAccessException("Wallet was already marked as initialized, thus the status for address " + address + " can't change to status " + initializationState.name());
            }
        }
        wallet.setInitializationState(initializationState.name());
        ajc$this.accountStorage.saveWallet(wallet, false);
        if (initializationState == WalletState.DELETED) {
            try {
                ajc$this.getListenerService().broadcast("exo.wallet.deleted", (Object)wallet, (Object)currentUser);
            }
            catch (Exception e) {
                LOG.error("Error while braodcasting wallet {} state modification", new Object[]{wallet, currentUser});
            }
        }
        try {
            ajc$this.getListenerService().broadcast("exo.wallet.initialization.state", (Object)wallet, (Object)currentUser);
        }
        catch (Exception e) {
            LOG.error("Error while braodcasting wallet {} state modification", new Object[]{wallet, currentUser});
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WalletAccountServiceImpl.java", WalletAccountServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveWalletAddress", "org.exoplatform.wallet.service.WalletAccountServiceImpl", "org.exoplatform.wallet.model.Wallet:java.lang.String", "wallet:currentUser", "java.lang.IllegalAccessException", "void"), 444);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enableWalletByAddress", "org.exoplatform.wallet.service.WalletAccountServiceImpl", "java.lang.String:boolean:java.lang.String", "address:enable:currentUser", "java.lang.IllegalAccessException", "boolean"), 645);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setInitializationStatus", "org.exoplatform.wallet.service.WalletAccountServiceImpl", "java.lang.String:org.exoplatform.wallet.model.WalletState:java.lang.String", "address:initializationState:currentUser", "java.lang.IllegalAccessException", "void"), 680);
    }
}

