/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.service.blockchain;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketListener;
import org.web3j.protocol.websocket.WebSocketService;

public class EthereumClientConnectorForTransaction {
    private static final Log LOG = ExoLogger.getLogger(EthereumClientConnectorForTransaction.class);
    private Web3j web3j = null;
    private WebSocketClient webSocketClient = null;
    private WebSocketService web3jService = null;
    private GlobalSettings globalSettings = null;
    private ScheduledExecutorService connectionVerifierExecutor = null;
    private boolean connectionInProgress = false;
    private boolean serviceStarted = false;
    private boolean serviceStopping = false;
    private ClassLoader contextCL;

    public EthereumClientConnectorForTransaction(ClassLoader contextCL) {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-websocket-connector-%d").build();
        this.connectionVerifierExecutor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        this.contextCL = contextCL;
    }

    public void start(GlobalSettings storedSettings) {
        this.globalSettings = storedSettings;
        this.serviceStarted = true;
        this.connectionVerifierExecutor.scheduleWithFixedDelay(() -> {
            Thread.currentThread().setContextClassLoader(this.contextCL);
            try {
                if (!this.initWeb3Connection()) {
                    return;
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)"Error while checking connection status to Etherreum Websocket endpoint: {}", e);
                return;
            }
        }, 5L, 10L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.serviceStopping = true;
        this.connectionVerifierExecutor.shutdownNow();
        this.resetConnection();
    }

    public boolean isConnected() {
        return this.web3j != null && this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen();
    }

    public Web3j getWeb3j() throws InterruptedException {
        this.waitConnection();
        return this.web3j;
    }

    public void waitConnection() throws InterruptedException {
        Thread.currentThread().setContextClassLoader(this.contextCL);
        if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.getWebsocketProviderURL())) {
            throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
        }
        if (this.serviceStopping) {
            throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
        }
        while (!this.isConnected()) {
            if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.getWebsocketProviderURL())) {
                throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
            }
            if (this.serviceStopping) {
                throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
            }
            LOG.info((Object)"Wait until Websocket connection to blockchain is established to retrieve information");
            Thread.sleep(5000L);
        }
    }

    private String getWebsocketProviderURL() {
        return this.globalSettings == null ? null : this.globalSettings.getNetwork().getWebsocketProviderURL();
    }

    private void resetConnection() {
        if (this.web3j != null) {
            block8: {
                LOG.info((Object)"Resetting blockchain connection");
                try {
                    this.web3j.shutdown();
                }
                catch (Throwable e) {
                    LOG.warn("Error closing old web3j connection: {}", new Object[]{e.getMessage()});
                    if (this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen()) {
                        try {
                            this.web3jService.close();
                        }
                        catch (Throwable e1) {
                            LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
                        }
                    }
                    if (this.webSocketClient == null || !this.webSocketClient.isOpen()) break block8;
                    try {
                        this.webSocketClient.close();
                    }
                    catch (Throwable e1) {
                        LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
                    }
                }
            }
            this.web3j = null;
            this.web3jService = null;
            this.webSocketClient = null;
        }
    }

    private boolean initWeb3Connection() throws Exception {
        if (this.connectionInProgress) {
            LOG.info((Object)"Web3 connection initialization in progress, skip transaction processing until it's initialized");
            return false;
        }
        if (this.serviceStopping) {
            LOG.info((Object)"Stopping server, thus no new connection is attempted again");
            return false;
        }
        String websocketProviderURL = this.getWebsocketProviderURL();
        if (StringUtils.isBlank((CharSequence)websocketProviderURL)) {
            LOG.info((Object)"No configured URL for Ethereum Websocket connection");
            this.resetConnection();
            return false;
        }
        if (!websocketProviderURL.startsWith("ws:") && !websocketProviderURL.startsWith("wss:")) {
            LOG.warn((Object)("Bad format for configured URL " + websocketProviderURL + " for Ethereum Websocket connection"));
            this.resetConnection();
            return false;
        }
        if (this.isConnected()) {
            return false;
        }
        this.connectionInProgress = true;
        try {
            if (this.web3j != null && this.web3jService != null && this.webSocketClient != null) {
                LOG.info("Reconnect to blockchain endpoint {}", new Object[]{this.getWebsocketProviderURL()});
                boolean reconnected = this.webSocketClient.reconnectBlocking();
                if (!reconnected) {
                    throw new IllegalStateException("Can't reconnect to ethereum blockchain: " + this.getWebsocketProviderURL());
                }
            } else {
                LOG.info("Connecting to Ethereum network endpoint {}", new Object[]{this.getWebsocketProviderURL()});
                this.webSocketClient = new WebSocketClient(new URI(this.getWebsocketProviderURL()));
                this.webSocketClient.setConnectionLostTimeout(10);
                this.web3jService = new WebSocketService(this.webSocketClient, true);
                this.webSocketClient.setListener(this.getWebsocketListener());
                this.web3jService.connect();
                Thread.sleep(10000L);
                this.web3j = Web3j.build((Web3jService)this.web3jService);
                LOG.info("Connection established to Ethereum network endpoint {}", new Object[]{this.getWebsocketProviderURL()});
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.connectionInProgress = false;
        }
    }

    private WebSocketListener getWebsocketListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ String access$100(EthereumClientConnectorForTransaction x0) {
        return x0.getWebsocketProviderURL();
    }
}

