/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.service.blockchain;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.exoplatform.addon.wallet.service.WalletService;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.addon.wallet.service.blockchain.EthereumClientConnectorForTransaction;
import org.exoplatform.addon.wallet.service.blockchain.EthereumWalletTokenAdminService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ServiceLoaderServlet
extends HttpServlet {
    private static final long serialVersionUID = 4629318431709644350L;
    private static final Log LOG = ExoLogger.getLogger(ServiceLoaderServlet.class);
    private static final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public void init() throws ServletException {
        executor.scheduleAtFixedRate(() -> {
            PortalContainer container = PortalContainer.getInstance();
            if (container == null || !container.isStarted()) {
                LOG.debug((Object)"Portal Container is not yet started");
                return;
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader currentClassLoader = currentThread.getContextClassLoader();
            ClassLoader contextCL = this.getServletContext().getClassLoader();
            currentThread.setContextClassLoader(contextCL);
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            RequestLifeCycle.begin((ExoContainer)container);
            try {
                Class<?> class1 = contextCL.loadClass(BouncyCastleProvider.class.getName());
                Provider provider = (Provider)class1.newInstance();
                Security.removeProvider(BouncyCastleProvider.PROVIDER_NAME);
                Security.addProvider(provider);
                provider = Security.getProvider(BouncyCastleProvider.PROVIDER_NAME);
                LOG.info("BouncyCastleProvider class registered with version {}", new Object[]{provider.getVersion()});
                WalletService walletservice = (WalletService)container.getComponentInstanceOfType(WalletService.class);
                EthereumClientConnectorForTransaction web3jConnector = new EthereumClientConnectorForTransaction(contextCL);
                web3jConnector.start(walletservice.getSettings());
                EthereumWalletTokenAdminService service = new EthereumWalletTokenAdminService(web3jConnector, contextCL);
                container.registerComponentInstance(WalletTokenAdminService.class, (Object)service);
                service.start();
                LOG.debug(EthereumWalletTokenAdminService.class.getSimpleName(), new Object[]{" service instance created"});
            }
            catch (Exception e) {
                LOG.warn((Object)"Error registering service into portal container", (Throwable)e);
            }
            finally {
                currentThread.setContextClassLoader(currentClassLoader);
                RequestLifeCycle.end();
            }
            executor.shutdown();
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.init();
        super.service(req, resp);
    }
}

