/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
public class ExoBlockchainTransactionAspect {
    private static final Log LOG = ExoLogger.getLogger(ExoBlockchainTransactionAspect.class);

    @Around(value="execution(* *(..)) && @annotation(org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransaction)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            Object object = point.proceed();
            return object;
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static final ClassLoader startOperationInWebAppCL(ClassLoader webappClassLoader) {
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(webappClassLoader);
        return currentClassLoader;
    }

    private static final void endOperationInWebappCL(ClassLoader currentClassLoader) {
        Thread currentThread = Thread.currentThread();
        currentThread.setContextClassLoader(currentClassLoader);
    }
}

