/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.service;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransaction;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionService;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.contract.ERTTokenV2;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletInitializationState;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.BlockchainTransactionService;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletContractService;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.EventValues;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

/*
 * Exception performing whole class analysis ignored.
 */
public class EthereumBlockchainTransactionService
implements BlockchainTransactionService,
ExoBlockchainTransactionService {
    private static final Log LOG = ExoLogger.getLogger(EthereumBlockchainTransactionService.class);
    private static final String FUNC_DEPOSIT_FUNDS = "depositFunds";
    private static final String TRANSFER_SIG = EventEncoder.encode((Event)ERTTokenV2.TRANSFER_EVENT);
    private static final String APPROVAL_SIG = EventEncoder.encode((Event)ERTTokenV2.APPROVAL_EVENT);
    private static final String ADDED_ADMIN_METHOD_SIG = EventEncoder.encode((Event)ERTTokenV2.ADDEDADMIN_EVENT);
    private static final String REMOVED_ADMIN_SIG = EventEncoder.encode((Event)ERTTokenV2.REMOVEDADMIN_EVENT);
    private static final String APPROVED_ACCOUNT_SIG = EventEncoder.encode((Event)ERTTokenV2.APPROVEDACCOUNT_EVENT);
    private static final String DISAPPROVED_ACCOUNT_SIG = EventEncoder.encode((Event)ERTTokenV2.DISAPPROVEDACCOUNT_EVENT);
    private static final String CONTRACT_PAUSED_SIG = EventEncoder.encode((Event)ERTTokenV2.CONTRACTPAUSED_EVENT);
    private static final String CONTRACT_UNPAUSED_SIG = EventEncoder.encode((Event)ERTTokenV2.CONTRACTUNPAUSED_EVENT);
    private static final String DEPOSIT_RECEIVED_SIG = EventEncoder.encode((Event)ERTTokenV2.DEPOSITRECEIVED_EVENT);
    private static final String TOKEN_PRICE_CHANGED_SIG = EventEncoder.encode((Event)ERTTokenV2.TOKENPRICECHANGED_EVENT);
    private static final String TRANSFER_OWNERSHIP_SIG = EventEncoder.encode((Event)ERTTokenV2.TRANSFEROWNERSHIP_EVENT);
    private static final String ACCOUNT_INITIALIZATION_SIG = EventEncoder.encode((Event)ERTTokenV2.INITIALIZATION_EVENT);
    private static final String ACCOUNT_REWARD_SIG = EventEncoder.encode((Event)ERTTokenV2.REWARD_EVENT);
    private static final String ACCOUNT_VESTED_SIG = EventEncoder.encode((Event)ERTTokenV2.VESTING_EVENT);
    private static final String TRANSFER_VESTING_SIG = EventEncoder.encode((Event)ERTTokenV2.VESTINGTRANSFER_EVENT);
    private static final String UPGRADED_SIG = EventEncoder.encode((Event)ERTTokenV2.UPGRADED_EVENT);
    private static final String DATA_UPGRADED_SIG = EventEncoder.encode((Event)ERTTokenV2.UPGRADEDDATA_EVENT);
    private static final Map<String, String> CONTRACT_METHODS_BY_SIG = new HashMap();
    private EthereumClientConnector ethereumClientConnector;
    private WalletAccountService accountService;
    private WalletContractService contractService;
    private WalletTransactionService transactionService;
    private SettingService settingService;
    private ListenerService listenerService;
    private ClassLoader webappClassLoader;

    public EthereumBlockchainTransactionService(EthereumClientConnector ethereumClientConnector, ClassLoader webappClassLoader) {
        this.ethereumClientConnector = ethereumClientConnector;
        this.webappClassLoader = webappClassLoader;
    }

    public ClassLoader getWebappClassLoader() {
        return this.webappClassLoader;
    }

    @ExoBlockchainTransaction
    public void checkPendingTransactions() {
        List pendingTransactions = this.getTransactionService().getPendingTransactions();
        if (pendingTransactions != null && !pendingTransactions.isEmpty()) {
            LOG.debug("Checking on blockchain the status of {} transactions marked as pending in database", new Object[]{pendingTransactions.size()});
            long pendingTransactionMaxDays = this.getTransactionService().getPendingTransactionMaxDays();
            for (TransactionDetail pendingTransactionDetail : pendingTransactions) {
                try {
                    this.verifyTransactionStatusOnBlockchain(pendingTransactionDetail, pendingTransactionMaxDays);
                }
                catch (Exception e) {
                    LOG.warn("Error treating pending transaction: {}", new Object[]{pendingTransactionDetail, e});
                }
            }
        }
    }

    @ExoBlockchainTransaction
    public void scanNewerBlocks() throws InterruptedException, IOException {
        long lastWatchedBlockNumber;
        GlobalSettings settings = WalletUtils.getSettings();
        if (settings == null) {
            LOG.debug((Object)"Empty settings, skip contract transaction verification");
            return;
        }
        long networkId = settings.getNetwork().getId();
        if (settings.getNetwork().getId() == 0L) {
            LOG.debug((Object)"Empty network id in settings, skip contract transaction verification");
            return;
        }
        String wsURL = settings.getNetwork().getWebsocketProviderURL();
        if (StringUtils.isBlank((CharSequence)wsURL)) {
            LOG.debug((Object)"Empty Websocket URL in settings, skip contract transaction verification");
            return;
        }
        ContractDetail contractDetail = settings.getContractDetail();
        if (contractDetail == null || StringUtils.isBlank((CharSequence)contractDetail.getAddress())) {
            LOG.debug((Object)"Empty token address in settings, skip contract transaction verification");
            return;
        }
        long lastEthereumBlockNumber = this.ethereumClientConnector.getLastestBlockNumber();
        if (lastEthereumBlockNumber <= (lastWatchedBlockNumber = this.getLastWatchedBlockNumber(networkId))) {
            LOG.debug("No new blocks to verify. last watched = {}. last blockchain block = {}", new Object[]{lastWatchedBlockNumber, lastEthereumBlockNumber});
            return;
        }
        boolean processed = true;
        String contractAddress = contractDetail.getAddress();
        Set transactionHashes = this.ethereumClientConnector.getContractTransactions(contractAddress, lastWatchedBlockNumber, lastEthereumBlockNumber);
        LOG.debug("{} transactions has been found on contract {} between block {} and {}", new Object[]{transactionHashes.size(), contractAddress, lastWatchedBlockNumber, lastEthereumBlockNumber});
        int addedTransactionsCount = 0;
        int modifiedTransactionsCount = 0;
        for (String transactionHash : transactionHashes) {
            TransactionDetail transactionDetail = this.getTransactionService().getTransactionByHash(transactionHash);
            if (transactionDetail == null) {
                processed = this.processTransaction(transactionHash, contractDetail) && processed;
                if (!processed) continue;
                ++addedTransactionsCount;
                continue;
            }
            LOG.debug(" - transaction {} already exists on database, ignore it.", new Object[]{transactionDetail});
            boolean changed = false;
            if (StringUtils.isBlank((CharSequence)transactionDetail.getContractAddress()) || StringUtils.isBlank((CharSequence)transactionDetail.getContractMethodName())) {
                transactionDetail.setContractAddress(contractAddress);
                this.computeTransactionDetail(transactionDetail, contractDetail);
                changed = true;
            }
            boolean braodcastSavingTransaction = transactionDetail.isPending();
            transactionDetail.setPending(false);
            boolean bl = changed = changed || braodcastSavingTransaction;
            if (!transactionDetail.isSucceeded()) {
                TransactionReceipt transactionReceipt = this.ethereumClientConnector.getTransactionReceipt(transactionHash);
                transactionDetail.setSucceeded(transactionReceipt != null && transactionReceipt.isStatusOK());
                changed = true;
            }
            if (!changed || !WalletUtils.hasKnownWalletInTransaction((TransactionDetail)transactionDetail)) continue;
            this.getTransactionService().saveTransactionDetail(transactionDetail, braodcastSavingTransaction);
            ++modifiedTransactionsCount;
        }
        LOG.debug("{} added and {} modified transactions has been stored using contract {} between block {} and {}", new Object[]{addedTransactionsCount, modifiedTransactionsCount, contractAddress, lastWatchedBlockNumber, lastEthereumBlockNumber});
        if (processed) {
            this.saveLastWatchedBlockNumber(networkId, lastEthereumBlockNumber);
        }
    }

    @ExoBlockchainTransaction
    public TransactionDetail computeTransactionDetail(String hash, ContractDetail contractDetail) throws InterruptedException {
        if (StringUtils.isBlank((CharSequence)hash)) {
            throw new IllegalArgumentException("Transaction hash is empty");
        }
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setNetworkId(WalletUtils.getNetworkId());
        transactionDetail.setHash(hash);
        return this.computeTransactionDetail(transactionDetail, contractDetail);
    }

    @ExoBlockchainTransaction
    public TransactionDetail computeTransactionDetail(TransactionDetail transactionDetail, ContractDetail contractDetail) throws InterruptedException {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Empty transaction detail parameter");
        }
        String hash = transactionDetail.getHash();
        if (StringUtils.isBlank((CharSequence)hash)) {
            throw new IllegalStateException("Transaction hash is empty");
        }
        if (transactionDetail.getNetworkId() <= 0L) {
            throw new IllegalStateException("Unknown network id: " + transactionDetail.getNetworkId());
        }
        Transaction transaction = this.ethereumClientConnector.getTransaction(hash);
        if (transaction == null) {
            LOG.info("Can't find transaction with hash {}, it may be pending", new Object[]{hash});
            return transactionDetail;
        }
        EthBlock.Block block = this.ethereumClientConnector.getBlock(transaction.getBlockHash());
        transactionDetail.setTimestamp(block.getTimestamp().longValue() * 1000L);
        String senderAddress = transaction.getFrom();
        transactionDetail.setFrom(senderAddress);
        BigInteger weiAmount = transaction.getValue();
        transactionDetail.setValueDecimal(weiAmount, 18);
        TransactionReceipt transactionReceipt = this.ethereumClientConnector.getTransactionReceipt(hash);
        transactionDetail.setPending(transactionReceipt == null);
        transactionDetail.setSucceeded(transactionReceipt != null && transactionReceipt.isStatusOK());
        String receiverAddress = transaction.getTo();
        transactionDetail.setTo(receiverAddress);
        if (contractDetail == null && receiverAddress != null) {
            contractDetail = this.getContractService().getContractDetail(receiverAddress);
        }
        if (contractDetail != null && StringUtils.isNotBlank((CharSequence)contractDetail.getAddress())) {
            transactionDetail.setContractAddress(contractDetail.getAddress());
            this.computeContractTransactionDetail(contractDetail, transactionDetail, transactionReceipt);
        }
        return transactionDetail;
    }

    @ExoBlockchainTransaction
    public void computeContractTransactionDetail(TransactionDetail transactionDetail, Object transactionReceipt) {
        this.computeContractTransactionDetail(null, transactionDetail, (TransactionReceipt)transactionReceipt);
    }

    private void computeContractTransactionDetail(ContractDetail contractDetail, TransactionDetail transactionDetail, TransactionReceipt transactionReceipt) {
        String toAddress;
        List logs = transactionReceipt == null ? null : transactionReceipt.getLogs();
        transactionDetail.setSucceeded(transactionReceipt != null && transactionReceipt.isStatusOK());
        if (!transactionDetail.isSucceeded()) {
            if (StringUtils.equals((CharSequence)transactionDetail.getContractMethodName(), (CharSequence)"initializeAccount")) {
                this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.MODIFIED);
            }
            return;
        }
        String string = toAddress = transactionReceipt == null ? null : transactionReceipt.getTo();
        if (contractDetail == null) {
            contractDetail = this.getContractService().getContractDetail(StringUtils.lowerCase((String)toAddress));
        }
        if (contractDetail == null || !StringUtils.equalsIgnoreCase((CharSequence)toAddress, (CharSequence)contractDetail.getAddress())) {
            return;
        }
        Integer contractDecimals = contractDetail.getDecimals();
        String hash = transactionDetail.getHash();
        if (logs != null && !logs.isEmpty()) {
            int logsSize = logs.size();
            LOG.debug("Retrieving information from blockchain for transaction {} with {} LOGS", new Object[]{hash, logsSize});
            int i = 0;
            boolean transactionLogTreated = false;
            while (!transactionLogTreated && i < logsSize) {
                BigInteger amount;
                EventValues parameters;
                org.web3j.protocol.core.methods.response.Log log;
                List topics;
                if ((topics = (log = (org.web3j.protocol.core.methods.response.Log)logs.get(i++)).getTopics()) == null || topics.isEmpty()) {
                    LOG.warn("Transaction {} has NO topics", new Object[]{hash});
                    transactionDetail.setSucceeded(false);
                    continue;
                }
                String topic = (String)topics.get(0);
                LOG.debug("Treating transaction {} with {} topics", new Object[]{hash, topics.size()});
                String methodName = (String)CONTRACT_METHODS_BY_SIG.get(topic);
                if (StringUtils.isBlank((CharSequence)methodName)) continue;
                transactionDetail.setContractMethodName(methodName);
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transfer")) {
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.TRANSFER_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    if (!StringUtils.equals((CharSequence)transactionReceipt.getFrom(), (CharSequence)transactionDetail.getFrom())) {
                        transactionDetail.setBy(transactionReceipt.getFrom());
                        transactionDetail.setContractMethodName("transferFrom");
                    }
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"approve")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.APPROVAL_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"approveAccount")) {
                    if (logsSize > 1) continue;
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.APPROVEDACCOUNT_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"disapproveAccount")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.DISAPPROVEDACCOUNT_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"addAdmin")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.ADDEDADMIN_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue()).longValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"removeAdmin")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.REMOVEDADMIN_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"upgradeData")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.UPGRADEDDATA_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(1)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"upgradeImplementation")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.UPGRADED_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(1)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"depositFunds")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.DEPOSITRECEIVED_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    BigInteger weiAmount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setValueDecimal(weiAmount, 18);
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"setSellPrice")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.TOKENPRICECHANGED_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transformToVested")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.VESTING_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transferOwnership")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.TRANSFEROWNERSHIP_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"initializeAccount")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.INITIALIZATION_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    BigInteger weiAmount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setValueDecimal(weiAmount, 18);
                    transactionDetail.setAdminOperation(false);
                    if (transactionDetail.isSucceeded()) {
                        this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.INITIALIZED);
                        continue;
                    }
                    this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.MODIFIED);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"reward")) {
                    transactionLogTreated = true;
                    parameters = EthereumBlockchainTransactionService.extractEventParameters((Event)ERTTokenV2.REWARD_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setValueDecimal(amount, contractDecimals.intValue());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (transactionLogTreated || i + 1 != logsSize) continue;
                LOG.warn("Can't find contract method name of transaction {}", new Object[]{transactionDetail});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getFrom()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getFromWallet())) {
            transactionDetail.setFromWallet(this.getAccountService().getWalletByAddress(transactionDetail.getFrom()));
        }
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getTo()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getToWallet())) {
            transactionDetail.setToWallet(this.getAccountService().getWalletByAddress(transactionDetail.getTo()));
        }
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getBy()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getByWallet())) {
            transactionDetail.setByWallet(this.getAccountService().getWalletByAddress(transactionDetail.getBy()));
        }
    }

    private static EventValues extractEventParameters(Event event, org.web3j.protocol.core.methods.response.Log log) {
        List topics = log.getTopics();
        String encodedEventSignature = EventEncoder.encode((Event)event);
        if (!((String)topics.get(0)).equals(encodedEventSignature)) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List nonIndexedValues = FunctionReturnDecoder.decode((String)log.getData(), (List)event.getNonIndexedParameters());
        List indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue((String)((String)topics.get(i + 1)), (TypeReference)((TypeReference)indexedParameters.get(i)));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    private void verifyTransactionStatusOnBlockchain(TransactionDetail pendingTransactionDetail, long pendingTransactionMaxDays) throws Exception {
        String blockHash;
        String hash = pendingTransactionDetail.getHash();
        Transaction transaction = this.ethereumClientConnector.getTransaction(hash);
        String string = blockHash = transaction == null ? null : transaction.getBlockHash();
        if (!StringUtils.isBlank((CharSequence)blockHash) && !StringUtils.equalsIgnoreCase((CharSequence)"0x0000000000000000000000000000000000000000000000000000000000000000", (CharSequence)blockHash) && transaction.getBlockNumber() != null) {
            this.getListenerService().broadcast("exo.addon.wallet.transaction.loaded", (Object)transaction, null);
        } else if (pendingTransactionMaxDays > 0L) {
            Duration duration;
            long creationTimestamp = pendingTransactionDetail.getTimestamp();
            if (transaction == null && creationTimestamp > 0L && (duration = Duration.ofMillis(System.currentTimeMillis() - creationTimestamp)).toDays() >= pendingTransactionMaxDays) {
                LOG.info("Transaction '{}' was not found on blockchain for more than '{}' days, so mark it as failed", new Object[]{hash, pendingTransactionMaxDays});
                this.getListenerService().broadcast("exo.addon.wallet.transaction.loaded", (Object)hash, null);
            }
        }
    }

    private boolean processTransaction(String transactionHash, ContractDetail contractDetail) {
        boolean processed = true;
        try {
            LOG.debug(" - treating transaction {} that doesn't exist on database.", new Object[]{transactionHash});
            TransactionDetail transactionDetail = this.computeTransactionDetail(transactionHash, contractDetail);
            if (transactionDetail == null) {
                throw new IllegalStateException("Empty transaction detail is returned");
            }
            if (WalletUtils.hasKnownWalletInTransaction((TransactionDetail)transactionDetail)) {
                LOG.info("Saving new transaction that wasn't managed by UI: {}", new Object[]{transactionDetail});
                this.getTransactionService().saveTransactionDetail(transactionDetail, true);
            }
        }
        catch (Exception e) {
            processed = false;
            LOG.warn("Error processing transaction {}. It will be retried next time.", new Object[]{transactionHash, e});
        }
        return processed;
    }

    private long getLastWatchedBlockNumber(long networkId) {
        SettingValue lastBlockNumberValue = this.getSettingService().get(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId);
        if (lastBlockNumberValue != null && lastBlockNumberValue.getValue() != null) {
            return Long.valueOf(lastBlockNumberValue.getValue().toString());
        }
        return 0L;
    }

    private void saveLastWatchedBlockNumber(long networkId, long lastWatchedBlockNumber) {
        LOG.debug("Save watched block number {} on network {}", new Object[]{lastWatchedBlockNumber, networkId});
        this.getSettingService().set(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId, SettingValue.create((Long)lastWatchedBlockNumber));
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        }
        return this.settingService;
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    private WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    private WalletContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = (WalletContractService)CommonsUtils.getService(WalletContractService.class);
        }
        return this.contractService;
    }

    static {
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_SIG, "transfer");
        CONTRACT_METHODS_BY_SIG.put(APPROVAL_SIG, "approve");
        CONTRACT_METHODS_BY_SIG.put(ADDED_ADMIN_METHOD_SIG, "addAdmin");
        CONTRACT_METHODS_BY_SIG.put(REMOVED_ADMIN_SIG, "removeAdmin");
        CONTRACT_METHODS_BY_SIG.put(APPROVED_ACCOUNT_SIG, "approveAccount");
        CONTRACT_METHODS_BY_SIG.put(DISAPPROVED_ACCOUNT_SIG, "disapproveAccount");
        CONTRACT_METHODS_BY_SIG.put(CONTRACT_PAUSED_SIG, "pause");
        CONTRACT_METHODS_BY_SIG.put(CONTRACT_UNPAUSED_SIG, "unPause");
        CONTRACT_METHODS_BY_SIG.put(DEPOSIT_RECEIVED_SIG, "depositFunds");
        CONTRACT_METHODS_BY_SIG.put(TOKEN_PRICE_CHANGED_SIG, "setSellPrice");
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_OWNERSHIP_SIG, "transferOwnership");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_INITIALIZATION_SIG, "initializeAccount");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_REWARD_SIG, "reward");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_VESTED_SIG, "transformToVested");
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_VESTING_SIG, "transfer");
        CONTRACT_METHODS_BY_SIG.put(UPGRADED_SIG, "upgradeImplementation");
        CONTRACT_METHODS_BY_SIG.put(DATA_UPGRADED_SIG, "upgradeData");
    }
}

