/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketListener;
import org.web3j.protocol.websocket.WebSocketService;

public class EthereumClientConnector
implements ExoBlockchainTransactionService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(EthereumClientConnector.class);
    private Web3j web3j = null;
    private WebSocketClient webSocketClient = null;
    private WebSocketService web3jService = null;
    private ScheduledExecutorService connectionVerifierExecutor = null;
    private boolean connectionInProgress = false;
    private boolean serviceStarted = false;
    private boolean serviceStopping = false;
    private ClassLoader webappClassLoader = null;
    private String websocketURL = null;

    public EthereumClientConnector(ClassLoader webappClassLoader) {
        this.webappClassLoader = webappClassLoader;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-websocket-connector-%d").build();
        this.connectionVerifierExecutor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
    }

    public ClassLoader getWebappClassLoader() {
        return this.webappClassLoader;
    }

    public void start() {
        this.start(WalletUtils.getWebsocketURL());
    }

    public void start(String websocketURL) {
        this.websocketURL = websocketURL;
        this.serviceStarted = true;
        this.connectionVerifierExecutor.scheduleWithFixedDelay(() -> {
            try {
                if (!this.initWeb3Connection()) {
                    return;
                }
            }
            catch (Throwable e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)"Error while checking connection status to Etherreum Websocket endpoint: {}", e);
                } else {
                    LOG.warn("Error while checking connection status to Etherreum Websocket endpoint: {}", new Object[]{e.getMessage()});
                }
                return;
            }
        }, 5L, 10L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.serviceStopping = true;
        this.connectionVerifierExecutor.shutdownNow();
        this.resetConnection();
    }

    public Transaction getTransaction(String transactionHash) throws InterruptedException {
        EthTransaction ethTransaction;
        this.waitConnection();
        try {
            ethTransaction = (EthTransaction)this.web3j.ethGetTransactionByHash(transactionHash).send();
        }
        catch (IOException e) {
            LOG.info("Connection interrupted while getting Transaction '{}' information. Reattempt until getting it. Reason: {}", new Object[]{transactionHash, e.getMessage()});
            return this.getTransaction(transactionHash);
        }
        if (ethTransaction != null) {
            return (Transaction)ethTransaction.getResult();
        }
        return null;
    }

    public EthBlock.Block getBlock(String blockHash) throws InterruptedException {
        EthBlock ethBlock;
        this.waitConnection();
        try {
            ethBlock = (EthBlock)this.web3j.ethGetBlockByHash(blockHash, false).send();
        }
        catch (IOException e) {
            LOG.info("Connection interrupted while getting Block '{}' information. Reattempt until getting it. Reason: {}", new Object[]{blockHash, e.getMessage()});
            return this.getBlock(blockHash);
        }
        if (ethBlock != null && ethBlock.getResult() != null) {
            return (EthBlock.Block)ethBlock.getResult();
        }
        return null;
    }

    public TransactionReceipt getTransactionReceipt(String transactionHash) throws InterruptedException {
        EthGetTransactionReceipt ethGetTransactionReceipt;
        this.waitConnection();
        try {
            ethGetTransactionReceipt = (EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(transactionHash).send();
        }
        catch (IOException e) {
            LOG.info("Connection interrupted while getting Transaction receipt '{}' information. Reattempt until getting it. Reason: {}", new Object[]{transactionHash, e.getMessage()});
            return this.getTransactionReceipt(transactionHash);
        }
        if (ethGetTransactionReceipt != null) {
            return (TransactionReceipt)ethGetTransactionReceipt.getResult();
        }
        return null;
    }

    public boolean isConnected() {
        return this.web3j != null && this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen();
    }

    public long getLastestBlockNumber() throws InterruptedException, IOException {
        this.waitConnection();
        EthBlock.Block block = ((EthBlock)this.web3j.ethGetBlockByNumber((DefaultBlockParameter)DefaultBlockParameterName.LATEST, false).send()).getBlock();
        return block.getNumber().longValue();
    }

    public Set<String> getContractTransactions(String contractsAddress, long fromBlock, long toBlock) throws IOException, InterruptedException {
        this.waitConnection();
        EthFilter filter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), contractsAddress);
        EthLog contractTransactions = (EthLog)this.web3j.ethGetLogs(filter).send();
        List logs = (List)contractTransactions.getResult();
        HashSet<String> txHashes = new HashSet<String>();
        if (logs != null && !logs.isEmpty()) {
            for (EthLog.LogResult logResult : logs) {
                org.web3j.protocol.core.methods.response.Log contractEventLog = (org.web3j.protocol.core.methods.response.Log)logResult.get();
                txHashes.add(contractEventLog.getTransactionHash());
            }
        }
        return txHashes;
    }

    public Web3j getWeb3j() throws InterruptedException {
        this.waitConnection();
        return this.web3j;
    }

    public void waitConnection() throws InterruptedException {
        if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.websocketURL)) {
            throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
        }
        if (this.serviceStopping) {
            throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
        }
        while (!this.isConnected()) {
            if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.websocketURL)) {
                throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
            }
            if (this.serviceStopping) {
                throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
            }
            LOG.info((Object)"Wait until Websocket connection to blockchain is established to retrieve information");
            Thread.sleep(5000L);
        }
    }

    private void resetConnection() {
        if (this.web3j != null) {
            block8: {
                LOG.info((Object)"Resetting blockchain connection");
                try {
                    this.web3j.shutdown();
                }
                catch (Throwable e) {
                    LOG.warn("Error closing old web3j connection: {}", new Object[]{e.getMessage()});
                    if (this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen()) {
                        try {
                            this.web3jService.close();
                        }
                        catch (Throwable e1) {
                            LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
                        }
                    }
                    if (this.webSocketClient == null || !this.webSocketClient.isOpen()) break block8;
                    try {
                        this.webSocketClient.close();
                    }
                    catch (Throwable e1) {
                        LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
                    }
                }
            }
            this.web3j = null;
            this.web3jService = null;
            this.webSocketClient = null;
        }
    }

    private boolean initWeb3Connection() throws Exception {
        if (this.connectionInProgress) {
            LOG.info((Object)"Web3 connection initialization in progress, skip transaction processing until it's initialized");
            return false;
        }
        if (this.serviceStopping) {
            LOG.info((Object)"Stopping server, thus no new connection is attempted again");
            return false;
        }
        String websocketProviderURL = this.websocketURL;
        if (StringUtils.isBlank((CharSequence)websocketProviderURL)) {
            LOG.info((Object)"No configured URL for Ethereum Websocket connection");
            this.resetConnection();
            return false;
        }
        if (!websocketProviderURL.startsWith("ws:") && !websocketProviderURL.startsWith("wss:")) {
            LOG.warn((Object)("Bad format for configured URL " + websocketProviderURL + " for Ethereum Websocket connection"));
            this.resetConnection();
            return false;
        }
        if (this.isConnected()) {
            return false;
        }
        this.connectionInProgress = true;
        try {
            if (this.web3j != null && this.web3jService != null && this.webSocketClient != null) {
                LOG.info("Reconnect to blockchain endpoint {}", new Object[]{this.websocketURL});
                boolean reconnected = this.webSocketClient.reconnectBlocking();
                if (!reconnected) {
                    throw new IllegalStateException("Can't reconnect to ethereum blockchain: " + this.websocketURL);
                }
            } else {
                LOG.info("Connecting to Ethereum network endpoint {}", new Object[]{this.websocketURL});
                this.webSocketClient = new WebSocketClient(new URI(this.websocketURL));
                this.webSocketClient.setConnectionLostTimeout(10);
                this.web3jService = new WebSocketService(this.webSocketClient, true);
                this.webSocketClient.setListener(this.getWebsocketListener());
                this.web3jService.connect();
                Thread.sleep(10000L);
                this.web3j = Web3j.build((Web3jService)this.web3jService);
                LOG.info("Connection established to Ethereum network endpoint {}", new Object[]{this.websocketURL});
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.connectionInProgress = false;
        }
    }

    private WebSocketListener getWebsocketListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private String getConnectionFailedMessage() {
        return "Connection failed to " + this.websocketURL;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ String access$100(EthereumClientConnector x0) {
        return x0.getConnectionFailedMessage();
    }
}

