/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransaction;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionAspect;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionService;
import org.exoplatform.addon.wallet.blockchain.statistic.ExoWalletStatistic;
import org.exoplatform.addon.wallet.blockchain.statistic.ExoWalletStatisticAspect;
import org.exoplatform.addon.wallet.blockchain.statistic.ExoWalletStatisticService;
import org.exoplatform.addon.wallet.statistic.StatisticUtils;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketListener;
import org.web3j.protocol.websocket.WebSocketService;

/*
 * Exception performing whole class analysis ignored.
 */
public class EthereumClientConnector
implements ExoBlockchainTransactionService,
ExoWalletStatisticService,
Startable {
    private static final Log LOG;
    private Web3j web3j = null;
    private WebSocketClient webSocketClient = null;
    private WebSocketService web3jService = null;
    private ScheduledExecutorService connectionVerifierExecutor = null;
    private boolean connectionInProgress = false;
    private boolean serviceStarted = false;
    private boolean serviceStopping = false;
    private ClassLoader webappClassLoader = null;
    private String websocketURL = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public EthereumClientConnector(ClassLoader webappClassLoader) {
        this.webappClassLoader = webappClassLoader;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-websocket-connector-%d").build();
        this.connectionVerifierExecutor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
    }

    public ClassLoader getWebappClassLoader() {
        return this.webappClassLoader;
    }

    public void start() {
        this.start(WalletUtils.getWebsocketURL());
    }

    public void start(String websocketURL) {
        this.websocketURL = websocketURL;
        this.serviceStarted = true;
        this.connectionVerifierExecutor.scheduleWithFixedDelay(() -> {
            try {
                if (!this.initWeb3Connection()) {
                    return;
                }
            }
            catch (Throwable e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)"Error while checking connection status to Etherreum Websocket endpoint: {}", e);
                } else {
                    LOG.warn("Error while checking connection status to Etherreum Websocket endpoint: {}", new Object[]{e.getMessage()});
                }
                return;
            }
        }, 5L, 10L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.serviceStopping = true;
        this.connectionVerifierExecutor.shutdownNow();
        this.resetConnection();
    }

    @ExoWalletStatistic(statisticType="eth_getTransactionByHash")
    public Transaction getTransaction(String transactionHash) throws InterruptedException {
        String string = transactionHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        return (Transaction)EthereumClientConnector.getTransaction_aroundBody1$advice((EthereumClientConnector)this, (String)string, (JoinPoint)joinPoint, (ExoWalletStatisticAspect)ExoWalletStatisticAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoWalletStatistic(statisticType="eth_getTransactionReceipt")
    public TransactionReceipt getTransactionReceipt(String transactionHash) throws InterruptedException {
        String string = transactionHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        return (TransactionReceipt)EthereumClientConnector.getTransactionReceipt_aroundBody3$advice((EthereumClientConnector)this, (String)string, (JoinPoint)joinPoint, (ExoWalletStatisticAspect)ExoWalletStatisticAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    public boolean isConnected() {
        return this.web3j != null && this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen();
    }

    @ExoWalletStatistic(statisticType="eth_blockNumber")
    public long getLastestBlockNumber() throws InterruptedException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        return Conversions.longValue((Object)EthereumClientConnector.getLastestBlockNumber_aroundBody5$advice((EthereumClientConnector)this, (JoinPoint)joinPoint, (ExoWalletStatisticAspect)ExoWalletStatisticAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint)));
    }

    @ExoWalletStatistic(statisticType="eth_getLogs")
    public Set<String> getContractTransactions(String contractsAddress, long fromBlock, long toBlock) throws IOException, InterruptedException {
        String string = contractsAddress;
        long l = fromBlock;
        long l2 = toBlock;
        Object[] objectArray = new Object[]{string, Conversions.longObject((long)l), Conversions.longObject((long)l2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        return (Set)EthereumClientConnector.getContractTransactions_aroundBody7$advice((EthereumClientConnector)this, (String)string, (long)l, (long)l2, (JoinPoint)joinPoint, (ExoWalletStatisticAspect)ExoWalletStatisticAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    public Web3j getWeb3j() throws InterruptedException {
        this.waitConnection();
        return this.web3j;
    }

    public void waitConnection() throws InterruptedException {
        if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.websocketURL)) {
            throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
        }
        if (this.serviceStopping) {
            throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
        }
        while (!this.isConnected()) {
            if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.websocketURL)) {
                throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
            }
            if (this.serviceStopping) {
                throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
            }
            LOG.info((Object)"Wait until Websocket connection to blockchain is established to retrieve information");
            Thread.sleep(5000L);
        }
    }

    private void resetConnection() {
        if (this.web3j != null) {
            block8: {
                LOG.info((Object)"Resetting blockchain connection");
                try {
                    this.web3j.shutdown();
                }
                catch (Throwable e) {
                    LOG.warn("Error closing old web3j connection: {}", new Object[]{e.getMessage()});
                    if (this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen()) {
                        try {
                            this.web3jService.close();
                        }
                        catch (Throwable e1) {
                            LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
                        }
                    }
                    if (this.webSocketClient == null || !this.webSocketClient.isOpen()) break block8;
                    try {
                        this.webSocketClient.close();
                    }
                    catch (Throwable e1) {
                        LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
                    }
                }
            }
            this.web3j = null;
            this.web3jService = null;
            this.webSocketClient = null;
        }
    }

    public Map<String, Object> getParameters(String statisticType, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("remote_service", "blockchain");
        parameters.put("operation", statisticType);
        switch (statisticType) {
            case "eth_getTransactionByHash": {
                parameters.put("transaction_hash", methodArgs[0]);
                break;
            }
            case "eth_getTransactionReceipt": {
                parameters.put("transaction_hash", methodArgs[0]);
                break;
            }
            case "eth_getTransactionCount": {
                parameters.put("wallet_address", methodArgs[0]);
                break;
            }
            case "eth_blockNumber": {
                parameters.put("last_block_number", result);
                break;
            }
            case "eth_getLogs": {
                parameters.put("from_block_number", methodArgs[1]);
                parameters.put("to_block_number", methodArgs[2]);
                if (result instanceof Set) {
                    parameters.put("transactions_count_received", ((Set)result).size());
                    break;
                }
                LOG.warn("Statistict type {} has an unexpected result class type", new Object[]{statisticType});
                break;
            }
            default: {
                LOG.warn("Statistic type {} not managed", new Object[]{statisticType});
            }
        }
        return parameters;
    }

    @ExoWalletStatistic(statisticType="eth_getTransactionCount")
    public BigInteger getNonce(String walletAddress) throws IOException, InterruptedException {
        String string = walletAddress;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        return (BigInteger)EthereumClientConnector.getNonce_aroundBody9$advice((EthereumClientConnector)this, (String)string, (JoinPoint)joinPoint, (ExoWalletStatisticAspect)ExoWalletStatisticAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    private boolean initWeb3Connection() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        return Conversions.booleanValue((Object)EthereumClientConnector.initWeb3Connection_aroundBody11$advice((EthereumClientConnector)this, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint)));
    }

    private WebSocketListener getWebsocketListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private String getConnectionFailedMessage() {
        return "Connection failed to " + this.websocketURL;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ String access$100(EthereumClientConnector x0) {
        return x0.getConnectionFailedMessage();
    }

    static {
        EthereumClientConnector.ajc$preClinit();
        LOG = ExoLogger.getLogger(EthereumClientConnector.class);
    }

    private static /* synthetic */ Transaction getTransaction_aroundBody0(EthereumClientConnector ajc$this, String transactionHash, JoinPoint joinPoint) {
        EthTransaction ethTransaction;
        ajc$this.waitConnection();
        try {
            ethTransaction = (EthTransaction)ajc$this.web3j.ethGetTransactionByHash(transactionHash).send();
        }
        catch (IOException e) {
            LOG.info("Connection interrupted while getting Transaction '{}' information. Reattempt until getting it. Reason: {}", new Object[]{transactionHash, e.getMessage()});
            return ajc$this.getTransaction(transactionHash);
        }
        if (ethTransaction != null) {
            return (Transaction)ethTransaction.getResult();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object getTransaction_aroundBody1$advice(EthereumClientConnector ajc$this, String transactionHash, JoinPoint thisJoinPoint, ExoWalletStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        Transaction transaction;
        ExoWalletStatisticService statisticService = (ExoWalletStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoWalletStatistic annotation = method.getAnnotation(ExoWalletStatistic.class);
        String statisticType = annotation.statisticType();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        Transaction result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            transaction = result = EthereumClientConnector.getTransaction_aroundBody0((EthereumClientConnector)ajc$this, (String)transactionHash, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
                    if (parameters == null || parameters.isEmpty()) {
                        ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                        throw throwable;
                    }
                    parameters.put("remote_service", "blockchain");
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry((Map)parameters);
                    throw throwable;
                }
                catch (Exception e2) {
                    ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
            if (parameters == null || parameters.isEmpty()) {
                ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                return transaction;
            }
            parameters.put("remote_service", "blockchain");
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry((Map)parameters);
            return transaction;
        }
        catch (Exception e) {
            ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e});
        }
        return transaction;
    }

    private static /* synthetic */ TransactionReceipt getTransactionReceipt_aroundBody2(EthereumClientConnector ajc$this, String transactionHash, JoinPoint joinPoint) {
        EthGetTransactionReceipt ethGetTransactionReceipt;
        ajc$this.waitConnection();
        try {
            ethGetTransactionReceipt = (EthGetTransactionReceipt)ajc$this.web3j.ethGetTransactionReceipt(transactionHash).send();
        }
        catch (IOException e) {
            LOG.info("Connection interrupted while getting Transaction receipt '{}' information. Reattempt until getting it. Reason: {}", new Object[]{transactionHash, e.getMessage()});
            return ajc$this.getTransactionReceipt(transactionHash);
        }
        if (ethGetTransactionReceipt != null) {
            return (TransactionReceipt)ethGetTransactionReceipt.getResult();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object getTransactionReceipt_aroundBody3$advice(EthereumClientConnector ajc$this, String transactionHash, JoinPoint thisJoinPoint, ExoWalletStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        TransactionReceipt transactionReceipt;
        ExoWalletStatisticService statisticService = (ExoWalletStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoWalletStatistic annotation = method.getAnnotation(ExoWalletStatistic.class);
        String statisticType = annotation.statisticType();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        TransactionReceipt result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            transactionReceipt = result = EthereumClientConnector.getTransactionReceipt_aroundBody2((EthereumClientConnector)ajc$this, (String)transactionHash, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
                    if (parameters == null || parameters.isEmpty()) {
                        ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                        throw throwable;
                    }
                    parameters.put("remote_service", "blockchain");
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry((Map)parameters);
                    throw throwable;
                }
                catch (Exception e2) {
                    ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
            if (parameters == null || parameters.isEmpty()) {
                ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                return transactionReceipt;
            }
            parameters.put("remote_service", "blockchain");
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry((Map)parameters);
            return transactionReceipt;
        }
        catch (Exception e) {
            ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e});
        }
        return transactionReceipt;
    }

    private static /* synthetic */ long getLastestBlockNumber_aroundBody4(EthereumClientConnector ajc$this, JoinPoint joinPoint) {
        ajc$this.waitConnection();
        BigInteger blockNumber = ((EthBlockNumber)ajc$this.web3j.ethBlockNumber().send()).getBlockNumber();
        return blockNumber.longValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object getLastestBlockNumber_aroundBody5$advice(EthereumClientConnector ajc$this, JoinPoint thisJoinPoint, ExoWalletStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        Object object;
        ExoWalletStatisticService statisticService = (ExoWalletStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoWalletStatistic annotation = method.getAnnotation(ExoWalletStatistic.class);
        String statisticType = annotation.statisticType();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        Object result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            object = result = Conversions.longObject((long)EthereumClientConnector.getLastestBlockNumber_aroundBody4((EthereumClientConnector)ajc$this, (JoinPoint)proceedingJoinPoint));
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map parameters = statisticService.getParameters(statisticType, result, point.getArgs());
                    if (parameters == null || parameters.isEmpty()) {
                        ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                        throw throwable;
                    }
                    parameters.put("remote_service", "blockchain");
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry((Map)parameters);
                    throw throwable;
                }
                catch (Exception e2) {
                    ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map parameters = statisticService.getParameters(statisticType, result, point.getArgs());
            if (parameters == null || parameters.isEmpty()) {
                ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                return object;
            }
            parameters.put("remote_service", "blockchain");
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry((Map)parameters);
            return object;
        }
        catch (Exception e) {
            ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e});
        }
        return object;
    }

    private static /* synthetic */ Set getContractTransactions_aroundBody6(EthereumClientConnector ajc$this, String contractsAddress, long fromBlock, long toBlock, JoinPoint joinPoint) {
        ajc$this.waitConnection();
        EthFilter filter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), contractsAddress);
        EthLog contractTransactions = (EthLog)ajc$this.web3j.ethGetLogs(filter).send();
        List logs = (List)contractTransactions.getResult();
        HashSet<String> txHashes = new HashSet<String>();
        if (logs != null && !logs.isEmpty()) {
            for (EthLog.LogResult logResult : logs) {
                org.web3j.protocol.core.methods.response.Log contractEventLog = (org.web3j.protocol.core.methods.response.Log)logResult.get();
                txHashes.add(contractEventLog.getTransactionHash());
            }
        }
        return txHashes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object getContractTransactions_aroundBody7$advice(EthereumClientConnector ajc$this, String contractsAddress, long fromBlock, long toBlock, JoinPoint thisJoinPoint, ExoWalletStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        Set set;
        ExoWalletStatisticService statisticService = (ExoWalletStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoWalletStatistic annotation = method.getAnnotation(ExoWalletStatistic.class);
        String statisticType = annotation.statisticType();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        Set result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            set = result = EthereumClientConnector.getContractTransactions_aroundBody6((EthereumClientConnector)ajc$this, (String)contractsAddress, (long)fromBlock, (long)toBlock, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
                    if (parameters == null || parameters.isEmpty()) {
                        ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                        throw throwable;
                    }
                    parameters.put("remote_service", "blockchain");
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry((Map)parameters);
                    throw throwable;
                }
                catch (Exception e2) {
                    ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
            if (parameters == null || parameters.isEmpty()) {
                ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                return set;
            }
            parameters.put("remote_service", "blockchain");
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry((Map)parameters);
            return set;
        }
        catch (Exception e) {
            ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e});
        }
        return set;
    }

    private static /* synthetic */ BigInteger getNonce_aroundBody8(EthereumClientConnector ajc$this, String walletAddress, JoinPoint joinPoint) {
        ajc$this.waitConnection();
        return ((EthGetTransactionCount)ajc$this.getWeb3j().ethGetTransactionCount(walletAddress, (DefaultBlockParameter)DefaultBlockParameterName.PENDING).send()).getTransactionCount();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object getNonce_aroundBody9$advice(EthereumClientConnector ajc$this, String walletAddress, JoinPoint thisJoinPoint, ExoWalletStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        BigInteger bigInteger;
        ExoWalletStatisticService statisticService = (ExoWalletStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoWalletStatistic annotation = method.getAnnotation(ExoWalletStatistic.class);
        String statisticType = annotation.statisticType();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        BigInteger result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            bigInteger = result = EthereumClientConnector.getNonce_aroundBody8((EthereumClientConnector)ajc$this, (String)walletAddress, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
                    if (parameters == null || parameters.isEmpty()) {
                        ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                        throw throwable;
                    }
                    parameters.put("remote_service", "blockchain");
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry((Map)parameters);
                    throw throwable;
                }
                catch (Exception e2) {
                    ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
            if (parameters == null || parameters.isEmpty()) {
                ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                return bigInteger;
            }
            parameters.put("remote_service", "blockchain");
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry((Map)parameters);
            return bigInteger;
        }
        catch (Exception e) {
            ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e});
        }
        return bigInteger;
    }

    private static /* synthetic */ boolean initWeb3Connection_aroundBody10(EthereumClientConnector ajc$this, JoinPoint joinPoint) {
        if (ajc$this.connectionInProgress) {
            LOG.info((Object)"Web3 connection initialization in progress, skip transaction processing until it's initialized");
            return false;
        }
        if (ajc$this.serviceStopping) {
            LOG.info((Object)"Stopping server, thus no new connection is attempted again");
            return false;
        }
        String websocketProviderURL = ajc$this.websocketURL;
        if (StringUtils.isBlank((CharSequence)websocketProviderURL)) {
            LOG.info((Object)"No configured URL for Ethereum Websocket connection");
            ajc$this.resetConnection();
            return false;
        }
        if (!websocketProviderURL.startsWith("ws:") && !websocketProviderURL.startsWith("wss:")) {
            LOG.warn((Object)("Bad format for configured URL " + websocketProviderURL + " for Ethereum Websocket connection"));
            ajc$this.resetConnection();
            return false;
        }
        if (ajc$this.isConnected()) {
            return false;
        }
        ajc$this.connectionInProgress = true;
        try {
            if (ajc$this.web3j != null && ajc$this.web3jService != null && ajc$this.webSocketClient != null) {
                LOG.info("Reconnect to blockchain endpoint {}", new Object[]{ajc$this.websocketURL});
                boolean reconnected = ajc$this.webSocketClient.reconnectBlocking();
                if (!reconnected) {
                    throw new IllegalStateException("Can't reconnect to ethereum blockchain: " + ajc$this.websocketURL);
                }
            } else {
                LOG.info("Connecting to Ethereum network endpoint {}", new Object[]{ajc$this.websocketURL});
                ajc$this.webSocketClient = new WebSocketClient(new URI(ajc$this.websocketURL));
                ajc$this.webSocketClient.setConnectionLostTimeout(10);
                ajc$this.web3jService = new WebSocketService(ajc$this.webSocketClient, true);
                ajc$this.webSocketClient.setListener(ajc$this.getWebsocketListener());
                ajc$this.web3jService.connect();
                Thread.sleep(10000L);
                ajc$this.web3j = Web3j.build((Web3jService)ajc$this.web3jService);
                LOG.info("Connection established to Ethereum network endpoint {}", new Object[]{ajc$this.websocketURL});
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ajc$this.connectionInProgress = false;
        }
    }

    private static /* synthetic */ Object initWeb3Connection_aroundBody11$advice(EthereumClientConnector ajc$this, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            Object object = Conversions.booleanObject((boolean)EthereumClientConnector.initWeb3Connection_aroundBody10((EthereumClientConnector)ajc$this, (JoinPoint)proceedingJoinPoint));
            return object;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EthereumClientConnector.java", EthereumClientConnector.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransaction", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "transactionHash", "java.lang.InterruptedException", "org.web3j.protocol.core.methods.response.Transaction"), 124);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransactionReceipt", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "transactionHash", "java.lang.InterruptedException", "org.web3j.protocol.core.methods.response.TransactionReceipt"), 149);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastestBlockNumber", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "", "", "java.lang.InterruptedException:java.io.IOException", "long"), 179);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getContractTransactions", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String:long:long", "contractsAddress:fromBlock:toBlock", "java.io.IOException:java.lang.InterruptedException", "java.util.Set"), 201);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNonce", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "walletAddress", "java.io.IOException:java.lang.InterruptedException", "java.math.BigInteger"), 308);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initWeb3Connection", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "", "", "java.lang.Exception", "boolean"), 316);
    }
}

