/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransaction;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionAspect;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionService;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.blockchain.statistic.ExoWalletStatistic;
import org.exoplatform.addon.wallet.blockchain.statistic.ExoWalletStatisticAspect;
import org.exoplatform.addon.wallet.blockchain.statistic.ExoWalletStatisticService;
import org.exoplatform.addon.wallet.contract.ERTTokenV2;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.WalletInitializationState;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletContractService;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.statistic.StatisticUtils;
import org.exoplatform.addon.wallet.storage.WalletStorage;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.picocontainer.Startable;
import org.web3j.abi.datatypes.Address;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.crypto.WalletUtils;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.FastRawTransactionManager;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;
import org.web3j.tx.response.NoOpProcessor;
import org.web3j.tx.response.TransactionReceiptProcessor;
import org.web3j.utils.Numeric;

/*
 * Exception performing whole class analysis ignored.
 */
public class EthereumWalletTokenAdminService
implements WalletTokenAdminService,
Startable,
ExoBlockchainTransactionService,
ExoWalletStatisticService {
    private static final Log LOG;
    private static final int ADMIN_WALLET_MIN_LEVEL = 2;
    private static final long DEFAULT_ADMIN_GAS = 300000L;
    private static final String NO_CONFIGURED_CONTRACT_ADDRESS = "No configured contract address";
    private static final String TRANSACTION_DETAIL_IS_MANDATORY = "Transaction detail is mandatory";
    private static final String TRANSACTION_HASH_IS_EMPTY = "Transaction hash is empty for transaction: ";
    private static final String RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY = "receiver address parameter is mandatory";
    private ClassLoader webappClassLoader;
    private UserACL userACL;
    private WalletContractService walletContractService;
    private EthereumClientConnector clientConnector;
    private WalletAccountService accountService;
    private WalletStorage accountStorage;
    private WalletTransactionService transactionService;
    private ERTTokenV2 ertInstance;
    private TransactionManager contractTransactionManager;
    private boolean isReadOnlyContract;
    private String configuredContractAddress;
    private Integer configuredContractDecimals;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;

    public EthereumWalletTokenAdminService(EthereumClientConnector clientConnector, ClassLoader classLoader) {
        this.webappClassLoader = classLoader;
        this.clientConnector = clientConnector;
    }

    public ClassLoader getWebappClassLoader() {
        return this.webappClassLoader;
    }

    @ExoBlockchainTransaction
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        EthereumWalletTokenAdminService.start_aroundBody1$advice((EthereumWalletTokenAdminService)this, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    public void stop() {
    }

    @ExoBlockchainTransaction
    public void createAdminAccount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        EthereumWalletTokenAdminService.createAdminAccount_aroundBody3$advice((EthereumWalletTokenAdminService)this, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    public org.exoplatform.addon.wallet.model.Wallet createAdminAccount(String privateKey, String currentUser) throws IllegalAccessException {
        String string = privateKey;
        String string2 = currentUser;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)string2);
        return (org.exoplatform.addon.wallet.model.Wallet)EthereumWalletTokenAdminService.createAdminAccount_aroundBody5$advice((EthereumWalletTokenAdminService)this, (String)string, (String)string2, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    public org.exoplatform.addon.wallet.model.Wallet getAdminWallet() {
        return this.getAccountService().getWalletByTypeAndId(WalletType.ADMIN.getId(), "admin");
    }

    public String getAdminWalletAddress() {
        org.exoplatform.addon.wallet.model.Wallet adminWallet = this.getAdminWallet();
        return adminWallet == null ? null : adminWallet.getAddress();
    }

    @ExoBlockchainTransaction
    public final boolean isApprovedAccount(String address) throws Exception {
        String string = address;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        return Conversions.booleanValue((Object)EthereumWalletTokenAdminService.isApprovedAccount_aroundBody7$advice((EthereumWalletTokenAdminService)this, (String)string, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint)));
    }

    @ExoBlockchainTransaction
    public final int getAdminLevel(String address) throws Exception {
        String string = address;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        return Conversions.intValue((Object)EthereumWalletTokenAdminService.getAdminLevel_aroundBody9$advice((EthereumWalletTokenAdminService)this, (String)string, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint)));
    }

    @ExoBlockchainTransaction
    public final boolean isInitializedAccount(String address) throws Exception {
        String string = address;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        return Conversions.booleanValue((Object)EthereumWalletTokenAdminService.isInitializedAccount_aroundBody11$advice((EthereumWalletTokenAdminService)this, (String)string, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint)));
    }

    @ExoBlockchainTransaction
    public final BigInteger balanceOf(String address) throws Exception {
        String string = address;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        return (BigInteger)EthereumWalletTokenAdminService.balanceOf_aroundBody13$advice((EthereumWalletTokenAdminService)this, (String)string, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    @ExoWalletStatistic(statisticType="eth_getBalance")
    public final BigInteger getEtherBalanceOf(String address) throws Exception {
        String string = address;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        return (BigInteger)EthereumWalletTokenAdminService.getEtherBalanceOf_aroundBody17$advice((EthereumWalletTokenAdminService)this, (String)string, (JoinPoint)joinPoint, (ExoWalletStatisticAspect)ExoWalletStatisticAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    public final TransactionDetail initialize(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        TransactionDetail transactionDetail2 = transactionDetail;
        String string = issuerUsername;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)transactionDetail2, (Object)string);
        return (TransactionDetail)EthereumWalletTokenAdminService.initialize_aroundBody19$advice((EthereumWalletTokenAdminService)this, (TransactionDetail)transactionDetail2, (String)string, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    public TransactionDetail sendEther(TransactionDetail transactionDetail, String currentUserId) throws Exception {
        TransactionDetail transactionDetail2 = transactionDetail;
        String string = currentUserId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)transactionDetail2, (Object)string);
        return (TransactionDetail)EthereumWalletTokenAdminService.sendEther_aroundBody21$advice((EthereumWalletTokenAdminService)this, (TransactionDetail)transactionDetail2, (String)string, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    public final TransactionDetail sendToken(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        TransactionDetail transactionDetail2 = transactionDetail;
        String string = issuerUsername;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)transactionDetail2, (Object)string);
        return (TransactionDetail)EthereumWalletTokenAdminService.sendToken_aroundBody23$advice((EthereumWalletTokenAdminService)this, (TransactionDetail)transactionDetail2, (String)string, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    public final TransactionDetail reward(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        TransactionDetail transactionDetail2 = transactionDetail;
        String string = issuerUsername;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)transactionDetail2, (Object)string);
        return (TransactionDetail)EthereumWalletTokenAdminService.reward_aroundBody25$advice((EthereumWalletTokenAdminService)this, (TransactionDetail)transactionDetail2, (String)string, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    public void refreshWallet(org.exoplatform.addon.wallet.model.Wallet wallet, ContractDetail contractDetail, Set<String> walletModifications) throws Exception {
        org.exoplatform.addon.wallet.model.Wallet wallet2 = wallet;
        ContractDetail contractDetail2 = contractDetail;
        Set<String> set = walletModifications;
        Object[] objectArray = new Object[]{wallet2, contractDetail2, set};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
        EthereumWalletTokenAdminService.refreshWallet_aroundBody27$advice((EthereumWalletTokenAdminService)this, (org.exoplatform.addon.wallet.model.Wallet)wallet2, (ContractDetail)contractDetail2, set, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    public void refreshContractDetailFromBlockchain(ContractDetail contractDetail, Set<String> contractModifications) {
        ContractDetail contractDetail2 = contractDetail;
        Set<String> set = contractModifications;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)contractDetail2, set);
        EthereumWalletTokenAdminService.refreshContractDetailFromBlockchain_aroundBody29$advice((EthereumWalletTokenAdminService)this, (ContractDetail)contractDetail2, set, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    public Map<String, Object> getParameters(String statisticType, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("remote_service", "blockchain");
        switch (statisticType) {
            case "eth_getBalance": {
                parameters.put("address", methodArgs[0]);
                break;
            }
            case "eth_call": {
                parameters.put("contract_address", methodArgs[0]);
                parameters.put("contract_method", methodArgs[1]);
                break;
            }
            case "SEND_ADMIN_ETHER_TRANSACTION": {
                this.addSendEtherTransactionParameters(parameters, methodArgs);
                break;
            }
            case "SEND_TOKEN_ADMIN_TRANSACTION": {
                String contractAddress = (String)methodArgs[0];
                String methodName = (String)methodArgs[1];
                org.exoplatform.addon.wallet.model.Wallet fromWallet = this.getAdminWallet();
                parameters.put("contract_address", contractAddress);
                parameters.put("contract_method", methodName);
                parameters.put("sender", fromWallet);
                if (StringUtils.equals((CharSequence)"initializeAccount", (CharSequence)methodName)) {
                    Object[] contractMethodParams = (Object[])methodArgs[2];
                    String toAddress = (String)contractMethodParams[0];
                    org.exoplatform.addon.wallet.model.Wallet toWallet = this.getAccountService().getWalletByAddress(toAddress);
                    BigInteger tokenAmountDecimals = (BigInteger)contractMethodParams[0];
                    double tokenAmount = org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)tokenAmountDecimals, (int)this.configuredContractDecimals);
                    BigInteger etherAmountDecimals = (BigInteger)contractMethodParams[0];
                    double etherAmount = org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)etherAmountDecimals, (int)18);
                    parameters.put("receiver", toWallet);
                    parameters.put("amount_token", tokenAmount);
                    parameters.put("amount_ether", etherAmount);
                    break;
                }
                if (StringUtils.equals((CharSequence)"reward", (CharSequence)methodName) || StringUtils.equals((CharSequence)"transfer", (CharSequence)methodName)) {
                    Object[] contractMethodParams = (Object[])methodArgs[2];
                    String toAddress = (String)contractMethodParams[0];
                    org.exoplatform.addon.wallet.model.Wallet toWallet = this.getAccountService().getWalletByAddress(toAddress);
                    BigInteger tokenAmountDecimals = (BigInteger)contractMethodParams[1];
                    double tokenAmount = org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)tokenAmountDecimals, (int)this.configuredContractDecimals);
                    parameters.put("receiver", toWallet);
                    parameters.put("amount_token", tokenAmount);
                    break;
                }
                LOG.warn("Admin wallet transaction with method name {} is not correctly managed in statistics", new Object[]{methodName});
                break;
            }
            default: {
                LOG.warn("Statistic type {} is not managed", new Object[]{statisticType});
            }
        }
        if ("SEND_ADMIN_ETHER_TRANSACTION".equals(statisticType) || "SEND_TOKEN_ADMIN_TRANSACTION".equals(statisticType)) {
            statisticType = "eth_sendRawTransaction";
        }
        parameters.put("operation", statisticType);
        return parameters;
    }

    private String checkContractAddress() {
        if (StringUtils.isBlank((CharSequence)this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        return this.configuredContractAddress;
    }

    private void setIssuer(TransactionDetail transactionDetail, String issuerUsername) {
        if (StringUtils.isNotBlank((CharSequence)issuerUsername)) {
            org.exoplatform.addon.wallet.model.Wallet issuerWallet = this.getAccountService().getWalletByTypeAndId(WalletType.USER.name(), issuerUsername);
            if (issuerWallet == null) {
                throw new IllegalStateException("Can't find identity of user with id " + issuerUsername);
            }
            transactionDetail.setIssuer(issuerWallet);
        }
    }

    private final void checkAdminWalletIsValid() throws Exception {
        String adminAddress = this.getAdminWalletAddress();
        if (adminAddress == null) {
            throw new IllegalStateException("No admin wallet is set");
        }
        int adminLevel = this.getAdminLevel(adminAddress);
        if (adminLevel < 2) {
            throw new IllegalStateException("Admin wallet haven't enough privileges to manage wallets");
        }
    }

    @ExoWalletStatistic(statisticType="SEND_ADMIN_ETHER_TRANSACTION")
    public String executeSendEtherTransaction(String receiverAddress, double amountInEther) throws Exception {
        String string = receiverAddress;
        double d = amountInEther;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string, (Object)Conversions.doubleObject((double)d));
        return (String)EthereumWalletTokenAdminService.executeSendEtherTransaction_aroundBody31$advice((EthereumWalletTokenAdminService)this, (String)string, (double)d, (JoinPoint)joinPoint, (ExoWalletStatisticAspect)ExoWalletStatisticAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    private Long getAdminGasPrice(GlobalSettings settings) {
        return settings.getNetwork().getMinGasPrice();
    }

    @ExoWalletStatistic(statisticType="SEND_TOKEN_ADMIN_TRANSACTION")
    public String executeTokenTransaction(String contractAddress, String methodName, Object ... arguments) throws Exception {
        String string = contractAddress;
        String string2 = methodName;
        Object[] objectArray = arguments;
        Object[] objectArray2 = new Object[]{string, string2, objectArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object[])objectArray2);
        return (String)EthereumWalletTokenAdminService.executeTokenTransaction_aroundBody33$advice((EthereumWalletTokenAdminService)this, (String)string, (String)string2, (Object[])objectArray, (JoinPoint)joinPoint, (ExoWalletStatisticAspect)ExoWalletStatisticAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoWalletStatistic(statisticType="eth_call")
    public Object executeReadOperation(String contractAddress, String methodName, Object ... arguments) throws Exception {
        String string = contractAddress;
        String string2 = methodName;
        Object[] objectArray = arguments;
        Object[] objectArray2 = new Object[]{string, string2, objectArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object[])objectArray2);
        return EthereumWalletTokenAdminService.executeReadOperation_aroundBody35$advice((EthereumWalletTokenAdminService)this, (String)string, (String)string2, (Object[])objectArray, (JoinPoint)joinPoint, (ExoWalletStatisticAspect)ExoWalletStatisticAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    public ERTTokenV2 getContractInstance(String contractAddress, boolean writeOperation) throws InterruptedException, IOException {
        if (writeOperation && this.contractTransactionManager instanceof FastRawTransactionManager) {
            FastRawTransactionManager fastRawTransactionManager = (FastRawTransactionManager)this.contractTransactionManager;
            BigInteger transactionCount = this.getClientConnector().getNonce(fastRawTransactionManager.getFromAddress());
            fastRawTransactionManager.setNonce(transactionCount.subtract(BigInteger.valueOf(1L)));
        }
        if (this.ertInstance != null) {
            if (this.isReadOnlyContract && writeOperation) {
                throw new IllegalStateException("Admin account keys aren't set");
            }
            return this.ertInstance;
        }
        Credentials adminCredentials = this.getAdminCredentials();
        if (adminCredentials == null && writeOperation) {
            throw new IllegalStateException("Admin account keys aren't set");
        }
        GlobalSettings settings = org.exoplatform.addon.wallet.utils.WalletUtils.getSettings();
        BigInteger gasPrice = BigInteger.valueOf(this.getAdminGasPrice(settings));
        BigInteger gasLimit = BigInteger.valueOf(300000L);
        StaticGasProvider gasProvider = new StaticGasProvider(gasPrice, gasLimit);
        this.contractTransactionManager = this.getTransactionManager(adminCredentials);
        this.ertInstance = ERTTokenV2.load((String)contractAddress, (Web3j)this.getClientConnector().getWeb3j(), (TransactionManager)this.contractTransactionManager, (ContractGasProvider)gasProvider);
        this.isReadOnlyContract = adminCredentials == null;
        return this.ertInstance;
    }

    private TransactionManager getTransactionManager(Credentials credentials) throws InterruptedException {
        this.getClientConnector().waitConnection();
        Web3j web3j = this.getClientConnector().getWeb3j();
        if (credentials == null) {
            return new ReadonlyTransactionManager(web3j, Address.DEFAULT.toString());
        }
        return new FastRawTransactionManager(web3j, credentials, (TransactionReceiptProcessor)new NoOpProcessor(web3j));
    }

    private Credentials getAdminCredentials() {
        ECKeyPair adminWalletKeys = (ECKeyPair)this.getAdminWalletKeys();
        if (adminWalletKeys == null) {
            return null;
        }
        return Credentials.create((ECKeyPair)adminWalletKeys);
    }

    private Object getAdminWalletKeys() {
        String adminPrivateKey = this.getAccountService().getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin");
        if (StringUtils.isBlank((CharSequence)adminPrivateKey)) {
            return null;
        }
        WalletFile adminWallet = null;
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
            adminWallet = (WalletFile)objectMapper.readerFor(WalletFile.class).readValue(adminPrivateKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while parsing admin wallet keys", e);
        }
        try {
            return Wallet.decrypt((String)this.accountService.getAdminAccountPassword(), (WalletFile)adminWallet);
        }
        catch (CipherException e) {
            throw new IllegalStateException("Can't descrypt stored admin wallet", e);
        }
    }

    private void addSendEtherTransactionParameters(Map<String, Object> parameters, Object ... methodArgs) {
        org.exoplatform.addon.wallet.model.Wallet fromWallet = this.getAdminWallet();
        org.exoplatform.addon.wallet.model.Wallet toWallet = this.getAccountService().getWalletByAddress((String)methodArgs[0]);
        double etherAmount = (Double)methodArgs[1];
        parameters.put("sender", fromWallet);
        parameters.put("receiver", toWallet);
        parameters.put("amount_ether", etherAmount);
    }

    private Method getMethod(String methodName) {
        Method[] methods;
        Method methodToInvoke = null;
        for (Method method : methods = ERTTokenV2.class.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)methodName, (CharSequence)method.getName())) continue;
            methodToInvoke = method;
        }
        return methodToInvoke;
    }

    private ContractDetail getPrincipalContractDetail() {
        GlobalSettings settings = org.exoplatform.addon.wallet.utils.WalletUtils.getSettings();
        return settings.getContractDetail();
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private WalletStorage getAccountStorage() {
        if (this.accountStorage == null) {
            this.accountStorage = (WalletStorage)CommonsUtils.getService(WalletStorage.class);
        }
        return this.accountStorage;
    }

    private WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    private WalletContractService getContractService() {
        if (this.walletContractService == null) {
            this.walletContractService = (WalletContractService)CommonsUtils.getService(WalletContractService.class);
        }
        return this.walletContractService;
    }

    private EthereumClientConnector getClientConnector() {
        return this.clientConnector;
    }

    private UserACL getUserACL() {
        if (this.userACL == null) {
            this.userACL = (UserACL)CommonsUtils.getService(UserACL.class);
        }
        return this.userACL;
    }

    static {
        EthereumWalletTokenAdminService.ajc$preClinit();
        LOG = ExoLogger.getLogger(EthereumWalletTokenAdminService.class);
    }

    private static /* synthetic */ void start_aroundBody0(EthereumWalletTokenAdminService ajc$this, JoinPoint joinPoint) {
        org.exoplatform.addon.wallet.model.Wallet wallet = ajc$this.getAdminWallet();
        if (wallet == null || StringUtils.isBlank((CharSequence)wallet.getAddress())) {
            ajc$this.createAdminAccount();
            LOG.info((Object)"Admin wallet created");
        }
        try {
            ajc$this.configuredContractAddress = org.exoplatform.addon.wallet.utils.WalletUtils.getSettings().getContractAddress();
            ajc$this.getContractService().refreshContractDetail(new HashSet());
            ajc$this.configuredContractDecimals = ajc$this.getPrincipalContractDetail().getDecimals();
        }
        catch (Exception e) {
            LOG.warn("Error refreshing contract detail from blockchain with address {}", new Object[]{ajc$this.configuredContractAddress, e});
        }
    }

    private static /* synthetic */ Object start_aroundBody1$advice(EthereumWalletTokenAdminService ajc$this, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            EthereumWalletTokenAdminService.start_aroundBody0((EthereumWalletTokenAdminService)ajc$this, (JoinPoint)proceedingJoinPoint);
            Object var6_7 = null;
            return var6_7;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ void createAdminAccount_aroundBody2(EthereumWalletTokenAdminService ajc$this, JoinPoint joinPoint) {
        try {
            ajc$this.createAdminAccount(null, ajc$this.getUserACL().getSuperUser());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("This exception shouldn't be thrown because no ACL check is made on server side method call", e);
        }
    }

    private static /* synthetic */ Object createAdminAccount_aroundBody3$advice(EthereumWalletTokenAdminService ajc$this, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            EthereumWalletTokenAdminService.createAdminAccount_aroundBody2((EthereumWalletTokenAdminService)ajc$this, (JoinPoint)proceedingJoinPoint);
            Object var6_7 = null;
            return var6_7;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ org.exoplatform.addon.wallet.model.Wallet createAdminAccount_aroundBody4(EthereumWalletTokenAdminService ajc$this, String privateKey, String currentUser, JoinPoint joinPoint) {
        if (!org.exoplatform.addon.wallet.utils.WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException("User " + currentUser + " is not allowed to create admin wallet");
        }
        Identity identity = org.exoplatform.addon.wallet.utils.WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.ADMIN, (String)"admin");
        if (identity == null) {
            throw new IllegalStateException("Can't find identity of admin wallet");
        }
        long identityId = Long.parseLong(identity.getId());
        org.exoplatform.addon.wallet.model.Wallet wallet = ajc$this.getAccountService().getWalletByIdentityId(identityId);
        if (wallet != null && wallet.getAddress() != null && ajc$this.getAccountService().getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin") != null) {
            throw new IllegalStateException("Admin wallet has already an associated wallet, thus can't overwrite it");
        }
        ECKeyPair ecKeyPair = null;
        if (StringUtils.isBlank((CharSequence)privateKey)) {
            try {
                ecKeyPair = Keys.createEcKeyPair();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error creating new wallet keys pair", e);
            }
        } else {
            if (!WalletUtils.isValidPrivateKey((String)privateKey)) {
                throw new IllegalStateException("Private key isn't valid");
            }
            ecKeyPair = Credentials.create((String)privateKey).getEcKeyPair();
        }
        WalletFile adminWallet = null;
        try {
            adminWallet = Wallet.createLight((String)ajc$this.accountService.getAdminAccountPassword(), (ECKeyPair)ecKeyPair);
        }
        catch (CipherException e) {
            throw new IllegalStateException("Error creating new wallet", e);
        }
        wallet = new org.exoplatform.addon.wallet.model.Wallet();
        wallet.setEnabled(true);
        wallet.setId("admin");
        wallet.setType(WalletType.ADMIN.getId());
        wallet.setAddress("0x" + adminWallet.getAddress());
        wallet.setTechnicalId(identityId);
        ajc$this.getAccountService().saveWalletAddress(wallet, currentUser, false);
        try {
            String walletJson = org.exoplatform.addon.wallet.utils.WalletUtils.toJsonString((Object)adminWallet);
            ajc$this.getAccountStorage().saveWalletPrivateKey(identityId, walletJson);
            ajc$this.isReadOnlyContract = false;
        }
        catch (Exception e) {
            ajc$this.getAccountService().removeWalletByAddress(wallet.getAddress(), currentUser);
        }
        return wallet;
    }

    private static /* synthetic */ Object createAdminAccount_aroundBody5$advice(EthereumWalletTokenAdminService ajc$this, String privateKey, String currentUser, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            org.exoplatform.addon.wallet.model.Wallet wallet = EthereumWalletTokenAdminService.createAdminAccount_aroundBody4((EthereumWalletTokenAdminService)ajc$this, (String)privateKey, (String)currentUser, (JoinPoint)proceedingJoinPoint);
            return wallet;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ boolean isApprovedAccount_aroundBody6(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint joinPoint) {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = ajc$this.checkContractAddress();
        return (Boolean)ajc$this.executeReadOperation(contractAddress, "isApprovedAccount", new Object[]{address});
    }

    private static /* synthetic */ Object isApprovedAccount_aroundBody7$advice(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            Object object = Conversions.booleanObject((boolean)EthereumWalletTokenAdminService.isApprovedAccount_aroundBody6((EthereumWalletTokenAdminService)ajc$this, (String)address, (JoinPoint)proceedingJoinPoint));
            return object;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ int getAdminLevel_aroundBody8(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint joinPoint) {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = ajc$this.checkContractAddress();
        BigInteger adminLevel = (BigInteger)ajc$this.executeReadOperation(contractAddress, "getAdminLevel", new Object[]{address});
        return adminLevel == null ? 0 : adminLevel.intValue();
    }

    private static /* synthetic */ Object getAdminLevel_aroundBody9$advice(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            Object object = Conversions.intObject((int)EthereumWalletTokenAdminService.getAdminLevel_aroundBody8((EthereumWalletTokenAdminService)ajc$this, (String)address, (JoinPoint)proceedingJoinPoint));
            return object;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ boolean isInitializedAccount_aroundBody10(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint joinPoint) {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = ajc$this.checkContractAddress();
        return (Boolean)ajc$this.executeReadOperation(contractAddress, "isInitializedAccount", new Object[]{address});
    }

    private static /* synthetic */ Object isInitializedAccount_aroundBody11$advice(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            Object object = Conversions.booleanObject((boolean)EthereumWalletTokenAdminService.isInitializedAccount_aroundBody10((EthereumWalletTokenAdminService)ajc$this, (String)address, (JoinPoint)proceedingJoinPoint));
            return object;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ BigInteger balanceOf_aroundBody12(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint joinPoint) {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = ajc$this.checkContractAddress();
        return (BigInteger)ajc$this.executeReadOperation(contractAddress, "balanceOf", new Object[]{address});
    }

    private static /* synthetic */ Object balanceOf_aroundBody13$advice(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            BigInteger bigInteger = EthereumWalletTokenAdminService.balanceOf_aroundBody12((EthereumWalletTokenAdminService)ajc$this, (String)address, (JoinPoint)proceedingJoinPoint);
            return bigInteger;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ BigInteger getEtherBalanceOf_aroundBody14(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint joinPoint) {
        Web3j web3j = ajc$this.getClientConnector().getWeb3j();
        if (web3j == null) {
            throw new IllegalStateException("Can't get ether balance of " + address + " . Connection is not established.");
        }
        return ((EthGetBalance)web3j.ethGetBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
    }

    private static /* synthetic */ Object getEtherBalanceOf_aroundBody15$advice(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            BigInteger bigInteger = EthereumWalletTokenAdminService.getEtherBalanceOf_aroundBody14((EthereumWalletTokenAdminService)ajc$this, (String)address, (JoinPoint)proceedingJoinPoint);
            return bigInteger;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ BigInteger getEtherBalanceOf_aroundBody16(EthereumWalletTokenAdminService ethereumWalletTokenAdminService, String string, JoinPoint joinPoint) {
        return (BigInteger)EthereumWalletTokenAdminService.getEtherBalanceOf_aroundBody15$advice((EthereumWalletTokenAdminService)ethereumWalletTokenAdminService, (String)string, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object getEtherBalanceOf_aroundBody17$advice(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint thisJoinPoint, ExoWalletStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        BigInteger bigInteger;
        ExoWalletStatisticService statisticService = (ExoWalletStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoWalletStatistic annotation = method.getAnnotation(ExoWalletStatistic.class);
        String statisticType = annotation.statisticType();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        BigInteger result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            bigInteger = result = EthereumWalletTokenAdminService.getEtherBalanceOf_aroundBody16((EthereumWalletTokenAdminService)ajc$this, (String)address, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
                    if (parameters == null || parameters.isEmpty()) {
                        ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                        throw throwable;
                    }
                    parameters.put("remote_service", "blockchain");
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry((Map)parameters);
                    throw throwable;
                }
                catch (Exception e2) {
                    ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
            if (parameters == null || parameters.isEmpty()) {
                ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                return bigInteger;
            }
            parameters.put("remote_service", "blockchain");
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry((Map)parameters);
            return bigInteger;
        }
        catch (Exception e) {
            ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e});
        }
        return bigInteger;
    }

    private static /* synthetic */ TransactionDetail initialize_aroundBody18(EthereumWalletTokenAdminService ajc$this, TransactionDetail transactionDetail, String issuerUsername, JoinPoint joinPoint) {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiver = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiver)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        ajc$this.checkAdminWalletIsValid();
        ajc$this.setIssuer(transactionDetail, issuerUsername);
        if (ajc$this.isInitializedAccount(receiver)) {
            throw new IllegalStateException("Wallet {} is already initialized");
        }
        String adminWalletAddress = ajc$this.getAdminWalletAddress();
        BigInteger tokenAmount = transactionDetail.getContractAmountDecimal(ajc$this.configuredContractDecimals.intValue());
        BigInteger etherAmount = transactionDetail.getValueDecimal(18);
        BigInteger balanceOfAdmin = ajc$this.balanceOf(adminWalletAddress);
        if (balanceOfAdmin == null || balanceOfAdmin.compareTo(tokenAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough tokens to initialize " + tokenAmount.longValue() + " tokens to " + receiver);
        }
        if (ajc$this.getEtherBalanceOf(adminWalletAddress).compareTo(etherAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough ether to initialize " + etherAmount.longValue() + " WEI to " + receiver);
        }
        if (StringUtils.isBlank((CharSequence)ajc$this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        String transactionHash = ajc$this.executeTokenTransaction(ajc$this.configuredContractAddress, "initializeAccount", new Object[]{receiver, tokenAmount, etherAmount});
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException("Transaction hash is empty for transaction: " + transactionDetail);
        }
        ajc$this.getAccountService().setInitializationStatus(receiver, WalletInitializationState.PENDING);
        transactionDetail.setNetworkId(org.exoplatform.addon.wallet.utils.WalletUtils.getNetworkId());
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(adminWalletAddress);
        transactionDetail.setContractAddress(ajc$this.configuredContractAddress);
        transactionDetail.setContractMethodName("initializeAccount");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        transactionDetail.setGasPrice((double)ajc$this.getAdminGasPrice(org.exoplatform.addon.wallet.utils.WalletUtils.getSettings()).longValue());
        ajc$this.getTransactionService().saveTransactionDetail(transactionDetail, true);
        return transactionDetail;
    }

    private static /* synthetic */ Object initialize_aroundBody19$advice(EthereumWalletTokenAdminService ajc$this, TransactionDetail transactionDetail, String issuerUsername, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            TransactionDetail transactionDetail2 = EthereumWalletTokenAdminService.initialize_aroundBody18((EthereumWalletTokenAdminService)ajc$this, (TransactionDetail)transactionDetail, (String)issuerUsername, (JoinPoint)proceedingJoinPoint);
            return transactionDetail2;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ TransactionDetail sendEther_aroundBody20(EthereumWalletTokenAdminService ajc$this, TransactionDetail transactionDetail, String currentUserId, JoinPoint joinPoint) {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        if (transactionDetail.getValue() < 0.0) {
            throw new IllegalArgumentException("ether amount parameter has to be a positive amount");
        }
        ajc$this.checkAdminWalletIsValid();
        ajc$this.setIssuer(transactionDetail, currentUserId);
        String adminWalletAddress = ajc$this.getAdminWalletAddress();
        BigInteger etherAmount = transactionDetail.getValueDecimal(18);
        BigInteger adminEtherBalance = ajc$this.getEtherBalanceOf(adminWalletAddress);
        if (adminEtherBalance.compareTo(etherAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough ether to initialize " + etherAmount.longValue() + " WEI to " + receiverAddress);
        }
        String transactionHash = ajc$this.executeSendEtherTransaction(transactionDetail.getTo(), transactionDetail.getValue());
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException("Transaction hash is empty for transaction: " + transactionDetail);
        }
        transactionDetail.setNetworkId(org.exoplatform.addon.wallet.utils.WalletUtils.getNetworkId());
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(adminWalletAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        transactionDetail.setGasPrice((double)ajc$this.getAdminGasPrice(org.exoplatform.addon.wallet.utils.WalletUtils.getSettings()).longValue());
        ajc$this.getTransactionService().saveTransactionDetail(transactionDetail, true);
        return transactionDetail;
    }

    private static /* synthetic */ Object sendEther_aroundBody21$advice(EthereumWalletTokenAdminService ajc$this, TransactionDetail transactionDetail, String currentUserId, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            TransactionDetail transactionDetail2 = EthereumWalletTokenAdminService.sendEther_aroundBody20((EthereumWalletTokenAdminService)ajc$this, (TransactionDetail)transactionDetail, (String)currentUserId, (JoinPoint)proceedingJoinPoint);
            return transactionDetail2;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ TransactionDetail sendToken_aroundBody22(EthereumWalletTokenAdminService ajc$this, TransactionDetail transactionDetail, String issuerUsername, JoinPoint joinPoint) {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        if (transactionDetail.getContractAmount() <= 0.0) {
            throw new IllegalArgumentException("token amount parameter has to be positive");
        }
        ajc$this.checkAdminWalletIsValid();
        ajc$this.setIssuer(transactionDetail, issuerUsername);
        if (!ajc$this.isApprovedAccount(receiverAddress)) {
            String receiver = transactionDetail.getToWallet() == null || StringUtils.isBlank((CharSequence)transactionDetail.getToWallet().getName()) ? receiverAddress : transactionDetail.getToWallet().getName();
            throw new IllegalStateException("Wallet receiver " + receiver + " is not approved yet, thus no transfer is allowed");
        }
        BigInteger tokenAmount = transactionDetail.getContractAmountDecimal(ajc$this.configuredContractDecimals.intValue());
        if (StringUtils.isBlank((CharSequence)ajc$this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        String transactionHash = ajc$this.executeTokenTransaction(ajc$this.configuredContractAddress, "transfer", new Object[]{receiverAddress, tokenAmount});
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException("Transaction hash is empty for transaction: " + transactionDetail);
        }
        TransactionDetail persistedTransaction = ajc$this.getTransactionService().getTransactionByHash(transactionHash);
        if (persistedTransaction != null) {
            LOG.info("Transaction with hash {} already exists in database, it will be replaced with new data", new Object[]{transactionHash});
            transactionDetail.setId(persistedTransaction.getId());
        }
        transactionDetail.setNetworkId(org.exoplatform.addon.wallet.utils.WalletUtils.getNetworkId());
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(ajc$this.getAdminWalletAddress());
        transactionDetail.setContractAddress(ajc$this.configuredContractAddress);
        transactionDetail.setContractMethodName("transfer");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        transactionDetail.setGasPrice((double)ajc$this.getAdminGasPrice(org.exoplatform.addon.wallet.utils.WalletUtils.getSettings()).longValue());
        ajc$this.getTransactionService().saveTransactionDetail(transactionDetail, true);
        return transactionDetail;
    }

    private static /* synthetic */ Object sendToken_aroundBody23$advice(EthereumWalletTokenAdminService ajc$this, TransactionDetail transactionDetail, String issuerUsername, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            TransactionDetail transactionDetail2 = EthereumWalletTokenAdminService.sendToken_aroundBody22((EthereumWalletTokenAdminService)ajc$this, (TransactionDetail)transactionDetail, (String)issuerUsername, (JoinPoint)proceedingJoinPoint);
            return transactionDetail2;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ TransactionDetail reward_aroundBody24(EthereumWalletTokenAdminService ajc$this, TransactionDetail transactionDetail, String issuerUsername, JoinPoint joinPoint) {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        if (transactionDetail.getContractAmount() < 0.0) {
            throw new IllegalArgumentException("reward amount parameter has to be a positive");
        }
        if (transactionDetail.getValue() <= 0.0) {
            throw new IllegalArgumentException("token amount parameter has to be a positive");
        }
        ajc$this.checkAdminWalletIsValid();
        ajc$this.setIssuer(transactionDetail, issuerUsername);
        if (!ajc$this.isApprovedAccount(receiverAddress)) {
            String receiver = transactionDetail.getToWallet() == null || StringUtils.isBlank((CharSequence)transactionDetail.getToWallet().getName()) ? receiverAddress : transactionDetail.getToWallet().getName();
            throw new IllegalStateException("Wallet receiver " + receiver + " is not approved yet, thus no transfer is allowed");
        }
        BigInteger tokenAmount = transactionDetail.getValueDecimal(ajc$this.configuredContractDecimals.intValue());
        BigInteger rewardAmount = transactionDetail.getContractAmountDecimal(ajc$this.configuredContractDecimals.intValue());
        if (StringUtils.isBlank((CharSequence)ajc$this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        String transactionHash = ajc$this.executeTokenTransaction(ajc$this.configuredContractAddress, "reward", new Object[]{receiverAddress, tokenAmount, rewardAmount});
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException("Transaction hash is empty for transaction: " + transactionDetail);
        }
        transactionDetail.setNetworkId(org.exoplatform.addon.wallet.utils.WalletUtils.getNetworkId());
        transactionDetail.setHash(transactionHash);
        transactionDetail.setFrom(ajc$this.getAdminWalletAddress());
        transactionDetail.setContractAddress(ajc$this.configuredContractAddress);
        transactionDetail.setContractMethodName("reward");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        transactionDetail.setGasPrice((double)ajc$this.getAdminGasPrice(org.exoplatform.addon.wallet.utils.WalletUtils.getSettings()).longValue());
        ajc$this.getTransactionService().saveTransactionDetail(transactionDetail, true);
        return transactionDetail;
    }

    private static /* synthetic */ Object reward_aroundBody25$advice(EthereumWalletTokenAdminService ajc$this, TransactionDetail transactionDetail, String issuerUsername, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            TransactionDetail transactionDetail2 = EthereumWalletTokenAdminService.reward_aroundBody24((EthereumWalletTokenAdminService)ajc$this, (TransactionDetail)transactionDetail, (String)issuerUsername, (JoinPoint)proceedingJoinPoint);
            return transactionDetail2;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ void refreshWallet_aroundBody26(EthereumWalletTokenAdminService ajc$this, org.exoplatform.addon.wallet.model.Wallet wallet, ContractDetail contractDetail, Set walletModifications, JoinPoint joinPoint) {
        if (wallet == null) {
            throw new IllegalArgumentException("wallet is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)wallet.getAddress())) {
            LOG.debug("No wallet address: {}", new Object[]{wallet});
            return;
        }
        if (contractDetail == null || StringUtils.isBlank((CharSequence)contractDetail.getAddress()) || contractDetail.getDecimals() == null) {
            throw new IllegalArgumentException("contractDetail is mandatory");
        }
        ajc$this.getAccountService().retrieveWalletBlockchainState(wallet);
        String walletAddress = wallet.getAddress();
        BigInteger walletEtherBalance = ajc$this.getEtherBalanceOf(walletAddress);
        wallet.setEtherBalance(Double.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)walletEtherBalance, (int)18)));
        if (wallet.getTokenBalance() == null || walletModifications == null || walletModifications.contains("reward") || walletModifications.contains("initialize") || walletModifications.contains("transfer") || walletModifications.contains("transferFrom") || walletModifications.contains("approve")) {
            BigInteger walletTokenBalance = (BigInteger)ajc$this.executeReadOperation(ajc$this.configuredContractAddress, "balanceOf", new Object[]{walletAddress});
            wallet.setTokenBalance(Double.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)walletTokenBalance, (int)ajc$this.configuredContractDecimals)));
        }
        if (wallet.getRewardBalance() == null || walletModifications == null || walletModifications.contains("reward")) {
            BigInteger walletRewardBalance = (BigInteger)ajc$this.executeReadOperation(ajc$this.configuredContractAddress, "rewardBalanceOf", new Object[]{walletAddress});
            wallet.setRewardBalance(Double.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)walletRewardBalance, (int)ajc$this.configuredContractDecimals)));
        }
        if (wallet.getVestingBalance() == null || walletModifications == null || walletModifications.contains("reward")) {
            BigInteger walletVestingBalance = (BigInteger)ajc$this.executeReadOperation(ajc$this.configuredContractAddress, "vestingBalanceOf", new Object[]{walletAddress});
            wallet.setVestingBalance(Double.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)walletVestingBalance, (int)ajc$this.configuredContractDecimals)));
        }
        if (wallet.getAdminLevel() == null || walletModifications == null || walletModifications.contains("transferOwnership") || walletModifications.contains("removeAdmin") || walletModifications.contains("addAdmin")) {
            BigInteger walletAdminLevel = (BigInteger)ajc$this.executeReadOperation(ajc$this.configuredContractAddress, "getAdminLevel", new Object[]{walletAddress});
            wallet.setAdminLevel(Integer.valueOf(walletAdminLevel.intValue()));
        }
        if (wallet.getIsApproved() == null || walletModifications == null || walletModifications.contains("initialize") || walletModifications.contains("addAdmin") || walletModifications.contains("removeAdmin") || walletModifications.contains("approveAccount") || walletModifications.contains("disapproveAccount") || walletModifications.contains("transferOwnership")) {
            Boolean approved = (Boolean)ajc$this.executeReadOperation(ajc$this.configuredContractAddress, "isApprovedAccount", new Object[]{walletAddress});
            wallet.setIsApproved(approved);
        }
        if (wallet.getIsInitialized() == null || walletModifications == null || walletModifications.contains("initializeAccount")) {
            Boolean initialized = (Boolean)ajc$this.executeReadOperation(ajc$this.configuredContractAddress, "isInitializedAccount", new Object[]{walletAddress});
            wallet.setIsInitialized(initialized);
        }
    }

    private static /* synthetic */ Object refreshWallet_aroundBody27$advice(EthereumWalletTokenAdminService ajc$this, org.exoplatform.addon.wallet.model.Wallet wallet, ContractDetail contractDetail, Set walletModifications, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            EthereumWalletTokenAdminService.refreshWallet_aroundBody26((EthereumWalletTokenAdminService)ajc$this, (org.exoplatform.addon.wallet.model.Wallet)wallet, (ContractDetail)contractDetail, (Set)walletModifications, (JoinPoint)proceedingJoinPoint);
            Object var9_10 = null;
            return var9_10;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ void refreshContractDetailFromBlockchain_aroundBody28(EthereumWalletTokenAdminService ajc$this, ContractDetail contractDetail, Set contractModifications, JoinPoint joinPoint) {
        if (contractDetail == null) {
            throw new IllegalArgumentException("contractDetail is mandatory");
        }
        String contractAddress = contractDetail.getAddress();
        try {
            if (contractDetail.getNetworkId() == null || contractDetail.getNetworkId() <= 0L) {
                contractDetail.setNetworkId(Long.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.getNetworkId()));
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getContractType()) || StringUtils.equals((CharSequence)contractDetail.getContractType(), (CharSequence)"0") || contractModifications == null || contractModifications.contains("upgradeImplementation") || contractModifications.contains("upgradeData") || contractModifications.contains("upgradeDataAndImplementation")) {
                BigInteger implementationVersion = (BigInteger)ajc$this.executeReadOperation(contractAddress, "version", new Object[0]);
                if (implementationVersion == null || implementationVersion.intValue() < 1) {
                    return;
                }
                contractDetail.setContractType(implementationVersion.toString());
            }
            if (contractDetail.getDecimals() == null || contractDetail.getDecimals() <= 0) {
                BigInteger decimals = (BigInteger)ajc$this.executeReadOperation(contractAddress, "decimals", new Object[0]);
                contractDetail.setDecimals(Integer.valueOf(decimals.intValue()));
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getName()) || contractModifications == null || contractModifications.contains("setName")) {
                String name = (String)ajc$this.executeReadOperation(contractAddress, "name", new Object[0]);
                contractDetail.setName(name);
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getSymbol()) || contractModifications == null || contractModifications.contains("setSymbol")) {
                String symbol = (String)ajc$this.executeReadOperation(contractAddress, "symbol", new Object[0]);
                contractDetail.setSymbol(symbol);
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getOwner()) || contractModifications == null || contractModifications.contains("transferOwnership")) {
                String owner = (String)ajc$this.executeReadOperation(contractAddress, "owner", new Object[0]);
                contractDetail.setOwner(owner);
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getSellPrice()) || contractModifications == null || contractModifications.contains("setSellPrice")) {
                BigInteger sellPrice = (BigInteger)ajc$this.executeReadOperation(contractAddress, "getSellPrice", new Object[0]);
                contractDetail.setSellPrice(String.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)sellPrice, (int)18)));
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getTotalSupply())) {
                BigInteger totalSupply = (BigInteger)ajc$this.executeReadOperation(contractAddress, "totalSupply", new Object[0]);
                contractDetail.setTotalSupply(String.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)totalSupply, (int)contractDetail.getDecimals())));
            }
            if (contractDetail.getIsPaused() == null || contractModifications == null || contractModifications.contains("pause") || contractModifications.contains("unPause")) {
                Boolean isPaused = (Boolean)ajc$this.executeReadOperation(contractAddress, "isPaused", new Object[0]);
                contractDetail.setIsPaused(isPaused);
            }
            if (contractDetail.getEtherBalance() == null || contractModifications == null || contractModifications.contains("depositFunds") || contractModifications.contains("transfer") || contractModifications.contains("transferFrom") || contractModifications.contains("approve")) {
                BigInteger contractEtherBalance = ajc$this.getEtherBalanceOf(contractAddress);
                contractDetail.setEtherBalance(Double.valueOf(org.exoplatform.addon.wallet.utils.WalletUtils.convertFromDecimals((BigInteger)contractEtherBalance, (int)18)));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while retrieving contract details from blockchain with address: " + contractAddress, e);
        }
    }

    private static /* synthetic */ Object refreshContractDetailFromBlockchain_aroundBody29$advice(EthereumWalletTokenAdminService ajc$this, ContractDetail contractDetail, Set contractModifications, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            EthereumWalletTokenAdminService.refreshContractDetailFromBlockchain_aroundBody28((EthereumWalletTokenAdminService)ajc$this, (ContractDetail)contractDetail, (Set)contractModifications, (JoinPoint)proceedingJoinPoint);
            Object var8_9 = null;
            return var8_9;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ String executeSendEtherTransaction_aroundBody30(EthereumWalletTokenAdminService ajc$this, String receiverAddress, double amountInEther, JoinPoint joinPoint) {
        BigInteger gasLimit;
        GlobalSettings settings;
        BigInteger gasPrice;
        Credentials adminCredentials = ajc$this.getAdminCredentials();
        if (adminCredentials == null) {
            throw new IllegalStateException("Admin credentials are empty");
        }
        Web3j web3j = ajc$this.getClientConnector().getWeb3j();
        String adminWalletAddress = ajc$this.getAdminWalletAddress();
        BigInteger nonce = ajc$this.getClientConnector().getNonce(adminWalletAddress);
        RawTransaction rawTransaction = RawTransaction.createEtherTransaction((BigInteger)nonce, (BigInteger)(gasPrice = BigInteger.valueOf(ajc$this.getAdminGasPrice(settings = org.exoplatform.addon.wallet.utils.WalletUtils.getSettings()))), (BigInteger)(gasLimit = BigInteger.valueOf(300000L)), (String)receiverAddress, (BigInteger)org.exoplatform.addon.wallet.utils.WalletUtils.convertToDecimals((double)amountInEther, (int)18));
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)adminCredentials);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        EthSendTransaction ethSendTransaction = (EthSendTransaction)web3j.ethSendRawTransaction(hexValue).sendAsync().get();
        if (ethSendTransaction == null) {
            throw new IllegalStateException("Ether Transaction is null");
        }
        String transactionHash = ethSendTransaction.getTransactionHash();
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            throw new IllegalStateException("Returned ether Transaction has empty hash");
        }
        return transactionHash;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object executeSendEtherTransaction_aroundBody31$advice(EthereumWalletTokenAdminService ajc$this, String receiverAddress, double amountInEther, JoinPoint thisJoinPoint, ExoWalletStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        String string;
        ExoWalletStatisticService statisticService = (ExoWalletStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoWalletStatistic annotation = method.getAnnotation(ExoWalletStatistic.class);
        String statisticType = annotation.statisticType();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        String result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            string = result = EthereumWalletTokenAdminService.executeSendEtherTransaction_aroundBody30((EthereumWalletTokenAdminService)ajc$this, (String)receiverAddress, (double)amountInEther, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
                    if (parameters == null || parameters.isEmpty()) {
                        ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                        throw throwable;
                    }
                    parameters.put("remote_service", "blockchain");
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry((Map)parameters);
                    throw throwable;
                }
                catch (Exception e2) {
                    ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
            if (parameters == null || parameters.isEmpty()) {
                ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                return string;
            }
            parameters.put("remote_service", "blockchain");
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry((Map)parameters);
            return string;
        }
        catch (Exception e) {
            ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e});
        }
        return string;
    }

    private static /* synthetic */ String executeTokenTransaction_aroundBody32(EthereumWalletTokenAdminService ajc$this, String contractAddress, String methodName, Object[] arguments, JoinPoint joinPoint) {
        ERTTokenV2 contractInstance = ajc$this.getContractInstance(contractAddress, true);
        Method methodToInvoke = ajc$this.getMethod(methodName);
        if (methodToInvoke == null) {
            throw new IllegalStateException("Can't find method " + methodName + " in Token instance");
        }
        RemoteCall response = (RemoteCall)methodToInvoke.invoke((Object)contractInstance, arguments);
        TransactionReceipt receipt = (TransactionReceipt)response.send();
        if (receipt == null) {
            throw new IllegalStateException("Transaction receipt is null");
        }
        return receipt.getTransactionHash();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object executeTokenTransaction_aroundBody33$advice(EthereumWalletTokenAdminService ajc$this, String contractAddress, String methodName, Object[] arguments, JoinPoint thisJoinPoint, ExoWalletStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        String string;
        ExoWalletStatisticService statisticService = (ExoWalletStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoWalletStatistic annotation = method.getAnnotation(ExoWalletStatistic.class);
        String statisticType = annotation.statisticType();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        String result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            string = result = EthereumWalletTokenAdminService.executeTokenTransaction_aroundBody32((EthereumWalletTokenAdminService)ajc$this, (String)contractAddress, (String)methodName, (Object[])arguments, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
                    if (parameters == null || parameters.isEmpty()) {
                        ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                        throw throwable;
                    }
                    parameters.put("remote_service", "blockchain");
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry((Map)parameters);
                    throw throwable;
                }
                catch (Exception e2) {
                    ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map parameters = statisticService.getParameters(statisticType, (Object)result, point.getArgs());
            if (parameters == null || parameters.isEmpty()) {
                ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                return string;
            }
            parameters.put("remote_service", "blockchain");
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry((Map)parameters);
            return string;
        }
        catch (Exception e) {
            ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e});
        }
        return string;
    }

    private static /* synthetic */ Object executeReadOperation_aroundBody34(EthereumWalletTokenAdminService ajc$this, String contractAddress, String methodName, Object[] arguments, JoinPoint joinPoint) {
        ERTTokenV2 contractInstance = ajc$this.getContractInstance(contractAddress, false);
        Method methodToInvoke = ajc$this.getMethod(methodName);
        if (methodToInvoke == null) {
            throw new IllegalStateException("Can't find method " + methodName + " in Token instance");
        }
        RemoteCall response = (RemoteCall)methodToInvoke.invoke((Object)contractInstance, arguments);
        return response.send();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object executeReadOperation_aroundBody35$advice(EthereumWalletTokenAdminService ajc$this, String contractAddress, String methodName, Object[] arguments, JoinPoint thisJoinPoint, ExoWalletStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        Object object;
        ExoWalletStatisticService statisticService = (ExoWalletStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoWalletStatistic annotation = method.getAnnotation(ExoWalletStatistic.class);
        String statisticType = annotation.statisticType();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        Object result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            object = result = EthereumWalletTokenAdminService.executeReadOperation_aroundBody34((EthereumWalletTokenAdminService)ajc$this, (String)contractAddress, (String)methodName, (Object[])arguments, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map parameters = statisticService.getParameters(statisticType, result, point.getArgs());
                    if (parameters == null || parameters.isEmpty()) {
                        ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                        throw throwable;
                    }
                    parameters.put("remote_service", "blockchain");
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry((Map)parameters);
                    throw throwable;
                }
                catch (Exception e2) {
                    ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map parameters = statisticService.getParameters(statisticType, result, point.getArgs());
            if (parameters == null || parameters.isEmpty()) {
                ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                return object;
            }
            parameters.put("remote_service", "blockchain");
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry((Map)parameters);
            return object;
        }
        catch (Exception e) {
            ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e});
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EthereumWalletTokenAdminService.java", EthereumWalletTokenAdminService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "", "", "", "void"), 102);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createAdminAccount", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "", "", "", "void"), 126);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "sendToken", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail:java.lang.String", "transactionDetail:issuerUsername", "java.lang.Exception", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail"), 376);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "reward", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail:java.lang.String", "transactionDetail:issuerUsername", "java.lang.Exception", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail"), 433);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshWallet", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "org.exoplatform.addon.wallet.model.Wallet:org.exoplatform.addon.wallet.model.ContractDetail:java.util.Set", "wallet:contractDetail:walletModifications", "java.lang.Exception", "void"), 490);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshContractDetailFromBlockchain", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "org.exoplatform.addon.wallet.model.ContractDetail:java.util.Set", "contractDetail:contractModifications", "", "void"), 574);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeSendEtherTransaction", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String:double", "receiverAddress:amountInEther", "java.lang.Exception", "java.lang.String"), 749);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "executeTokenTransaction", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String:java.lang.String:[Ljava.lang.Object;", "contractAddress:methodName:arguments", "java.lang.Exception", "java.lang.String"), 788);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "executeReadOperation", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String:java.lang.String:[Ljava.lang.Object;", "contractAddress:methodName:arguments", "java.lang.Exception", "java.lang.Object"), 806);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createAdminAccount", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String:java.lang.String", "privateKey:currentUser", "java.lang.IllegalAccessException", "org.exoplatform.addon.wallet.model.Wallet"), 136);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "isApprovedAccount", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String", "address", "java.lang.Exception", "boolean"), 208);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getAdminLevel", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String", "address", "java.lang.Exception", "int"), 220);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "isInitializedAccount", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String", "address", "java.lang.Exception", "boolean"), 233);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "balanceOf", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String", "address", "java.lang.Exception", "java.math.BigInteger"), 245);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getEtherBalanceOf", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String", "address", "java.lang.Exception", "java.math.BigInteger"), 258);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "initialize", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail:java.lang.String", "transactionDetail:issuerUsername", "java.lang.Exception", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail"), 268);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "sendEther", "org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail:java.lang.String", "transactionDetail:currentUserId", "java.lang.Exception", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail"), 331);
    }
}

