/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.service;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransaction;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionAspect;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionService;
import org.exoplatform.addon.wallet.blockchain.listener.BlockchainTransactionProcessorListener;
import org.exoplatform.addon.wallet.blockchain.listener.TransactionMinedListener;
import org.exoplatform.addon.wallet.blockchain.listener.WebSocketContractListener;
import org.exoplatform.addon.wallet.blockchain.listener.WebSocketTransactionListener;
import org.exoplatform.addon.wallet.blockchain.listener.WebSocketWalletListener;
import org.exoplatform.addon.wallet.blockchain.service.EthereumBlockchainTransactionService;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService;
import org.exoplatform.addon.wallet.job.ContractTransactionVerifierJob;
import org.exoplatform.addon.wallet.job.PendingTransactionVerifierJob;
import org.exoplatform.addon.wallet.service.BlockchainTransactionService;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.CronJob;
import org.exoplatform.services.scheduler.JobSchedulerService;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceLoaderServlet
extends HttpServlet
implements ExoBlockchainTransactionService {
    private static final long serialVersionUID = 4629318431709644350L;
    private static final Log LOG;
    private static final ScheduledExecutorService executor;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public void init() throws ServletException {
        executor.scheduleAtFixedRate(() -> this.instantiateBlockchainServices(), 10L, 10L, TimeUnit.SECONDS);
    }

    @ExoBlockchainTransaction
    private void instantiateBlockchainServices() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        ServiceLoaderServlet.instantiateBlockchainServices_aroundBody1$advice((ServiceLoaderServlet)this, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.init();
        super.service(req, resp);
    }

    private void addBlockchainScheduledJob(Class<?> jobClass, String description, String defaultCronExpression) throws Exception {
        JobSchedulerService schedulerService = (JobSchedulerService)CommonsUtils.getService(JobSchedulerService.class);
        String jobSimpleName = jobClass.getSimpleName();
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("cronjob.info");
        propertiesParam.setDescription(description);
        propertiesParam.setProperty("jobName", jobSimpleName);
        propertiesParam.setProperty("groupName", "Wallet");
        propertiesParam.setProperty("job", jobClass.getName());
        propertiesParam.setProperty("expression", System.getProperty("exo.wallet." + jobSimpleName + ".expression", defaultCronExpression));
        params.addParam((Object)propertiesParam);
        CronJob cronJob = new CronJob(params);
        schedulerService.addCronJob((ComponentPlugin)cronJob);
    }

    public ClassLoader getWebappClassLoader() {
        return this.getServletContext().getClassLoader();
    }

    static {
        ServiceLoaderServlet.ajc$preClinit();
        LOG = ExoLogger.getLogger(ServiceLoaderServlet.class);
        executor = Executors.newScheduledThreadPool(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void instantiateBlockchainServices_aroundBody0(ServiceLoaderServlet ajc$this, JoinPoint joinPoint) {
        PortalContainer container = PortalContainer.getInstance();
        if (container == null || !container.isStarted()) {
            LOG.debug((Object)"Portal Container is not yet started");
            return;
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            ClassLoader webappClassLoader = ajc$this.getWebappClassLoader();
            Class<?> class1 = webappClassLoader.loadClass(BouncyCastleProvider.class.getName());
            Provider provider = (Provider)class1.newInstance();
            Security.removeProvider(BouncyCastleProvider.PROVIDER_NAME);
            Security.addProvider(provider);
            provider = Security.getProvider(BouncyCastleProvider.PROVIDER_NAME);
            LOG.info("BouncyCastleProvider class registered with version {}", new Object[]{provider.getVersion()});
            EthereumClientConnector web3jConnector = new EthereumClientConnector(webappClassLoader);
            container.registerComponentInstance(EthereumClientConnector.class, (Object)web3jConnector);
            web3jConnector.start();
            EthereumBlockchainTransactionService transactionDecoderService = new EthereumBlockchainTransactionService(web3jConnector, webappClassLoader);
            container.registerComponentInstance(BlockchainTransactionService.class, (Object)transactionDecoderService);
            EthereumWalletTokenAdminService tokenAdminService = new EthereumWalletTokenAdminService(web3jConnector, webappClassLoader);
            container.registerComponentInstance(WalletTokenAdminService.class, (Object)tokenAdminService);
            tokenAdminService.start();
            transactionDecoderService.start();
            ListenerService listernerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
            listernerService.addListener("exo.addon.wallet.transaction.loaded", (Listener)new BlockchainTransactionProcessorListener(container));
            listernerService.addListener("exo.addon.wallet.transaction.mined", (Listener)new TransactionMinedListener());
            listernerService.addListener("exo.addon.wallet.transaction.modified", (Listener)new WebSocketTransactionListener());
            listernerService.addListener("exo.addon.wallet.modified", (Listener)new WebSocketWalletListener());
            listernerService.addListener("exo.addon.wallet.contract.modified", (Listener)new WebSocketContractListener());
            ajc$this.addBlockchainScheduledJob(PendingTransactionVerifierJob.class, "Configuration for wallet transaction stored status verifier", "0/10 * * * * ?");
            ajc$this.addBlockchainScheduledJob(ContractTransactionVerifierJob.class, "Add a job to verify if mined contract transactions are added in database", "0 0 * ? * * *");
            LOG.debug((Object)"Blockchain Service instances created");
        }
        catch (Throwable e) {
            LOG.error((Object)"Error registering service into portal container", e);
        }
        finally {
            RequestLifeCycle.end();
        }
        executor.shutdown();
    }

    private static /* synthetic */ Object instantiateBlockchainServices_aroundBody1$advice(ServiceLoaderServlet ajc$this, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            ServiceLoaderServlet.instantiateBlockchainServices_aroundBody0((ServiceLoaderServlet)ajc$this, (JoinPoint)proceedingJoinPoint);
            Object var6_7 = null;
            return var6_7;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ServiceLoaderServlet.java", ServiceLoaderServlet.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "instantiateBlockchainServices", "org.exoplatform.addon.wallet.blockchain.service.ServiceLoaderServlet", "", "", "", "void"), 54);
    }
}

