/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.service;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransaction;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionAspect;
import org.exoplatform.addon.wallet.blockchain.ExoBlockchainTransactionService;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.contract.ERTTokenV2;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletInitializationState;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.BlockchainTransactionService;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletContractService;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.EventValues;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

/*
 * Exception performing whole class analysis ignored.
 */
public class EthereumBlockchainTransactionService
implements BlockchainTransactionService,
ExoBlockchainTransactionService,
Startable {
    private static final Log LOG;
    private static final String TRANSFER_SIG;
    private static final String APPROVAL_SIG;
    private static final String ADDED_ADMIN_METHOD_SIG;
    private static final String REMOVED_ADMIN_SIG;
    private static final String APPROVED_ACCOUNT_SIG;
    private static final String DISAPPROVED_ACCOUNT_SIG;
    private static final String CONTRACT_PAUSED_SIG;
    private static final String CONTRACT_UNPAUSED_SIG;
    private static final String DEPOSIT_RECEIVED_SIG;
    private static final String TOKEN_PRICE_CHANGED_SIG;
    private static final String TRANSFER_OWNERSHIP_SIG;
    private static final String ACCOUNT_INITIALIZATION_SIG;
    private static final String ACCOUNT_REWARD_SIG;
    private static final String ACCOUNT_VESTED_SIG;
    private static final String TRANSFER_VESTING_SIG;
    private static final String UPGRADED_SIG;
    private static final String DATA_UPGRADED_SIG;
    private static final String NOSUFFICIENTFUND_EVENT_HASH;
    private static final String TRANSACTIONFEE_EVENT_HASH;
    private static final Map<String, String> CONTRACT_METHODS_BY_SIG;
    private EthereumClientConnector ethereumClientConnector;
    private WalletAccountService accountService;
    private WalletContractService contractService;
    private WalletTransactionService transactionService;
    private SettingService settingService;
    private ListenerService listenerService;
    private ClassLoader webappClassLoader;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public EthereumBlockchainTransactionService(EthereumClientConnector ethereumClientConnector, ClassLoader webappClassLoader) {
        this.ethereumClientConnector = ethereumClientConnector;
        this.webappClassLoader = webappClassLoader;
    }

    @ExoBlockchainTransaction
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        EthereumBlockchainTransactionService.start_aroundBody1$advice((EthereumBlockchainTransactionService)this, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    public void stop() {
    }

    public ClassLoader getWebappClassLoader() {
        return this.webappClassLoader;
    }

    @ExoBlockchainTransaction
    public int checkPendingTransactions(long pendingTransactionMaxDays) {
        long l = pendingTransactionMaxDays;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        return Conversions.intValue((Object)EthereumBlockchainTransactionService.checkPendingTransactions_aroundBody3$advice((EthereumBlockchainTransactionService)this, (long)l, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint)));
    }

    @ExoBlockchainTransaction
    public void scanNewerBlocks() throws InterruptedException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        EthereumBlockchainTransactionService.scanNewerBlocks_aroundBody5$advice((EthereumBlockchainTransactionService)this, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    public TransactionDetail computeTransactionDetail(String hash, ContractDetail contractDetail) throws InterruptedException {
        String string = hash;
        ContractDetail contractDetail2 = contractDetail;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)contractDetail2);
        return (TransactionDetail)EthereumBlockchainTransactionService.computeTransactionDetail_aroundBody7$advice((EthereumBlockchainTransactionService)this, (String)string, (ContractDetail)contractDetail2, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    public TransactionDetail computeTransactionDetail(TransactionDetail transactionDetail, ContractDetail contractDetail) throws InterruptedException {
        TransactionDetail transactionDetail2 = transactionDetail;
        ContractDetail contractDetail2 = contractDetail;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)transactionDetail2, (Object)contractDetail2);
        return (TransactionDetail)EthereumBlockchainTransactionService.computeTransactionDetail_aroundBody9$advice((EthereumBlockchainTransactionService)this, (TransactionDetail)transactionDetail2, (ContractDetail)contractDetail2, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    @ExoBlockchainTransaction
    public void computeContractTransactionDetail(TransactionDetail transactionDetail, Object transactionReceipt) {
        TransactionDetail transactionDetail2 = transactionDetail;
        Object object = transactionReceipt;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)transactionDetail2, (Object)object);
        EthereumBlockchainTransactionService.computeContractTransactionDetail_aroundBody11$advice((EthereumBlockchainTransactionService)this, (TransactionDetail)transactionDetail2, (Object)object, (JoinPoint)joinPoint, (ExoBlockchainTransactionAspect)ExoBlockchainTransactionAspect.aspectOf(), (ProceedingJoinPoint)((ProceedingJoinPoint)joinPoint));
    }

    private void computeContractTransactionDetail(ContractDetail contractDetail, TransactionDetail transactionDetail, TransactionReceipt transactionReceipt) {
        String toAddress;
        List logs = transactionReceipt == null ? null : transactionReceipt.getLogs();
        transactionDetail.setSucceeded(transactionReceipt != null && transactionReceipt.isStatusOK());
        if (transactionReceipt != null && transactionReceipt.getGasUsed() != null) {
            transactionDetail.setGasUsed(transactionReceipt.getGasUsed().intValue());
        }
        if (!transactionDetail.isSucceeded()) {
            if (StringUtils.equals((CharSequence)transactionDetail.getContractMethodName(), (CharSequence)"initializeAccount")) {
                this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.MODIFIED);
            }
            return;
        }
        String string = toAddress = transactionReceipt == null ? null : transactionReceipt.getTo();
        if (contractDetail == null) {
            contractDetail = this.getContractService().getContractDetail(StringUtils.lowerCase((String)toAddress));
        }
        if (contractDetail == null || !StringUtils.equalsIgnoreCase((CharSequence)toAddress, (CharSequence)contractDetail.getAddress())) {
            return;
        }
        Integer contractDecimals = contractDetail.getDecimals();
        String hash = transactionDetail.getHash();
        if (logs != null && !logs.isEmpty()) {
            int logsSize = logs.size();
            LOG.debug("Retrieving information from blockchain for transaction {} with {} LOGS", new Object[]{hash, logsSize});
            int i = 0;
            boolean transactionLogTreated = false;
            while (i < logsSize) {
                BigInteger amount;
                EventValues parameters;
                String methodName;
                org.web3j.protocol.core.methods.response.Log log;
                List topics;
                if ((topics = (log = (org.web3j.protocol.core.methods.response.Log)logs.get(i++)).getTopics()) == null || topics.isEmpty()) {
                    LOG.warn("Transaction {} has NO topics", new Object[]{hash});
                    transactionDetail.setSucceeded(false);
                    continue;
                }
                String topic = (String)topics.get(0);
                LOG.debug("Treating transaction log {} with {} topics", new Object[]{hash, topics.size()});
                if (NOSUFFICIENTFUND_EVENT_HASH.equals(topic)) {
                    transactionDetail.setNoContractFunds(true);
                    continue;
                }
                if (TRANSACTIONFEE_EVENT_HASH.equals(topic)) {
                    EventValues parameters2 = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.TRANSACTIONFEE_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    BigInteger tokenFee = (BigInteger)((Type)parameters2.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setTokenFee(WalletUtils.convertFromDecimals((BigInteger)tokenFee, (int)contractDecimals));
                    continue;
                }
                if (transactionLogTreated || StringUtils.isBlank((CharSequence)(methodName = (String)CONTRACT_METHODS_BY_SIG.get(topic)))) continue;
                transactionDetail.setContractMethodName(methodName);
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transfer")) {
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.TRANSFER_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    if (!StringUtils.equals((CharSequence)transactionReceipt.getFrom(), (CharSequence)transactionDetail.getFrom())) {
                        transactionDetail.setBy(transactionReceipt.getFrom());
                        transactionDetail.setContractMethodName("transferFrom");
                    }
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"approve")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.APPROVAL_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"approveAccount")) {
                    if (logsSize > 1) continue;
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.APPROVEDACCOUNT_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"disapproveAccount")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.DISAPPROVEDACCOUNT_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"addAdmin")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.ADDEDADMIN_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue()).longValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"removeAdmin")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.REMOVEDADMIN_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"upgradeData")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.UPGRADEDDATA_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(1)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"upgradeImplementation")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.UPGRADED_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(1)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"depositFunds")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.DEPOSITRECEIVED_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    BigInteger weiAmount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setValueDecimal(weiAmount, 18);
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"setSellPrice")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.TOKENPRICECHANGED_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transformToVested")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.VESTING_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transferOwnership")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.TRANSFEROWNERSHIP_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"initializeAccount")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.INITIALIZATION_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    BigInteger weiAmount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setValueDecimal(weiAmount, 18);
                    transactionDetail.setAdminOperation(false);
                    if (transactionDetail.isSucceeded()) {
                        this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.INITIALIZED);
                        continue;
                    }
                    this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.MODIFIED);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"reward")) {
                    transactionLogTreated = true;
                    parameters = ERTTokenV2.staticExtractEventParameters((Event)ERTTokenV2.REWARD_EVENT, (org.web3j.protocol.core.methods.response.Log)log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setValueDecimal(amount, contractDecimals.intValue());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (transactionLogTreated || i + 1 != logsSize) continue;
                LOG.warn("Can't find contract method name of transaction {}", new Object[]{transactionDetail});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getFrom()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getFromWallet())) {
            transactionDetail.setFromWallet(this.getAccountService().getWalletByAddress(transactionDetail.getFrom()));
        }
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getTo()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getToWallet())) {
            transactionDetail.setToWallet(this.getAccountService().getWalletByAddress(transactionDetail.getTo()));
        }
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getBy()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getByWallet())) {
            transactionDetail.setByWallet(this.getAccountService().getWalletByAddress(transactionDetail.getBy()));
        }
    }

    private boolean verifyTransactionStatusOnBlockchain(TransactionDetail pendingTransactionDetail, long pendingTransactionMaxDays) throws Exception {
        String blockHash;
        String hash = pendingTransactionDetail.getHash();
        Transaction transaction = this.ethereumClientConnector.getTransaction(hash);
        String string = blockHash = transaction == null ? null : transaction.getBlockHash();
        if (!StringUtils.isBlank((CharSequence)blockHash) && !StringUtils.equalsIgnoreCase((CharSequence)"0x0000000000000000000000000000000000000000000000000000000000000000", (CharSequence)blockHash) && transaction.getBlockNumber() != null) {
            this.getListenerService().broadcast("exo.addon.wallet.transaction.loaded", (Object)transaction, null);
            return true;
        }
        if (transaction == null) {
            long creationTimestamp;
            boolean emitFailedTransactionEvent = true;
            if (pendingTransactionMaxDays > 0L && (creationTimestamp = pendingTransactionDetail.getTimestamp()) > 0L) {
                Duration duration = Duration.ofMillis(System.currentTimeMillis() - creationTimestamp);
                boolean bl = emitFailedTransactionEvent = duration.toDays() >= pendingTransactionMaxDays;
            }
            if (emitFailedTransactionEvent) {
                LOG.debug("Transaction '{}' was not found on blockchain for more than '{}' days, so mark it as failed", new Object[]{hash, pendingTransactionMaxDays});
                this.getListenerService().broadcast("exo.addon.wallet.transaction.loaded", (Object)pendingTransactionDetail, null);
                return true;
            }
        }
        return false;
    }

    private TransactionDetail processTransaction(String transactionHash, ContractDetail contractDetail) {
        TransactionDetail transactionDetail = null;
        try {
            LOG.debug(" - treating transaction {} that doesn't exist on database.", new Object[]{transactionHash});
            transactionDetail = this.computeTransactionDetail(transactionHash, contractDetail);
            if (transactionDetail == null) {
                throw new IllegalStateException("Empty transaction detail is returned");
            }
            if (WalletUtils.hasKnownWalletInTransaction((TransactionDetail)transactionDetail)) {
                LOG.debug("Saving new transaction that wasn't managed by UI: {}", new Object[]{transactionDetail});
                this.getTransactionService().saveTransactionDetail(transactionDetail, true);
            }
        }
        catch (Exception e) {
            LOG.warn("Error processing transaction {}. It will be retried next time.", new Object[]{transactionHash, e});
            return null;
        }
        return transactionDetail;
    }

    private long getLastWatchedBlockNumber(long networkId) {
        SettingValue lastBlockNumberValue = this.getSettingService().get(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId);
        if (lastBlockNumberValue != null && lastBlockNumberValue.getValue() != null) {
            return Long.valueOf(lastBlockNumberValue.getValue().toString());
        }
        return 0L;
    }

    private void saveLastWatchedBlockNumber(long networkId, long lastWatchedBlockNumber) {
        LOG.debug("Save watched block number {} on network {}", new Object[]{lastWatchedBlockNumber, networkId});
        this.getSettingService().set(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId, SettingValue.create((Long)lastWatchedBlockNumber));
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        }
        return this.settingService;
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    private WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    private WalletContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = (WalletContractService)CommonsUtils.getService(WalletContractService.class);
        }
        return this.contractService;
    }

    static {
        EthereumBlockchainTransactionService.ajc$preClinit();
        LOG = ExoLogger.getLogger(EthereumBlockchainTransactionService.class);
        TRANSFER_SIG = EventEncoder.encode((Event)ERTTokenV2.TRANSFER_EVENT);
        APPROVAL_SIG = EventEncoder.encode((Event)ERTTokenV2.APPROVAL_EVENT);
        ADDED_ADMIN_METHOD_SIG = EventEncoder.encode((Event)ERTTokenV2.ADDEDADMIN_EVENT);
        REMOVED_ADMIN_SIG = EventEncoder.encode((Event)ERTTokenV2.REMOVEDADMIN_EVENT);
        APPROVED_ACCOUNT_SIG = EventEncoder.encode((Event)ERTTokenV2.APPROVEDACCOUNT_EVENT);
        DISAPPROVED_ACCOUNT_SIG = EventEncoder.encode((Event)ERTTokenV2.DISAPPROVEDACCOUNT_EVENT);
        CONTRACT_PAUSED_SIG = EventEncoder.encode((Event)ERTTokenV2.CONTRACTPAUSED_EVENT);
        CONTRACT_UNPAUSED_SIG = EventEncoder.encode((Event)ERTTokenV2.CONTRACTUNPAUSED_EVENT);
        DEPOSIT_RECEIVED_SIG = EventEncoder.encode((Event)ERTTokenV2.DEPOSITRECEIVED_EVENT);
        TOKEN_PRICE_CHANGED_SIG = EventEncoder.encode((Event)ERTTokenV2.TOKENPRICECHANGED_EVENT);
        TRANSFER_OWNERSHIP_SIG = EventEncoder.encode((Event)ERTTokenV2.TRANSFEROWNERSHIP_EVENT);
        ACCOUNT_INITIALIZATION_SIG = EventEncoder.encode((Event)ERTTokenV2.INITIALIZATION_EVENT);
        ACCOUNT_REWARD_SIG = EventEncoder.encode((Event)ERTTokenV2.REWARD_EVENT);
        ACCOUNT_VESTED_SIG = EventEncoder.encode((Event)ERTTokenV2.VESTING_EVENT);
        TRANSFER_VESTING_SIG = EventEncoder.encode((Event)ERTTokenV2.VESTINGTRANSFER_EVENT);
        UPGRADED_SIG = EventEncoder.encode((Event)ERTTokenV2.UPGRADED_EVENT);
        DATA_UPGRADED_SIG = EventEncoder.encode((Event)ERTTokenV2.UPGRADEDDATA_EVENT);
        NOSUFFICIENTFUND_EVENT_HASH = EventEncoder.encode((Event)ERTTokenV2.NOSUFFICIENTFUND_EVENT);
        TRANSACTIONFEE_EVENT_HASH = EventEncoder.encode((Event)ERTTokenV2.TRANSACTIONFEE_EVENT);
        CONTRACT_METHODS_BY_SIG = new HashMap();
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_SIG, "transfer");
        CONTRACT_METHODS_BY_SIG.put(APPROVAL_SIG, "approve");
        CONTRACT_METHODS_BY_SIG.put(ADDED_ADMIN_METHOD_SIG, "addAdmin");
        CONTRACT_METHODS_BY_SIG.put(REMOVED_ADMIN_SIG, "removeAdmin");
        CONTRACT_METHODS_BY_SIG.put(APPROVED_ACCOUNT_SIG, "approveAccount");
        CONTRACT_METHODS_BY_SIG.put(DISAPPROVED_ACCOUNT_SIG, "disapproveAccount");
        CONTRACT_METHODS_BY_SIG.put(CONTRACT_PAUSED_SIG, "pause");
        CONTRACT_METHODS_BY_SIG.put(CONTRACT_UNPAUSED_SIG, "unPause");
        CONTRACT_METHODS_BY_SIG.put(DEPOSIT_RECEIVED_SIG, "depositFunds");
        CONTRACT_METHODS_BY_SIG.put(TOKEN_PRICE_CHANGED_SIG, "setSellPrice");
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_OWNERSHIP_SIG, "transferOwnership");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_INITIALIZATION_SIG, "initializeAccount");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_REWARD_SIG, "reward");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_VESTED_SIG, "transformToVested");
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_VESTING_SIG, "transfer");
        CONTRACT_METHODS_BY_SIG.put(UPGRADED_SIG, "upgradeImplementation");
        CONTRACT_METHODS_BY_SIG.put(DATA_UPGRADED_SIG, "upgradeData");
    }

    private static /* synthetic */ void start_aroundBody0(EthereumBlockchainTransactionService ajc$this, JoinPoint joinPoint) {
        long networkId = WalletUtils.getNetworkId();
        try {
            long lastWatchedBlockNumber = ajc$this.getLastWatchedBlockNumber(networkId);
            if (lastWatchedBlockNumber <= 0L) {
                long lastEthereumBlockNumber = ajc$this.ethereumClientConnector.getLastestBlockNumber();
                ajc$this.saveLastWatchedBlockNumber(networkId, lastEthereumBlockNumber);
                LOG.info("Start watching Blockchain transactions from block number {}", new Object[]{lastEthereumBlockNumber});
            }
        }
        catch (Exception e) {
            LOG.error("Error while getting latest block number from blockchain with network id: {}", new Object[]{networkId, e});
        }
    }

    private static /* synthetic */ Object start_aroundBody1$advice(EthereumBlockchainTransactionService ajc$this, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            EthereumBlockchainTransactionService.start_aroundBody0((EthereumBlockchainTransactionService)ajc$this, (JoinPoint)proceedingJoinPoint);
            Object var6_7 = null;
            return var6_7;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ int checkPendingTransactions_aroundBody2(EthereumBlockchainTransactionService ajc$this, long pendingTransactionMaxDays, JoinPoint joinPoint) {
        List pendingTransactions = ajc$this.getTransactionService().getPendingTransactions();
        int transactionsMarkedAsMined = 0;
        if (pendingTransactions != null && !pendingTransactions.isEmpty()) {
            LOG.debug("Checking on blockchain the status of {} transactions marked as pending in database", new Object[]{pendingTransactions.size()});
            for (TransactionDetail pendingTransactionDetail : pendingTransactions) {
                try {
                    boolean transactionMined = ajc$this.verifyTransactionStatusOnBlockchain(pendingTransactionDetail, pendingTransactionMaxDays);
                    if (!transactionMined) continue;
                    ++transactionsMarkedAsMined;
                }
                catch (Exception e) {
                    LOG.warn("Error treating pending transaction: {}", new Object[]{pendingTransactionDetail, e});
                }
            }
        }
        return transactionsMarkedAsMined;
    }

    private static /* synthetic */ Object checkPendingTransactions_aroundBody3$advice(EthereumBlockchainTransactionService ajc$this, long pendingTransactionMaxDays, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            Object object = Conversions.intObject((int)EthereumBlockchainTransactionService.checkPendingTransactions_aroundBody2((EthereumBlockchainTransactionService)ajc$this, (long)pendingTransactionMaxDays, (JoinPoint)proceedingJoinPoint));
            return object;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ void scanNewerBlocks_aroundBody4(EthereumBlockchainTransactionService ajc$this, JoinPoint joinPoint) {
        long lastWatchedBlockNumber;
        GlobalSettings settings = WalletUtils.getSettings();
        if (settings == null) {
            LOG.debug((Object)"Empty settings, skip contract transaction verification");
            return;
        }
        long networkId = settings.getNetwork().getId();
        if (settings.getNetwork().getId() == 0L) {
            LOG.debug((Object)"Empty network id in settings, skip contract transaction verification");
            return;
        }
        String wsURL = settings.getNetwork().getWebsocketProviderURL();
        if (StringUtils.isBlank((CharSequence)wsURL)) {
            LOG.debug((Object)"Empty Websocket URL in settings, skip contract transaction verification");
            return;
        }
        ContractDetail contractDetail = settings.getContractDetail();
        if (contractDetail == null || StringUtils.isBlank((CharSequence)contractDetail.getAddress())) {
            LOG.debug((Object)"Empty token address in settings, skip contract transaction verification");
            return;
        }
        long lastEthereumBlockNumber = ajc$this.ethereumClientConnector.getLastestBlockNumber();
        if (lastEthereumBlockNumber <= (lastWatchedBlockNumber = ajc$this.getLastWatchedBlockNumber(networkId))) {
            LOG.debug("No new blocks to verify. last watched = {}. last blockchain block = {}", new Object[]{lastWatchedBlockNumber, lastEthereumBlockNumber});
            return;
        }
        boolean processed = true;
        String contractAddress = contractDetail.getAddress();
        Set transactionHashes = ajc$this.ethereumClientConnector.getContractTransactions(contractAddress, lastWatchedBlockNumber, lastEthereumBlockNumber);
        LOG.debug("{} transactions has been found on contract {} between block {} and {}", new Object[]{transactionHashes.size(), contractAddress, lastWatchedBlockNumber, lastEthereumBlockNumber});
        int addedTransactionsCount = 0;
        int modifiedTransactionsCount = 0;
        for (String transactionHash : transactionHashes) {
            TransactionDetail transactionDetail = ajc$this.getTransactionService().getTransactionByHash(transactionHash);
            if (transactionDetail == null) {
                transactionDetail = ajc$this.processTransaction(transactionHash, contractDetail);
                processed = transactionDetail != null && processed;
                if (!processed) continue;
                ++addedTransactionsCount;
                continue;
            }
            LOG.debug(" - transaction {} already exists on database, ignore it.", new Object[]{transactionDetail});
            boolean braodcastSavingTransaction = transactionDetail.isPending();
            transactionDetail.setPending(false);
            boolean changed = braodcastSavingTransaction;
            if (StringUtils.isBlank((CharSequence)transactionDetail.getContractAddress()) || StringUtils.isBlank((CharSequence)transactionDetail.getContractMethodName())) {
                transactionDetail.setContractAddress(contractAddress);
                ajc$this.computeTransactionDetail(transactionDetail, contractDetail);
                changed = true;
            } else if (!transactionDetail.isSucceeded()) {
                TransactionReceipt transactionReceipt = ajc$this.ethereumClientConnector.getTransactionReceipt(transactionDetail.getHash());
                ajc$this.computeContractTransactionDetail(transactionDetail, (Object)transactionReceipt);
                changed = true;
            }
            if (!changed || !WalletUtils.hasKnownWalletInTransaction((TransactionDetail)transactionDetail)) continue;
            ajc$this.getTransactionService().saveTransactionDetail(transactionDetail, braodcastSavingTransaction);
            ++modifiedTransactionsCount;
        }
        LOG.debug("{} added and {} modified transactions has been stored using contract {} between block {} and {}", new Object[]{addedTransactionsCount, modifiedTransactionsCount, contractAddress, lastWatchedBlockNumber, lastEthereumBlockNumber});
        if (processed) {
            ajc$this.saveLastWatchedBlockNumber(networkId, lastEthereumBlockNumber);
        }
    }

    private static /* synthetic */ Object scanNewerBlocks_aroundBody5$advice(EthereumBlockchainTransactionService ajc$this, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            EthereumBlockchainTransactionService.scanNewerBlocks_aroundBody4((EthereumBlockchainTransactionService)ajc$this, (JoinPoint)proceedingJoinPoint);
            Object var6_7 = null;
            return var6_7;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ TransactionDetail computeTransactionDetail_aroundBody6(EthereumBlockchainTransactionService ajc$this, String hash, ContractDetail contractDetail, JoinPoint joinPoint) {
        if (StringUtils.isBlank((CharSequence)hash)) {
            throw new IllegalArgumentException("Transaction hash is empty");
        }
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setNetworkId(WalletUtils.getNetworkId());
        transactionDetail.setHash(hash);
        return ajc$this.computeTransactionDetail(transactionDetail, contractDetail);
    }

    private static /* synthetic */ Object computeTransactionDetail_aroundBody7$advice(EthereumBlockchainTransactionService ajc$this, String hash, ContractDetail contractDetail, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            TransactionDetail transactionDetail = EthereumBlockchainTransactionService.computeTransactionDetail_aroundBody6((EthereumBlockchainTransactionService)ajc$this, (String)hash, (ContractDetail)contractDetail, (JoinPoint)proceedingJoinPoint);
            return transactionDetail;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ TransactionDetail computeTransactionDetail_aroundBody8(EthereumBlockchainTransactionService ajc$this, TransactionDetail transactionDetail, ContractDetail contractDetail, JoinPoint joinPoint) {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Empty transaction detail parameter");
        }
        String hash = transactionDetail.getHash();
        if (StringUtils.isBlank((CharSequence)hash)) {
            throw new IllegalStateException("Transaction hash is empty");
        }
        if (transactionDetail.getNetworkId() <= 0L) {
            throw new IllegalStateException("Unknown network id: " + transactionDetail.getNetworkId());
        }
        Transaction transaction = ajc$this.ethereumClientConnector.getTransaction(hash);
        if (transaction == null) {
            LOG.info("Can't find transaction with hash {}, it may be pending", new Object[]{hash});
            return transactionDetail;
        }
        transactionDetail.setGasPrice((double)transaction.getGasPrice().intValue());
        String senderAddress = transaction.getFrom();
        transactionDetail.setFrom(senderAddress);
        BigInteger weiAmount = transaction.getValue();
        transactionDetail.setValueDecimal(weiAmount, 18);
        TransactionReceipt transactionReceipt = ajc$this.ethereumClientConnector.getTransactionReceipt(hash);
        transactionDetail.setPending(transactionReceipt == null);
        transactionDetail.setSucceeded(transactionReceipt != null && transactionReceipt.isStatusOK());
        if (transactionReceipt != null && transactionReceipt.getGasUsed() != null) {
            transactionDetail.setGasUsed(transactionReceipt.getGasUsed().intValue());
        }
        String receiverAddress = transaction.getTo();
        transactionDetail.setTo(receiverAddress);
        if (contractDetail == null && receiverAddress != null) {
            contractDetail = ajc$this.getContractService().getContractDetail(receiverAddress);
        }
        if (contractDetail != null && StringUtils.isNotBlank((CharSequence)contractDetail.getAddress())) {
            transactionDetail.setContractAddress(contractDetail.getAddress());
            ajc$this.computeContractTransactionDetail(contractDetail, transactionDetail, transactionReceipt);
        }
        return transactionDetail;
    }

    private static /* synthetic */ Object computeTransactionDetail_aroundBody9$advice(EthereumBlockchainTransactionService ajc$this, TransactionDetail transactionDetail, ContractDetail contractDetail, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            TransactionDetail transactionDetail2 = EthereumBlockchainTransactionService.computeTransactionDetail_aroundBody8((EthereumBlockchainTransactionService)ajc$this, (TransactionDetail)transactionDetail, (ContractDetail)contractDetail, (JoinPoint)proceedingJoinPoint);
            return transactionDetail2;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ void computeContractTransactionDetail_aroundBody10(EthereumBlockchainTransactionService ajc$this, TransactionDetail transactionDetail, Object transactionReceipt, JoinPoint joinPoint) {
        ajc$this.computeContractTransactionDetail(null, transactionDetail, (TransactionReceipt)transactionReceipt);
    }

    private static /* synthetic */ Object computeContractTransactionDetail_aroundBody11$advice(EthereumBlockchainTransactionService ajc$this, TransactionDetail transactionDetail, Object transactionReceipt, JoinPoint thisJoinPoint, ExoBlockchainTransactionAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ExoBlockchainTransactionService blockchainTransactionService = (ExoBlockchainTransactionService)point.getThis();
        if (blockchainTransactionService.getWebappClassLoader() == null) {
            throw new IllegalStateException("Webapp class loader is null");
        }
        ClassLoader currentThreadCL = ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$startOperationInWebAppCL((ClassLoader)blockchainTransactionService.getWebappClassLoader());
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            EthereumBlockchainTransactionService.computeContractTransactionDetail_aroundBody10((EthereumBlockchainTransactionService)ajc$this, (TransactionDetail)transactionDetail, (Object)transactionReceipt, (JoinPoint)proceedingJoinPoint);
            Object var8_9 = null;
            return var8_9;
        }
        catch (RuntimeException e) {
            ExoBlockchainTransactionAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$LOG().error((Object)"Error while processing blockchain transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            ExoBlockchainTransactionAspect.ajc$inlineAccessMethod$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$org_exoplatform_addon_wallet_blockchain_ExoBlockchainTransactionAspect$endOperationInWebappCL((ClassLoader)currentThreadCL);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EthereumBlockchainTransactionService.java", EthereumBlockchainTransactionService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.exoplatform.addon.wallet.blockchain.service.EthereumBlockchainTransactionService", "", "", "", "void"), 137);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkPendingTransactions", "org.exoplatform.addon.wallet.blockchain.service.EthereumBlockchainTransactionService", "long", "pendingTransactionMaxDays", "", "int"), 163);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "scanNewerBlocks", "org.exoplatform.addon.wallet.blockchain.service.EthereumBlockchainTransactionService", "", "", "java.lang.InterruptedException:java.io.IOException", "void"), 186);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computeTransactionDetail", "org.exoplatform.addon.wallet.blockchain.service.EthereumBlockchainTransactionService", "java.lang.String:org.exoplatform.addon.wallet.model.ContractDetail", "hash:contractDetail", "java.lang.InterruptedException", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail"), 285);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computeTransactionDetail", "org.exoplatform.addon.wallet.blockchain.service.EthereumBlockchainTransactionService", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail:org.exoplatform.addon.wallet.model.ContractDetail", "transactionDetail:contractDetail", "java.lang.InterruptedException", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail"), 299);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computeContractTransactionDetail", "org.exoplatform.addon.wallet.blockchain.service.EthereumBlockchainTransactionService", "org.exoplatform.addon.wallet.model.transaction.TransactionDetail:java.lang.Object", "transactionDetail:transactionReceipt", "", "void"), 347);
    }
}

