/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.statistic;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.exoplatform.addon.wallet.blockchain.statistic.ExoWalletStatistic;
import org.exoplatform.addon.wallet.blockchain.statistic.ExoWalletStatisticService;
import org.exoplatform.addon.wallet.statistic.StatisticUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
public class ExoWalletStatisticAspect {
    private static final Log LOG = ExoLogger.getLogger(ExoWalletStatisticAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ExoWalletStatisticAspect ajc$perSingletonInstance;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="execution(* *(..)) && @annotation(org.exoplatform.addon.wallet.blockchain.statistic.ExoWalletStatistic)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object object;
        ExoWalletStatisticService statisticService = (ExoWalletStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoWalletStatistic annotation = method.getAnnotation(ExoWalletStatistic.class);
        String statisticType = annotation.statisticType();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        Object result = null;
        try {
            object = result = point.proceed();
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map parameters = statisticService.getParameters(statisticType, result, point.getArgs());
                    if (parameters == null || parameters.isEmpty()) {
                        ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                        throw throwable;
                    }
                    parameters.put("remote_service", "blockchain");
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry((Map)parameters);
                    throw throwable;
                }
                catch (Exception e2) {
                    ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map parameters = statisticService.getParameters(statisticType, result, point.getArgs());
            if (parameters == null || parameters.isEmpty()) {
                ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Empty statistic parameters was returned in method {} for statistic type {}", new Object[]{method.getName(), statisticType});
                return object;
            }
            parameters.put("remote_service", "blockchain");
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry((Map)parameters);
            return object;
        }
        catch (Exception e) {
            ExoWalletStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG().error("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), statisticType, e});
        }
        return object;
    }

    static {
        try {
            ExoWalletStatisticAspect.ajc$postClinit();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static ExoWalletStatisticAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.exoplatform.addon.wallet.blockchain.statistic.ExoWalletStatisticAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    private static /* synthetic */ void ajc$postClinit() {
        ajc$perSingletonInstance = new ExoWalletStatisticAspect();
    }

    public static /* synthetic */ Log ajc$inlineAccessFieldGet$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$org_exoplatform_addon_wallet_blockchain_statistic_ExoWalletStatisticAspect$LOG() {
        return LOG;
    }
}

