/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector$AjcClosure1;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector$AjcClosure3;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector$AjcClosure5;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.statistic.ExoWalletStatistic;
import org.exoplatform.addon.wallet.statistic.ExoWalletStatisticAspect;
import org.exoplatform.addon.wallet.statistic.ExoWalletStatisticService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketListener;
import org.web3j.protocol.websocket.WebSocketService;

/*
 * Exception performing whole class analysis ignored.
 */
public class EthereumClientConnector
implements ExoWalletStatisticService,
Startable {
    private static final Log LOG;
    private Web3j web3j = null;
    private WebSocketClient webSocketClient = null;
    private WebSocketService web3jService = null;
    private ScheduledExecutorService connectionVerifierExecutor = null;
    private boolean connectionInProgress = false;
    private boolean serviceStarted = false;
    private boolean serviceStopping = false;
    private String websocketURL = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public EthereumClientConnector() {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-websocket-connector-%d").build();
        this.connectionVerifierExecutor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
    }

    public void start() {
        this.start(WalletUtils.getWebsocketURL());
    }

    public void start(String websocketURL) {
        this.websocketURL = websocketURL;
        this.serviceStarted = true;
        this.connectionVerifierExecutor.scheduleWithFixedDelay(() -> {
            try {
                if (!this.initWeb3Connection()) {
                    return;
                }
            }
            catch (Throwable e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)"Error while checking connection status to Etherreum Websocket endpoint: {}", e);
                } else {
                    LOG.warn("Error while checking connection status to Etherreum Websocket endpoint: {}", new Object[]{e.getMessage()});
                }
                return;
            }
        }, 5L, 10L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.serviceStopping = true;
        this.connectionVerifierExecutor.shutdownNow();
        this.resetConnection();
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionByHash")
    public Transaction getTransaction(String transactionHash) {
        String string = transactionHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Transaction)ExoWalletStatisticAspect.aspectOf().around(new EthereumClientConnector$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionReceipt")
    public TransactionReceipt getTransactionReceipt(String transactionHash) {
        String string = transactionHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (TransactionReceipt)ExoWalletStatisticAspect.aspectOf().around(new EthereumClientConnector$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public boolean isConnected() {
        return this.web3j != null && this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen();
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_blockNumber")
    public long getLastestBlockNumber() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.longValue((Object)ExoWalletStatisticAspect.aspectOf().around(new EthereumClientConnector$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getLogs")
    public Set<String> getContractTransactions(String contractsAddress, long fromBlock, long toBlock) throws IOException {
        String string = contractsAddress;
        long l = fromBlock;
        long l2 = toBlock;
        Object[] objectArray = new Object[]{string, Conversions.longObject((long)l), Conversions.longObject((long)l2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, Conversions.longObject((long)l), Conversions.longObject((long)l2), joinPoint};
        return (Set)ExoWalletStatisticAspect.aspectOf().around(new AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public Web3j getWeb3j() {
        this.waitConnection();
        return this.web3j;
    }

    public void waitConnection() {
        if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.websocketURL)) {
            throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
        }
        if (this.serviceStopping) {
            throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
        }
        try {
            while (!this.isConnected()) {
                if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.websocketURL)) {
                    throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
                }
                if (this.serviceStopping) {
                    throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
                }
                LOG.info((Object)"Wait until Websocket connection to blockchain is established to retrieve information");
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("An error is thrown while waiting for connection on blockchain", e);
        }
    }

    private void resetConnection() {
        if (this.web3j != null) {
            block8: {
                LOG.info((Object)"Resetting blockchain connection");
                try {
                    this.web3j.shutdown();
                }
                catch (Throwable e) {
                    LOG.warn("Error closing old web3j connection: {}", new Object[]{e.getMessage()});
                    if (this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen()) {
                        try {
                            this.web3jService.close();
                        }
                        catch (Throwable e1) {
                            LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
                        }
                    }
                    if (this.webSocketClient == null || !this.webSocketClient.isOpen()) break block8;
                    try {
                        this.webSocketClient.close();
                    }
                    catch (Throwable e1) {
                        LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
                    }
                }
            }
            this.web3j = null;
            this.web3jService = null;
            this.webSocketClient = null;
        }
    }

    public Map<String, Object> getStatisticParameters(String statisticType, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        GlobalSettings settings = WalletUtils.getSettings();
        if (settings != null && settings.getNetwork() != null && StringUtils.isNotBlank((CharSequence)settings.getNetwork().getWebsocketProviderURL())) {
            parameters.put("blockchain_network_id", settings.getNetwork().getId());
            String websocketProviderURL = settings.getNetwork().getWebsocketProviderURL();
            String[] urlParts = websocketProviderURL.split("/");
            parameters.put("blockchain_network_url_suffix", urlParts[urlParts.length - 1]);
        }
        switch (statisticType) {
            case "eth_getTransactionByHash": {
                parameters.put("transaction_hash", methodArgs[0]);
                break;
            }
            case "eth_getTransactionReceipt": {
                parameters.put("transaction_hash", methodArgs[0]);
                break;
            }
            case "eth_getTransactionCount": {
                parameters.put("wallet_address", methodArgs[0]);
                break;
            }
            case "eth_blockNumber": {
                parameters.put("last_block_number", result);
                break;
            }
            case "eth_getLogs": {
                parameters.put("from_block_number", methodArgs[1]);
                parameters.put("to_block_number", methodArgs[2]);
                if (result instanceof Set) {
                    parameters.put("transactions_count_received", ((Set)result).size());
                    break;
                }
                LOG.warn("Statistict type {} has an unexpected result class type", new Object[]{statisticType});
                break;
            }
            default: {
                LOG.warn("Statistic type {} not managed", new Object[]{statisticType});
                return null;
            }
        }
        return parameters;
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionCount")
    public BigInteger getNonce(String walletAddress) throws IOException {
        String string = walletAddress;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (BigInteger)ExoWalletStatisticAspect.aspectOf().around(new AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    private boolean initWeb3Connection() throws Exception {
        if (this.connectionInProgress) {
            LOG.info((Object)"Web3 connection initialization in progress, skip transaction processing until it's initialized");
            return false;
        }
        if (this.serviceStopping) {
            LOG.info((Object)"Stopping server, thus no new connection is attempted again");
            return false;
        }
        String websocketProviderURL = this.websocketURL;
        if (StringUtils.isBlank((CharSequence)websocketProviderURL)) {
            LOG.info((Object)"No configured URL for Ethereum Websocket connection");
            this.resetConnection();
            return false;
        }
        if (!websocketProviderURL.startsWith("ws:") && !websocketProviderURL.startsWith("wss:")) {
            LOG.warn((Object)("Bad format for configured URL " + websocketProviderURL + " for Ethereum Websocket connection"));
            this.resetConnection();
            return false;
        }
        if (this.isConnected()) {
            return false;
        }
        this.connectionInProgress = true;
        try {
            if (this.web3j != null && this.web3jService != null && this.webSocketClient != null) {
                LOG.info("Reconnect to blockchain endpoint {}", new Object[]{this.websocketURL});
                boolean reconnected = this.webSocketClient.reconnectBlocking();
                if (!reconnected) {
                    throw new IllegalStateException("Can't reconnect to ethereum blockchain: " + this.websocketURL);
                }
            } else {
                LOG.info("Connecting to Ethereum network endpoint {}", new Object[]{this.websocketURL});
                this.webSocketClient = new WebSocketClient(new URI(this.websocketURL));
                this.webSocketClient.setConnectionLostTimeout(10);
                this.web3jService = new WebSocketService(this.webSocketClient, true);
                this.webSocketClient.setListener(this.getWebsocketListener());
                this.web3jService.connect();
                Thread.sleep(10000L);
                this.web3j = Web3j.build((Web3jService)this.web3jService);
                LOG.info("Connection established to Ethereum network endpoint {}", new Object[]{this.websocketURL});
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.connectionInProgress = false;
        }
    }

    private WebSocketListener getWebsocketListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private String getConnectionFailedMessage() {
        return "Connection failed to " + this.websocketURL;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ String access$100(EthereumClientConnector x0) {
        return x0.getConnectionFailedMessage();
    }

    static {
        EthereumClientConnector.ajc$preClinit();
        LOG = ExoLogger.getLogger(EthereumClientConnector.class);
    }

    static /* synthetic */ Transaction getTransaction_aroundBody0(EthereumClientConnector ajc$this, String transactionHash, JoinPoint joinPoint) {
        EthTransaction ethTransaction;
        ajc$this.waitConnection();
        try {
            ethTransaction = (EthTransaction)ajc$this.web3j.ethGetTransactionByHash(transactionHash).send();
        }
        catch (IOException e) {
            LOG.info("Connection interrupted while getting Transaction '{}' information. Reattempt until getting it. Reason: {}", new Object[]{transactionHash, e.getMessage()});
            return ajc$this.getTransaction(transactionHash);
        }
        if (ethTransaction != null) {
            return (Transaction)ethTransaction.getResult();
        }
        return null;
    }

    static /* synthetic */ TransactionReceipt getTransactionReceipt_aroundBody2(EthereumClientConnector ajc$this, String transactionHash, JoinPoint joinPoint) {
        EthGetTransactionReceipt ethGetTransactionReceipt;
        ajc$this.waitConnection();
        try {
            ethGetTransactionReceipt = (EthGetTransactionReceipt)ajc$this.web3j.ethGetTransactionReceipt(transactionHash).send();
        }
        catch (IOException e) {
            LOG.info("Connection interrupted while getting Transaction receipt '{}' information. Reattempt until getting it. Reason: {}", new Object[]{transactionHash, e.getMessage()});
            return ajc$this.getTransactionReceipt(transactionHash);
        }
        if (ethGetTransactionReceipt != null) {
            return (TransactionReceipt)ethGetTransactionReceipt.getResult();
        }
        return null;
    }

    static /* synthetic */ long getLastestBlockNumber_aroundBody4(EthereumClientConnector ajc$this, JoinPoint joinPoint) {
        ajc$this.waitConnection();
        BigInteger blockNumber = ((EthBlockNumber)ajc$this.web3j.ethBlockNumber().send()).getBlockNumber();
        return blockNumber.longValue();
    }

    static /* synthetic */ Set getContractTransactions_aroundBody6(EthereumClientConnector ajc$this, String contractsAddress, long fromBlock, long toBlock, JoinPoint joinPoint) {
        ajc$this.waitConnection();
        EthFilter filter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), contractsAddress);
        EthLog contractTransactions = (EthLog)ajc$this.web3j.ethGetLogs(filter).send();
        List logs = (List)contractTransactions.getResult();
        HashSet<String> txHashes = new HashSet<String>();
        if (logs != null && !logs.isEmpty()) {
            for (EthLog.LogResult logResult : logs) {
                org.web3j.protocol.core.methods.response.Log contractEventLog = (org.web3j.protocol.core.methods.response.Log)logResult.get();
                txHashes.add(contractEventLog.getTransactionHash());
            }
        }
        return txHashes;
    }

    static /* synthetic */ BigInteger getNonce_aroundBody8(EthereumClientConnector ajc$this, String walletAddress, JoinPoint joinPoint) {
        ajc$this.waitConnection();
        return ((EthGetTransactionCount)ajc$this.getWeb3j().ethGetTransactionCount(walletAddress, (DefaultBlockParameter)DefaultBlockParameterName.PENDING).send()).getTransactionCount();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EthereumClientConnector.java", EthereumClientConnector.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransaction", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "transactionHash", "", "org.web3j.protocol.core.methods.response.Transaction"), 113);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransactionReceipt", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "transactionHash", "", "org.web3j.protocol.core.methods.response.TransactionReceipt"), 137);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastestBlockNumber", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "", "", "java.io.IOException", "long"), 166);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getContractTransactions", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String:long:long", "contractsAddress:fromBlock:toBlock", "java.io.IOException", "java.util.Set"), 186);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNonce", "org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "walletAddress", "java.io.IOException", "java.math.BigInteger"), 305);
    }
}

