/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.blockchain.servlet;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.exoplatform.addon.wallet.blockchain.listener.BlockMinedListener;
import org.exoplatform.addon.wallet.blockchain.listener.TransactionMinedListener;
import org.exoplatform.addon.wallet.blockchain.listener.WebSocketContractListener;
import org.exoplatform.addon.wallet.blockchain.listener.WebSocketTransactionListener;
import org.exoplatform.addon.wallet.blockchain.listener.WebSocketWalletListener;
import org.exoplatform.addon.wallet.blockchain.service.EthereumBlockchainTransactionService;
import org.exoplatform.addon.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.blockchain.service.EthereumWalletTokenAdminService;
import org.exoplatform.addon.wallet.job.ContractTransactionVerifierJob;
import org.exoplatform.addon.wallet.job.GasPriceUpdaterJob;
import org.exoplatform.addon.wallet.job.TransactionSenderJob;
import org.exoplatform.addon.wallet.listener.TransactionNotificationListener;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.service.BlockchainTransactionService;
import org.exoplatform.addon.wallet.service.WalletService;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.CronJob;
import org.exoplatform.services.scheduler.JobSchedulerService;

public class ServiceLoaderServlet
extends HttpServlet {
    private static final long serialVersionUID = 4629318431709644350L;
    private static final Log LOG = ExoLogger.getLogger(ServiceLoaderServlet.class);
    private static final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public void init() throws ServletException {
        executor.scheduleAtFixedRate(() -> this.instantiateBlockchainServices(), 10L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instantiateBlockchainServices() {
        PortalContainer container = PortalContainer.getInstance();
        if (container == null || !container.isStarted()) {
            LOG.debug((Object)"Portal Container is not yet started");
            return;
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            GlobalSettings settings = WalletUtils.getSettings();
            if (settings == null) {
                LOG.warn((Object)"No wallet addon settings are found");
                return;
            }
            if (settings.getNetwork() == null || settings.getNetwork().getId() <= 0L || StringUtils.isBlank((CharSequence)settings.getNetwork().getProviderURL()) || StringUtils.isBlank((CharSequence)settings.getNetwork().getWebsocketProviderURL())) {
                LOG.warn("No valid blockchain network settings are found: {}", new Object[]{settings.getNetwork()});
                return;
            }
            if (StringUtils.isBlank((CharSequence)settings.getContractAddress())) {
                LOG.warn((Object)"No contract address is configured");
                return;
            }
            ClassLoader webappClassLoader = this.getWebappClassLoader();
            Class<?> class1 = webappClassLoader.loadClass(BouncyCastleProvider.class.getName());
            Provider provider = (Provider)class1.newInstance();
            Security.removeProvider(BouncyCastleProvider.PROVIDER_NAME);
            Security.addProvider(provider);
            provider = Security.getProvider(BouncyCastleProvider.PROVIDER_NAME);
            LOG.info("BouncyCastleProvider class registered with version {}", new Object[]{provider.getVersion()});
            EthereumClientConnector web3jConnector = new EthereumClientConnector();
            container.registerComponentInstance(EthereumClientConnector.class, (Object)web3jConnector);
            web3jConnector.start(true);
            EthereumBlockchainTransactionService transactionDecoderService = new EthereumBlockchainTransactionService(web3jConnector);
            container.registerComponentInstance(BlockchainTransactionService.class, (Object)transactionDecoderService);
            EthereumWalletTokenAdminService tokenAdminService = new EthereumWalletTokenAdminService(web3jConnector);
            container.registerComponentInstance(WalletTokenAdminService.class, (Object)tokenAdminService);
            ListenerService listernerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
            listernerService.addListener("exo.addon.wallet.block.mined", (Listener)new BlockMinedListener((ExoContainer)container, (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class), (BlockchainTransactionService)transactionDecoderService));
            listernerService.addListener("exo.addon.wallet.transaction.mined", (Listener)new TransactionMinedListener());
            listernerService.addListener("exo.addon.wallet.transaction.modified", (Listener)new TransactionNotificationListener(container));
            listernerService.addListener("exo.addon.wallet.transaction.modified", (Listener)new WebSocketTransactionListener());
            listernerService.addListener("exo.addon.wallet.modified", (Listener)new WebSocketWalletListener());
            listernerService.addListener("exo.addon.wallet.contract.modified", (Listener)new WebSocketContractListener());
            tokenAdminService.start();
            transactionDecoderService.start();
            this.addBlockchainScheduledJob(ContractTransactionVerifierJob.class, "Add a job to verify if mined contract transactions are added in database", "0 0/5 * ? * * *");
            this.addBlockchainScheduledJob(TransactionSenderJob.class, "Configuration for transaction sending to blockchain", "0/30 * * * * ?");
            WalletService walletService = (WalletService)container.getComponentInstanceOfType(WalletService.class);
            if (walletService.isUseDynamicGasPrice()) {
                this.addBlockchainScheduledJob(GasPriceUpdaterJob.class, "A job to update gas price from blockchain", "0 0/2 * * * ?");
            }
            LOG.debug((Object)"Blockchain Service instances created");
        }
        catch (Throwable e) {
            LOG.error((Object)"Error registering service into portal container", e);
        }
        finally {
            RequestLifeCycle.end();
        }
        executor.shutdown();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.init();
        super.service(req, resp);
    }

    private void addBlockchainScheduledJob(Class<?> jobClass, String description, String defaultCronExpression) throws Exception {
        JobSchedulerService schedulerService = (JobSchedulerService)CommonsUtils.getService(JobSchedulerService.class);
        String jobSimpleName = jobClass.getSimpleName();
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("cronjob.info");
        propertiesParam.setDescription(description);
        propertiesParam.setProperty("jobName", jobSimpleName);
        propertiesParam.setProperty("groupName", "Wallet");
        propertiesParam.setProperty("job", jobClass.getName());
        propertiesParam.setProperty("expression", System.getProperty("exo.wallet." + jobSimpleName + ".expression", defaultCronExpression));
        params.addParam((Object)propertiesParam);
        CronJob cronJob = new CronJob(params);
        schedulerService.addCronJob((ComponentPlugin)cronJob);
    }

    private ClassLoader getWebappClassLoader() {
        return this.getServletContext().getClassLoader();
    }
}

