/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.UndeliverableException;
import io.reactivex.plugins.RxJavaPlugins;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure1;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure13;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure3;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure5;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.statistic.ExoWalletStatistic;
import org.exoplatform.wallet.statistic.ExoWalletStatisticAspect;
import org.exoplatform.wallet.statistic.ExoWalletStatisticService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.picocontainer.Startable;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketListener;
import org.web3j.protocol.websocket.WebSocketService;
import org.web3j.utils.Async;

/*
 * Exception performing whole class analysis ignored.
 */
public class EthereumClientConnector
implements ExoWalletStatisticService,
Startable {
    private static final Log LOG;
    private static final int MINIMUM_POOLING_TIME = 15000;
    private static final int DEFAULT_POOLING_TIME = 60000;
    private Web3j web3j = null;
    private WebSocketClient webSocketClient = null;
    private WebSocketService web3jService = null;
    private ListenerService listenerService = null;
    private ScheduledExecutorService connectionVerifierExecutor = null;
    private boolean permanentlyScanBlockchain = false;
    private boolean listeningToBlockchain = false;
    private boolean connectionInProgress = false;
    private boolean serviceStarted = false;
    private boolean serviceStopping = false;
    private long networkId = 0L;
    private String websocketURL = null;
    private String websocketURLSuffix = null;
    private Disposable blockSubscribtion;
    private long poolingInterval = 0L;
    private long lastWatchedBlockNumber;
    private long lastBlockNumber;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public EthereumClientConnector() {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-websocket-connector-%d").build();
        this.connectionVerifierExecutor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        String poolingIntervalParam = System.getProperty("exo.wallet.blockchain.pooling.intervalInSeconds");
        if (StringUtils.isNotBlank((CharSequence)poolingIntervalParam)) {
            this.setPoolingInterval(Long.parseLong(poolingIntervalParam) * 1000L);
        } else {
            this.setPoolingInterval(60000L);
        }
        String permanentlyScanParam = System.getProperty("exo.wallet.blockchain.permanentlyScan", "false");
        this.permanentlyScanBlockchain = Boolean.parseBoolean(permanentlyScanParam);
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean blocking) {
        this.websocketURL = WalletUtils.getWebsocketURL();
        this.networkId = WalletUtils.getNetworkId();
        this.serviceStarted = true;
        if (RxJavaPlugins.getErrorHandler() == null) {
            RxJavaPlugins.setErrorHandler(e -> {
                if (e instanceof UndeliverableException) {
                    e = e.getCause();
                }
                LOG.warn((Object)"Unhandeled error happened while communicating with blockchain", e);
            });
        }
        if (this.permanentlyScanBlockchain) {
            this.startListeningBlockchain();
            if (blocking) {
                this.waitConnection();
            }
        }
    }

    public void stop() {
        this.serviceStopping = true;
        this.connectionVerifierExecutor.shutdownNow();
        this.stopListeningToBlockchain();
        this.closeConnection();
    }

    public void startListeningBlockchain() {
        this.connectionVerifierExecutor.scheduleAtFixedRate(() -> this.checkConnection(), 0L, 10L, TimeUnit.SECONDS);
    }

    public void stopListeningToBlockchain() {
        if (this.blockSubscribtion != null && !this.blockSubscribtion.isDisposed()) {
            LOG.info((Object)"Close mined blocks subscription");
            try {
                this.blockSubscribtion.dispose();
            }
            catch (Exception e) {
                LOG.warn("Error when closing old subscription", new Object[]{e.getMessage()});
            }
            this.listeningToBlockchain = false;
        }
    }

    public boolean isPermanentlyScanBlockchain() {
        return this.permanentlyScanBlockchain;
    }

    public boolean isListeningToBlockchain() {
        return this.listeningToBlockchain;
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionByHash")
    public Transaction getTransaction(String transactionHash) {
        String string = transactionHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Transaction)ExoWalletStatisticAspect.aspectOf().around(new EthereumClientConnector$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionReceipt")
    public TransactionReceipt getTransactionReceipt(String transactionHash) {
        String string = transactionHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (TransactionReceipt)ExoWalletStatisticAspect.aspectOf().around(new EthereumClientConnector$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_blockNumber")
    public long getLastestBlockNumber() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.longValue((Object)ExoWalletStatisticAspect.aspectOf().around(new EthereumClientConnector$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getLogs")
    public Set<String> getContractTransactions(String contractsAddress, long fromBlock, long toBlock) throws IOException {
        String string = contractsAddress;
        long l = fromBlock;
        long l2 = toBlock;
        Object[] objectArray = new Object[]{string, Conversions.longObject((long)l), Conversions.longObject((long)l2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, Conversions.longObject((long)l), Conversions.longObject((long)l2), joinPoint};
        return (Set)ExoWalletStatisticAspect.aspectOf().around(new AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_sendRawTransaction")
    public CompletableFuture<EthSendTransaction> sendTransactionToBlockchain(TransactionDetail transactionDetail) throws IOException {
        TransactionDetail transactionDetail2 = transactionDetail;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)transactionDetail2);
        Object[] objectArray = new Object[]{this, transactionDetail2, joinPoint};
        return (CompletableFuture)ExoWalletStatisticAspect.aspectOf().around(new AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionCount")
    public BigInteger getNonce(String walletAddress, DefaultBlockParameterName blockParameterName) throws IOException {
        String string = walletAddress;
        DefaultBlockParameterName defaultBlockParameterName = blockParameterName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)defaultBlockParameterName);
        Object[] objectArray = new Object[]{this, string, defaultBlockParameterName, joinPoint};
        return (BigInteger)ExoWalletStatisticAspect.aspectOf().around(new AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getGasPrice")
    public BigInteger getGasPrice() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (BigInteger)ExoWalletStatisticAspect.aspectOf().around(new EthereumClientConnector$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    public Web3j getWeb3j() {
        if (this.isPermanentlyScanBlockchain()) {
            this.waitConnection();
        } else {
            this.checkConnection();
        }
        return this.web3j;
    }

    public Map<String, Object> getStatisticParameters(String statisticType, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.networkId > 0L && StringUtils.isNotBlank((CharSequence)this.websocketURL)) {
            if (this.websocketURLSuffix == null) {
                String[] urlParts = this.websocketURL.split("/");
                this.websocketURLSuffix = urlParts[urlParts.length - 1];
            }
            parameters.put("blockchain_network_url_suffix", this.websocketURLSuffix);
            parameters.put("blockchain_network_id", this.networkId);
        }
        switch (statisticType) {
            case "eth_getTransactionByHash": {
                parameters.put("transaction_hash", methodArgs[0]);
                break;
            }
            case "eth_getTransactionReceipt": {
                parameters.put("transaction_hash", methodArgs[0]);
                break;
            }
            case "eth_getTransactionCount": {
                parameters.put("wallet_address", methodArgs[0]);
                break;
            }
            case "eth_getGasPrice": {
                BigInteger gasPriceInWei = (BigInteger)result;
                parameters.put("ga_price_gwei", WalletUtils.convertFromDecimals((BigInteger)BigInteger.valueOf(gasPriceInWei.longValue()), (int)9));
                break;
            }
            case "eth_blockNumber": {
                parameters.put("last_block_number", result);
                break;
            }
            case "eth_getLogs": {
                parameters.put("from_block_number", methodArgs[1]);
                parameters.put("to_block_number", methodArgs[2]);
                if (result instanceof Set) {
                    parameters.put("transactions_count_received", ((Set)result).size());
                    break;
                }
                LOG.warn("Statistict type {} has an unexpected result class type", new Object[]{statisticType});
                break;
            }
            case "eth_sendRawTransaction": {
                double valueAmount;
                double contractAmount;
                TransactionDetail transactionDetail = (TransactionDetail)methodArgs[0];
                String methodName = transactionDetail.getContractMethodName();
                parameters.put("hash", transactionDetail.getHash());
                parameters.put("nonce", transactionDetail.getNonce());
                parameters.put("sender", transactionDetail.getFromWallet());
                parameters.put("receiver", transactionDetail.getToWallet());
                parameters.put("gas_price", WalletUtils.convertFromDecimals((BigInteger)BigInteger.valueOf((long)transactionDetail.getGasPrice()), (int)9));
                if (StringUtils.isNotBlank((CharSequence)transactionDetail.getContractAddress())) {
                    parameters.put("contract_address", transactionDetail.getContractAddress());
                }
                if (StringUtils.isNotBlank((CharSequence)methodName)) {
                    parameters.put("contract_method", methodName);
                }
                if ((contractAmount = transactionDetail.getContractAmount()) > 0.0 && (StringUtils.equals((CharSequence)"initializeAccount", (CharSequence)methodName) || StringUtils.equals((CharSequence)"transfer", (CharSequence)methodName) || StringUtils.equals((CharSequence)"reward", (CharSequence)methodName) || StringUtils.equals((CharSequence)"approve", (CharSequence)methodName) || StringUtils.equals((CharSequence)"transferFrom", (CharSequence)methodName))) {
                    parameters.put("amount_token", contractAmount);
                }
                if (!((valueAmount = transactionDetail.getValue()) > 0.0)) break;
                if (StringUtils.equals((CharSequence)"reward", (CharSequence)methodName)) {
                    parameters.put("amount_reward_token", valueAmount);
                    break;
                }
                parameters.put("amount_ether", valueAmount);
                break;
            }
            default: {
                LOG.warn("Statistic type {} not managed", new Object[]{statisticType});
                return null;
            }
        }
        return parameters;
    }

    public void renewBlockSubscription(long lastWatchedBlockNumber) throws IOException {
        this.lastWatchedBlockNumber = lastWatchedBlockNumber;
        this.lastBlockNumber = this.getLastestBlockNumber();
        LOG.info("Start watching mined blocks from blockchain from block '{}'", new Object[]{this.lastWatchedBlockNumber});
        this.stopListeningToBlockchain();
        this.subscribeToBlockMining();
    }

    public void setPoolingInterval(long poolingInterval) {
        if (poolingInterval < 15000L) {
            throw new IllegalStateException("Pooling interval " + poolingInterval + " shouldn't be less than block time " + 15000);
        }
        this.poolingInterval = poolingInterval;
    }

    public long getPoolingInterval() {
        return this.poolingInterval;
    }

    private boolean isConnected() {
        return this.web3j != null && this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen();
    }

    private void waitConnection() {
        if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.websocketURL)) {
            throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
        }
        if (this.serviceStopping) {
            throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
        }
        try {
            while (!this.isConnected()) {
                if (this.serviceStarted && StringUtils.isBlank((CharSequence)this.websocketURL)) {
                    throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
                }
                if (this.serviceStopping) {
                    throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
                }
                LOG.debug((Object)"Wait until Websocket connection to blockchain is established to retrieve information");
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("An error is thrown while waiting for connection on blockchain", e);
        }
    }

    private boolean connect() throws Exception {
        if (this.connectionInProgress) {
            LOG.debug((Object)"Web3 connection is in progress");
            return false;
        }
        if (this.serviceStopping) {
            LOG.info((Object)"Stopping server, thus no new connection is attempted again");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.websocketURL)) {
            LOG.info((Object)"No configured URL for Ethereum Websocket connection");
            return false;
        }
        if (!this.websocketURL.startsWith("ws:") && !this.websocketURL.startsWith("wss:")) {
            LOG.warn((Object)("Bad format for configured URL " + this.websocketURL + " for Ethereum Websocket connection"));
            return false;
        }
        this.connectionInProgress = true;
        try {
            if (this.web3j != null && this.web3jService != null && this.webSocketClient != null) {
                LOG.info("Reconnect to blockchain endpoint {}", new Object[]{this.websocketURL});
                boolean reconnected = this.webSocketClient.reconnectBlocking();
                if (reconnected) {
                    LOG.info("Connection established to Ethereum network endpoint {}", new Object[]{this.websocketURL});
                    this.renewBlockSubscription(this.lastWatchedBlockNumber + 1L);
                }
                boolean bl = reconnected;
                return bl;
            }
            LOG.info("Connecting to Ethereum network endpoint {}", new Object[]{this.websocketURL});
            this.webSocketClient = new WebSocketClient(new URI(this.websocketURL));
            this.webSocketClient.setConnectionLostTimeout(10);
            this.web3jService = new WebSocketService(this.webSocketClient, true);
            this.webSocketClient.setListener((WebSocketListener)new /* Unavailable Anonymous Inner Class!! */);
            this.web3jService.connect();
            this.web3j = Web3j.build((Web3jService)this.web3jService, (long)this.getPoolingInterval(), (ScheduledExecutorService)Async.defaultExecutorService());
            LOG.info("Connection established to Ethereum network endpoint {}", new Object[]{this.websocketURL});
            boolean bl = true;
            return bl;
        }
        finally {
            this.connectionInProgress = false;
        }
    }

    private void checkConnection() {
        try {
            if (!this.isConnected()) {
                this.connect();
                this.waitConnection();
            }
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"Error while checking connection status to Etherreum Websocket endpoint", e);
            }
            LOG.warn("Error while checking connection status to Etherreum Websocket endpoint: {}", new Object[]{e.getMessage()});
        }
    }

    private void closeConnection() {
        if (this.web3j != null) {
            LOG.info((Object)"Closing blockchain connection");
            try {
                this.web3j.shutdown();
                this.web3j = null;
                this.web3jService = null;
                this.webSocketClient = null;
            }
            catch (Throwable e) {
                LOG.warn("Error closing old web3j connection: {}", new Object[]{e.getMessage()});
            }
        }
        if (this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                this.web3jService.close();
                this.web3jService = null;
                this.webSocketClient = null;
            }
            catch (Throwable e1) {
                LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
            }
        }
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                this.webSocketClient.close();
                this.webSocketClient = null;
            }
            catch (Throwable e1) {
                LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
            }
        }
    }

    private void subscribeToBlockMining() {
        LOG.debug("Replay all blocks starting from number '{}' until last mined one {}.", new Object[]{this.lastWatchedBlockNumber, this.lastBlockNumber});
        this.listeningToBlockchain = true;
        Flowable blocksFlowable = this.getWeb3j().replayPastAndFutureBlocksFlowable((DefaultBlockParameter)this.getLastWatchedBlock(), false);
        this.initSubscribe(blocksFlowable);
    }

    private void initSubscribe(Flowable<EthBlock> flowable) {
        this.blockSubscribtion = flowable.subscribe(ethBlock -> this.handleNewBlockEvent(ethBlock), exception -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Subscription to mined blocks events is interrupted, reattempt subsciption it !", exception);
            } else {
                LOG.info("Subscription to mined blocks events is interrupted with message: {}, reattempt subsciption it !", new Object[]{this.getLastExceptionMessage(exception)});
            }
            this.renewBlockSubscription(this.lastWatchedBlockNumber + 1L);
        });
    }

    private String getLastExceptionMessage(Throwable exception) {
        if (exception == null) {
            return "NO EXCEPTION MESSAGE";
        }
        if (exception.getCause() == null) {
            return exception.getMessage();
        }
        return this.getLastExceptionMessage(exception.getCause());
    }

    private void handleNewBlockEvent(EthBlock ethBlock) throws Exception {
        if (ethBlock == null || ethBlock.getBlock() == null) {
            return;
        }
        EthBlock.Block block = ethBlock.getBlock();
        long blockNumber = block.getNumber().longValue();
        this.getListenerService().broadcast("exo.wallet.block.mined", (Object)block, (Object)(blockNumber > this.lastBlockNumber ? 1 : 0));
        this.lastWatchedBlockNumber = Math.max(this.lastWatchedBlockNumber, blockNumber);
    }

    private DefaultBlockParameterNumber getLastWatchedBlock() {
        return new DefaultBlockParameterNumber(this.lastWatchedBlockNumber);
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static {
        EthereumClientConnector.ajc$preClinit();
        LOG = ExoLogger.getLogger(EthereumClientConnector.class);
    }

    static /* synthetic */ Transaction getTransaction_aroundBody0(EthereumClientConnector ajc$this, String transactionHash, JoinPoint joinPoint) {
        EthTransaction ethTransaction;
        try {
            ethTransaction = (EthTransaction)ajc$this.getWeb3j().ethGetTransactionByHash(transactionHash).send();
        }
        catch (IOException e) {
            LOG.info("Connection interrupted while getting Transaction '{}' information. Reattempt until getting it. Reason: {}", new Object[]{transactionHash, e.getMessage()});
            return ajc$this.getTransaction(transactionHash);
        }
        if (ethTransaction != null) {
            return (Transaction)ethTransaction.getResult();
        }
        return null;
    }

    static /* synthetic */ TransactionReceipt getTransactionReceipt_aroundBody2(EthereumClientConnector ajc$this, String transactionHash, JoinPoint joinPoint) {
        EthGetTransactionReceipt ethGetTransactionReceipt;
        try {
            ethGetTransactionReceipt = (EthGetTransactionReceipt)ajc$this.getWeb3j().ethGetTransactionReceipt(transactionHash).send();
        }
        catch (IOException e) {
            LOG.info("Connection interrupted while getting Transaction receipt '{}' information. Reattempt until getting it. Reason: {}", new Object[]{transactionHash, e.getMessage()});
            return ajc$this.getTransactionReceipt(transactionHash);
        }
        if (ethGetTransactionReceipt != null) {
            return (TransactionReceipt)ethGetTransactionReceipt.getResult();
        }
        return null;
    }

    static /* synthetic */ long getLastestBlockNumber_aroundBody4(EthereumClientConnector ajc$this, JoinPoint joinPoint) {
        BigInteger blockNumber = ((EthBlockNumber)ajc$this.getWeb3j().ethBlockNumber().send()).getBlockNumber();
        return blockNumber.longValue();
    }

    static /* synthetic */ Set getContractTransactions_aroundBody6(EthereumClientConnector ajc$this, String contractsAddress, long fromBlock, long toBlock, JoinPoint joinPoint) {
        EthFilter filter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), contractsAddress);
        EthLog contractTransactions = (EthLog)ajc$this.getWeb3j().ethGetLogs(filter).send();
        List logs = (List)contractTransactions.getResult();
        HashSet<String> txHashes = new HashSet<String>();
        if (logs != null && !logs.isEmpty()) {
            for (EthLog.LogResult logResult : logs) {
                org.web3j.protocol.core.methods.response.Log contractEventLog = (org.web3j.protocol.core.methods.response.Log)logResult.get();
                txHashes.add(contractEventLog.getTransactionHash());
            }
        }
        return txHashes;
    }

    static /* synthetic */ CompletableFuture sendTransactionToBlockchain_aroundBody8(EthereumClientConnector ajc$this, TransactionDetail transactionDetail, JoinPoint joinPoint) {
        return ajc$this.getWeb3j().ethSendRawTransaction(transactionDetail.getRawTransaction()).sendAsync();
    }

    static /* synthetic */ BigInteger getNonce_aroundBody10(EthereumClientConnector ajc$this, String walletAddress, DefaultBlockParameterName blockParameterName, JoinPoint joinPoint) {
        if (blockParameterName == null) {
            blockParameterName = DefaultBlockParameterName.LATEST;
        }
        return ((EthGetTransactionCount)ajc$this.getWeb3j().ethGetTransactionCount(walletAddress, (DefaultBlockParameter)blockParameterName).send()).getTransactionCount();
    }

    static /* synthetic */ BigInteger getGasPrice_aroundBody12(EthereumClientConnector ajc$this, JoinPoint joinPoint) {
        return ((EthGasPrice)ajc$this.getWeb3j().ethGasPrice().send()).getGasPrice();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EthereumClientConnector.java", EthereumClientConnector.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransaction", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "transactionHash", "", "org.web3j.protocol.core.methods.response.Transaction"), 185);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransactionReceipt", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "transactionHash", "", "org.web3j.protocol.core.methods.response.TransactionReceipt"), 208);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastestBlockNumber", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "", "", "java.io.IOException", "long"), 227);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getContractTransactions", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "java.lang.String:long:long", "contractsAddress:fromBlock:toBlock", "java.io.IOException", "java.util.Set"), 246);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "sendTransactionToBlockchain", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "org.exoplatform.wallet.model.transaction.TransactionDetail", "transactionDetail", "java.io.IOException", "java.util.concurrent.CompletableFuture"), 277);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNonce", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "java.lang.String:org.web3j.protocol.core.DefaultBlockParameterName", "walletAddress:blockParameterName", "java.io.IOException", "java.math.BigInteger"), 295);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGasPrice", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "", "", "java.io.IOException", "java.math.BigInteger"), 310);
    }
}

