/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.wallet.blockchain.service.EthereumWalletTokenAdminService;
import org.exoplatform.wallet.contract.ERTTokenV2;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.WalletInitializationState;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.model.settings.GlobalSettings;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletContractService;
import org.exoplatform.wallet.service.WalletService;
import org.exoplatform.wallet.service.WalletTokenAdminService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.statistic.ExoWalletStatistic;
import org.exoplatform.wallet.statistic.ExoWalletStatisticAspect;
import org.exoplatform.wallet.statistic.ExoWalletStatisticService;
import org.exoplatform.wallet.storage.WalletStorage;
import org.exoplatform.wallet.utils.WalletUtils;
import org.picocontainer.Startable;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;
import org.web3j.utils.Numeric;

/*
 * Exception performing whole class analysis ignored.
 */
public class EthereumWalletTokenAdminService
implements WalletTokenAdminService,
Startable,
ExoWalletStatisticService {
    private static final Log LOG;
    private static final int ADMIN_WALLET_MIN_LEVEL = 2;
    private static final String NO_CONFIGURED_CONTRACT_ADDRESS = "No configured contract address";
    private static final String TRANSACTION_DETAIL_IS_MANDATORY = "Transaction detail is mandatory";
    private static final String RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY = "receiver address parameter is mandatory";
    private UserACL userACL;
    private WalletService walletService;
    private WalletContractService walletContractService;
    private EthereumClientConnector clientConnector;
    private WalletAccountService accountService;
    private WalletStorage accountStorage;
    private WalletTransactionService transactionService;
    private ERTTokenV2 ertInstance;
    private long networkId = 0L;
    private String websocketURL = null;
    private String websocketURLSuffix = null;
    private String configuredContractAddress;
    private Integer configuredContractDecimals;
    private String adminPrivateKey;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public EthereumWalletTokenAdminService(EthereumClientConnector clientConnector, String adminPrivateKey) {
        this.clientConnector = clientConnector;
        this.adminPrivateKey = adminPrivateKey;
    }

    public void start() {
        try {
            this.configuredContractAddress = WalletUtils.getContractAddress();
            this.websocketURL = WalletUtils.getWebsocketURL();
            this.networkId = WalletUtils.getNetworkId();
            ContractDetail contractDetail = this.getContractService().getContractDetail(this.configuredContractAddress);
            if (contractDetail == null) {
                contractDetail = new ContractDetail();
                contractDetail.setAddress(this.configuredContractAddress);
                this.refreshContractDetailFromBlockchain(contractDetail, null);
                this.getWalletService().setConfiguredContractDetail(contractDetail);
            }
            this.configuredContractDecimals = this.getPrincipalContractDetail().getDecimals();
        }
        catch (Exception e) {
            LOG.warn("Error refreshing contract detail from blockchain with address {}", new Object[]{this.configuredContractAddress, e});
        }
        org.exoplatform.wallet.model.Wallet wallet = this.getAccountService().getAdminWallet();
        if (wallet == null || StringUtils.isBlank((CharSequence)wallet.getAddress())) {
            if (StringUtils.isBlank((CharSequence)this.adminPrivateKey)) {
                this.createAdminAccount();
            } else {
                try {
                    this.createAdminAccount(this.adminPrivateKey, this.getUserACL().getSuperUser());
                    LOG.warn((Object)"Admin wallet private key has been imported, you can delete it from property to keep it safe");
                }
                catch (Exception e) {
                    this.createAdminAccount();
                }
            }
        } else {
            LOG.warn((Object)"Admin wallet private key has been already imported, you can delete it from property to keep it safe!");
        }
    }

    public void stop() {
    }

    public void createAdminAccount() {
        try {
            this.createAdminAccount(null, this.getUserACL().getSuperUser());
            LOG.info((Object)"Admin wallet created");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("This exception shouldn't be thrown because no ACL check is made on server side method call", e);
        }
    }

    public org.exoplatform.wallet.model.Wallet createAdminAccount(String privateKey, String currentUser) throws IllegalAccessException {
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException("User " + currentUser + " is not allowed to create admin wallet");
        }
        Identity identity = WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.ADMIN, (String)"admin");
        if (identity == null) {
            throw new IllegalStateException("Can't find identity of admin wallet");
        }
        long identityId = Long.parseLong(identity.getId());
        org.exoplatform.wallet.model.Wallet wallet = this.getAccountService().getWalletByIdentityId(identityId);
        if (wallet != null && wallet.getAddress() != null && this.getAccountService().getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin") != null) {
            throw new IllegalStateException("Admin wallet has already an associated wallet, thus can't overwrite it");
        }
        ECKeyPair ecKeyPair = null;
        if (StringUtils.isBlank((CharSequence)privateKey)) {
            try {
                ecKeyPair = Keys.createEcKeyPair();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error creating new wallet keys pair", e);
            }
        } else {
            if (!org.web3j.crypto.WalletUtils.isValidPrivateKey((String)privateKey)) {
                throw new IllegalStateException("Private key isn't valid");
            }
            ecKeyPair = Credentials.create((String)privateKey).getEcKeyPair();
        }
        WalletFile adminWallet = null;
        try {
            adminWallet = Wallet.createLight((String)this.accountService.getAdminAccountPassword(), (ECKeyPair)ecKeyPair);
        }
        catch (CipherException e) {
            throw new IllegalStateException("Error creating new wallet", e);
        }
        wallet = new org.exoplatform.wallet.model.Wallet();
        wallet.setEnabled(true);
        wallet.setId("admin");
        wallet.setType(WalletType.ADMIN.getId());
        wallet.setAddress("0x" + adminWallet.getAddress());
        wallet.setTechnicalId(identityId);
        this.getAccountService().saveWalletAddress(wallet, currentUser);
        try {
            String walletJson = WalletUtils.toJsonString((Object)adminWallet);
            this.getAccountStorage().saveWalletPrivateKey(identityId, walletJson);
        }
        catch (Exception e) {
            this.getAccountService().removeWalletByAddress(wallet.getAddress(), currentUser);
        }
        return wallet;
    }

    public String getAdminWalletAddress() {
        org.exoplatform.wallet.model.Wallet adminWallet = this.getAccountService().getAdminWallet();
        return adminWallet == null ? null : adminWallet.getAddress();
    }

    public final boolean isApprovedAccount(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = this.checkContractAddress();
        return (Boolean)this.executeReadOperation(contractAddress, "isApprovedAccount", new Object[]{address});
    }

    public final int getAdminLevel(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = this.checkContractAddress();
        BigInteger adminLevel = (BigInteger)this.executeReadOperation(contractAddress, "getAdminLevel", new Object[]{address});
        return adminLevel == null ? 0 : adminLevel.intValue();
    }

    public final boolean isInitializedAccount(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = this.checkContractAddress();
        return (Boolean)this.executeReadOperation(contractAddress, "isInitializedAccount", new Object[]{address});
    }

    public final BigInteger balanceOf(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        String contractAddress = this.checkContractAddress();
        return (BigInteger)this.executeReadOperation(contractAddress, "balanceOf", new Object[]{address});
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getBalance")
    public final BigInteger getEtherBalanceOf(String address) throws Exception {
        String string = address;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (BigInteger)ExoWalletStatisticAspect.aspectOf().around(new AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final TransactionDetail initialize(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, issuerUsername);
        if (this.isInitializedAccount(receiverAddress)) {
            throw new IllegalStateException("Wallet {} is already initialized");
        }
        String adminWalletAddress = this.getAdminWalletAddress();
        BigInteger tokenAmount = transactionDetail.getContractAmountDecimal(this.configuredContractDecimals.intValue());
        BigInteger etherAmount = transactionDetail.getValueDecimal(18);
        BigInteger balanceOfAdmin = this.balanceOf(adminWalletAddress);
        if (balanceOfAdmin == null || balanceOfAdmin.compareTo(tokenAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough tokens to initialize " + tokenAmount.longValue() + " tokens to " + receiverAddress);
        }
        if (this.getEtherBalanceOf(adminWalletAddress).compareTo(etherAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough ether to initialize " + etherAmount.longValue() + " WEI to " + receiverAddress);
        }
        if (StringUtils.isBlank((CharSequence)this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        Function initializeAccountFunction = this.getInitializeAccountFunctionCall(receiverAddress, tokenAmount);
        this.generateRawTransaction(this.configuredContractAddress, initializeAccountFunction, etherAmount, transactionDetail);
        transactionDetail.setNetworkId(this.networkId);
        transactionDetail.setFrom(adminWalletAddress);
        transactionDetail.setContractAddress(this.configuredContractAddress);
        transactionDetail.setContractMethodName("initializeAccount");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        this.getTransactionService().saveTransactionDetail(transactionDetail, false);
        this.getAccountService().setInitializationStatus(receiverAddress, WalletInitializationState.PENDING);
        return transactionDetail;
    }

    public TransactionDetail sendEther(TransactionDetail transactionDetail, String currentUserId) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        if (transactionDetail.getValue() <= 0.0) {
            throw new IllegalArgumentException("ether amount parameter has to be a positive amount");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, currentUserId);
        String adminWalletAddress = this.getAdminWalletAddress();
        BigInteger etherAmount = transactionDetail.getValueDecimal(18);
        BigInteger adminEtherBalance = this.getEtherBalanceOf(adminWalletAddress);
        if (adminEtherBalance.compareTo(etherAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough ether to initialize " + etherAmount.longValue() + " WEI to " + receiverAddress);
        }
        this.generateRawTransaction(receiverAddress, null, etherAmount, transactionDetail);
        transactionDetail.setNetworkId(this.networkId);
        transactionDetail.setFrom(adminWalletAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        transactionDetail.setGasPrice((double)WalletUtils.getAdminGasPrice().longValue());
        this.getTransactionService().saveTransactionDetail(transactionDetail, false);
        return transactionDetail;
    }

    public final TransactionDetail sendToken(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        if (transactionDetail.getContractAmount() <= 0.0) {
            throw new IllegalArgumentException("token amount parameter has to be positive");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, issuerUsername);
        if (!this.isApprovedAccount(receiverAddress)) {
            String receiver = transactionDetail.getToWallet() == null || StringUtils.isBlank((CharSequence)transactionDetail.getToWallet().getName()) ? receiverAddress : transactionDetail.getToWallet().getName();
            throw new IllegalStateException("Wallet receiver " + receiver + " is not approved yet, thus no transfer is allowed");
        }
        if (StringUtils.isBlank((CharSequence)this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        BigInteger tokenAmount = transactionDetail.getContractAmountDecimal(this.configuredContractDecimals.intValue());
        Function transferFunction = this.getTransferFunctionCall(receiverAddress, tokenAmount);
        this.generateRawTransaction(this.configuredContractAddress, transferFunction, BigInteger.ZERO, transactionDetail);
        transactionDetail.setNetworkId(this.networkId);
        transactionDetail.setFrom(this.getAdminWalletAddress());
        transactionDetail.setContractAddress(this.configuredContractAddress);
        transactionDetail.setContractMethodName("transfer");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        this.getTransactionService().saveTransactionDetail(transactionDetail, false);
        return transactionDetail;
    }

    public final TransactionDetail reward(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException("receiver address parameter is mandatory");
        }
        if (transactionDetail.getContractAmount() < 0.0) {
            throw new IllegalArgumentException("reward amount parameter has to be a positive");
        }
        if (transactionDetail.getValue() <= 0.0) {
            throw new IllegalArgumentException("token amount parameter has to be a positive");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, issuerUsername);
        if (!this.isApprovedAccount(receiverAddress)) {
            String receiver = transactionDetail.getToWallet() == null || StringUtils.isBlank((CharSequence)transactionDetail.getToWallet().getName()) ? receiverAddress : transactionDetail.getToWallet().getName();
            throw new IllegalStateException("Wallet receiver " + receiver + " is not approved yet, thus no transfer is allowed");
        }
        BigInteger tokenAmount = transactionDetail.getValueDecimal(this.configuredContractDecimals.intValue());
        BigInteger rewardAmount = transactionDetail.getContractAmountDecimal(this.configuredContractDecimals.intValue());
        if (StringUtils.isBlank((CharSequence)this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        Function rewardFunction = this.getRewardFunctionCall(receiverAddress, tokenAmount, rewardAmount);
        this.generateRawTransaction(this.configuredContractAddress, rewardFunction, BigInteger.ZERO, transactionDetail);
        transactionDetail.setNetworkId(this.networkId);
        transactionDetail.setFrom(this.getAdminWalletAddress());
        transactionDetail.setContractAddress(this.configuredContractAddress);
        transactionDetail.setContractMethodName("reward");
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        this.getTransactionService().saveTransactionDetail(transactionDetail, false);
        return transactionDetail;
    }

    public void retrieveWalletInformationFromBlockchain(org.exoplatform.wallet.model.Wallet wallet, ContractDetail contractDetail, Set<String> walletModifications) throws Exception {
        if (wallet == null) {
            throw new IllegalArgumentException("wallet is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)wallet.getAddress())) {
            LOG.debug("No wallet address: {}", new Object[]{wallet});
            return;
        }
        if (contractDetail == null || StringUtils.isBlank((CharSequence)contractDetail.getAddress()) || contractDetail.getDecimals() == null) {
            throw new IllegalArgumentException("contractDetail is mandatory");
        }
        String walletAddress = wallet.getAddress();
        BigInteger walletEtherBalance = this.getEtherBalanceOf(walletAddress);
        wallet.setEtherBalance(Double.valueOf(WalletUtils.convertFromDecimals((BigInteger)walletEtherBalance, (int)18)));
        if (wallet.getTokenBalance() == null || walletModifications == null || walletModifications.contains("reward") || walletModifications.contains("initializeAccount") || walletModifications.contains("transformToVested") || walletModifications.contains("transfer") || walletModifications.contains("transferFrom") || walletModifications.contains("approve")) {
            BigInteger walletTokenBalance = (BigInteger)this.executeReadOperation(this.configuredContractAddress, "balanceOf", new Object[]{walletAddress});
            wallet.setTokenBalance(Double.valueOf(WalletUtils.convertFromDecimals((BigInteger)walletTokenBalance, (int)this.configuredContractDecimals)));
        }
        if (wallet.getRewardBalance() == null || walletModifications == null || walletModifications.contains("reward")) {
            BigInteger walletRewardBalance = (BigInteger)this.executeReadOperation(this.configuredContractAddress, "rewardBalanceOf", new Object[]{walletAddress});
            wallet.setRewardBalance(Double.valueOf(WalletUtils.convertFromDecimals((BigInteger)walletRewardBalance, (int)this.configuredContractDecimals)));
        }
        if (wallet.getVestingBalance() == null || walletModifications == null || walletModifications.contains("transformToVested")) {
            BigInteger walletVestingBalance = (BigInteger)this.executeReadOperation(this.configuredContractAddress, "vestingBalanceOf", new Object[]{walletAddress});
            wallet.setVestingBalance(Double.valueOf(WalletUtils.convertFromDecimals((BigInteger)walletVestingBalance, (int)this.configuredContractDecimals)));
        }
        if (wallet.getAdminLevel() == null || walletModifications == null || walletModifications.contains("transferOwnership") || walletModifications.contains("removeAdmin") || walletModifications.contains("addAdmin")) {
            BigInteger walletAdminLevel = (BigInteger)this.executeReadOperation(this.configuredContractAddress, "getAdminLevel", new Object[]{walletAddress});
            wallet.setAdminLevel(Integer.valueOf(walletAdminLevel.intValue()));
        }
        if (wallet.getIsApproved() == null || walletModifications == null || walletModifications.contains("initializeAccount") || walletModifications.contains("addAdmin") || walletModifications.contains("removeAdmin") || walletModifications.contains("approveAccount") || walletModifications.contains("disapproveAccount") || walletModifications.contains("transferOwnership")) {
            Boolean approved = (Boolean)this.executeReadOperation(this.configuredContractAddress, "isApprovedAccount", new Object[]{walletAddress});
            wallet.setIsApproved(approved);
        }
        if (wallet.getIsApproved() != null && wallet.getIsApproved().booleanValue()) {
            wallet.setIsInitialized(Boolean.valueOf(true));
        } else if (wallet.getIsInitialized() == null || walletModifications == null || walletModifications.contains("initializeAccount")) {
            Boolean initialized = (Boolean)this.executeReadOperation(this.configuredContractAddress, "isInitializedAccount", new Object[]{walletAddress});
            wallet.setIsInitialized(initialized);
        }
    }

    public void refreshContractDetailFromBlockchain(ContractDetail contractDetail, Set<String> contractModifications) {
        if (contractDetail == null) {
            throw new IllegalArgumentException("contractDetail is mandatory");
        }
        String contractAddress = contractDetail.getAddress();
        try {
            if (contractDetail.getNetworkId() == null || contractDetail.getNetworkId() <= 0L) {
                contractDetail.setNetworkId(Long.valueOf(this.networkId));
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getContractType()) || StringUtils.equals((CharSequence)contractDetail.getContractType(), (CharSequence)"0") || contractModifications == null || contractModifications.contains("upgradeImplementation") || contractModifications.contains("upgradeData") || contractModifications.contains("upgradeDataAndImplementation")) {
                BigInteger implementationVersion = (BigInteger)this.executeReadOperation(contractAddress, "version", new Object[0]);
                if (implementationVersion == null || implementationVersion.intValue() < 1) {
                    return;
                }
                contractDetail.setContractType(implementationVersion.toString());
            }
            if (contractDetail.getDecimals() == null || contractDetail.getDecimals() <= 0) {
                BigInteger decimals = (BigInteger)this.executeReadOperation(contractAddress, "decimals", new Object[0]);
                contractDetail.setDecimals(Integer.valueOf(decimals.intValue()));
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getName()) || contractModifications == null || contractModifications.contains("setName")) {
                String name = (String)this.executeReadOperation(contractAddress, "name", new Object[0]);
                contractDetail.setName(name);
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getSymbol()) || contractModifications == null || contractModifications.contains("setSymbol")) {
                String symbol = (String)this.executeReadOperation(contractAddress, "symbol", new Object[0]);
                contractDetail.setSymbol(symbol);
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getOwner()) || contractModifications == null || contractModifications.contains("transferOwnership")) {
                String owner = (String)this.executeReadOperation(contractAddress, "owner", new Object[0]);
                contractDetail.setOwner(owner);
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getSellPrice()) || contractModifications == null || contractModifications.contains("setSellPrice")) {
                BigInteger sellPrice = (BigInteger)this.executeReadOperation(contractAddress, "getSellPrice", new Object[0]);
                contractDetail.setSellPrice(String.valueOf(WalletUtils.convertFromDecimals((BigInteger)sellPrice, (int)18)));
            }
            if (StringUtils.isEmpty((CharSequence)contractDetail.getTotalSupply())) {
                BigInteger totalSupply = (BigInteger)this.executeReadOperation(contractAddress, "totalSupply", new Object[0]);
                contractDetail.setTotalSupply(String.valueOf(WalletUtils.convertFromDecimals((BigInteger)totalSupply, (int)contractDetail.getDecimals())));
            }
            if (contractDetail.getIsPaused() == null || contractModifications == null || contractModifications.contains("pause") || contractModifications.contains("unPause")) {
                Boolean isPaused = (Boolean)this.executeReadOperation(contractAddress, "isPaused", new Object[0]);
                contractDetail.setIsPaused(isPaused);
            }
            if (contractDetail.getEtherBalance() == null || contractModifications == null || contractModifications.contains("depositFunds") || contractModifications.contains("transfer") || contractModifications.contains("transferFrom") || contractModifications.contains("approve")) {
                BigInteger contractEtherBalance = this.getEtherBalanceOf(contractAddress);
                contractDetail.setEtherBalance(Double.valueOf(WalletUtils.convertFromDecimals((BigInteger)contractEtherBalance, (int)18)));
            }
            this.getContractService().saveContractDetail(contractDetail);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while retrieving contract details from blockchain with address: " + contractAddress, e);
        }
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_call")
    public Object executeReadOperation(String contractAddress, String methodName, Object ... arguments) throws Exception {
        String string = contractAddress;
        String string2 = methodName;
        Object[] objectArray = arguments;
        Object[] objectArray2 = new Object[]{string, string2, objectArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray2);
        Object[] objectArray3 = new Object[]{this, string, string2, objectArray, joinPoint};
        return ExoWalletStatisticAspect.aspectOf().around(new AjcClosure3(objectArray3).linkClosureAndJoinPoint(69648));
    }

    public Map<String, Object> getStatisticParameters(String operation, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.networkId > 0L && StringUtils.isNotBlank((CharSequence)this.websocketURL)) {
            if (this.websocketURLSuffix == null) {
                String[] urlParts = this.websocketURL.split("/");
                this.websocketURLSuffix = urlParts[urlParts.length - 1];
            }
            parameters.put("blockchain_network_url_suffix", this.websocketURLSuffix);
            parameters.put("blockchain_network_id", this.networkId);
        }
        switch (operation) {
            case "eth_getBalance": {
                parameters.put("address", methodArgs[0]);
                break;
            }
            case "eth_call": {
                parameters.put("contract_address", methodArgs[0]);
                parameters.put("contract_method", methodArgs[1]);
                break;
            }
            default: {
                LOG.warn("Statistic type {} is not managed", new Object[]{operation});
                return null;
            }
        }
        return parameters;
    }

    public String generateHash(String rawTransaction) {
        return Hash.sha3((String)rawTransaction);
    }

    private void generateRawTransaction(String toAddress, Function function, BigInteger etherValueInWei, TransactionDetail transactionDetail) throws Exception {
        Credentials adminCredentials = this.getAdminCredentials();
        if (adminCredentials == null) {
            throw new IllegalStateException("Can't find admin credentials");
        }
        Long adminGasPrice = WalletUtils.getAdminGasPrice();
        BigInteger gasPrice = BigInteger.valueOf(adminGasPrice);
        transactionDetail.setGasPrice((double)adminGasPrice.longValue());
        BigInteger gasLimit = BigInteger.valueOf(WalletUtils.getGasLimit());
        BigInteger nonceToUse = this.getAdminNonce();
        transactionDetail.setNonce(nonceToUse.longValue());
        RawTransaction rawTransaction = null;
        if (function != null) {
            String transactionData = FunctionEncoder.encode((Function)function);
            rawTransaction = RawTransaction.createTransaction((BigInteger)nonceToUse, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)toAddress, (BigInteger)etherValueInWei, (String)transactionData);
        } else {
            rawTransaction = RawTransaction.createEtherTransaction((BigInteger)nonceToUse, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)toAddress, (BigInteger)etherValueInWei);
        }
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)adminCredentials);
        String rawTransactionString = Numeric.toHexString((byte[])signedMessage);
        transactionDetail.setRawTransaction(rawTransactionString);
        transactionDetail.setHash(this.generateHash(rawTransactionString));
    }

    private BigInteger getAdminNonce() throws IOException {
        String adminAddress = this.getAdminWalletAddress();
        long blockchainNonce = this.getClientConnector().getNonce(adminAddress, DefaultBlockParameterName.PENDING).longValue();
        long storedNonce = this.getTransactionService().getNonce(adminAddress);
        return BigInteger.valueOf(Long.max(blockchainNonce, storedNonce));
    }

    private ERTTokenV2 getContractInstance(String contractAddress) {
        if (this.ertInstance == null) {
            BigInteger gasPrice = BigInteger.valueOf(WalletUtils.getAdminGasPrice());
            BigInteger gasLimit = BigInteger.valueOf(WalletUtils.getGasLimit());
            Web3j web3j = this.getClientConnector().getWeb3j();
            this.ertInstance = ERTTokenV2.load((String)contractAddress, (Web3j)web3j, (TransactionManager)new ReadonlyTransactionManager(web3j, Address.DEFAULT.toString()), (ContractGasProvider)new StaticGasProvider(gasPrice, gasLimit));
        }
        return this.ertInstance;
    }

    private String checkContractAddress() {
        if (StringUtils.isBlank((CharSequence)this.configuredContractAddress)) {
            throw new IllegalStateException("No configured contract address");
        }
        return this.configuredContractAddress;
    }

    private void setIssuer(TransactionDetail transactionDetail, String issuerUsername) {
        if (StringUtils.isNotBlank((CharSequence)issuerUsername)) {
            org.exoplatform.wallet.model.Wallet issuerWallet = this.getAccountService().getWalletByTypeAndId(WalletType.USER.name(), issuerUsername);
            if (issuerWallet == null) {
                throw new IllegalStateException("Can't find identity of user with id " + issuerUsername);
            }
            transactionDetail.setIssuer(issuerWallet);
        }
    }

    private final void checkAdminWalletIsValid() throws Exception {
        String adminAddress = this.getAdminWalletAddress();
        if (adminAddress == null) {
            throw new IllegalStateException("No admin wallet is set");
        }
        int adminLevel = this.getAdminLevel(adminAddress);
        if (adminLevel < 2) {
            throw new IllegalStateException("Admin wallet haven't enough privileges to manage wallets");
        }
    }

    private Credentials getAdminCredentials() {
        ECKeyPair adminWalletKeys = (ECKeyPair)this.getAdminWalletKeys();
        if (adminWalletKeys == null) {
            return null;
        }
        return Credentials.create((ECKeyPair)adminWalletKeys);
    }

    private Object getAdminWalletKeys() {
        String privateKey = this.getAccountService().getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin");
        if (StringUtils.isBlank((CharSequence)privateKey)) {
            return null;
        }
        WalletFile adminWallet = null;
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
            adminWallet = (WalletFile)objectMapper.readerFor(WalletFile.class).readValue(privateKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while parsing admin wallet keys", e);
        }
        try {
            return Wallet.decrypt((String)this.accountService.getAdminAccountPassword(), (WalletFile)adminWallet);
        }
        catch (CipherException e) {
            throw new IllegalStateException("Can't descrypt stored admin wallet", e);
        }
    }

    private Method getMethod(String methodName) {
        Method[] methods;
        Method methodToInvoke = null;
        for (Method method : methods = ERTTokenV2.class.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)methodName, (CharSequence)method.getName())) continue;
            methodToInvoke = method;
        }
        return methodToInvoke;
    }

    private ContractDetail getPrincipalContractDetail() {
        GlobalSettings settings = WalletUtils.getSettings();
        return settings.getContractDetail();
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private WalletStorage getAccountStorage() {
        if (this.accountStorage == null) {
            this.accountStorage = (WalletStorage)CommonsUtils.getService(WalletStorage.class);
        }
        return this.accountStorage;
    }

    private WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    private WalletContractService getContractService() {
        if (this.walletContractService == null) {
            this.walletContractService = (WalletContractService)CommonsUtils.getService(WalletContractService.class);
        }
        return this.walletContractService;
    }

    private WalletService getWalletService() {
        if (this.walletService == null) {
            this.walletService = (WalletService)CommonsUtils.getService(WalletService.class);
        }
        return this.walletService;
    }

    private EthereumClientConnector getClientConnector() {
        return this.clientConnector;
    }

    private UserACL getUserACL() {
        if (this.userACL == null) {
            this.userACL = (UserACL)CommonsUtils.getService(UserACL.class);
        }
        return this.userACL;
    }

    private Function getInitializeAccountFunctionCall(String toAddress, BigInteger tokenAmount) {
        return new Function("initializeAccount", Arrays.asList(new Address(toAddress), new Uint256(tokenAmount)), Collections.emptyList());
    }

    private Function getTransferFunctionCall(String toAddress, BigInteger tokenAmount) {
        return new Function("transfer", Arrays.asList(new Address(toAddress), new Uint256(tokenAmount)), Collections.emptyList());
    }

    private Function getRewardFunctionCall(String toAddress, BigInteger tokenAmount, BigInteger rewardAmount) {
        return new Function("reward", Arrays.asList(new Address(toAddress), new Uint256(tokenAmount), new Uint256(rewardAmount)), Collections.emptyList());
    }

    static {
        EthereumWalletTokenAdminService.ajc$preClinit();
        LOG = ExoLogger.getLogger(EthereumWalletTokenAdminService.class);
    }

    static /* synthetic */ BigInteger getEtherBalanceOf_aroundBody0(EthereumWalletTokenAdminService ajc$this, String address, JoinPoint joinPoint) {
        Web3j web3j = ajc$this.getClientConnector().getWeb3j();
        if (web3j == null) {
            throw new IllegalStateException("Can't get ether balance of " + address + " . Connection is not established.");
        }
        return ((EthGetBalance)web3j.ethGetBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
    }

    static /* synthetic */ Object executeReadOperation_aroundBody2(EthereumWalletTokenAdminService ajc$this, String contractAddress, String methodName, Object[] arguments, JoinPoint joinPoint) {
        ERTTokenV2 contractInstance = ajc$this.getContractInstance(contractAddress);
        Method methodToInvoke = ajc$this.getMethod(methodName);
        if (methodToInvoke == null) {
            throw new IllegalStateException("Can't find method " + methodName + " in Token instance");
        }
        RemoteCall response = (RemoteCall)methodToInvoke.invoke((Object)contractInstance, arguments);
        return response.send();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EthereumWalletTokenAdminService.java", EthereumWalletTokenAdminService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getEtherBalanceOf", "org.exoplatform.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String", "address", "java.lang.Exception", "java.math.BigInteger"), 270);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "executeReadOperation", "org.exoplatform.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String:java.lang.String:[Ljava.lang.Object;", "contractAddress:methodName:arguments", "java.lang.Exception", "java.lang.Object"), 649);
    }
}

