/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.listener;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.BlockchainTransactionService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.statistic.ExoWalletStatistic;
import org.exoplatform.wallet.statistic.ExoWalletStatisticService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.web3j.protocol.core.methods.response.EthBlock;

@Asynchronous
public class BlockMinedListener
extends Listener<EthBlock.Block, Boolean>
implements ExoWalletStatisticService {
    private static final Log LOG = ExoLogger.getLogger(BlockMinedListener.class);
    private ExoContainer container;
    private WalletTransactionService transactionService;
    private BlockchainTransactionService blockchainTransactionService;

    public BlockMinedListener(ExoContainer container, WalletTransactionService transactionService, BlockchainTransactionService blockchainTransactionService) {
        this.container = container;
        this.transactionService = transactionService;
        this.blockchainTransactionService = blockchainTransactionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExoWalletStatistic(local=false, service="blockchain", operation="eth_getBlockByXXX")
    public void onEvent(Event<EthBlock.Block, Boolean> event) throws Exception {
        EthBlock.Block block = (EthBlock.Block)event.getSource();
        long blockNumber = block.getNumber().longValue();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            List pendingTransactions = this.transactionService.getPendingTransactions();
            if (pendingTransactions.isEmpty()) {
                LOG.debug("No pending transaction to check for block '{}'", new Object[]{blockNumber});
            } else {
                LOG.debug("Checking on blockchain the status of {} transactions marked as pending in database in block {}", new Object[]{pendingTransactions.size(), blockNumber});
                List transactions = block.getTransactions();
                Set minedTransactionHashes = transactions.stream().map(tx -> tx.get().toString().toLowerCase()).collect(Collectors.toSet());
                Set pendingTransactionHashes = pendingTransactions.stream().map(TransactionDetail::getHash).collect(Collectors.toSet());
                minedTransactionHashes.retainAll(pendingTransactionHashes);
                if (!minedTransactionHashes.isEmpty()) {
                    for (String hash : minedTransactionHashes) {
                        try {
                            this.blockchainTransactionService.checkTransactionStatusOnBlockchain(hash, true);
                        }
                        catch (Exception e) {
                            LOG.warn("Error checking mined transaction on blockchain: {}", new Object[]{hash, e});
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error while checking pending transactions on mined block '{}'", new Object[]{blockNumber, e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public Map<String, Object> getStatisticParameters(String operation, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Event event = (Event)methodArgs[0];
        EthBlock.Block block = (EthBlock.Block)event.getSource();
        boolean newBlock = (Boolean)event.getData();
        if (newBlock) {
            parameters.put("operation", "eth_getBlockByHash");
        } else {
            parameters.put("operation", "eth_getBlockByNumber");
        }
        parameters.put("blockchain_network_id", WalletUtils.getNetworkId());
        parameters.put("blockchain_network_url_suffix", WalletUtils.getBlockchainURLSuffix());
        parameters.put("block_hash", block.getHash());
        parameters.put("block_number", block.getNumber().longValue());
        return parameters;
    }
}

