/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing;

import com.ibm.icu.util.Calendar;
import java.io.Serializable;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webconferencing.CallConflictException;
import org.exoplatform.webconferencing.CallInfo;
import org.exoplatform.webconferencing.CallInfoException;
import org.exoplatform.webconferencing.CallProvider;
import org.exoplatform.webconferencing.CallProviderConfiguration;
import org.exoplatform.webconferencing.CallProviderException;
import org.exoplatform.webconferencing.CallState;
import org.exoplatform.webconferencing.GroupInfo;
import org.exoplatform.webconferencing.IdentityInfo;
import org.exoplatform.webconferencing.IdentityNotFound;
import org.exoplatform.webconferencing.InvalidCallStateException;
import org.exoplatform.webconferencing.ParticipantInfo;
import org.exoplatform.webconferencing.UserCallListener;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure1;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure11;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure13;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure3;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure5;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure7;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure9;
import org.exoplatform.webconferencing.WrongIdException;
import org.exoplatform.webconferencing.dao.CallDAO;
import org.exoplatform.webconferencing.dao.ParticipantDAO;
import org.exoplatform.webconferencing.domain.CallEntity;
import org.exoplatform.webconferencing.domain.ParticipantEntity;
import org.exoplatform.webconferencing.domain.ParticipantId;
import org.json.JSONException;
import org.json.JSONObject;
import org.picocontainer.Startable;

public class WebConferencingService
implements Startable {
    public static final String SPACE_TYPE_NAME;
    public static final String CHAT_ROOM_TYPE_NAME;
    protected static final String GROUP_CALL_TYPE;
    protected static final String CALL_OWNER_SCOPE_NAME;
    protected static final String CALL_ID_SCOPE_NAME;
    protected static final String USER_CALLS_SCOPE_NAME;
    protected static final String PROVIDER_SCOPE_NAME;
    public static final String OWNER_TYPE_SPACE = "space";
    public static final String OWNER_TYPE_CHATROOM = "chat_room";
    protected static final Log LOG;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final NodeHierarchyCreator hierarchyCreator;
    protected final OrganizationService organization;
    protected final IdentityManager socialIdentityManager;
    protected final ManageDriveService driveService;
    protected final ListenerService listenerService;
    protected final SettingService settingService;
    protected final CallDAO callStorage;
    protected final ParticipantDAO participantsStorage;
    protected final Map<String, CallProvider> providers = new ConcurrentHashMap<String, CallProvider>();
    protected SpaceService spaceService;
    protected final Map<String, Set<UserCallListener>> userListeners = new ConcurrentHashMap<String, Set<UserCallListener>>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public WebConferencingService(RepositoryService jcrService, SessionProviderService sessionProviders, NodeHierarchyCreator hierarchyCreator, OrganizationService organization, IdentityManager socialIdentityManager, ManageDriveService driveService, ListenerService listenerService, SettingService settingService, CallDAO callStorage, ParticipantDAO participantsStorage) {
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.hierarchyCreator = hierarchyCreator;
        this.organization = organization;
        this.socialIdentityManager = socialIdentityManager;
        this.driveService = driveService;
        this.listenerService = listenerService;
        this.settingService = settingService;
        this.callStorage = callStorage;
        this.participantsStorage = participantsStorage;
    }

    public UserInfo getUserInfo(String id) throws Exception {
        User user = this.organization.getUserHandler().findUserByName(id);
        if (user != null) {
            Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", id, true);
            if (userIdentity != null) {
                Profile socialProfile = userIdentity.getProfile();
                List ims = (List)socialProfile.getProperty("ims");
                UserInfo info = new UserInfo(user.getUserName(), user.getFirstName(), user.getLastName());
                if (ims != null) {
                    for (Map m : ims) {
                        CallProvider provider;
                        String imType = (String)m.get("key");
                        String imId = (String)m.get("value");
                        if (imId == null || imId.length() <= 0 || (provider = this.getProvider(imType)) == null || !provider.isActive() || !provider.isSupportedType(imType)) continue;
                        try {
                            UserInfo.IMInfo im = provider.getIMInfo(imId);
                            if (im == null) continue;
                            info.addImAccount(im);
                        }
                        catch (CallProviderException e) {
                            LOG.warn((Object)e.getMessage());
                        }
                    }
                }
                info.setAvatarLink(socialProfile.getAvatarUrl());
                info.setProfileLink(LinkProvider.getUserProfileUri((String)id));
                return info;
            }
            LOG.warn((Object)("Social identity not found for " + user.getUserName() + " (" + user.getFirstName() + " " + user.getLastName() + ")"));
        } else {
            LOG.warn((Object)("User not found: " + id));
        }
        return null;
    }

    public SpaceInfo getSpaceInfo(String spacePrettyName) throws Exception {
        return this.spaceInfo(spacePrettyName, this.readGroupCallId(spacePrettyName));
    }

    protected SpaceInfo spaceInfo(String spacePrettyName, String callId) throws Exception {
        Space socialSpace = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        SpaceInfo space = new SpaceInfo(socialSpace);
        for (String sm : socialSpace.getMembers()) {
            UserInfo user = this.getUserInfo(sm);
            if (user == null) continue;
            space.addMember(user);
        }
        space.setProfileLink(socialSpace.getUrl());
        space.setAvatarLink(socialSpace.getAvatarUrl());
        space.setCallId(callId);
        return space;
    }

    public RoomInfo getRoomInfo(String id, String name, String title, String[] members) throws Exception {
        return this.roomInfo(id, name, title, members, this.readGroupCallId(id));
    }

    protected RoomInfo roomInfo(String id, String name, String title, String[] members, String callId) throws Exception {
        RoomInfo room = new RoomInfo(id, name, title);
        for (String userName : members) {
            UserInfo user = this.getUserInfo(userName);
            if (user == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skipped not found user: " + userName));
                }
                throw new IdentityNotFound("User " + userName + " not found or not accessible");
            }
            room.addMember(user);
        }
        room.setProfileLink(IdentityInfo.EMPTY);
        room.setAvatarLink("/eXoSkin/skin/images/system/SpaceAvtDefault.png");
        room.setCallId(callId);
        return room;
    }

    public CallInfo addCall(String id, String ownerId, String ownerType, String title, String providerType, Collection<String> parts) throws Exception {
        if (IdentityInfo.isValidId(id)) {
            if (IdentityInfo.isValidId(ownerId)) {
                Object avatar;
                IdentityInfo owner;
                CallEntity existingCallEntity;
                String prevId;
                boolean isGroup;
                String currentUserId = this.currentUserId();
                boolean isUser = UserInfo.TYPE_NAME.equals(ownerType);
                boolean isSpace = OWNER_TYPE_SPACE.equals(ownerType);
                boolean isRoom = OWNER_TYPE_CHATROOM.equals(ownerType);
                boolean bl = isGroup = isSpace || isRoom;
                if (isGroup && (prevId = this.readGroupCallId(ownerId)) != null && !prevId.equals(id)) {
                    this.deleteCall(prevId);
                    LOG.warn((Object)("Deleted outdated group call: " + prevId));
                }
                if ((existingCallEntity = (CallEntity)this.callStorage.find((Serializable)((Object)id))) != null) {
                    if (isGroup) {
                        throw new CallConflictException("Call already created");
                    }
                    CallInfo existingCall = this.readCallEntity(existingCallEntity, true);
                    if ("started".equals(existingCall.getState())) {
                        for (UserInfo savedPart : existingCall.getParticipants()) {
                            Set<UserCallListener> ulisteners = this.userListeners.get(savedPart.getId());
                            if (ulisteners == null) continue;
                            for (UserCallListener ul : ulisteners) {
                                if (!savedPart.hasSameClientId(ul.getClientId())) continue;
                                throw new CallConflictException("Call already started");
                            }
                        }
                        this.deleteCall(id);
                        LOG.warn((Object)("Deleted not active call: " + id));
                    } else {
                        this.deleteCall(id);
                        LOG.warn((Object)("Deleted outdated call: " + id));
                    }
                }
                if (isUser) {
                    UserInfo userInfo = this.getUserInfo(ownerId);
                    if (userInfo == null) {
                        owner = new RoomInfo(ownerId, ownerId, title);
                        owner.setAvatarLink("/eXoSkin/skin/images/system/UserAvtDefault.png");
                    } else {
                        owner = userInfo;
                        owner.setProfileLink(userInfo.getProfileLink());
                        avatar = userInfo.getAvatarLink();
                        avatar = avatar != null ? avatar : "/eXoSkin/skin/images/system/UserAvtDefault.png";
                        owner.setAvatarLink((String)avatar);
                    }
                } else if (isSpace) {
                    Space space = this.spaceService.getSpaceByPrettyName(ownerId);
                    if (space != null) {
                        owner = new SpaceInfo(space);
                        owner.setProfileLink(space.getUrl());
                        avatar = space.getAvatarUrl();
                        avatar = avatar != null ? avatar : "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
                        owner.setAvatarLink((String)avatar);
                    } else {
                        LOG.warn((Object)("Cannot find call's owner space: " + ownerId));
                        owner = new RoomInfo(ownerId, ownerId, title);
                        owner.setAvatarLink("/eXoSkin/skin/images/system/SpaceAvtDefault.png");
                    }
                } else if (isRoom) {
                    owner = new RoomInfo(ownerId, ownerId, title);
                    owner.setAvatarLink("/eXoSkin/skin/images/system/SpaceAvtDefault.png");
                } else {
                    throw new CallInfoException("Wrong call owner type: " + ownerType);
                }
                LinkedHashSet<UserInfo> participants = new LinkedHashSet<UserInfo>();
                for (String pid : parts) {
                    if (IdentityInfo.isValidId(pid)) {
                        UserInfo part = this.getUserInfo(pid);
                        if (part != null) {
                            participants.add(part);
                            continue;
                        }
                        participants.add(new ParticipantInfo(providerType, pid));
                        continue;
                    }
                    LOG.error((Object)("Cannot add call participant with too long ID: " + pid));
                    throw new WrongIdException("Wrong participant ID (" + pid + ")");
                }
                CallInfo call = new CallInfo(id, title, owner, providerType);
                call.addParticipants(participants);
                call.setState("started");
                call.setLastDate(Calendar.getInstance().getTime());
                try {
                    this.participantsStorage.clear();
                    this.callStorage.clear();
                    this.createCall(call);
                }
                catch (PersistenceException pe) {
                    SQLIntegrityConstraintViolationException constEx = this.findCause(pe, SQLIntegrityConstraintViolationException.class);
                    if (constEx != null && constEx.getMessage().indexOf("PK_WBC_CALLID") >= 0) {
                        CallEntity conflictedCallEntity = (CallEntity)this.callStorage.find((Serializable)((Object)id));
                        if (conflictedCallEntity != null) {
                            if ("started".equals(call.getState())) {
                                for (UserInfo savedPart : call.getParticipants()) {
                                    Set<UserCallListener> ulisteners = this.userListeners.get(savedPart.getId());
                                    if (ulisteners == null) continue;
                                    for (UserCallListener ul : ulisteners) {
                                        if (!savedPart.hasSameClientId(ul.getClientId())) continue;
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("Call already started and running: " + id), (Throwable)pe);
                                        }
                                        throw new CallConflictException("Call already started and running");
                                    }
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Call already started: " + id), (Throwable)pe);
                                }
                                throw new CallConflictException("Call already started");
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Call already created with state " + conflictedCallEntity.getState() + ": " + id), (Throwable)pe);
                            }
                            throw new CallConflictException("Call already created");
                        }
                        LOG.warn((Object)("Call ID already found but cannot read the call: " + id), (Throwable)pe);
                        throw new CallConflictException("Call ID already found", pe);
                    }
                    LOG.error((Object)("Error creating call: " + id), (Throwable)pe);
                    throw new CallInfoException("Error creating call", pe);
                }
                if (isGroup) {
                    for (UserInfo part : call.getParticipants()) {
                        if (!UserInfo.TYPE_NAME.equals(part.getType()) || currentUserId.equals(part.getId())) continue;
                        this.fireUserCallStateChanged(part.getId(), id, providerType, "started", ownerId, ownerType);
                    }
                } else if (isUser) {
                    this.notifyUserCallStateChanged(call, currentUserId, "started");
                }
                return call;
            }
            throw new WrongIdException("Wrong owner ID value");
        }
        throw new WrongIdException("Wrong call ID value");
    }

    public CallInfo getCall(String id) throws Exception {
        return this.readCallById(id);
    }

    public CallInfo stopCall(String id, boolean remove) throws Exception {
        String userId = this.currentUserId();
        CallInfo call = this.readCallById(id);
        if (call != null) {
            this.stopCall(call, userId, remove);
        }
        return call;
    }

    protected CallInfo stopCall(CallInfo call, String userId, boolean remove) throws Exception {
        if (remove) {
            this.deleteCall(call.getId());
        } else {
            call.setState("stopped");
            this.updateCall(call);
        }
        if (call.getOwner().isGroup()) {
            String callId = call.getId();
            for (UserInfo part : call.getParticipants()) {
                if (!UserInfo.TYPE_NAME.equals(part.getType()) || userId != null && remove && userId.equals(part.getId())) continue;
                this.fireUserCallStateChanged(part.getId(), callId, call.getProviderType(), "stopped", call.getOwner().getId(), call.getOwner().getType());
            }
        } else {
            this.notifyUserCallStateChanged(call, userId, "stopped");
        }
        return call;
    }

    public CallInfo startCall(String id, String clientId) throws Exception {
        CallInfo call = this.readCallById(id);
        if (call != null) {
            this.startCall(call, clientId);
        }
        return call;
    }

    protected void startCall(CallInfo call, String clientId) throws Exception {
        String callId = call.getId();
        call.setState("started");
        String userId = this.currentUserId();
        for (UserInfo part : call.getParticipants()) {
            if (UserInfo.TYPE_NAME.equals(part.getType()) && userId.equals(part.getId())) {
                part.setState("joined");
                part.setClientId(clientId);
                continue;
            }
            part.setState("leaved");
            part.setClientId(null);
        }
        this.updateCallAndParticipants(call);
        for (UserInfo part : call.getParticipants()) {
            this.fireUserCallStateChanged(part.getId(), callId, call.getProviderType(), "started", call.getOwner().getId(), call.getOwner().getType());
        }
    }

    public CallInfo joinCall(String id, String userId, String clientId) throws Exception {
        CallInfo call = this.readCallById(id);
        if (call != null) {
            if ("started".equals(call.getState())) {
                UserInfo joined = null;
                for (UserInfo part : call.getParticipants()) {
                    if (!UserInfo.TYPE_NAME.equals(part.getType()) || !userId.equals(part.getId())) continue;
                    part.setState("joined");
                    part.setClientId(clientId);
                    joined = part;
                    break;
                }
                if (joined != null) {
                    this.updateParticipant(id, joined);
                    for (UserInfo part : call.getParticipants()) {
                        this.fireUserCallJoined(id, call.getProviderType(), call.getOwner().getId(), call.getOwner().getType(), userId, part.getId());
                    }
                }
            } else {
                this.startCall(call, clientId);
            }
        }
        return call;
    }

    public CallInfo leaveCall(String id, String userId, String clientId) throws Exception {
        CallInfo call = this.readCallById(id);
        if (call != null && ("started".equals(call.getState()) || "paused".equals(call.getState()))) {
            UserInfo leaved = null;
            int leavedNum = 0;
            for (UserInfo part : call.getParticipants()) {
                if (!UserInfo.TYPE_NAME.equals(part.getType())) continue;
                if (userId.equals(part.getId())) {
                    if (!part.hasSameClientId(clientId)) continue;
                    part.setState("leaved");
                    part.setClientId(null);
                    leaved = part;
                    ++leavedNum;
                    continue;
                }
                if (part.getState() != null && !part.getState().equals("leaved")) continue;
                ++leavedNum;
            }
            if (leaved != null) {
                this.updateParticipant(id, leaved);
                for (UserInfo part : call.getParticipants()) {
                    this.fireUserCallLeaved(id, call.getProviderType(), call.getOwner().getId(), call.getOwner().getType(), userId, part.getId());
                }
            }
            boolean needStop = false;
            if (call.getOwner().isGroup()) {
                if (leavedNum == call.getParticipants().size()) {
                    needStop = true;
                }
            } else if (call.getParticipants().size() - leavedNum <= 1) {
                needStop = true;
            }
            if (needStop) {
                this.stopCall(call, userId, false);
            }
        }
        return call;
    }

    public CallState[] getUserCalls(String userId) throws Exception {
        CallState[] states = (CallState[])this.readUserGroupCalls(userId).stream().map(c -> new CallState(c.getId(), c.getState() != null ? c.getState() : "stopped")).toArray(CallState[]::new);
        return states;
    }

    public void addUserCallListener(UserCallListener listener) {
        String userId = listener.getUserId();
        this.userListeners.computeIfAbsent(userId, k -> new LinkedHashSet()).add(listener);
    }

    public void removeUserCallListener(UserCallListener listener) {
        String userId = listener.getUserId();
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    protected void fireUserCallStateChanged(String userId, String callId, String providerType, String callState, String ownerId, String ownerType) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                listener.onCallStateChanged(callId, providerType, callState, ownerId, ownerType);
            }
        }
    }

    protected void fireUserCallJoined(String callId, String providerType, String ownerId, String ownerType, String partId, String userId) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                listener.onPartJoined(callId, providerType, ownerId, ownerType, partId);
            }
        }
    }

    protected void fireUserCallLeaved(String callId, String providerType, String ownerId, String ownerType, String partId, String userId) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                listener.onPartLeaved(callId, providerType, ownerId, ownerType, partId);
            }
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        Class<CallProvider> pclass = CallProvider.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            this.addProvider((CallProvider)((Object)pclass.cast(plugin)));
        } else {
            LOG.warn((Object)("Web Conferencing provider plugin is not an instance of " + pclass.getName() + ". Skipped plugin: " + plugin));
        }
    }

    public void addProvider(CallProvider provider) {
        for (String type : provider.getSupportedTypes()) {
            CallProvider existing = this.providers.putIfAbsent(type, provider);
            if (existing == null) continue;
            LOG.warn((Object)("Video Calls provider type '" + existing.getType() + "' already registered. Skipped plugin: " + (Object)((Object)provider)));
        }
    }

    public CallProvider getProvider(String type) {
        CallProvider p = this.providers.get(type);
        if (p != null) {
            try {
                CallProviderConfiguration conf = this.readProviderConfig(p.getType());
                if (conf != null) {
                    p.setActive(conf.isActive());
                } else {
                    p.setActive(true);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Error reading provider configuration " + p.getType()), (Throwable)e);
                p.setActive(true);
            }
        }
        return p;
    }

    public Set<CallProviderConfiguration> getProviderConfigurations(Locale locale) {
        LinkedHashSet<CallProvider> allProviders = new LinkedHashSet<CallProvider>();
        for (CallProvider registeredProvider : this.providers.values()) {
            allProviders.add(registeredProvider);
        }
        LinkedHashSet<CallProviderConfiguration> allConfs = new LinkedHashSet<CallProviderConfiguration>();
        for (CallProvider p : allProviders) {
            boolean addDefault = false;
            try {
                CallProviderConfiguration conf = this.readProviderConfig(p.getType());
                if (conf != null) {
                    conf.setTitle(p.getTitle());
                    conf.setDescription(p.getDescription(locale));
                    conf.setLogEnabled(p.isLogEnabled());
                    allConfs.add(conf);
                } else {
                    addDefault = true;
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Error reading providers configuration " + p.getType()), (Throwable)e);
                addDefault = true;
            }
            if (!addDefault) continue;
            CallProviderConfiguration defaultConf = CallProviderConfiguration.fromProvider(p, locale);
            allConfs.add(defaultConf);
        }
        return allConfs;
    }

    public Set<CallProviderConfiguration> getProviderConfigurations() {
        return this.getProviderConfigurations(Locale.getDefault());
    }

    public CallProviderConfiguration getProviderConfiguration(String providerType, Locale locale) throws Exception {
        CallProvider p = this.getProvider(providerType);
        if (p != null) {
            CallProviderConfiguration conf = this.readProviderConfig(p.getType());
            if (conf == null) {
                conf = CallProviderConfiguration.fromProvider(p, locale);
            } else {
                conf.setTitle(p.getTitle());
                conf.setDescription(p.getDescription(locale));
                conf.setLogEnabled(p.isLogEnabled());
            }
            return conf;
        }
        return null;
    }

    public void saveProviderConfiguration(CallProviderConfiguration config) throws Exception {
        this.saveProviderConfig(config);
    }

    public void start() {
        this.spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        LOG.info((Object)"Web Conferencing service started.");
        try {
            int cleaned = this.deleteAllUserCalls();
            if (cleaned > 0) {
                LOG.info((Object)("Cleaned " + cleaned + " expired user calls."));
            }
        }
        catch (Throwable e) {
            LOG.error((Object)"Error cleaning calls from previous server execution", e);
        }
    }

    public void stop() {
    }

    protected boolean isSpaceMember(String userName, String spacePrettyName) {
        return this.getSpaceMembers(spacePrettyName).contains(userName);
    }

    protected Set<String> getSpaceMembers(String spacePrettyName) {
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        HashSet<String> spaceMembers = new HashSet<String>();
        for (String sm : space.getMembers()) {
            spaceMembers.add(sm);
        }
        return spaceMembers;
    }

    protected JSONObject readJson(String str) throws JSONException, CallInfoException {
        if (str.startsWith("{")) {
            return new JSONObject(str);
        }
        throw new CallInfoException("String not in JSON format: " + str);
    }

    protected CallInfo readCallById(String id) throws Exception {
        CallEntity savedCall = (CallEntity)this.callStorage.find((Serializable)((Object)id));
        return this.readCallEntity(savedCall, true);
    }

    protected String readGroupCallId(String ownerId) {
        CallEntity savedCall = this.callStorage.findGroupCallByOwnerId(ownerId);
        if (savedCall != null) {
            return savedCall.getId();
        }
        return null;
    }

    protected Collection<CallInfo> readUserGroupCalls(String userId) throws Exception {
        List<CallEntity> savedCalls = this.callStorage.findUserGroupCalls(userId);
        ArrayList<CallInfo> calls = new ArrayList<CallInfo>();
        for (CallEntity c : savedCalls) {
            calls.add(this.readCallEntity(c, false));
        }
        return Collections.unmodifiableCollection(calls);
    }

    protected CallProviderConfiguration jsonToProviderConfig(JSONObject json) throws Exception {
        String type = json.getString("type");
        boolean active = json.getBoolean("active");
        CallProviderConfiguration conf = new CallProviderConfiguration();
        conf.setActive(active);
        conf.setType(type);
        return conf;
    }

    protected JSONObject providerConfigToJson(CallProviderConfiguration conf) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("type", (Object)conf.getType());
        json.put("active", conf.isActive());
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CallProviderConfiguration readProviderConfig(String type) throws Exception {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            String safeType = URLEncoder.encode(type, "UTF-8");
            SettingValue val = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(PROVIDER_SCOPE_NAME), safeType);
            if (val != null) {
                String str = String.valueOf(val.getValue());
                if (str.startsWith("{")) {
                    CallProviderConfiguration conf;
                    CallProviderConfiguration callProviderConfiguration = conf = this.jsonToProviderConfig(new JSONObject(str));
                    return callProviderConfiguration;
                }
                LOG.warn((Object)("Cannot parse saved CallProviderConfiguration: " + str));
            }
            CallProviderConfiguration callProviderConfiguration = null;
            return callProviderConfiguration;
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveProviderConfig(CallProviderConfiguration conf) throws Exception {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            JSONObject json = this.providerConfigToJson(conf);
            String safeType = URLEncoder.encode(conf.getType(), "UTF-8");
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(PROVIDER_SCOPE_NAME), safeType, SettingValue.create((String)json.toString()));
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    protected String currentUserId() {
        ConversationState contextState = ConversationState.getCurrent();
        if (contextState != null) {
            return contextState.getIdentity().getUserId();
        }
        return null;
    }

    protected void notifyUserCallStateChanged(CallInfo call, String initiatorId, String state) {
        for (UserInfo part : call.getParticipants()) {
            if (!UserInfo.TYPE_NAME.equals(part.getType()) || initiatorId != null && initiatorId.equals(part.getId()) && !"stopped".equals(state)) continue;
            this.fireUserCallStateChanged(part.getId(), call.getId(), call.getProviderType(), state, call.getOwner().getId(), call.getOwner().getType());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected CallInfo readCallEntity(CallEntity savedCall, boolean withParticipants) throws Exception {
        void var3_11;
        block10: {
            if (savedCall == null) {
                return null;
            }
            String ownerId = savedCall.getOwnerId();
            if (OWNER_TYPE_CHATROOM.equals(savedCall.getOwnerType())) {
                String settings = savedCall.getSettings();
                JSONObject json = this.readJson(settings);
                String roomName = json.optString("roomName");
                String roomTitle = json.optString("roomTitle");
                if (roomName != null && roomName.length() > 0 && roomTitle != null && roomTitle.length() > 0) {
                    RoomInfo roomInfo = this.roomInfo(ownerId, roomName, roomTitle, new String[0], savedCall.getId());
                    break block10;
                } else {
                    LOG.error((Object)("Saved call doesn't contain room settings: '" + settings + "'"));
                    throw new CallInfoException("Saved call doesn't contain room settings");
                }
            }
            if (OWNER_TYPE_SPACE.equals(savedCall.getOwnerType())) {
                SpaceInfo spaceInfo = this.spaceInfo(ownerId, savedCall.getId());
            } else {
                if (!UserInfo.TYPE_NAME.equals(savedCall.getOwnerType())) {
                    LOG.error((Object)("Unexpected call owner, type: " + savedCall.getOwnerType() + ", id: " + ownerId));
                    throw new CallInfoException("Unexpected call owner: " + ownerId);
                }
                UserInfo userInfo = this.getUserInfo(ownerId);
            }
        }
        String callId = savedCall.getId();
        CallInfo call = new CallInfo(callId, savedCall.getTitle(), (IdentityInfo)var3_11, savedCall.getProviderType());
        call.setState(savedCall.getState());
        call.setLastDate(savedCall.getLastDate());
        if (withParticipants) {
            for (ParticipantEntity p : this.participantsStorage.findCallParts(callId)) {
                UserInfo user = this.readParticipantEntity(p);
                if (user != null) {
                    call.addParticipant(user);
                    continue;
                }
                LOG.warn((Object)("Non user participant skipped for call " + callId + ": " + p.getId() + " (" + p.getType() + ")"));
            }
        }
        return call;
    }

    protected UserInfo readParticipantEntity(ParticipantEntity savedPart) throws Exception {
        if (UserInfo.TYPE_NAME.equals(savedPart.getType())) {
            UserInfo user = this.getUserInfo(savedPart.getId());
            user.setState(savedPart.getState());
            return user;
        }
        return null;
    }

    protected CallEntity createCallEntity(CallInfo call) throws Exception {
        CallEntity entity = new CallEntity();
        this.updateCallEntity(call, entity);
        return entity;
    }

    protected void updateCallEntity(CallInfo call, CallEntity entity) throws Exception {
        if (call != null) {
            String callId = call.getId();
            entity.setId(callId);
            entity.setProviderType(call.getProviderType());
            entity.setTitle(call.getTitle());
            IdentityInfo owner = call.getOwner();
            entity.setOwnerId(owner.getId());
            entity.setOwnerType(owner.getType());
            entity.setState(call.getState());
            entity.setLastDate(call.getLastDate());
            if (OWNER_TYPE_CHATROOM.equals(owner.getType())) {
                RoomInfo room = (RoomInfo)RoomInfo.class.cast(owner);
                JSONObject json = new JSONObject();
                json.put("roomName", (Object)room.getName());
                json.put("roomTitle", (Object)room.getTitle());
                entity.setSettings(json.toString());
                entity.setIsGroup(true);
                entity.setIsUser(false);
            } else if (OWNER_TYPE_SPACE.equals(owner.getType())) {
                entity.setIsGroup(true);
                entity.setIsUser(false);
            } else {
                entity.setIsGroup(false);
                entity.setIsUser(true);
            }
        } else {
            throw new NullPointerException("Call info is null");
        }
    }

    protected ParticipantEntity createParticipantEntity(String callId, UserInfo user) {
        ParticipantEntity part = new ParticipantEntity();
        part.setId(user.getId());
        part.setCallId(callId);
        part.setType(user.getType());
        part.setState(user.getState());
        part.setClientId(user.getClientId());
        return part;
    }

    protected <C extends SQLException> C findCause(PersistenceException pe, Class<C> causeClass) {
        Throwable c;
        PersistenceException e = pe;
        do {
            if (e == null || !causeClass.isAssignableFrom(((Object)((Object)e)).getClass())) continue;
            return (C)((SQLException)causeClass.cast((Object)e));
        } while ((e = (c = e.getCause()) != null && c != e ? c : null) != null);
        return null;
    }

    @ExoTransactional
    protected void createCall(CallInfo call) throws Exception {
        CallInfo callInfo = call;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)callInfo);
        Object[] objectArray = new Object[]{this, callInfo, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void saveCall(CallInfo call) throws Exception {
        CallEntity entity = (CallEntity)this.callStorage.find((Serializable)((Object)call.getId()));
        if (entity == null) {
            LOG.error((Object)("Call not found: " + call.getId()));
            throw new InvalidCallStateException("Call not found");
        }
        this.updateCallEntity(call, entity);
        this.callStorage.update(entity);
    }

    @ExoTransactional
    protected void updateCall(CallInfo call) throws Exception {
        CallInfo callInfo = call;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)callInfo);
        Object[] objectArray = new Object[]{this, callInfo, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void saveParticipant(String callId, UserInfo participant) throws Exception {
        ParticipantEntity part = (ParticipantEntity)this.participantsStorage.find(new ParticipantId(participant.getId(), callId));
        if (part == null) {
            throw new CallInfoException("Call participant has no saved entity " + participant.getId() + " for " + callId);
        }
        part.setState(participant.getState());
        part.setClientId(participant.getClientId());
        this.participantsStorage.update(part);
    }

    @ExoTransactional
    protected void updateParticipant(String callId, UserInfo participant) throws Exception {
        String string = callId;
        UserInfo userInfo = participant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)userInfo);
        Object[] objectArray = new Object[]{this, string, userInfo, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected void updateCallAndParticipant(CallInfo call, UserInfo participant) throws Exception {
        CallInfo callInfo = call;
        UserInfo userInfo = participant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)callInfo, (Object)userInfo);
        Object[] objectArray = new Object[]{this, callInfo, userInfo, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected void updateCallAndParticipants(CallInfo call) throws Exception {
        CallInfo callInfo = call;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)callInfo);
        Object[] objectArray = new Object[]{this, callInfo, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected boolean deleteCall(String callId) throws Exception {
        String string = callId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.booleanValue((Object)ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    protected int deleteAllUserCalls() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(new WebConferencingService$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648)));
    }

    static {
        WebConferencingService.ajc$preClinit();
        SPACE_TYPE_NAME = OWNER_TYPE_SPACE.intern();
        CHAT_ROOM_TYPE_NAME = OWNER_TYPE_CHATROOM.intern();
        GROUP_CALL_TYPE = "group".intern();
        CALL_OWNER_SCOPE_NAME = "webconferencing.callOwner".intern();
        CALL_ID_SCOPE_NAME = "webconferencing.callId".intern();
        USER_CALLS_SCOPE_NAME = "webconferencing.user.calls".intern();
        PROVIDER_SCOPE_NAME = "webconferencing.provider".intern();
        LOG = ExoLogger.getLogger(WebConferencingService.class);
    }

    static /* synthetic */ void createCall_aroundBody0(WebConferencingService ajc$this, CallInfo call, JoinPoint joinPoint) {
        ajc$this.callStorage.create(ajc$this.createCallEntity(call));
        String callId = call.getId();
        for (UserInfo p : call.getParticipants()) {
            ajc$this.participantsStorage.create(ajc$this.createParticipantEntity(callId, p));
        }
    }

    static /* synthetic */ void updateCall_aroundBody2(WebConferencingService ajc$this, CallInfo call, JoinPoint joinPoint) {
        ajc$this.saveCall(call);
    }

    static /* synthetic */ void updateParticipant_aroundBody4(WebConferencingService ajc$this, String callId, UserInfo participant, JoinPoint joinPoint) {
        ajc$this.saveParticipant(callId, participant);
    }

    static /* synthetic */ void updateCallAndParticipant_aroundBody6(WebConferencingService ajc$this, CallInfo call, UserInfo participant, JoinPoint joinPoint) {
        ajc$this.saveCall(call);
        ajc$this.saveParticipant(call.getId(), participant);
    }

    static /* synthetic */ void updateCallAndParticipants_aroundBody8(WebConferencingService ajc$this, CallInfo call, JoinPoint joinPoint) {
        ajc$this.saveCall(call);
        String callId = call.getId();
        for (UserInfo p : call.getParticipants()) {
            ajc$this.saveParticipant(callId, p);
        }
    }

    static /* synthetic */ boolean deleteCall_aroundBody10(WebConferencingService ajc$this, String callId, JoinPoint joinPoint) {
        CallEntity entity = (CallEntity)ajc$this.callStorage.find((Serializable)((Object)callId));
        if (entity != null) {
            ajc$this.callStorage.delete(entity);
            return true;
        }
        return false;
    }

    static /* synthetic */ int deleteAllUserCalls_aroundBody12(WebConferencingService ajc$this, JoinPoint joinPoint) {
        return ajc$this.callStorage.deleteAllUsersCalls();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebConferencingService.java", WebConferencingService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createCall", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo", "call", "java.lang.Exception", "void"), 1527);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "updateCall", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo", "call", "java.lang.Exception", "void"), 1560);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "updateParticipant", "org.exoplatform.webconferencing.WebConferencingService", "java.lang.String:org.exoplatform.webconferencing.UserInfo", "callId:participant", "java.lang.Exception", "void"), 1592);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "updateCallAndParticipant", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo:org.exoplatform.webconferencing.UserInfo", "call:participant", "java.lang.Exception", "void"), 1605);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "updateCallAndParticipants", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo", "call", "java.lang.Exception", "void"), 1620);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteCall", "org.exoplatform.webconferencing.WebConferencingService", "java.lang.String", "callId", "java.lang.Exception", "boolean"), 1641);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteAllUserCalls", "org.exoplatform.webconferencing.WebConferencingService", "", "", "java.lang.Exception", "int"), 1659);
    }

    public class RoomInfo
    extends GroupInfo {
        protected final String name;

        public RoomInfo(String id, String name, String title) {
            super(id, title);
            this.name = name;
            this.profileLink = IdentityInfo.EMPTY;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return CHAT_ROOM_TYPE_NAME;
        }
    }

    public class SpaceInfo
    extends GroupInfo {
        protected final String groupId;

        public SpaceInfo(Space socialSpace) {
            super(socialSpace.getPrettyName(), socialSpace.getDisplayName());
            this.groupId = socialSpace.getGroupId();
        }

        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getType() {
            return SPACE_TYPE_NAME;
        }
    }
}

