/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.dao;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.domain.CallEntity;

public class CallDAO
extends GenericDAOJPAImpl<CallEntity, String> {
    public static final int USER_CALL_DAYS_LIVETIME = 2;

    public CallEntity findGroupCallByOwnerId(String ownerId) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findGroupCallByOwnerId", CallEntity.class).setParameter("ownerId", (Object)ownerId);
        try {
            return (CallEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<CallEntity> findUserGroupCalls(String userId) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findUserGroupCalls", CallEntity.class).setParameter("userId", (Object)userId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public int deleteAllUsersCalls() {
        LocalDateTime expired = LocalDate.now().atStartOfDay().minusDays(2L);
        return this.getEntityManager().createNamedQuery("WebConfCall.deleteOwnerOlderCalls").setParameter("ownerType", (Object)UserInfo.TYPE_NAME).setParameter("expiredDate", (Object)Timestamp.valueOf(expired)).executeUpdate();
    }

    public void clear() {
        this.getEntityManager().clear();
    }
}

