/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.persistence.PersistenceException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.lang.RandomStringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.ecm.utils.permission.PermissionUtil;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;
import org.exoplatform.wcm.ext.component.document.service.ShareDocumentService;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.webconferencing.CallArgumentException;
import org.exoplatform.webconferencing.CallConflictException;
import org.exoplatform.webconferencing.CallInfo;
import org.exoplatform.webconferencing.CallInfoException;
import org.exoplatform.webconferencing.CallNotFoundException;
import org.exoplatform.webconferencing.CallOwnerException;
import org.exoplatform.webconferencing.CallProvider;
import org.exoplatform.webconferencing.CallProviderConfiguration;
import org.exoplatform.webconferencing.CallProviderException;
import org.exoplatform.webconferencing.CallSettingsException;
import org.exoplatform.webconferencing.CallState;
import org.exoplatform.webconferencing.GroupInfo;
import org.exoplatform.webconferencing.GuestInfo;
import org.exoplatform.webconferencing.IdentityData;
import org.exoplatform.webconferencing.IdentityInfo;
import org.exoplatform.webconferencing.IdentityStateException;
import org.exoplatform.webconferencing.InvalidCallException;
import org.exoplatform.webconferencing.InvitedIdentity;
import org.exoplatform.webconferencing.OriginInfo;
import org.exoplatform.webconferencing.ParticipantInfo;
import org.exoplatform.webconferencing.ParticipantNotFoundException;
import org.exoplatform.webconferencing.UploadFileException;
import org.exoplatform.webconferencing.UploadFileInfo;
import org.exoplatform.webconferencing.UserCallListener;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure1;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure11;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure13;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure15;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure17;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure19;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure21;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure23;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure25;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure3;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure5;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure7;
import org.exoplatform.webconferencing.WebConferencingService$AjcClosure9;
import org.exoplatform.webconferencing.dao.CallDAO;
import org.exoplatform.webconferencing.dao.InviteDAO;
import org.exoplatform.webconferencing.dao.OriginDAO;
import org.exoplatform.webconferencing.dao.ParticipantDAO;
import org.exoplatform.webconferencing.dao.StorageException;
import org.exoplatform.webconferencing.domain.CallEntity;
import org.exoplatform.webconferencing.domain.InviteEntity;
import org.exoplatform.webconferencing.domain.OriginEntity;
import org.exoplatform.webconferencing.domain.ParticipantEntity;
import org.exoplatform.webconferencing.domain.ParticipantId;
import org.json.JSONException;
import org.json.JSONObject;
import org.picocontainer.Startable;

public class WebConferencingService
implements Startable {
    public static final int ID_MAX_LENGTH = 255;
    public static final int TEXT_MAX_LENGTH = 255;
    public static final int ARG_MAX_LENGTH = 32;
    public static final int DATA_MAX_LENGTH = 2000;
    public static final int MAX_RESULT_SIZE = 30;
    public static final String SESSION_TOKEN_COOKIE;
    public static final String OPERATION_CALL_ADDED = "call-added";
    public static final String OPERATION_CALL_STARTED = "call-started";
    public static final String OPERATION_CALL_JOINED = "call-joined";
    public static final String OPERATION_CALL_LEAVED = "call-leaved";
    public static final String OPERATION_CALL_STOPPED = "call-stopped";
    public static final String OPERATION_CALL_DELETED = "call-deleted";
    public static final String OPERATION_CALL_RECORDED = "call-recorded";
    public static final String STATUS_OK = "ok";
    public static final String STATUS_NOT_OK = "ko";
    public static final String EVENT_CALL_CREATED = "exo.webconferencing.callCreated";
    public static final String EVENT_CALL_STARTED = "exo.webconferencing.callStarted";
    public static final String EVENT_CALL_JOINDED = "exo.webconferencing.callJoined";
    public static final String EVENT_CALL_LEFT = "exo.webconferencing.callLeft";
    public static final String EVENT_CALL_STOPPED = "exo.webconferencing.callStopped";
    public static final String EVENT_CALL_RECORDED = "exo.webconferencing.callRecorded";
    public static final String ROOM_DEFAULT_AVATAR_URL = "/webconferencing/skin/images/room-default.jpg";
    protected static final String CALL_OWNER_SCOPE_NAME;
    protected static final String CALL_ID_SCOPE_NAME;
    protected static final String USER_CALLS_SCOPE_NAME;
    protected static final String PROVIDER_SCOPE_NAME;
    protected static final String JWT_CONFIGURATION_PROPERTIES = "jwt-configuration";
    protected static final String SECRET_KEY = "secret-key";
    public static final String ALL_USERS = "*";
    public static final String GROUP = "group";
    public static final String USER = "user";
    public static final String OWNER_TYPE_USER = "user";
    public static final String OWNER_TYPE_SPACE = "space";
    public static final String OWNER_TYPE_SPACEEVENT = "space_event";
    public static final String OWNER_TYPE_CHATROOM = "chat_room";
    public static final String CMS_GROUPS_PATH = "groupsPath";
    public static final String EXO_TITLE_PROP = "exo:title";
    public static final String NT_FILE = "nt:file";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_DATA = "jcr:data";
    public static final String JCR_MIME_TYPE = "jcr:mimeType";
    public static final String JCR_LAST_MODIFIED_PROP = "jcr:lastModified";
    public static final String EXO_RSS_ENABLE_PROP = "exo:rss-enable";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String MIX_PRIVILEGEABLE = "exo:privilegeable";
    protected static final Log LOG;
    protected final String secretKey;
    protected final OrganizationService organization;
    protected final IdentityManager socialIdentityManager;
    protected final ListenerService listenerService;
    protected final SettingService settingService;
    protected final CallDAO callStorage;
    protected final ParticipantDAO participantsStorage;
    protected final OriginDAO originsStorage;
    protected final InviteDAO inviteStorage;
    protected final Map<String, CallProvider> providers = new ConcurrentHashMap<String, CallProvider>();
    protected SpaceService spaceService;
    protected ShareDocumentService shareService;
    protected final Map<String, Set<UserCallListener>> userListeners = new ConcurrentHashMap<String, Set<UserCallListener>>();
    protected final UploadService uploadService;
    protected final RepositoryService repositoryService;
    protected final SessionProviderService sessionProviders;
    protected final NodeHierarchyCreator nodeCreator;
    protected final IdentityRegistry identityRegistry;
    protected final Authenticator authenticator;
    protected final LinkManager linkManager;
    private AbstractCodec codec;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    public static boolean isValidId(String id) {
        return id != null && id.length() > 0 && id.length() <= 255;
    }

    public static boolean isValidText(String text) {
        return text == null || text.length() > 0 && text.length() <= 255;
    }

    public static boolean isValidArg(String arg) {
        return arg == null || arg.length() > 0 && arg.length() <= 32;
    }

    public static boolean isNotNullArg(String arg) {
        return arg != null && arg.length() > 0 && arg.length() <= 32;
    }

    public static boolean isValidData(String data) throws UnsupportedEncodingException {
        return data == null || data.length() > 0 && data.getBytes("UTF8").length <= 2000;
    }

    public WebConferencingService(OrganizationService organization, IdentityManager socialIdentityManager, ListenerService listenerService, SettingService settingService, CallDAO callStorage, ParticipantDAO participantsStorage, OriginDAO originsStorage, InviteDAO inviteStorage, UploadService uploadService, RepositoryService repositoryService, SessionProviderService sessionProviders, NodeHierarchyCreator nodeCreator, IdentityRegistry identityRegistry, Authenticator authenticator, ShareDocumentService shareService, InitParams initParams, LinkManager linkManager, CodecInitializer codecInitializer) {
        this.organization = organization;
        this.socialIdentityManager = socialIdentityManager;
        this.listenerService = listenerService;
        this.settingService = settingService;
        this.callStorage = callStorage;
        this.participantsStorage = participantsStorage;
        this.originsStorage = originsStorage;
        this.inviteStorage = inviteStorage;
        this.uploadService = uploadService;
        this.repositoryService = repositoryService;
        this.sessionProviders = sessionProviders;
        this.nodeCreator = nodeCreator;
        this.identityRegistry = identityRegistry;
        this.authenticator = authenticator;
        PropertiesParam jwtSecretParam = initParams.getPropertiesParam(JWT_CONFIGURATION_PROPERTIES);
        this.secretKey = jwtSecretParam.getProperty(SECRET_KEY);
        this.shareService = shareService;
        this.linkManager = linkManager;
        try {
            this.codec = codecInitializer.getCodec();
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing codecs", (Throwable)e);
        }
    }

    protected UserInfo userInfo(String id) throws IdentityStateException {
        User user;
        try {
            user = this.organization.getUserHandler().findUserByName(id, UserStatus.ANY);
        }
        catch (Exception e) {
            throw new IdentityStateException("Error finding user in organization service", e);
        }
        if (user != null) {
            if (user.isEnabled()) {
                org.exoplatform.social.core.identity.model.Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", id, true);
                if (userIdentity != null) {
                    Profile socialProfile = userIdentity.getProfile();
                    UserInfo info = new UserInfo(user.getUserName(), user.getFirstName(), user.getLastName());
                    this.getUserIMs(socialProfile).forEach(im -> info.addImAccount((UserInfo.IMInfo)im));
                    info.setAvatarLink(socialProfile.getAvatarUrl());
                    info.setProfileLink(LinkProvider.getUserProfileUri((String)id));
                    return info;
                }
                LOG.warn((Object)("Social identity not found for " + user.getUserName() + " (" + user.getFirstName() + " " + user.getLastName() + ")"));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ignore disabled user (treat as not found): '" + id + "'"));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("User not found: '" + id + "'"));
        }
        return null;
    }

    public UserInfo getUserInfo(String id) throws IdentityStateException {
        return this.userInfo(id);
    }

    public SpaceInfo getSpaceInfo(String spacePrettyName) throws IdentityStateException, StorageException {
        return this.spaceInfo(spacePrettyName, this.findSpaceCallId(spacePrettyName));
    }

    public SpaceEventInfo getSpaceEventInfo(String spaceIdentityId, String[] partIds, String[] spacesPrettyName) throws IdentityStateException, StorageException {
        return this.spaceEventInfo(spaceIdentityId, this.findLastSpaceEventCallId(spaceIdentityId), partIds, spacesPrettyName);
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    protected SpaceInfo spaceInfo(String spacePrettyName, String callId) throws IdentityStateException {
        Space socialSpace = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        if (socialSpace != null) {
            SpaceInfo space = new SpaceInfo(socialSpace);
            for (String sm : socialSpace.getMembers()) {
                UserInfo user = this.userInfo(sm);
                if (user != null) {
                    space.addMember(user);
                    continue;
                }
                LOG.warn((Object)("Skipped not found space member " + sm + " of " + spacePrettyName));
            }
            space.setProfileLink(socialSpace.getUrl());
            space.setAvatarLink(socialSpace.getAvatarUrl());
            space.setCallId(callId);
            return space;
        }
        return null;
    }

    protected SpaceEventInfo spaceEventInfo(String spaceIdentityId, String callId, String[] participants, String[] spaces) throws IdentityStateException {
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.socialIdentityManager.getIdentity(spaceIdentityId);
        SpaceEventInfo spaceEvent = new SpaceEventInfo(spaceIdentity);
        LinkedHashSet<String> allSpaces = new LinkedHashSet<String>();
        String spacePrettyName = spaceIdentity.getRemoteId();
        allSpaces.add(spacePrettyName);
        allSpaces.addAll(Arrays.asList(spaces));
        for (String s : allSpaces) {
            Space socialSpace = this.spaceService.getSpaceByPrettyName(s);
            if (socialSpace != null) {
                for (String sm : socialSpace.getMembers()) {
                    UserInfo user = this.userInfo(sm);
                    if (user != null) {
                        spaceEvent.addMember(user);
                        continue;
                    }
                    LOG.warn((Object)("Skipped not found space member as participant " + sm + " for space event in " + spacePrettyName));
                }
                continue;
            }
            LOG.warn((Object)("Skipped not found space " + s + " for event in " + spacePrettyName));
        }
        for (String p : participants) {
            UserInfo user = this.userInfo(p);
            if (user != null) {
                spaceEvent.addMember(user);
                continue;
            }
            LOG.warn((Object)("Skipped not found participant " + p + " for space event in " + spacePrettyName));
        }
        spaceEvent.setCallId(callId);
        return spaceEvent;
    }

    public RoomInfo getRoomInfo(String id, String title, String[] members) throws IdentityStateException, StorageException {
        return this.roomInfo(id, title, members, this.findChatRoomCallId(id));
    }

    protected RoomInfo roomInfo(String id, String title, String[] members, String callId) throws IdentityStateException {
        RoomInfo room = new RoomInfo(id, title);
        for (String userName : members) {
            UserInfo user = this.userInfo(userName);
            if (user != null) {
                room.addMember(user);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("External room member " + userName + " for '" + title + "'"));
            }
            room.addMember(new ParticipantInfo(userName));
        }
        room.setProfileLink(IdentityInfo.EMPTY);
        room.setAvatarLink(ROOM_DEFAULT_AVATAR_URL);
        room.setCallId(callId);
        return room;
    }

    public CallInfo addCall(String id, String ownerId, String ownerType, String title, String providerType, Collection<String> partIds) throws CallArgumentException, StorageException, IdentityStateException, CallConflictException, CallSettingsException {
        return this.createCall(id, ownerId, ownerType, title, providerType, partIds, null, true, null, null);
    }

    public CallInfo createCall(String id, String ownerId, String ownerType, String title, String providerType, Collection<String> partIds, Collection<String> spaces, boolean start, Date startDate, Date endDate) throws CallArgumentException, StorageException, IdentityStateException, CallConflictException, CallSettingsException {
        long opStart = System.currentTimeMillis();
        String currentUserId = this.currentUserId();
        if (WebConferencingService.isValidId(id)) {
            if (WebConferencingService.isValidId(ownerId)) {
                if (WebConferencingService.isNotNullArg(ownerType)) {
                    if (WebConferencingService.isNotNullArg(providerType)) {
                        if (WebConferencingService.isValidText(title)) {
                            IdentityInfo owner;
                            String prevId;
                            boolean isGroup;
                            boolean isUser = "user".equals(ownerType);
                            boolean isSpace = OWNER_TYPE_SPACE.equals(ownerType);
                            boolean isSpaceEvent = OWNER_TYPE_SPACEEVENT.equals(ownerType);
                            boolean isRoom = OWNER_TYPE_CHATROOM.equals(ownerType);
                            boolean bl = isGroup = isSpace || isRoom || isSpaceEvent;
                            if (isGroup && !isSpaceEvent && (prevId = this.findGroupCallId(ownerId)) != null && !prevId.equals(id)) {
                                this.deleteCall(prevId);
                                LOG.warn((Object)("Deleted outdated group call: " + prevId));
                            }
                            this.invalidateCall(id, isGroup);
                            if (start && isGroup) {
                                GroupInfo group;
                                if (isRoom) {
                                    group = this.roomInfo(ownerId, title, partIds.toArray(new String[partIds.size()]), id);
                                    owner = group;
                                } else if (isSpaceEvent) {
                                    group = this.spaceEventInfo(ownerId, id, partIds.toArray(new String[partIds.size()]), spaces.toArray(new String[spaces.size()]));
                                    owner = group;
                                } else if (isSpace) {
                                    group = this.spaceInfo(ownerId, id);
                                    owner = group;
                                } else {
                                    throw new CallArgumentException("Unexpected call owner type: " + ownerType + " for " + ownerId);
                                }
                                for (UserInfo m : group.getMembers().values()) {
                                    m.setState("leaved");
                                }
                            } else {
                                owner = this.createOwner(ownerId, ownerType, title, isUser, isSpace, isSpaceEvent, isRoom);
                            }
                            CallInfo call = new CallInfo(id, title, owner, providerType);
                            call.addOrigins(this.createOrigins(providerType, partIds, spaces));
                            call.setStartDate(startDate);
                            call.setEndDate(endDate);
                            if (start) {
                                call.setState("started");
                                call.setLastDate(Calendar.getInstance().getTime());
                                if (isUser) {
                                    call.addParticipants(this.createParticipants(providerType, partIds));
                                }
                            } else {
                                call.setLastDate(Calendar.getInstance().getTime());
                            }
                            this.createCall(call);
                            if (start) {
                                if (isGroup) {
                                    for (UserInfo part : call.getParticipants()) {
                                        if (!UserInfo.TYPE_NAME.equals(part.getType()) || currentUserId.equals(part.getId())) continue;
                                        this.fireUserCallStateChanged(part.getId(), id, providerType, "started", ownerId, ownerType);
                                    }
                                } else if (isUser) {
                                    this.notifyUserCallStateChanged(call, currentUserId, "started");
                                }
                            }
                            this.broacastCallEvent(EVENT_CALL_CREATED, call, currentUserId, null);
                            LOG.info((Object)this.metricMessage(currentUserId, call, OPERATION_CALL_ADDED, STATUS_OK, System.currentTimeMillis() - opStart, null, null));
                            return call;
                        }
                        throw new CallArgumentException("Wrong call title");
                    }
                    throw new CallArgumentException("Wrong provider");
                }
                throw new CallArgumentException("Wrong owner type");
            }
            throw new CallArgumentException("Wrong owner ID value");
        }
        throw new CallArgumentException("Wrong call ID value");
    }

    public CallInfo updateCall(String callId, String ownerId, String newOwnerType, String newTitle, String newProviderType, List<String> partIds, List<String> spaces, Date startDate, Date endDate) throws InvalidCallException, CallArgumentException, CallSettingsException, StorageException, CallNotFoundException, IdentityStateException, ParticipantNotFoundException {
        if (WebConferencingService.isValidId(callId)) {
            CallInfo currentCall = this.getCall(callId);
            if (currentCall != null) {
                String ownerType = WebConferencingService.isNotNullArg(newOwnerType) ? newOwnerType : currentCall.getOwner().getType();
                boolean isUser = "user".equals(ownerType);
                boolean isSpace = OWNER_TYPE_SPACE.equals(ownerType);
                boolean isSpaceEvent = OWNER_TYPE_SPACEEVENT.equals(ownerType);
                boolean isRoom = OWNER_TYPE_CHATROOM.equals(ownerType);
                String title = WebConferencingService.isValidText(newTitle) ? newTitle : currentCall.getTitle();
                IdentityInfo owner = WebConferencingService.isValidId(ownerId) ? this.createOwner(ownerId, ownerType, title, isUser, isSpace, isSpaceEvent, isRoom) : currentCall.getOwner();
                String providerType = WebConferencingService.isNotNullArg(newProviderType) ? newProviderType : currentCall.getProviderType();
                CallInfo call = new CallInfo(callId, title, owner, providerType);
                call.setLastDate(currentCall.getLastDate());
                call.addOrigins(this.createOrigins(providerType, partIds, spaces));
                Date newStartDate = startDate != null ? startDate : currentCall.getStartDate();
                call.setStartDate(newStartDate);
                Date newEndDate = endDate != null ? endDate : currentCall.getEndDate();
                call.setEndDate(newEndDate);
                this.updateCallAndOrigins(call);
                return call;
            }
            throw new CallNotFoundException("Call not found " + callId);
        }
        throw new CallArgumentException("Wrong call ID value");
    }

    protected Set<UserInfo> createParticipants(String providerType, Collection<String> partIds) throws IdentityStateException, CallArgumentException {
        LinkedHashSet<UserInfo> participants = new LinkedHashSet<UserInfo>();
        for (String pid : partIds) {
            if (WebConferencingService.isValidId(pid)) {
                UserInfo part = this.userInfo(pid);
                if (part != null) {
                    participants.add(part);
                } else {
                    part = new ParticipantInfo(providerType, pid);
                    participants.add(part);
                }
                part.setState("leaved");
                continue;
            }
            LOG.error((Object)("Cannot add call participant with too long ID: " + pid));
            throw new CallArgumentException("Wrong participant ID (" + pid + ")");
        }
        return participants;
    }

    protected Set<OriginInfo> createOrigins(String providerType, Collection<String> partIds, Collection<String> spacePrettyNames) throws IdentityStateException, CallArgumentException {
        LinkedHashSet<OriginInfo> origins = new LinkedHashSet<OriginInfo>();
        if (partIds != null) {
            for (String pid : partIds) {
                if (WebConferencingService.isValidId(pid)) {
                    UserInfo userInfo = this.userInfo(pid);
                    if (userInfo != null) {
                        origins.add(new OriginInfo(pid, "user"));
                        continue;
                    }
                    LOG.error((Object)("Cannot find call origin participant user: " + pid));
                    throw new CallArgumentException("Wrong participant name (" + pid + ")");
                }
                LOG.error((Object)("Cannot add call origin participant with too long name: " + pid));
                throw new CallArgumentException("Wrong participant name (" + pid + ")");
            }
        }
        if (spacePrettyNames != null) {
            for (String gid : spacePrettyNames) {
                if (WebConferencingService.isValidId(gid)) {
                    Space space = this.spaceService.getSpaceByPrettyName(gid);
                    if (space != null) {
                        origins.add(new OriginInfo(gid, OWNER_TYPE_SPACE));
                        continue;
                    }
                    LOG.error((Object)("Cannot find call origin space: " + gid));
                    throw new CallArgumentException("Wrong space name (" + gid + ")");
                }
                LOG.error((Object)("Cannot add call origin space with too long name: " + gid));
                throw new CallArgumentException("Wrong space name (" + gid + ")");
            }
        }
        return origins;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected IdentityInfo createOwner(String ownerId, String ownerType, String title, boolean isUser, boolean isSpace, boolean isSpaceEvent, boolean isRoom) throws CallArgumentException, IdentityStateException {
        IdentityInfo owner;
        if (isUser) {
            UserInfo userInfo = this.userInfo(ownerId);
            if (userInfo == null) {
                LOG.error((Object)("Cannot find call's owner user: " + ownerId));
                throw new CallArgumentException("Wrong call owner (" + ownerId + ")");
            }
            owner = userInfo;
            owner.setProfileLink(userInfo.getProfileLink());
            String avatar = userInfo.getAvatarLink();
            avatar = avatar != null ? avatar : "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png";
            owner.setAvatarLink(avatar);
            return owner;
        }
        if (isSpace) {
            Space space = this.spaceService.getSpaceByPrettyName(ownerId);
            if (space == null) {
                LOG.error((Object)("Cannot find call's owner space: " + ownerId));
                throw new CallArgumentException("Wrong call owner (" + ownerId + ")");
            }
            owner = new SpaceInfo(space);
            owner.setProfileLink(space.getUrl());
            String avatar = space.getAvatarUrl();
            avatar = avatar != null ? avatar : "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
            owner.setAvatarLink(avatar);
            return owner;
        }
        if (!isSpaceEvent) {
            if (!isRoom) throw new CallArgumentException("Wrong call owner type: " + ownerType);
            owner = new RoomInfo(ownerId, title);
            owner.setAvatarLink("/eXoSkin/skin/images/system/SpaceAvtDefault.png");
            return owner;
        }
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.socialIdentityManager.getIdentity(ownerId);
        if (spaceIdentity != null) {
            return new SpaceEventInfo(spaceIdentity);
        }
        LOG.error((Object)("Cannot find call's owner event space: " + ownerId));
        throw new CallArgumentException("Wrong call owner (" + ownerId + ")");
    }

    public CallInfo getCall(String id) throws InvalidCallException {
        try {
            return this.findCallById(id, true);
        }
        catch (CallOwnerException | CallSettingsException | IdentityStateException | StorageException e) {
            throw new InvalidCallException("Error getting call: " + id, e);
        }
    }

    public void initializeStartedCallsState() {
        try {
            List<CallEntity> savedCalls = this.callStorage.findGroupCallsByState("started");
            savedCalls.stream().forEach(callEntity -> {
                try {
                    int parts = this.participantsStorage.updateParticipantStateByCallId("leaved", callEntity.getId());
                    LOG.info("State of {} participants of call {} were updated to {} ", new Object[]{parts, callEntity.getId(), "leaved"});
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while updating participants state ", (Throwable)e);
                }
            });
            int calls = this.callStorage.updateStartedCallState("stopped");
            LOG.info("{} Calls state were updated to {} ", new Object[]{calls, "stopped"});
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting saved started calls");
        }
    }

    public CallInfo stopCall(String callId, boolean remove) throws CallNotFoundException, InvalidCallException {
        long opStart = System.currentTimeMillis();
        CallInfo call = this.getCall(callId);
        if (call != null) {
            String userId = this.currentUserId();
            try {
                this.stopCall(call, userId, remove);
                this.broacastCallEvent(EVENT_CALL_STOPPED, call, userId, null);
                if (remove) {
                    LOG.info((Object)this.metricMessage(userId, call, OPERATION_CALL_DELETED, STATUS_OK, System.currentTimeMillis() - opStart, null, null));
                } else {
                    LOG.info((Object)this.metricMessage(userId, call, OPERATION_CALL_STOPPED, STATUS_OK, System.currentTimeMillis() - opStart, null, null));
                }
                return call;
            }
            catch (StorageException e) {
                throw new InvalidCallException("Error stopping call: " + callId, e);
            }
        }
        throw new CallNotFoundException("Call not found: " + callId);
    }

    protected void stopCall(CallInfo call, String userId, boolean remove) throws StorageException {
        try {
            this.txStopCall(call, remove);
            if (call.getOwner().isGroup()) {
                String callId = call.getId();
                for (UserInfo part : call.getParticipants()) {
                    if (!UserInfo.TYPE_NAME.equals(part.getType()) && !GuestInfo.TYPE_NAME.equals(part.getType())) continue;
                    this.fireUserCallStateChanged(part.getId(), callId, call.getProviderType(), "stopped", call.getOwner().getId(), call.getOwner().getType());
                }
            } else {
                this.notifyUserCallStateChanged(call, userId, "stopped");
            }
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error stopping call " + call.getId(), e);
        }
    }

    public CallInfo startCall(String callId, String clientId) throws CallNotFoundException, InvalidCallException {
        long opStart = System.currentTimeMillis();
        CallInfo call = this.getCall(callId);
        if (call != null) {
            try {
                String userId = this.currentUserId();
                this.startCall(call, userId, clientId, true);
                this.broacastCallEvent(EVENT_CALL_STARTED, call, userId, null);
                LOG.info((Object)this.metricMessage(userId, call, OPERATION_CALL_STARTED, STATUS_OK, System.currentTimeMillis() - opStart, null, null));
                return call;
            }
            catch (CallSettingsException | ParticipantNotFoundException | StorageException e) {
                throw new InvalidCallException("Error starting call: " + callId, e);
            }
        }
        throw new CallNotFoundException("Call not found: " + callId);
    }

    protected void startCall(CallInfo call, String partId, String clientId, boolean notifyStarted) throws ParticipantNotFoundException, CallSettingsException, StorageException, CallNotFoundException {
        String callId = call.getId();
        call.setState("started");
        call.setLastDate(Calendar.getInstance().getTime());
        this.syncMembersAndParticipants(call);
        for (UserInfo part : call.getParticipants()) {
            if (UserInfo.TYPE_NAME.equals(part.getType()) && partId.equals(part.getId())) {
                part.setState("joined");
                part.setClientId(clientId);
                continue;
            }
            part.setState("leaved");
            part.setClientId(null);
        }
        this.updateCallAndParticipants(call);
        if (notifyStarted) {
            Set<UserInfo> parts = call.getOwner().isGroup() ? ((GroupInfo)GroupInfo.class.cast(call.getOwner())).getMembers().values() : call.getParticipants();
            for (UserInfo part : parts) {
                this.fireUserCallStateChanged(part.getId(), callId, call.getProviderType(), "started", call.getOwner().getId(), call.getOwner().getType());
            }
        }
    }

    public CallInfo updateParticipants(String callId, List<String> partIds) throws CallNotFoundException, InvalidCallException, StorageException {
        if (partIds == null || partIds.isEmpty()) {
            throw new IllegalArgumentException("Participants cannot be null or empty");
        }
        ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
        for (String userId : partIds) {
            try {
                UserInfo userInfo = this.userInfo(userId);
                if (userInfo == null) continue;
                userInfos.add(userInfo);
            }
            catch (IdentityStateException e) {
                LOG.warn((Object)("Cannot get userInfo for " + userId), (Throwable)e);
            }
        }
        try {
            CallInfo call = this.findCallById(callId, false);
            if (call != null) {
                try {
                    this.txUpdateParticipants(call, userInfos);
                }
                catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
                    throw new StorageException("Error updating participants of the call " + callId, e);
                }
                return call;
            }
            throw new CallNotFoundException("Call not found: " + callId);
        }
        catch (CallOwnerException | CallSettingsException | IdentityStateException e) {
            throw new StorageException("Error reading the call " + callId, e);
        }
    }

    public void addParticipant(String callId, String partId) throws StorageException, CallNotFoundException, InvalidCallException, IdentityStateException, CallArgumentException {
        UserInfo userInfo = this.userInfo(partId);
        if (userInfo != null) {
            try {
                this.txAddParticipant(callId, userInfo);
            }
            catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
                throw new StorageException("Error adding participant to call " + callId, e);
            }
        } else {
            throw new CallArgumentException("Participant user cannot be found: " + partId);
        }
    }

    public CallInfo addGuest(String callIId, String guestId) throws StorageException, CallNotFoundException, InvalidCallException, IdentityStateException {
        UserInfo userInfo = this.userInfo(guestId);
        GuestInfo guestInfo = userInfo == null ? new GuestInfo(guestId) : new GuestInfo(userInfo);
        CallInfo call = this.getCall(callIId);
        if (call != null) {
            try {
                this.txAddParticipant(callIId, guestInfo);
            }
            catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
                throw new StorageException("Error adding guest to call " + callIId, e);
            }
            call.addParticipant(guestInfo);
            return call;
        }
        throw new CallNotFoundException("Call not found: " + callIId);
    }

    public CallInfo updateInvites(String callId, List<InvitedIdentity> identities) throws CallNotFoundException, InvalidCallException, StorageException {
        CallInfo call = this.getCall(callId);
        if (call != null) {
            try {
                this.txUpdateInvites(callId, identities);
                return call;
            }
            catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
                throw new StorageException("Error updating invites of call " + callId, e);
            }
        }
        throw new CallNotFoundException("Call not found: " + callId);
    }

    public CallInfo joinCall(String callId, String partId, String clientId) throws InvalidCallException, CallNotFoundException, IdentityStateException, CallArgumentException {
        long opStart = System.currentTimeMillis();
        CallInfo call = this.getCall(callId);
        if (call != null) {
            block10: {
                try {
                    if ("started".equals(call.getState())) {
                        UserInfo joined = null;
                        for (UserInfo part : call.getParticipants()) {
                            if (!UserInfo.TYPE_NAME.equals(part.getType()) && !GuestInfo.TYPE_NAME.equals(part.getType()) || !partId.equals(part.getId())) continue;
                            part.setState("joined");
                            part.setClientId(clientId);
                            joined = part;
                            break;
                        }
                        if (joined != null) {
                            try {
                                this.updateParticipant(callId, joined);
                            }
                            catch (ParticipantNotFoundException e) {
                                if (call.getOwner().isGroup() && ((GroupInfo)GroupInfo.class.cast(call.getOwner())).getMembers().keySet().contains(partId)) {
                                    this.addParticipant(callId, partId);
                                }
                                throw new ParticipantNotFoundException("Cannot join the call with not allowed participant: " + partId + ", call: " + callId, e);
                            }
                            for (UserInfo part : call.getParticipants()) {
                                this.fireUserCallJoined(callId, call.getProviderType(), call.getOwner().getId(), call.getOwner().getType(), partId, part.getId());
                            }
                            this.broacastCallEvent(EVENT_CALL_JOINDED, call, partId, null);
                            LOG.info((Object)this.metricMessage(partId, call, OPERATION_CALL_JOINED, STATUS_OK, System.currentTimeMillis() - opStart, null, null));
                            break block10;
                        }
                        LOG.warn((Object)("Call join invoked but no participant was found for given user. Call ID: " + callId + ", participant: " + partId));
                        break block10;
                    }
                    String userId = this.currentUserId();
                    this.startCall(call, userId, clientId, false);
                    this.broacastCallEvent(EVENT_CALL_JOINDED, call, userId, null);
                    LOG.info((Object)this.metricMessage(userId, call, OPERATION_CALL_STARTED, STATUS_OK, System.currentTimeMillis() - opStart, null, null));
                }
                catch (CallSettingsException | ParticipantNotFoundException | StorageException e) {
                    throw new InvalidCallException("Error joining call: " + callId, e);
                }
            }
            return call;
        }
        throw new CallNotFoundException("Call not found: " + callId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallInfo leaveCall(String callId, String partId, String clientId) throws InvalidCallException {
        long opStart = System.currentTimeMillis();
        CallInfo call = this.getCall(callId);
        if (call != null) {
            try {
                if (!"started".equals(call.getState()) && !"paused".equals(call.getState())) return call;
                UserInfo leaved = null;
                boolean isGuestLeaved = false;
                int leavedNum = 0;
                for (UserInfo part : call.getParticipants()) {
                    boolean partIsGuest = GuestInfo.TYPE_NAME.equals(part.getType());
                    if (!UserInfo.TYPE_NAME.equals(part.getType()) && !partIsGuest) continue;
                    if (partId.equals(part.getId())) {
                        part.setState("leaved");
                        part.setClientId(null);
                        leaved = part;
                        if (partIsGuest) {
                            isGuestLeaved = true;
                        }
                        ++leavedNum;
                        continue;
                    }
                    if (part.getState() != null && !"leaved".equals(part.getState())) continue;
                    ++leavedNum;
                }
                if (leaved == null) return call;
                if (isGuestLeaved) {
                    this.removeParticipant(callId, leaved);
                } else {
                    this.updateParticipant(callId, leaved);
                }
                for (UserInfo part : call.getParticipants()) {
                    this.fireUserCallLeaved(callId, call.getProviderType(), call.getOwner().getId(), call.getOwner().getType(), partId, part.getId());
                }
                this.broacastCallEvent(EVENT_CALL_LEFT, call, partId, null);
                LOG.info((Object)this.metricMessage(partId, call, OPERATION_CALL_LEAVED, STATUS_OK, System.currentTimeMillis() - opStart, null, null));
                if (call.getOwner().isGroup()) {
                    if (leavedNum != call.getParticipants().size() && call.getParticipants().size() != 0 && !call.getParticipants().stream().allMatch(p -> p.getType().equals(GuestInfo.TYPE_NAME) || p.getState() == null || "leaved".equals(p.getState()))) return call;
                    call.getParticipants().stream().filter(participant -> participant.getType().equals(GuestInfo.TYPE_NAME) && participant.getState().equals("joined")).forEach(guest -> this.fireUserCallStateChanged(guest.getId(), callId, call.getProviderType(), "stopped", call.getOwner().getId(), call.getOwner().getType()));
                    this.stopCall(call, partId, false);
                    this.broacastCallEvent(EVENT_CALL_STOPPED, call, partId, null);
                    LOG.info((Object)this.metricMessage(partId, call, OPERATION_CALL_STOPPED, STATUS_OK, System.currentTimeMillis() - opStart, null, null));
                    return call;
                }
                if (call.getParticipants().size() - leavedNum > 1) return call;
                this.stopCall(call, partId, true);
                this.broacastCallEvent(EVENT_CALL_STOPPED, call, partId, null);
                LOG.info((Object)this.metricMessage(partId, call, OPERATION_CALL_DELETED, STATUS_OK, System.currentTimeMillis() - opStart, null, null));
                return call;
            }
            catch (ParticipantNotFoundException | StorageException e) {
                throw new InvalidCallException("Error leaving call: " + callId, e);
            }
        } else {
            LOG.warn((Object)("Call " + callId + " not found to leave it " + partId));
        }
        return call;
    }

    public CallState[] getUserCalls(String userId) throws StorageException {
        CallState[] states = (CallState[])this.findUserGroupCalls(userId).stream().map(c -> new CallState(c.getId(), c.getState() != null ? c.getState() : "stopped")).toArray(CallState[]::new);
        return states;
    }

    public void addUserCallListener(UserCallListener listener) {
        String userId = listener.getUserId();
        this.userListeners.computeIfAbsent(userId, k -> new LinkedHashSet()).add(listener);
    }

    public void removeUserCallListener(UserCallListener listener) {
        String userId = listener.getUserId();
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    protected void fireUserCallStateChanged(String userId, String callId, String providerType, String callState, String ownerId, String ownerType) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                listener.onCallStateChanged(callId, providerType, callState, ownerId, ownerType);
            }
        }
    }

    protected void fireUserCallJoined(String callId, String providerType, String ownerId, String ownerType, String partId, String userId) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                listener.onPartJoined(callId, providerType, ownerId, ownerType, partId);
            }
        }
    }

    protected void fireUserCallLeaved(String callId, String providerType, String ownerId, String ownerType, String partId, String userId) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                listener.onPartLeaved(callId, providerType, ownerId, ownerType, partId);
            }
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        Class<CallProvider> pclass = CallProvider.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            this.addProvider((CallProvider)((Object)pclass.cast(plugin)));
        } else {
            LOG.warn((Object)("Web Conferencing provider plugin is not an instance of " + pclass.getName() + ". Skipped plugin: " + plugin));
        }
    }

    public void addProvider(CallProvider provider) {
        for (String type : provider.getSupportedTypes()) {
            CallProvider existing = this.providers.putIfAbsent(type, provider);
            if (existing == null) continue;
            LOG.warn((Object)("Web Conferencing provider type '" + existing.getType() + "' already registered. Skipped plugin: " + provider));
        }
    }

    public boolean checkInvite(String callId, String inviteId, String identity) throws Exception {
        for (InviteEntity invite : this.inviteStorage.findCallInvites(callId)) {
            if (!invite.getInvitationId().equals(inviteId)) continue;
            if (invite.getIdentity().equals(ALL_USERS)) {
                return true;
            }
            if ("user".equals(invite.getIdentityType()) && invite.getIdentity().equals(identity)) {
                return true;
            }
            if (!GROUP.equals(invite.getIdentityType())) continue;
            Collection membersips = this.organization.getMembershipHandler().findMembershipsByUserAndGroup(identity, invite.getIdentity());
            return !membersips.isEmpty();
        }
        return false;
    }

    public CallProvider getProvider(String type) {
        CallProvider p = this.providers.get(type);
        if (p != null) {
            try {
                CallProviderConfiguration conf = this.readProviderConfig(p.getType());
                if (conf != null) {
                    p.setActive(conf.isActive());
                } else {
                    p.setActive(true);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Error reading provider configuration " + p.getType()), (Throwable)e);
                p.setActive(true);
            }
        }
        return p;
    }

    public Set<CallProviderConfiguration> getProviderConfigurations(Locale locale) {
        LinkedHashSet<CallProvider> allProviders = new LinkedHashSet<CallProvider>();
        for (CallProvider registeredProvider : this.providers.values()) {
            allProviders.add(registeredProvider);
        }
        LinkedHashSet<CallProviderConfiguration> allConfs = new LinkedHashSet<CallProviderConfiguration>();
        for (CallProvider p : allProviders) {
            boolean addDefault = false;
            try {
                CallProviderConfiguration conf = this.readProviderConfig(p.getType());
                if (conf != null) {
                    conf.setTitle(p.getTitle());
                    conf.setDescription(p.getDescription(locale));
                    conf.setLogEnabled(p.isLogEnabled());
                    allConfs.add(conf);
                } else {
                    addDefault = true;
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Error reading providers configuration " + p.getType()), (Throwable)e);
                addDefault = true;
            }
            if (!addDefault) continue;
            CallProviderConfiguration defaultConf = CallProviderConfiguration.fromProvider(p, locale);
            allConfs.add(defaultConf);
        }
        return allConfs;
    }

    public Set<CallProviderConfiguration> getProviderConfigurations() {
        return this.getProviderConfigurations(Locale.getDefault());
    }

    public CallProviderConfiguration getProviderConfiguration(String providerType, Locale locale) {
        CallProvider p = this.getProvider(providerType);
        if (p != null) {
            CallProviderConfiguration conf = this.readProviderConfig(p.getType());
            if (conf == null) {
                conf = CallProviderConfiguration.fromProvider(p, locale);
            } else {
                conf.setTitle(p.getTitle());
                conf.setDescription(p.getDescription(locale));
                conf.setLogEnabled(p.isLogEnabled());
            }
            return conf;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProviderConfiguration(CallProviderConfiguration conf) throws UnsupportedEncodingException, JSONException {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            JSONObject json = this.providerConfigToJson(conf);
            String safeType = URLEncoder.encode(conf.getType(), "UTF-8");
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(PROVIDER_SCOPE_NAME), safeType, SettingValue.create((String)json.toString()));
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    public List<IdentityData> findGroupsAndUsers(String name) throws Exception {
        List<IdentityData> identitiesData = this.findUsers(name, 15);
        int remain = 30 - identitiesData.size();
        identitiesData.addAll(this.findGroups(name, remain));
        Collections.sort(identitiesData, new Comparator<IdentityData>(){

            @Override
            public int compare(IdentityData s1, IdentityData s2) {
                return s1.getDisplayName().compareTo(s2.getDisplayName());
            }
        });
        return identitiesData;
    }

    protected List<IdentityData> findUsers(String name, int count) throws Exception {
        int size;
        ArrayList<IdentityData> results = new ArrayList<IdentityData>();
        ProfileFilter identityFilter = new ProfileFilter();
        identityFilter.setName(name);
        ListAccess identitiesList = this.socialIdentityManager.getIdentitiesByProfileFilter("organization", identityFilter, false);
        int n = size = identitiesList.getSize() >= count ? count : identitiesList.getSize();
        if (size > 0) {
            org.exoplatform.social.core.identity.model.Identity[] identities;
            for (org.exoplatform.social.core.identity.model.Identity id : identities = (org.exoplatform.social.core.identity.model.Identity[])identitiesList.load(0, size)) {
                Profile profile = id.getProfile();
                String fullName = profile.getFullName();
                String userName = (String)profile.getProperty("username");
                String avatarUrl = profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png";
                results.add(new IdentityData(userName, fullName, "user", avatarUrl));
            }
        }
        return results;
    }

    protected List<IdentityData> findGroups(String name, int count) throws Exception {
        int size;
        ArrayList<IdentityData> results = new ArrayList<IdentityData>();
        ListAccess groupsAccess = this.organization.getGroupHandler().findGroupsByKeyword(name);
        int n = size = groupsAccess.getSize() >= count ? count : groupsAccess.getSize();
        if (size > 0) {
            Group[] groups;
            for (Group group : groups = (Group[])groupsAccess.load(0, size)) {
                Space space = this.spaceService.getSpaceByGroupId(group.getId());
                if (space != null) {
                    String avatarUrl = space.getAvatarUrl() != null ? space.getAvatarUrl() : "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
                    results.add(new IdentityData(space.getGroupId(), space.getDisplayName(), GROUP, avatarUrl));
                    continue;
                }
                results.add(new IdentityData(group.getId(), group.getLabel(), GROUP, "/eXoSkin/skin/images/system/SpaceAvtDefault.png"));
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(UploadFileInfo uploadInfo, HttpServletRequest request) throws UploadFileException, RepositoryException {
        block13: {
            long opStart = System.currentTimeMillis();
            String uploadId = String.valueOf((long)(Math.random() * 100000.0));
            try {
                this.uploadService.createUploadResource(uploadId, request);
            }
            catch (FileUploadException e) {
                LOG.error((Object)("Cannot create upload resource: " + e.getMessage()));
                throw new UploadFileException("Cannot create upload resource", e);
            }
            UploadResource resource = this.uploadService.getUploadResource(uploadId);
            CallInfo call = null;
            try {
                call = this.getCall(uploadInfo.getCallId());
                if (resource.getStatus() == 1) {
                    String uploadingUser = uploadInfo.getUser();
                    String owner = null;
                    owner = !uploadInfo.getType().equals(OWNER_TYPE_SPACEEVENT) && !uploadInfo.getType().equals(OWNER_TYPE_SPACE) && !uploadInfo.getIdentity().equals(uploadingUser) ? uploadingUser : uploadInfo.getIdentity();
                    Node rootNode = this.getRootFolderNode(owner, uploadInfo.getType());
                    if (uploadInfo.getType().equals(OWNER_TYPE_CHATROOM) || uploadInfo.getType().equals("user")) {
                        this.saveFile(rootNode, resource, uploadingUser, uploadInfo.getParticipants());
                    } else {
                        this.saveFile(rootNode, resource, uploadingUser, null);
                    }
                    this.broacastCallEvent(EVENT_CALL_RECORDED, call, uploadingUser, resource.getUploadedSize(), resource.getFileName(), uploadInfo, STATUS_OK);
                    LOG.info((Object)this.metricMessage(uploadingUser, call, OPERATION_CALL_RECORDED, STATUS_OK, System.currentTimeMillis() - opStart, null, resource.getUploadedSize()));
                    break block13;
                }
                if (this.uploadService.isLimited(resource, resource.getEstimatedSize())) {
                    UploadService.UploadLimit limitUpload = this.uploadService.getLimitForResource(resource);
                    Object limit = "";
                    limit = " (" + limitUpload.getLimit() + " " + limitUpload.getUnit() + ")";
                    this.broacastCallEvent(EVENT_CALL_RECORDED, call, uploadInfo.getUser(), resource.getEstimatedSize(), null, uploadInfo, STATUS_NOT_OK);
                    LOG.info((Object)this.metricMessage(uploadInfo.getUser(), call, OPERATION_CALL_RECORDED, STATUS_NOT_OK, System.currentTimeMillis() - opStart, "Record size limit exceed the upload limit" + (String)limit, resource.getEstimatedSize()));
                    LOG.error((Object)("Failed while uploading the record : record size exceed the upload limit" + (String)limit));
                    break block13;
                }
                throw new UploadFileException("The file " + resource.getFileName() + " cannot be uploaded. Status: " + resource.getStatus());
            }
            catch (InvalidCallException e) {
                LOG.warn((Object)"Failed to build metric for call-recorded", (Throwable)e);
            }
            catch (Exception e) {
                this.broacastCallEvent(EVENT_CALL_RECORDED, call, uploadInfo.getUser(), resource.getEstimatedSize(), null, null, STATUS_NOT_OK);
                LOG.info((Object)this.metricMessage(uploadInfo.getUser(), call, OPERATION_CALL_RECORDED, STATUS_NOT_OK, System.currentTimeMillis() - opStart, null, resource.getEstimatedSize()));
                LOG.error((Object)("Failed while saving the uploaded file " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.uploadService.removeUploadResource(uploadId);
            }
        }
    }

    private void saveFile(Node parent, UploadResource resource, String user, List<String> shareToUsers) throws RepositoryException, UploadFileException {
        if (parent == null) {
            throw new UploadFileException("Cannot save the file because parent node empty for user: " + user);
        }
        if (resource == null) {
            throw new UploadFileException("Cannot save the file because upload resources are empty for user: " + user);
        }
        if (user == null) {
            throw new UploadFileException("Cannot save the file because user is undefined");
        }
        ConversationState state = null;
        try {
            state = this.createState(user);
            ConversationState.setCurrent((ConversationState)state);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot set conversation state for user: " + user), (Throwable)e);
            throw new UploadFileException("Cannot set conversation state for user: " + user);
        }
        ManageableRepository repository = this.repositoryService.getCurrentRepository();
        SessionProvider systemSessionProvider = this.sessionProviders.getSystemSessionProvider(null);
        Session session = systemSessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
        Node folder = (Node)session.getItem(parent.getPath());
        Node recordingsFolder = this.getRecordingsFolder(folder);
        if (recordingsFolder != null) {
            Node fileNode = recordingsFolder.addNode(resource.getFileName(), NT_FILE);
            if (!fileNode.hasProperty(EXO_TITLE_PROP)) {
                fileNode.addMixin(EXO_RSS_ENABLE_PROP);
            }
            fileNode.setProperty(EXO_TITLE_PROP, resource.getFileName());
            Node content = fileNode.addNode(JCR_CONTENT, NT_RESOURCE);
            try (FileInputStream fis = new FileInputStream(resource.getStoreLocation());){
                content.setProperty(JCR_DATA, (InputStream)fis);
            }
            catch (IOException e) {
                LOG.error("Cannot set JCR_DATA to created node.", new Object[]{e.getMessage()});
                throw new UploadFileException("Cannot set JCR_DATA for file node " + resource.getFileName());
            }
            content.setProperty(JCR_MIME_TYPE, resource.getMimeType());
            content.setProperty(JCR_LAST_MODIFIED_PROP, (Calendar)new GregorianCalendar());
            folder.save();
            String perm = "read" + "," + "add_node" + "," + "set_property";
            if (shareToUsers != null) {
                for (String participant : shareToUsers) {
                    if (participant.equals(user)) continue;
                    this.shareRecordToUser(participant, fileNode, perm);
                }
            }
        } else {
            this.cleanConversationState();
            throw new UploadFileException("Cannot get the node for recorings folder to upload the record (" + resource.getFileName() + ") for user:" + user);
        }
        this.cleanConversationState();
    }

    private Node getRecordingsFolder(Node folder) throws RepositoryException {
        Node recordingsFolder = null;
        if (!folder.hasNode("recordings")) {
            recordingsFolder = this.addRecordingsFolder(folder);
        } else {
            recordingsFolder = folder.getNode("recordings");
            if (recordingsFolder.isNodeType("nt:unstructured") || recordingsFolder.isNodeType("nt:folder")) {
                recordingsFolder.addMixin("exo:recordingsFolder");
            } else {
                try {
                    recordingsFolder = this.addRecordingsFolder(folder);
                }
                catch (Exception e) {
                    LOG.warn((Object)"An error occured while adding the recordings folder when the 'recordings' node already exists", (Throwable)e);
                }
            }
        }
        return recordingsFolder;
    }

    private Node addRecordingsFolder(Node folder) throws RepositoryException {
        Node recordingsFolder = folder.addNode("recordings", "nt:folder");
        recordingsFolder.setProperty(EXO_TITLE_PROP, "Recordings");
        recordingsFolder.addMixin("exo:recordingsFolder");
        return recordingsFolder;
    }

    private void cleanConversationState() {
        try {
            ConversationState.setCurrent(null);
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occured while cleaning the ConversationState", (Throwable)e);
        }
    }

    private Node getPrivateUserNode(SessionProvider sessionProvider, String user) throws Exception, PathNotFoundException, RepositoryException {
        String privateRelativePath = this.nodeCreator.getJcrPath("userPrivate");
        Node userNode = this.nodeCreator.getUserNode(sessionProvider, user);
        return userNode.getNode(privateRelativePath);
    }

    private void shareRecordToUser(String user, Node recordNode, String perm) {
        block9: {
            Node userPrivateNode = null;
            try {
                String tempPerms;
                SessionProvider sessionProvider = this.sessionProviders.getSystemSessionProvider(null);
                ManageableRepository repository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                userPrivateNode = this.getPrivateUserNode(sessionProvider, user);
                Node recordingsFolder = this.getRecordingsFolder(userPrivateNode);
                if (recordNode.isNodeType("exo:symlink")) {
                    recordNode = this.linkManager.getTarget(recordNode);
                }
                if (!(tempPerms = perm.toString()).equals("read")) {
                    tempPerms = "read,add_node,set_property,remove";
                }
                if (PermissionUtil.canChangePermission((Node)recordNode)) {
                    this.setUserPermission(recordNode, user, tempPerms.split(","));
                } else if (PermissionUtil.canRead((Node)recordNode)) {
                    SessionProvider systemSessionProvider = SessionProvider.createSystemProvider();
                    Session systemSession = systemSessionProvider.getSession(session.getWorkspace().getName(), repository);
                    Node _node = (Node)systemSession.getItem(recordNode.getPath());
                    this.setUserPermission(_node, user, tempPerms.split(","));
                }
                recordNode.getSession().save();
                Node link = this.linkManager.createLink(recordingsFolder, recordNode);
                String nodeMimeType = Utils.getMimeType((Node)recordNode);
                link.addMixin("mix:fileType");
                link.setProperty("exo:fileType", nodeMimeType);
                userPrivateNode.save();
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void setUserPermission(Node currentNode, String username, String[] permissions) throws Exception {
        ExtendedNode node = (ExtendedNode)currentNode;
        if (node.canAddMixin(MIX_PRIVILEGEABLE)) {
            node.addMixin(MIX_PRIVILEGEABLE);
        }
        node.setPermission(username, permissions);
        node.save();
    }

    private Node getRootFolderNode(String identity, String type) throws RepositoryException {
        Node folderNode = null;
        ManageableRepository repository = this.repositoryService.getCurrentRepository();
        SessionProvider sessionProvider = this.sessionProviders.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
        if (OWNER_TYPE_SPACE.equals(type)) {
            Node rootSpace = null;
            Space space = this.spaceService.getSpaceByPrettyName(identity);
            rootSpace = (Node)session.getItem(this.nodeCreator.getJcrPath(CMS_GROUPS_PATH) + space.getGroupId());
            folderNode = rootSpace.getNode("Documents");
        } else if (OWNER_TYPE_SPACEEVENT.equals(type)) {
            Node rootSpace = null;
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.socialIdentityManager.getIdentity(identity);
            Space space = this.spaceService.getSpaceByPrettyName(spaceIdentity.getRemoteId());
            rootSpace = (Node)session.getItem(this.nodeCreator.getJcrPath(CMS_GROUPS_PATH) + space.getGroupId());
            folderNode = rootSpace.getNode("Documents");
        } else {
            String privateRelativePath = this.nodeCreator.getJcrPath("userPrivate");
            Node userNode = null;
            try {
                userNode = this.nodeCreator.getUserNode(sessionProvider, identity);
            }
            catch (Exception e) {
                LOG.error("Cannot find user node by id: " + identity, new Object[]{e.getMessage()});
                throw new RepositoryException("Cannot find user node by id: " + identity, (Throwable)e);
            }
            folderNode = userNode.getNode(privateRelativePath);
        }
        return folderNode;
    }

    private ConversationState createState(String userId) {
        Identity userIdentity = this.userIdentity(userId);
        if (userIdentity != null) {
            ConversationState state = new ConversationState(userIdentity);
            state.setAttribute("subject", (Object)userIdentity.getSubject());
            return state;
        }
        LOG.warn((Object)("User identity not found " + userId + " for setting conversation state"));
        return null;
    }

    protected Identity userIdentity(String userId) {
        Identity userIdentity = this.identityRegistry.getIdentity(userId);
        if (userIdentity == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User identity not registered, trying to create it for: " + userId));
                }
                userIdentity = this.authenticator.createIdentity(userId);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to create user identity: " + userId), (Throwable)e);
            }
        }
        return userIdentity;
    }

    public void start() {
        this.spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        LOG.info((Object)"Web Conferencing service started.");
        PortalContainer container = PortalContainer.getInstance();
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            int cleaned = this.deleteAllUserCalls();
            if (cleaned > 0) {
                LOG.info((Object)("Cleaned " + cleaned + " expired user calls."));
            }
            this.initializeStartedCallsState();
        }
        catch (Throwable e) {
            LOG.warn((Object)"Error cleaning calls from previous server execution", e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    protected boolean isSpaceMember(String userName, String spacePrettyName) {
        return this.getSpaceMembers(spacePrettyName).contains(userName);
    }

    protected Set<String> getSpaceMembers(String spacePrettyName) {
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        HashSet<String> spaceMembers = new HashSet<String>();
        for (String sm : space.getMembers()) {
            spaceMembers.add(sm);
        }
        return spaceMembers;
    }

    protected CallProviderConfiguration jsonToProviderConfig(JSONObject json) throws JSONException {
        String type = json.getString("type");
        boolean active = json.getBoolean("active");
        CallProviderConfiguration conf = new CallProviderConfiguration();
        conf.setActive(active);
        conf.setType(type);
        return conf;
    }

    protected List<UserInfo.IMInfo> getUserIMs(Profile profile) {
        ArrayList<UserInfo.IMInfo> activeIMs = new ArrayList<UserInfo.IMInfo>();
        List ims = (List)profile.getProperty("ims");
        if (ims != null) {
            for (Map m : ims) {
                CallProvider provider;
                String imType = (String)m.get("key");
                String imId = (String)m.get("value");
                if (imId == null || imId.length() <= 0 || (provider = this.getProvider(imType)) == null || !provider.isActive() || !provider.isSupportedType(imType)) continue;
                try {
                    UserInfo.IMInfo im = provider.getIMInfo(imId);
                    if (im == null) continue;
                    activeIMs.add(im);
                }
                catch (CallProviderException e) {
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
        return activeIMs;
    }

    protected JSONObject providerConfigToJson(CallProviderConfiguration conf) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("type", (Object)conf.getType());
        json.put("active", conf.isActive());
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CallProviderConfiguration readProviderConfig(String type) {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            String safeType = URLEncoder.encode(type, "UTF-8");
            SettingValue val = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(PROVIDER_SCOPE_NAME), safeType);
            if (val != null) {
                String str = String.valueOf(val.getValue());
                if (str.startsWith("{")) {
                    CallProviderConfiguration conf;
                    CallProviderConfiguration callProviderConfiguration = conf = this.jsonToProviderConfig(new JSONObject(str));
                    return callProviderConfiguration;
                }
                LOG.warn((Object)("Cannot parse saved CallProviderConfiguration: " + str));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)"UTF8 encoding required to read provider config", (Throwable)e);
        }
        catch (JSONException e) {
            LOG.warn((Object)"Error reading provider config", (Throwable)e);
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
        return null;
    }

    protected String currentUserId() {
        ConversationState contextState = ConversationState.getCurrent();
        if (contextState != null) {
            return contextState.getIdentity().getUserId();
        }
        return null;
    }

    protected void notifyUserCallStateChanged(CallInfo call, String initiatorId, String state) {
        for (UserInfo part : call.getParticipants()) {
            if (!UserInfo.TYPE_NAME.equals(part.getType()) && !GuestInfo.TYPE_NAME.equals(part.getType()) || initiatorId != null && initiatorId.equals(part.getId()) && !"stopped".equals(state)) continue;
            this.fireUserCallStateChanged(part.getId(), call.getId(), call.getProviderType(), state, call.getOwner().getId(), call.getOwner().getType());
        }
    }

    protected CallInfo readCallEntity(CallEntity savedCall, boolean withParticipants) throws CallSettingsException, IdentityStateException, CallOwnerException {
        IdentityInfo owner;
        if (savedCall == null) {
            return null;
        }
        String callId = savedCall.getId();
        String ownerId = savedCall.getOwnerId();
        List<ParticipantEntity> savedParticipants = null;
        if (OWNER_TYPE_CHATROOM.equals(savedCall.getOwnerType())) {
            String settings = savedCall.getSettings();
            try {
                JSONObject json = new JSONObject(settings);
                String roomTitle = json.optString("roomTitle");
                if (roomTitle == null || roomTitle.length() <= 0) {
                    LOG.warn((Object)("Saved call doesn't have room settings: '" + settings + "'"));
                    throw new CallSettingsException("Saved call doesn't have room settings");
                }
                savedParticipants = this.participantsStorage.findCallParts(callId);
                String[] members = (String[])savedParticipants.stream().filter(p -> !GuestInfo.TYPE_NAME.equals(p.getType())).map(p -> p.getId()).toArray(String[]::new);
                owner = this.roomInfo(ownerId, roomTitle, members, callId);
            }
            catch (JSONException e) {
                LOG.warn((Object)("Saved call has wrong room settings format (bad JSON syntax): '" + settings + "'"), (Throwable)e);
                throw new CallSettingsException("Saved call has wrong room settings format", e);
            }
        } else if (OWNER_TYPE_SPACEEVENT.equals(savedCall.getOwnerType())) {
            String[] eventParticipants = (String[])this.originsStorage.findCallOrigins(callId, "user").stream().map(p -> p.getId()).toArray(String[]::new);
            String[] eventSpaces = (String[])this.originsStorage.findCallOrigins(callId, OWNER_TYPE_SPACE).stream().map(p -> p.getId()).toArray(String[]::new);
            owner = this.spaceEventInfo(ownerId, callId, eventParticipants, eventSpaces);
        } else if (OWNER_TYPE_SPACE.equals(savedCall.getOwnerType())) {
            owner = this.spaceInfo(ownerId, callId);
        } else if ("user".equals(savedCall.getOwnerType())) {
            owner = this.userInfo(ownerId);
        } else {
            throw new CallOwnerException("Unexpected call owner type: " + savedCall.getOwnerType() + " for " + ownerId);
        }
        if (owner == null) {
            LOG.warn((Object)("Call owner cannot be found: " + ownerId + " of call " + callId));
            try {
                LOG.info("Proceed to delete call: {}", new Object[]{callId});
                this.deleteCall(callId);
            }
            catch (StorageException e) {
                LOG.error("Error while deleting call: {}", new Object[]{callId});
            }
            return null;
        }
        CallInfo call = new CallInfo(callId, savedCall.getTitle(), owner, savedCall.getProviderType());
        call.setState(savedCall.getState());
        call.setLastDate(savedCall.getLastDate());
        call.setStartDate(savedCall.getStartDate());
        call.setEndDate(savedCall.getEndDate());
        try {
            String inviteId = this.getInviteId(callId);
            if (inviteId != null) {
                call.setInviteId(inviteId);
            } else if ("started".equals(call.getState())) {
                LOG.warn("Cannot find inviteId for started call {}", new Object[]{callId});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("An inviteId not found for call {}", new Object[]{callId});
            }
        }
        catch (StorageException e) {
            LOG.warn("Cannot get inviteId for call {} : {}", new Object[]{callId, e.getMessage()});
        }
        if (withParticipants) {
            if (savedParticipants == null) {
                savedParticipants = this.participantsStorage.findCallParts(callId);
            }
            for (ParticipantEntity p2 : savedParticipants) {
                if (UserInfo.TYPE_NAME.equals(p2.getType()) || GuestInfo.TYPE_NAME.equals(p2.getType())) {
                    UserInfo user = this.userInfo(p2.getId());
                    if (user == null) {
                        user = GuestInfo.TYPE_NAME.equals(p2.getType()) ? new GuestInfo(p2.getId()) : new ParticipantInfo(savedCall.getProviderType(), p2.getId());
                    } else if (GuestInfo.TYPE_NAME.equals(user.getType())) {
                        user = new GuestInfo(user);
                    }
                    user.setState(p2.getState());
                    user.setClientId(p2.getClientId());
                    call.addParticipant(user);
                    continue;
                }
                LOG.warn((Object)("Non user participant skipped for call " + savedCall.getId() + ": " + p2.getId() + " (" + p2.getType() + ")"));
            }
            if (savedCall.isGroup()) {
                HashSet<UserInfo> members = new HashSet<UserInfo>(((GroupInfo)GroupInfo.class.cast(owner)).getMembers().values());
                members.stream().forEach(m -> m.setState("leaved"));
                call.addParticipants(members);
            }
        }
        return call;
    }

    protected String getInviteId(String callId) throws StorageException {
        try {
            List<InviteEntity> invites = this.inviteStorage.findCallInvites(callId);
            if (!invites.isEmpty()) {
                return invites.get(0).getInvitationId();
            }
            return this.createInvite(callId);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error getting invite Id for call " + callId, e);
        }
    }

    private void createInvite(String callId, String identity, String type, String inviteId) throws IllegalArgumentException, IllegalStateException, PersistenceException {
        this.inviteStorage.create(new InviteEntity(callId, identity, type, inviteId));
    }

    private String createInvite(String callId) {
        String inviteId = this.codec.encode(callId);
        byte[] inviteIdBytes = Base64.getDecoder().decode(inviteId);
        inviteId = Base64.getUrlEncoder().withoutPadding().encodeToString(inviteIdBytes);
        this.createInvite(callId, ALL_USERS, GROUP, inviteId);
        return inviteId;
    }

    protected CallEntity createCallEntity(CallInfo call) throws CallSettingsException {
        CallEntity entity = new CallEntity();
        entity.setId(call.getId());
        this.syncCallEntity(call, entity);
        return entity;
    }

    protected void syncCallEntity(CallInfo call, CallEntity entity) throws CallSettingsException {
        if (call != null) {
            entity.setProviderType(call.getProviderType());
            entity.setTitle(call.getTitle());
            IdentityInfo owner = call.getOwner();
            entity.setOwnerId(owner.getId());
            entity.setOwnerType(owner.getType());
            entity.setState(call.getState());
            entity.setLastDate(call.getLastDate());
            entity.setStartDate(call.getStartDate());
            entity.setEndDate(call.getEndDate());
            if (OWNER_TYPE_CHATROOM.equals(owner.getType())) {
                entity.setIsGroup(true);
                entity.setIsUser(false);
                RoomInfo room = (RoomInfo)RoomInfo.class.cast(owner);
                try {
                    JSONObject json = new JSONObject();
                    json.put("roomTitle", (Object)room.getTitle());
                    String settings = json.toString();
                    if (!WebConferencingService.isValidData(settings)) {
                        LOG.warn((Object)("Call settings too long: '" + settings + "'. Max value is 2000 bytes in UTF8 encoding."));
                        throw new CallSettingsException("Call settings too long (room title)");
                    }
                    entity.setSettings(settings);
                }
                catch (UnsupportedEncodingException e) {
                    throw new CallSettingsException("Cannot save call settings (UTF8 encoding required)", e);
                }
                catch (JSONException e) {
                    throw new CallSettingsException("Cannot save call settings (title should be a text)", e);
                }
            } else if (OWNER_TYPE_SPACEEVENT.equals(owner.getType())) {
                entity.setIsGroup(true);
                entity.setIsUser(false);
            } else if (OWNER_TYPE_SPACE.equals(owner.getType())) {
                entity.setIsGroup(true);
                entity.setIsUser(false);
            } else {
                entity.setIsGroup(false);
                entity.setIsUser(true);
            }
        } else {
            throw new NullPointerException("Call info is null");
        }
    }

    protected ParticipantEntity createParticipantEntity(String callId, UserInfo user) {
        ParticipantEntity part = new ParticipantEntity();
        part.setId(user.getId());
        part.setCallId(callId);
        part.setType(user.getType());
        part.setState(user.getState());
        part.setClientId(user.getClientId());
        return part;
    }

    protected OriginEntity createOriginEntity(String callId, OriginInfo origin) {
        OriginEntity orig = new OriginEntity();
        orig.setId(origin.getId());
        orig.setCallId(callId);
        orig.setType(origin.getType());
        return orig;
    }

    protected <C extends SQLException> C exceptionCause(PersistenceException pe, Class<C> causeClass) {
        Throwable c;
        PersistenceException e = pe;
        do {
            if (e == null || !causeClass.isAssignableFrom(((Object)((Object)e)).getClass())) continue;
            return (C)((SQLException)causeClass.cast((Object)e));
        } while ((e = (c = e.getCause()) != null && c != e ? c : null) != null);
        return null;
    }

    @ExoTransactional
    protected void txCreateCall(CallInfo call) throws IllegalArgumentException, IllegalStateException, PersistenceException, CallSettingsException {
        CallInfo callInfo = call;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)callInfo);
        Object[] objectArray = new Object[]{this, callInfo, joinPoint};
        WebConferencingService$AjcClosure1 webConferencingService$AjcClosure1 = new WebConferencingService$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected void txAddParticipant(String callId, UserInfo participant) throws IllegalArgumentException, IllegalStateException, PersistenceException {
        String string = callId;
        UserInfo userInfo = participant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)userInfo);
        Object[] objectArray = new Object[]{this, string, userInfo, joinPoint};
        WebConferencingService$AjcClosure3 webConferencingService$AjcClosure3 = new WebConferencingService$AjcClosure3(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    private void addParticipant(String callId, UserInfo participant) throws IllegalArgumentException, IllegalStateException, PersistenceException {
        if (this.participantsStorage.find(new ParticipantId(participant.getId(), callId)) == null) {
            this.participantsStorage.create(this.createParticipantEntity(callId, participant));
        } else {
            LOG.warn("Cannot add participant with id {} for call {}. Participant already exists", new Object[]{participant.getId(), callId});
        }
    }

    private void saveCall(CallInfo call) throws CallNotFoundException, IllegalArgumentException, IllegalStateException, PersistenceException, CallSettingsException {
        CallEntity entity = (CallEntity)this.callStorage.find((Serializable)((Object)call.getId()));
        if (entity == null) {
            throw new CallNotFoundException("Call not found: " + call.getId());
        }
        this.syncCallEntity(call, entity);
        this.callStorage.update(entity);
    }

    @ExoTransactional
    protected void txStopCall(CallInfo call, boolean remove) throws IllegalArgumentException, IllegalStateException, PersistenceException {
        CallInfo callInfo = call;
        boolean bl = remove;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)callInfo, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, callInfo, Conversions.booleanObject((boolean)bl), joinPoint};
        WebConferencingService$AjcClosure5 webConferencingService$AjcClosure5 = new WebConferencingService$AjcClosure5(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected void txUpdateCall(CallInfo call) throws CallNotFoundException, IllegalArgumentException, IllegalStateException, PersistenceException, CallSettingsException {
        CallInfo callInfo = call;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)callInfo);
        Object[] objectArray = new Object[]{this, callInfo, joinPoint};
        WebConferencingService$AjcClosure7 webConferencingService$AjcClosure7 = new WebConferencingService$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected void txUpdateInvites(String callId, List<InvitedIdentity> identities) throws IllegalArgumentException, IllegalStateException, PersistenceException {
        String string = callId;
        List<InvitedIdentity> list = identities;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, list);
        Object[] objectArray = new Object[]{this, string, list, joinPoint};
        WebConferencingService$AjcClosure9 webConferencingService$AjcClosure9 = new WebConferencingService$AjcClosure9(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    private void saveParticipant(String callId, UserInfo user) throws IllegalArgumentException, IllegalStateException, PersistenceException, ParticipantNotFoundException {
        ParticipantEntity part = (ParticipantEntity)this.participantsStorage.find(new ParticipantId(user.getId(), callId));
        if (part == null) {
            throw new ParticipantNotFoundException("Call participant " + user.getId() + " not found for " + callId);
        }
        part.setState(user.getState());
        part.setClientId(user.getClientId());
        this.participantsStorage.update(part);
    }

    @ExoTransactional
    protected void txUpdateParticipant(String callId, UserInfo participant) throws IllegalArgumentException, IllegalStateException, PersistenceException, ParticipantNotFoundException {
        String string = callId;
        UserInfo userInfo = participant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)userInfo);
        Object[] objectArray = new Object[]{this, string, userInfo, joinPoint};
        WebConferencingService$AjcClosure11 webConferencingService$AjcClosure11 = new WebConferencingService$AjcClosure11(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected void txSyncMembersAndParticipants(CallInfo call) {
        CallInfo callInfo = call;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)callInfo);
        Object[] objectArray = new Object[]{this, callInfo, joinPoint};
        WebConferencingService$AjcClosure13 webConferencingService$AjcClosure13 = new WebConferencingService$AjcClosure13(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    private void removeGuests(CallInfo call) {
        List<ParticipantEntity> participants = this.participantsStorage.findCallParts(call.getId());
        participants.stream().filter(part -> part.getType().equals(GuestInfo.TYPE_NAME)).forEach(g -> {
            this.participantsStorage.delete(g);
            call.removeParticipant(new GuestInfo(g.getId()));
        });
    }

    @ExoTransactional
    protected void txRemoveParticipant(String callId, String partId) throws ParticipantNotFoundException {
        String string = callId;
        String string2 = partId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        WebConferencingService$AjcClosure15 webConferencingService$AjcClosure15 = new WebConferencingService$AjcClosure15(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    private void removeInvites(String callId) {
        List<InviteEntity> savedInvites = this.inviteStorage.findCallInvites(callId);
        for (InviteEntity i : savedInvites) {
            this.inviteStorage.delete(i);
        }
    }

    @ExoTransactional
    protected void txUpdateCallAndParticipants(CallInfo call) throws IllegalArgumentException, IllegalStateException, PersistenceException, CallNotFoundException, CallSettingsException, ParticipantNotFoundException {
        CallInfo callInfo = call;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)callInfo);
        Object[] objectArray = new Object[]{this, callInfo, joinPoint};
        WebConferencingService$AjcClosure17 webConferencingService$AjcClosure17 = new WebConferencingService$AjcClosure17(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected void txUpdateCallAndOrigins(CallInfo call) throws IllegalArgumentException, IllegalStateException, PersistenceException, CallNotFoundException, CallSettingsException, ParticipantNotFoundException {
        CallInfo callInfo = call;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)callInfo);
        Object[] objectArray = new Object[]{this, callInfo, joinPoint};
        WebConferencingService$AjcClosure19 webConferencingService$AjcClosure19 = new WebConferencingService$AjcClosure19(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected void txDeleteCall(String id) throws IllegalArgumentException, IllegalStateException, PersistenceException {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        WebConferencingService$AjcClosure21 webConferencingService$AjcClosure21 = new WebConferencingService$AjcClosure21(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure21.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected void txUpdateParticipants(CallInfo call, List<UserInfo> participants) throws IllegalArgumentException, IllegalStateException, PersistenceException {
        CallInfo callInfo = call;
        List<UserInfo> list = participants;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)callInfo, list);
        Object[] objectArray = new Object[]{this, callInfo, list, joinPoint};
        WebConferencingService$AjcClosure23 webConferencingService$AjcClosure23 = new WebConferencingService$AjcClosure23(objectArray);
        ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure23.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    protected int txDeleteAllUserCalls() throws IllegalArgumentException, IllegalStateException, PersistenceException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        WebConferencingService$AjcClosure25 webConferencingService$AjcClosure25 = new WebConferencingService$AjcClosure25(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(webConferencingService$AjcClosure25.linkClosureAndJoinPoint(69648)));
    }

    @Deprecated
    protected void clearStorage() {
        try {
            this.callStorage.clear();
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            LOG.warn((Object)"Call storage cleanup failed", e);
        }
    }

    protected void deleteCall(String id) throws StorageException {
        try {
            this.txDeleteCall(id);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error deleting call " + id, e);
        }
    }

    protected int deleteAllUserCalls() throws StorageException {
        try {
            return this.txDeleteAllUserCalls();
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error deleting all user calls", e);
        }
    }

    protected void updateCallAndParticipants(CallInfo call) throws StorageException, ParticipantNotFoundException, CallSettingsException, CallNotFoundException {
        try {
            this.txUpdateCallAndParticipants(call);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error updating call and participants: " + call.getId(), e);
        }
    }

    protected void updateCallAndOrigins(CallInfo call) throws StorageException, ParticipantNotFoundException, CallSettingsException, CallNotFoundException {
        try {
            this.txUpdateCallAndOrigins(call);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error updating call and origins: " + call.getId(), e);
        }
    }

    protected void syncMembersAndParticipants(CallInfo call) throws StorageException {
        try {
            this.txSyncMembersAndParticipants(call);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error sync call members and participants: " + call.getId(), e);
        }
    }

    protected void updateParticipant(String callId, UserInfo participant) throws ParticipantNotFoundException, StorageException {
        try {
            this.txUpdateParticipant(callId, participant);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error updating participant " + participant.getId() + " of call " + callId, e);
        }
    }

    protected void removeParticipant(String callId, UserInfo participant) throws ParticipantNotFoundException, StorageException {
        try {
            this.txRemoveParticipant(callId, participant.getId());
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error removing participant " + participant.getId() + " from call " + callId, e);
        }
    }

    protected void updateCall(CallInfo call) throws CallNotFoundException, CallSettingsException, StorageException {
        try {
            this.txUpdateCall(call);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error updating call " + call.getId(), e);
        }
    }

    protected CallInfo findCallById(String id, boolean withParticipants) throws IdentityStateException, StorageException, CallSettingsException, CallOwnerException {
        try {
            CallEntity savedCall = (CallEntity)this.callStorage.find((Serializable)((Object)id));
            return this.readCallEntity(savedCall, withParticipants);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error reading call " + id, e);
        }
    }

    protected String findGroupCallId(String ownerId) throws StorageException {
        try {
            CallEntity savedCall = this.callStorage.findGroupCallByOwnerId(ownerId);
            if (savedCall != null) {
                return savedCall.getId();
            }
            return null;
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error reading owner group call ID by " + ownerId, e);
        }
    }

    protected String findSpaceCallId(String spaceId) throws StorageException {
        try {
            CallEntity savedCall = this.callStorage.findGroupCallByOwnerTypeId(spaceId, OWNER_TYPE_SPACE);
            if (savedCall != null) {
                return savedCall.getId();
            }
            return null;
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error reading space call ID by " + spaceId, e);
        }
    }

    protected String findChatRoomCallId(String roomId) throws StorageException {
        try {
            CallEntity savedCall = this.callStorage.findGroupCallByOwnerTypeId(roomId, OWNER_TYPE_CHATROOM);
            if (savedCall != null) {
                return savedCall.getId();
            }
            return null;
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error reading chat room call ID by " + roomId, e);
        }
    }

    protected String findLastSpaceEventCallId(String ownerId) throws StorageException {
        try {
            CallEntity savedCall = this.callStorage.findGroupCallByOwnerTypeId(ownerId, OWNER_TYPE_SPACEEVENT);
            if (savedCall != null) {
                return savedCall.getId();
            }
            return null;
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error reading space event call ID by " + ownerId, e);
        }
    }

    protected Collection<CallInfo> findUserGroupCalls(String userId) throws StorageException {
        try {
            List<CallEntity> savedCalls = this.callStorage.findUserGroupCalls(userId);
            ArrayList<CallInfo> calls = new ArrayList<CallInfo>();
            for (CallEntity c : savedCalls) {
                try {
                    calls.add(this.readCallEntity(c, false));
                }
                catch (CallInfoException | IdentityStateException e) {
                    LOG.warn((Object)("Error reading user group call: " + c.getId()), (Throwable)e);
                }
            }
            return Collections.unmodifiableCollection(calls);
        }
        catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
            throw new StorageException("Error reading user group calls by " + userId, e);
        }
    }

    protected void createCall(CallInfo call) throws StorageException, CallConflictException, CallSettingsException {
        try {
            this.txCreateCall(call);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new StorageException("Error creating call " + call.getId(), e);
        }
        catch (PersistenceException pe) {
            SQLIntegrityConstraintViolationException constEx = this.exceptionCause(pe, SQLIntegrityConstraintViolationException.class);
            if (constEx != null && constEx.getMessage().indexOf("PK_WBC_CALLID") >= 0) {
                CallEntity conflictedCallEntity = (CallEntity)this.callStorage.find((Serializable)((Object)call.getId()));
                if (conflictedCallEntity != null) {
                    if ("started".equals(call.getState())) {
                        for (UserInfo savedPart : call.getParticipants()) {
                            Set<UserCallListener> ulisteners = this.userListeners.get(savedPart.getId());
                            if (ulisteners == null) continue;
                            for (UserCallListener ul : ulisteners) {
                                if (!savedPart.hasSameClientId(ul.getClientId())) continue;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Call already started and running: " + call.getId()), (Throwable)pe);
                                }
                                throw new CallConflictException("Call already started and running");
                            }
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Call already started: " + call.getId()), (Throwable)pe);
                        }
                        throw new CallConflictException("Call already started");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Call already created with state " + conflictedCallEntity.getState() + ": " + call.getId()), (Throwable)pe);
                    }
                    throw new CallConflictException("Call already created");
                }
                LOG.warn((Object)("Call ID already found but cannot read the call: " + call.getId()), (Throwable)pe);
                throw new CallConflictException("Call ID already found", pe);
            }
            LOG.error((Object)("Error creating call: " + call.getId()), (Throwable)pe);
            throw new StorageException("Error creating call", pe);
        }
    }

    protected void invalidateCall(String id, boolean isGroup) throws CallConflictException, StorageException {
        block8: {
            try {
                CallEntity existingCallEntity = (CallEntity)this.callStorage.find((Serializable)((Object)id));
                if (existingCallEntity == null) break block8;
                if (isGroup) {
                    throw new CallConflictException("Call already created");
                }
                try {
                    CallInfo existingCall = this.readCallEntity(existingCallEntity, true);
                    if ("started".equals(existingCall.getState())) {
                        for (UserInfo savedPart : existingCall.getParticipants()) {
                            Set<UserCallListener> ulisteners = this.userListeners.get(savedPart.getId());
                            if (ulisteners == null) continue;
                            for (UserCallListener ul : ulisteners) {
                                if (!savedPart.hasSameClientId(ul.getClientId())) continue;
                                throw new CallConflictException("Call already started");
                            }
                        }
                        this.deleteCall(id);
                        LOG.warn((Object)("Deleted not active call: " + id));
                        break block8;
                    }
                    this.deleteCall(id);
                    LOG.warn((Object)("Deleted outdated call: " + id));
                }
                catch (CallInfoException | IdentityStateException e) {
                    LOG.warn((Object)("Call in erroneous state: " + id), (Throwable)e);
                    this.deleteCall(id);
                    LOG.warn((Object)("Deleted erroneous call: " + id));
                }
            }
            catch (IllegalArgumentException | IllegalStateException | PersistenceException e) {
                LOG.warn((Object)("Error reading call by ID: " + id), e);
            }
        }
    }

    protected String metricMessage(String userId, CallInfo call, String operation, String status, Long duration, String error, Double fileSize) {
        StringBuilder res = new StringBuilder("service=webconferencing");
        res.append(" operation=").append(operation);
        res.append(" status=").append(status);
        res.append(" parameters=");
        res.append("\"userId:").append(userId);
        res.append(", isGroup:").append(call.getOwner().isGroup());
        res.append(", owner:").append(call.getOwner().getId());
        res.append(", ownerType:").append(call.getOwner().getType());
        res.append(", provider:").append(call.getProviderType());
        res.append(", state:").append(call.getState());
        res.append(", participantsCount:").append(call.getParticipants().size());
        if (fileSize != null) {
            DecimalFormat df = new DecimalFormat("0.00");
            String fileSizeByMO = df.format(fileSize / 1048576.0);
            res.append(", recording_file_size_in_mb:").append(fileSizeByMO);
        }
        if (call.getLastDate() != null) {
            long callDurationSec = Math.round((System.currentTimeMillis() - call.getLastDate().getTime()) / 1000L);
            res.append(", callDuration_sec:").append(callDurationSec);
            long callDurationMin = Math.round(callDurationSec / 60L);
            res.append(", callDuration_min:").append(callDurationMin);
        }
        res.append("\"");
        if (error != null && error.length() > 0) {
            res.append(" error_msg=\"").append(error).append("\"");
        }
        res.append(" duration_ms=").append(duration != null ? duration : -1L);
        return res.toString();
    }

    private void broacastCallEvent(String eventName, CallInfo call, String userId, Double fileSize, String fileName, UploadFileInfo uploadFileInfo, String status) {
        try {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("user_id", userId);
            info.put("status", status);
            if (fileSize != null) {
                DecimalFormat df = new DecimalFormat("0.00");
                String fileSizeByMO = df.format(fileSize / 1048576.0);
                info.put("file_size", fileSizeByMO);
                info.put("file_name", fileName);
                info.put("type", uploadFileInfo.getType());
                info.put("identity", uploadFileInfo.getIdentity());
            }
            this.listenerService.broadcast(eventName, (Object)call, info);
        }
        catch (Exception e) {
            LOG.error("Error while broadcasting event '{}' for user '{}'", new Object[]{eventName, userId, e});
        }
    }

    private void broacastCallEvent(String eventName, CallInfo call, String userId, Double fileSize) {
        this.broacastCallEvent(eventName, call, userId, fileSize, null, null, STATUS_OK);
    }

    public String getRecordingUrl(String identity, String fileName, String type) throws Exception {
        if (!fileName.isEmpty()) {
            DocumentService documentService = (DocumentService)WCMCoreUtils.getService(DocumentService.class);
            Node rootNode = this.getRootFolderNode(identity, type);
            Node recordingsFolder = this.getRecordingsFolder(rootNode);
            Node fileRecorded = recordingsFolder.getNode(fileName);
            String shortLink = documentService.getShortLinkInDocumentsApp(fileRecorded.getSession().getWorkspace().getName(), ((NodeImpl)fileRecorded).getInternalIdentifier());
            return CommonsUtils.getCurrentDomain() + shortLink;
        }
        return "#";
    }

    static {
        WebConferencingService.ajc$preClinit();
        SESSION_TOKEN_COOKIE = "webconf_session_token".intern();
        CALL_OWNER_SCOPE_NAME = "webconferencing.callOwner".intern();
        CALL_ID_SCOPE_NAME = "webconferencing.callId".intern();
        USER_CALLS_SCOPE_NAME = "webconferencing.user.calls".intern();
        PROVIDER_SCOPE_NAME = "webconferencing.provider".intern();
        LOG = ExoLogger.getLogger(WebConferencingService.class);
    }

    static /* synthetic */ void txCreateCall_aroundBody0(WebConferencingService ajc$this, CallInfo call, JoinPoint joinPoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> txCreateCall: " + call.getId()));
        }
        ajc$this.callStorage.create(ajc$this.createCallEntity(call));
        String callId = call.getId();
        if (call.getOwner().isGroup()) {
            if ("started".equals(call.getState())) {
                ajc$this.txSyncMembersAndParticipants(call);
            }
        } else {
            for (UserInfo p : call.getParticipants()) {
                ajc$this.participantsStorage.create(ajc$this.createParticipantEntity(callId, p));
            }
        }
        for (OriginInfo o : call.getOrigins()) {
            ajc$this.originsStorage.create(ajc$this.createOriginEntity(callId, o));
        }
        call.setInviteId(ajc$this.createInvite(callId));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< txCreateCall: " + call.getId()));
        }
    }

    static /* synthetic */ void txAddParticipant_aroundBody2(WebConferencingService ajc$this, String callId, UserInfo participant, JoinPoint joinPoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> txAddParticipant: " + participant.getId() + "@" + callId));
        }
        ajc$this.addParticipant(callId, participant);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< txAddParticipant: " + participant.getId() + "@" + callId));
        }
    }

    static /* synthetic */ void txStopCall_aroundBody4(WebConferencingService ajc$this, CallInfo call, boolean remove, JoinPoint joinPoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> txStopCall: " + call.getId()));
        }
        call.setState("stopped");
        if (remove) {
            ajc$this.txDeleteCall(call.getId());
            call.setInviteId(null);
        } else {
            try {
                ajc$this.saveCall(call);
                ajc$this.removeInvites(call.getId());
                call.setInviteId(null);
                ajc$this.removeGuests(call);
            }
            catch (CallNotFoundException | CallSettingsException e) {
                LOG.warn((Object)("Failed to save stopped call: " + call.getId()), (Throwable)e);
            }
        }
        call.setInviteId(null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< txStopCall: " + call.getId()));
        }
    }

    static /* synthetic */ void txUpdateCall_aroundBody6(WebConferencingService ajc$this, CallInfo call, JoinPoint joinPoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> txUpdateCall: " + call.getId()));
        }
        ajc$this.saveCall(call);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< txUpdateCall: " + call.getId()));
        }
    }

    static /* synthetic */ void txUpdateInvites_aroundBody8(WebConferencingService ajc$this, String callId, List identities, JoinPoint joinPoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> txUpdateInvites: " + callId));
        }
        identities = identities.stream().distinct().collect(Collectors.toList());
        List<InviteEntity> invites = ajc$this.inviteStorage.findCallInvites(callId);
        String inviteId = !invites.isEmpty() ? invites.get(0).getInvitationId() : RandomStringUtils.randomAlphabetic((int)12);
        for (InviteEntity invite : invites) {
            ajc$this.inviteStorage.delete(invite);
        }
        for (InvitedIdentity identity : identities) {
            ajc$this.createInvite(callId, identity.getIdentity(), identity.getType(), inviteId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< txUpdateInvites: " + callId));
        }
    }

    static /* synthetic */ void txUpdateParticipant_aroundBody10(WebConferencingService ajc$this, String callId, UserInfo participant, JoinPoint joinPoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> txUpdateParticipant: " + participant.getId() + "@" + callId));
        }
        ajc$this.saveParticipant(callId, participant);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< txUpdateParticipant: " + participant.getId() + "@" + callId));
        }
    }

    static /* synthetic */ void txSyncMembersAndParticipants_aroundBody12(WebConferencingService ajc$this, CallInfo call, JoinPoint joinPoint) {
        if (call.getOwner().isGroup()) {
            ParticipantEntity entity;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">> txSyncMembersAndParticipants: " + call.getId()));
            }
            LinkedHashSet<UserInfo> members = new LinkedHashSet<UserInfo>(((GroupInfo)GroupInfo.class.cast(call.getOwner())).getMembers().values());
            Set<UserInfo> participants = call.getParticipants();
            LinkedHashSet<UserInfo> deleteParties = new LinkedHashSet<UserInfo>(participants);
            deleteParties.removeAll(members);
            for (UserInfo p : deleteParties) {
                if (GuestInfo.TYPE_NAME.equals(p.getType())) continue;
                entity = (ParticipantEntity)ajc$this.participantsStorage.find(new ParticipantId(p.getId(), call.getId()));
                if (entity != null) {
                    ajc$this.participantsStorage.delete(entity);
                }
                call.removeParticipant(p);
            }
            members.removeAll(participants);
            for (UserInfo m : members) {
                entity = (ParticipantEntity)ajc$this.participantsStorage.find(new ParticipantId(m.getId(), call.getId()));
                if (entity == null) {
                    ajc$this.participantsStorage.create(ajc$this.createParticipantEntity(call.getId(), m));
                }
                call.addParticipant(m);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<< txSyncMembersAndParticipants: " + call.getId()));
            }
        }
    }

    static /* synthetic */ void txRemoveParticipant_aroundBody14(WebConferencingService ajc$this, String callId, String partId, JoinPoint joinPoint) {
        ParticipantEntity entity;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> txRemoveParticipant: " + partId + "@" + callId));
        }
        if ((entity = (ParticipantEntity)ajc$this.participantsStorage.find(new ParticipantId(partId, callId))) == null) {
            throw new ParticipantNotFoundException("Call participant " + partId + " not found for " + callId);
        }
        ajc$this.participantsStorage.delete(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< txRemoveParticipant: " + partId + "@" + callId));
        }
    }

    static /* synthetic */ void txUpdateCallAndParticipants_aroundBody16(WebConferencingService ajc$this, CallInfo call, JoinPoint joinPoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> txUpdateCallAndParticipants: " + call.getId()));
        }
        ajc$this.saveCall(call);
        if ("started".equals(call.getState()) && call.getInviteId() == null) {
            call.setInviteId(ajc$this.createInvite(call.getId()));
        }
        String callId = call.getId();
        for (UserInfo p : call.getParticipants()) {
            try {
                ajc$this.saveParticipant(callId, p);
            }
            catch (ParticipantNotFoundException e) {
                if (call.getOwner().isGroup() && ((GroupInfo)GroupInfo.class.cast(call.getOwner())).getMembers().keySet().contains(p.getId())) {
                    ajc$this.addParticipant(callId, p);
                    continue;
                }
                throw new ParticipantNotFoundException("Cannot update the call with not allowed participant: " + p.getId() + ", call: " + callId, e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< txUpdateCallAndParticipants: " + call.getId()));
        }
    }

    static /* synthetic */ void txUpdateCallAndOrigins_aroundBody18(WebConferencingService ajc$this, CallInfo call, JoinPoint joinPoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> txUpdateCallAndOrigins: " + call.getId()));
        }
        ajc$this.saveCall(call);
        String callId = call.getId();
        List savedOrigins = Stream.concat(ajc$this.originsStorage.findCallOrigins(callId, "user").stream(), ajc$this.originsStorage.findCallOrigins(callId, OWNER_TYPE_SPACE).stream()).collect(Collectors.toCollection(ArrayList::new));
        block0: for (OriginInfo o : call.getOrigins()) {
            Iterator oiter = savedOrigins.iterator();
            while (oiter.hasNext()) {
                OriginEntity oe = (OriginEntity)oiter.next();
                if (!oe.getType().equals(o.getType()) || !oe.getId().equals(o.getId())) continue;
                oiter.remove();
                continue block0;
            }
            ajc$this.originsStorage.create(ajc$this.createOriginEntity(callId, o));
        }
        for (OriginEntity oe : savedOrigins) {
            ajc$this.originsStorage.delete(oe);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< txUpdateCallAndOrigins: " + call.getId()));
        }
    }

    static /* synthetic */ void txDeleteCall_aroundBody20(WebConferencingService ajc$this, String id, JoinPoint joinPoint) {
        CallEntity entity = (CallEntity)ajc$this.callStorage.find((Serializable)((Object)id));
        if (entity != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">> txDeleteCall: " + id));
            }
            ajc$this.callStorage.delete(entity);
            ajc$this.removeInvites(id);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<< txDeleteCall: " + id));
            }
        }
    }

    static /* synthetic */ void txUpdateParticipants_aroundBody22(WebConferencingService ajc$this, CallInfo call, List participants, JoinPoint joinPoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> txUpdateParticipants: " + call.getId()));
        }
        if (participants != null && !participants.isEmpty()) {
            Set partIds = participants.stream().map(IdentityInfo::getId).collect(Collectors.toSet());
            List<ParticipantEntity> savedParts = ajc$this.participantsStorage.findCallParts(call.getId());
            Set savedPartIds = savedParts.stream().map(ParticipantEntity::getId).collect(Collectors.toSet());
            for (ParticipantEntity participantEntity : savedParts) {
                if (partIds.contains(participantEntity.getId())) continue;
                ajc$this.participantsStorage.delete(participantEntity);
                savedPartIds.remove(participantEntity.getId());
            }
            for (UserInfo userInfo : participants) {
                if (!savedPartIds.contains(userInfo.getId())) {
                    ajc$this.participantsStorage.create(ajc$this.createParticipantEntity(call.getId(), userInfo));
                }
                call.addParticipant(userInfo);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< txUpdateParticipants: " + call.getId()));
        }
    }

    static /* synthetic */ int txDeleteAllUserCalls_aroundBody24(WebConferencingService ajc$this, JoinPoint joinPoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)">> txDeleteAllUserCalls");
        }
        int r = ajc$this.callStorage.deleteAllUsersCalls();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< txDeleteAllUserCalls: " + r));
        }
        return r;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebConferencingService.java", WebConferencingService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txCreateCall", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo", "call", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException:org.exoplatform.webconferencing.CallSettingsException", "void"), 2978);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txAddParticipant", "org.exoplatform.webconferencing.WebConferencingService", "java.lang.String:org.exoplatform.webconferencing.UserInfo", "callId:participant", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException", "void"), 3017);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txDeleteCall", "org.exoplatform.webconferencing.WebConferencingService", "java.lang.String", "id", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException", "void"), 3414);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txUpdateParticipants", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo:java.util.List", "call:participants", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException", "void"), 3442);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txDeleteAllUserCalls", "org.exoplatform.webconferencing.WebConferencingService", "", "", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException", "int"), 3479);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txStopCall", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo:boolean", "call:remove", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException", "void"), 3072);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txUpdateCall", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo", "call", "org.exoplatform.webconferencing.CallNotFoundException:java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException:org.exoplatform.webconferencing.CallSettingsException", "void"), 3117);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txUpdateInvites", "org.exoplatform.webconferencing.WebConferencingService", "java.lang.String:java.util.List", "callId:identities", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException", "void"), 3140);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txUpdateParticipant", "org.exoplatform.webconferencing.WebConferencingService", "java.lang.String:org.exoplatform.webconferencing.UserInfo", "callId:participant", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException:org.exoplatform.webconferencing.ParticipantNotFoundException", "void"), 3199);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txSyncMembersAndParticipants", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo", "call", "", "void"), 3215);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txRemoveParticipant", "org.exoplatform.webconferencing.WebConferencingService", "java.lang.String:java.lang.String", "callId:partId", "org.exoplatform.webconferencing.ParticipantNotFoundException", "void"), 3279);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txUpdateCallAndParticipants", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo", "call", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException:org.exoplatform.webconferencing.CallNotFoundException:org.exoplatform.webconferencing.CallSettingsException:org.exoplatform.webconferencing.ParticipantNotFoundException", "void"), 3323);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "txUpdateCallAndOrigins", "org.exoplatform.webconferencing.WebConferencingService", "org.exoplatform.webconferencing.CallInfo", "call", "java.lang.IllegalArgumentException:java.lang.IllegalStateException:javax.persistence.PersistenceException:org.exoplatform.webconferencing.CallNotFoundException:org.exoplatform.webconferencing.CallSettingsException:org.exoplatform.webconferencing.ParticipantNotFoundException", "void"), 3370);
    }

    public class SpaceInfo
    extends GroupInfo {
        protected final String groupId;

        public SpaceInfo(Space socialSpace) {
            super(socialSpace.getPrettyName(), socialSpace.getDisplayName());
            this.groupId = socialSpace.getGroupId();
        }

        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getType() {
            return WebConferencingService.OWNER_TYPE_SPACE;
        }
    }

    public class SpaceEventInfo
    extends GroupInfo {
        protected final String groupId;

        public SpaceEventInfo(org.exoplatform.social.core.identity.model.Identity spaceIdentity) {
            super(spaceIdentity.getId(), spaceIdentity.getRemoteId());
            Space space = WebConferencingService.this.spaceService.getSpaceByPrettyName(spaceIdentity.getRemoteId());
            this.profileLink = space.getUrl();
            this.avatarLink = space.getAvatarUrl() != null ? space.getAvatarUrl() : "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
            this.groupId = space.getGroupId();
        }

        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getType() {
            return WebConferencingService.OWNER_TYPE_SPACEEVENT;
        }
    }

    public class RoomInfo
    extends GroupInfo {
        public RoomInfo(String id, String title) {
            super(id, title);
            this.profileLink = IdentityInfo.EMPTY;
        }

        @Override
        public String getType() {
            return WebConferencingService.OWNER_TYPE_CHATROOM;
        }
    }
}

