/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.notification.pwa;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.webconferencing.notification.utils.NotificationConstants;

public class CallRecordingPwaPlugin
implements PwaNotificationPlugin {
    public static final String ID = "CallRecordingPlugin";
    private static final String TITLE_LABEL_KEY_OK = "pwa.notification.webconferencing.callrecording.success";
    private static final String TITLE_LABEL_KEY_KO = "pwa.notification.webconferencing.callrecording.failed";
    private static final Log LOG = ExoLogger.getLogger(PwaNotificationPlugin.class);
    private ResourceBundleService resourceBundleService;

    public CallRecordingPwaPlugin(ResourceBundleService resourceBundleService) {
        this.resourceBundleService = resourceBundleService;
    }

    public String getId() {
        return ID;
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        String status = notification.getValueOwnerParameter(NotificationConstants.RECORDING_STATUS.getKey());
        String title = status.equals("ok") ? this.resourceBundleService.getSharedString(TITLE_LABEL_KEY_OK, localeConfig.getLocale()) : this.resourceBundleService.getSharedString(TITLE_LABEL_KEY_KO, localeConfig.getLocale());
        notificationMessage.setTitle(title);
        notificationMessage.setUrl(notification.getValueOwnerParameter(NotificationConstants.RECORDED_FILE_URL.getKey()));
        return notificationMessage;
    }
}

