/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.webrtc.server;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.webconferencing.webrtc.server.WebrtcContext;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class WebrtcCallFilter
extends AbstractFilter
implements Filter {
    protected static final Logger LOG = LoggerFactory.getLogger(WebrtcCallFilter.class);
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpRes = (HttpServletResponse)response;
        String scheme = httpReq.getScheme();
        scheme = scheme != null ? scheme.toUpperCase().toLowerCase() : SCHEME_HTTP;
        if (httpReq.getRemoteUser() != null) {
            if (scheme.equals(SCHEME_HTTP)) {
                String secure;
                LOG.warn((Object)new StringBuilder("WebRTC call page request with not secure shceme ").append(httpReq.getRequestURL()).append(". Redirecting to secure page."));
                try {
                    URI secureURI = new URI(SCHEME_HTTPS, null, httpReq.getServerName(), httpReq.getServerPort(), httpReq.getServletPath(), httpReq.getQueryString(), null);
                    secure = secureURI.toASCIIString();
                }
                catch (URISyntaxException e) {
                    LOG.warn((Object)("Error creating secure URL for " + httpReq.getRequestURL().toString()), (Throwable)e);
                    secure = SCHEME_HTTPS + httpReq.getRequestURL().substring(4) + '/' + httpReq.getQueryString();
                }
                httpReq.setAttribute(WebrtcContext.CALL_REDIRECT, (Object)secure);
            } else {
                ServletContext context = httpReq.getSession().getServletContext().getContext(WebrtcContext.WEBRTC_SERVLET_CTX);
                context.getRequestDispatcher(WebrtcContext.CALL_SERVLET).forward((ServletRequest)httpReq, (ServletResponse)httpRes);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

