/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.webrtc.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.webconferencing.Utils;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class WebrtcSettingsServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = -6075521943684442791L;
    protected static final Logger LOG = LoggerFactory.getLogger(WebrtcSettingsServlet.class);
    private static final String UNAUTHORIZED_PAGE = "/WEB-INF/pages/unauthorized.html";
    private static final String SERVER_ERROR_PAGE = "/WEB-INF/pages/servererror.html";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpServletRequest httpReq = req;
        HttpServletResponse httpRes = resp;
        httpRes.setContentType("text/html; charset=UTF-8");
        String remoteUser = httpReq.getRemoteUser();
        try {
            req.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"Encoding not supported", (Throwable)e);
        }
        if (remoteUser != null) {
            try {
                Map messages = Utils.getResourceMessages((String)"locale.webrtc.WebRTCAdmin", (Locale)httpReq.getLocale());
                httpReq.setAttribute("messages", (Object)messages);
                httpReq.getRequestDispatcher("/WEB-INF/pages/settings.jsp").include((ServletRequest)httpReq, (ServletResponse)httpRes);
            }
            catch (Exception e) {
                LOG.error((Object)"Error processing WebRTC settings page", (Throwable)e);
                httpRes.setStatus(500);
                httpReq.getRequestDispatcher(SERVER_ERROR_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
            }
        } else {
            httpRes.setStatus(401);
            httpReq.getRequestDispatcher(UNAUTHORIZED_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

