/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.webrtc.portlet;

import java.io.IOException;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.webrtc.WebrtcProvider;
import org.exoplatform.webui.application.WebuiRequestContext;

public class WebrtcProviderPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(WebrtcProviderPortlet.class);
    private WebConferencingService webConferencing;
    private WebrtcProvider provider;

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.getProvider() != null) {
            try {
                WebrtcProvider.WebrtcSettings settings = this.getProvider().settings().callUri(Utils.buildUrl((String)request.getScheme(), (String)request.getServerName(), (int)request.getServerPort(), (String)"/webrtc/call")).locale(request.getLocale()).build();
                request.setAttribute("messages", (Object)settings.getMessages());
                PortletRequestDispatcher prDispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/pages/incoming-call.jsp");
                prDispatcher.include(request, response);
                String settingsJson = Utils.asJSON((Object)settings);
                JavascriptManager js = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
                js.require("SHARED/webConferencing", "webConferencing").require("SHARED/webConferencing_webrtc", "webrtcProvider").addScripts("if (webrtcProvider) { webrtcProvider.configure(" + settingsJson + "); webConferencing.addProvider(webrtcProvider); webConferencing.update(); }");
            }
            catch (Exception e) {
                LOG.error((Object)("Error processing WebRTC call portlet for user " + request.getRemoteUser()), (Throwable)e);
            }
        }
    }

    private WebrtcProvider getProvider() {
        if (this.provider == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.webConferencing = (WebConferencingService)container.getComponentInstanceOfType(WebConferencingService.class);
            try {
                this.provider = (WebrtcProvider)this.webConferencing.getProvider("webrtc");
            }
            catch (ClassCastException e) {
                LOG.error((Object)("Provider webrtc isn't an instance of " + WebrtcProvider.class.getName()), (Throwable)e);
            }
        }
        return this.provider;
    }
}

