/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.videocall;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.model.videocall.VideoCallModel;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class VideoCallService {
    private static ExoCache<Serializable, VideoCallModel> videoProfileCache;
    public static String VIDEO_PROFILE_KEY;
    public static String BASE_PATH;
    public static String VIDEOCALL_BASE_PATH;
    public static String VIDEOCALL_NODETYPE;
    public static String DISABLEVIDEOCALL_PROP;
    public static String WEEMOKEY_PROP;
    public static String VIDEO_PERMISSIONS_PROP;
    public static String VIDEO_PASSPHARSE;
    public static String VIDEO_AUTH_ID;
    public static String VIDEO_AUTH_SECRET;
    public static String VIDEO_P12_CERT_NODE_NAME;
    public static String VIDEO_PEM_CERT_NODE_NAME;
    public static String VIDEO_CERT_MIXIN_NAME;
    public static String VIDEO_PROFILE_ID;
    public static String VIDEO_DOMAIN_ID;
    private static String tokenKey;
    private static final Log LOG;
    protected static final String WORKSPACE_NAME = "collaboration";

    public VideoCallService() {
        videoProfileCache = ((CacheService)WCMCoreUtils.getService(CacheService.class)).getCacheInstance(VideoCallService.class.getName());
    }

    public String getTokenKey() {
        return tokenKey;
    }

    public void setTokenKey(String newTokenKey) {
        tokenKey = newTokenKey;
    }

    public void saveVideoCallProfile(VideoCallModel videoCallModel) {
        block19: {
            String disbaleVideoCall = videoCallModel.getDisableVideoCall();
            String weemoKey = videoCallModel.getWeemoKey();
            String videoCallPermissions = videoCallModel.getVideoCallPermissions();
            String passPharse = videoCallModel.getCustomerCertificatePassphrase();
            String authId = videoCallModel.getAuthId();
            String authSecret = videoCallModel.getAuthSecret();
            InputStream p12Cert = videoCallModel.getP12Cert();
            InputStream pemCert = videoCallModel.getPemCert();
            String profileId = videoCallModel.getProfileId();
            String domainId = videoCallModel.getDomainId();
            SessionProvider sessionProvider = null;
            try {
                Node pemCertNode;
                String mimetype;
                DMSMimeTypeResolver mimeTypeResolver;
                Node jcrContent;
                Node p12CertNode;
                sessionProvider = WCMCoreUtils.getSystemSessionProvider();
                RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
                Session session = sessionProvider.getSession(WORKSPACE_NAME, repositoryService.getCurrentRepository());
                Node rootNode = session.getRootNode();
                Node baseNode = rootNode.getNode(BASE_PATH);
                Node videoCallNode = null;
                videoCallNode = baseNode.hasNode(VIDEOCALL_BASE_PATH) ? baseNode.getNode(VIDEOCALL_BASE_PATH) : baseNode.addNode(VIDEOCALL_BASE_PATH, VIDEOCALL_NODETYPE);
                videoCallNode.setProperty(DISABLEVIDEOCALL_PROP, Boolean.valueOf(disbaleVideoCall).booleanValue());
                videoCallNode.setProperty(WEEMOKEY_PROP, weemoKey);
                videoCallNode.setProperty(VIDEO_PERMISSIONS_PROP, videoCallPermissions);
                videoCallNode.setProperty(VIDEO_PASSPHARSE, passPharse);
                videoCallNode.setProperty(VIDEO_AUTH_ID, authId);
                videoCallNode.setProperty(VIDEO_AUTH_SECRET, authSecret);
                if (StringUtils.isNotEmpty((String)profileId)) {
                    videoCallNode.setProperty(VIDEO_PROFILE_ID, profileId);
                }
                if (StringUtils.isNotEmpty((String)domainId)) {
                    videoCallNode.setProperty(VIDEO_DOMAIN_ID, domainId);
                }
                if (p12Cert != null) {
                    p12CertNode = null;
                    p12CertNode = videoCallNode.hasNode(VIDEO_P12_CERT_NODE_NAME) ? videoCallNode.getNode(VIDEO_P12_CERT_NODE_NAME) : videoCallNode.addNode(VIDEO_P12_CERT_NODE_NAME, "nt:file");
                    jcrContent = null;
                    jcrContent = p12CertNode.hasNode("jcr:content") ? p12CertNode.getNode("jcr:content") : p12CertNode.addNode("jcr:content", "nt:resource");
                    mimeTypeResolver = DMSMimeTypeResolver.getInstance();
                    mimetype = mimeTypeResolver.getMimeType(videoCallModel.getP12CertName());
                    jcrContent.setProperty("jcr:data", p12Cert);
                    jcrContent.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                    jcrContent.setProperty("jcr:mimeType", mimetype);
                    if (jcrContent.canAddMixin(VIDEO_CERT_MIXIN_NAME)) {
                        jcrContent.addMixin(VIDEO_CERT_MIXIN_NAME);
                    }
                    jcrContent.setProperty("exo:videoCallCertificateFileName", videoCallModel.getP12CertName());
                } else if (videoCallNode.hasNode(VIDEO_P12_CERT_NODE_NAME) && (p12CertNode = videoCallNode.getNode(VIDEO_P12_CERT_NODE_NAME)).hasNode("jcr:content") && (jcrContent = p12CertNode.getNode("jcr:content")).hasProperty("exo:videoCallCertificateFileName")) {
                    videoCallModel.setP12CertName(jcrContent.getProperty("exo:videoCallCertificateFileName").getString());
                }
                if (pemCert != null) {
                    pemCertNode = null;
                    pemCertNode = videoCallNode.hasNode(VIDEO_PEM_CERT_NODE_NAME) ? videoCallNode.getNode(VIDEO_PEM_CERT_NODE_NAME) : videoCallNode.addNode(VIDEO_PEM_CERT_NODE_NAME, "nt:file");
                    jcrContent = null;
                    jcrContent = pemCertNode.hasNode("jcr:content") ? pemCertNode.getNode("jcr:content") : pemCertNode.addNode("jcr:content", "nt:resource");
                    mimeTypeResolver = DMSMimeTypeResolver.getInstance();
                    mimetype = mimeTypeResolver.getMimeType(videoCallModel.getPemCertName());
                    jcrContent.setProperty("jcr:data", pemCert);
                    jcrContent.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                    jcrContent.setProperty("jcr:mimeType", mimetype);
                    if (jcrContent.canAddMixin(VIDEO_CERT_MIXIN_NAME)) {
                        jcrContent.addMixin(VIDEO_CERT_MIXIN_NAME);
                    }
                    jcrContent.setProperty("exo:videoCallCertificateFileName", videoCallModel.getPemCertName());
                } else if (videoCallNode.hasNode(VIDEO_PEM_CERT_NODE_NAME) && (pemCertNode = videoCallNode.getNode(VIDEO_PEM_CERT_NODE_NAME)).hasNode("jcr:content") && (jcrContent = pemCertNode.getNode("jcr:content")).hasProperty("exo:videoCallCertificateFileName")) {
                    videoCallModel.setPemCertName(jcrContent.getProperty("exo:videoCallCertificateFileName").getString());
                }
                ExtendedNode node = (ExtendedNode)videoCallNode;
                if (node.canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                    node.setPermission("*:/platform/users", new String[]{"read"});
                }
                session.save();
                videoProfileCache.put((Serializable)((Object)VIDEO_PROFILE_KEY), (Object)videoCallModel);
            }
            catch (LoginException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"saveVideoCallProfile() failed because of ", (Throwable)e);
                }
            }
            catch (NoSuchWorkspaceException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"saveVideoCallProfile() failed because of ", (Throwable)e);
                }
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"saveVideoCallProfile() failed because of ", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block19;
                LOG.error((Object)"saveVideoCallProfile() failed because of ", (Throwable)e);
            }
        }
    }

    public InputStream getP12CertInputStream() {
        InputStream isP12 = null;
        SessionProvider sessionProvider = null;
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        if (repositoryService == null) {
            return null;
        }
        sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        try {
            Node p12CertNode;
            Node jcrContent;
            Node videoCallNode;
            Session session = sessionProvider.getSession(WORKSPACE_NAME, repositoryService.getCurrentRepository());
            Node rootNode = session.getRootNode();
            Node baseNode = rootNode.getNode(BASE_PATH);
            if (baseNode.hasNode(VIDEOCALL_BASE_PATH) && (videoCallNode = baseNode.getNode(VIDEOCALL_BASE_PATH)).hasNode(VIDEO_P12_CERT_NODE_NAME) && (jcrContent = (p12CertNode = videoCallNode.getNode(VIDEO_P12_CERT_NODE_NAME)).getNode("jcr:content")) != null && jcrContent.getProperty("jcr:data") != null) {
                isP12 = jcrContent.getProperty("jcr:data").getStream();
            }
        }
        catch (LoginException e) {
            LOG.warn((Object)e.getMessage());
        }
        catch (NoSuchWorkspaceException e) {
            LOG.warn((Object)e.getMessage());
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage());
        }
        return isP12;
    }

    public InputStream getPemCertInputStream() {
        InputStream isPem = null;
        SessionProvider sessionProvider = null;
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        if (repositoryService == null) {
            return null;
        }
        sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        try {
            Node p12CertNode;
            Node jcrContent;
            Node videoCallNode;
            Session session = sessionProvider.getSession(WORKSPACE_NAME, repositoryService.getCurrentRepository());
            Node rootNode = session.getRootNode();
            Node baseNode = rootNode.getNode(BASE_PATH);
            if (baseNode.hasNode(VIDEOCALL_BASE_PATH) && (videoCallNode = baseNode.getNode(VIDEOCALL_BASE_PATH)).hasNode(VIDEO_PEM_CERT_NODE_NAME) && (jcrContent = (p12CertNode = videoCallNode.getNode(VIDEO_PEM_CERT_NODE_NAME)).getNode("jcr:content")) != null && jcrContent.getProperty("jcr:data") != null) {
                isPem = jcrContent.getProperty("jcr:data").getStream();
            }
        }
        catch (LoginException e) {
            LOG.warn((Object)e.getMessage());
        }
        catch (NoSuchWorkspaceException e) {
            LOG.warn((Object)e.getMessage());
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage());
        }
        return isPem;
    }

    public VideoCallModel getVideoCallProfile() {
        VideoCallModel videoCallModel = null;
        if (videoProfileCache != null && videoProfileCache.get((Serializable)((Object)VIDEO_PROFILE_KEY)) != null) {
            videoCallModel = (VideoCallModel)videoProfileCache.get((Serializable)((Object)VIDEO_PROFILE_KEY));
        } else {
            SessionProvider sessionProvider = null;
            RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            if (repositoryService == null) {
                return null;
            }
            sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            try {
                Session session = sessionProvider.getSession(WORKSPACE_NAME, repositoryService.getCurrentRepository());
                Node rootNode = session.getRootNode();
                Node baseNode = rootNode.getNode(BASE_PATH);
                if (baseNode.hasNode(VIDEOCALL_BASE_PATH)) {
                    Node jcrContent;
                    Node videoCallNode = baseNode.getNode(VIDEOCALL_BASE_PATH);
                    videoCallModel = new VideoCallModel();
                    videoCallModel.setWeemoKey(videoCallNode.getProperty(WEEMOKEY_PROP).getString());
                    videoCallModel.setDisableVideoCall(videoCallNode.getProperty(DISABLEVIDEOCALL_PROP).getString());
                    videoCallModel.setProfileId(videoCallNode.getProperty(VIDEO_PROFILE_ID).getString());
                    if (videoCallNode.hasProperty(VIDEO_DOMAIN_ID)) {
                        videoCallModel.setDomainId(videoCallNode.getProperty(VIDEO_DOMAIN_ID).getString());
                    }
                    if (videoCallNode.hasProperty(VIDEO_PERMISSIONS_PROP)) {
                        videoCallModel.setVideoCallPermissions(videoCallNode.getProperty(VIDEO_PERMISSIONS_PROP).getString());
                    }
                    videoCallModel.setCustomerCertificatePassphrase(videoCallNode.getProperty(VIDEO_PASSPHARSE).getString());
                    videoCallModel.setAuthId(videoCallNode.getProperty(VIDEO_AUTH_ID).getString());
                    videoCallModel.setAuthSecret(videoCallNode.getProperty(VIDEO_AUTH_SECRET).getString());
                    if (videoCallNode.hasNode(VIDEO_P12_CERT_NODE_NAME)) {
                        Node p12CertNode = videoCallNode.getNode(VIDEO_P12_CERT_NODE_NAME);
                        jcrContent = p12CertNode.getNode("jcr:content");
                        if (jcrContent != null && jcrContent.getProperty("jcr:data") != null) {
                            InputStream isP12 = jcrContent.getProperty("jcr:data").getStream();
                            videoCallModel.setP12Cert(isP12);
                            videoCallModel.setP12CertName(jcrContent.getProperty("exo:videoCallCertificateFileName").getString());
                        }
                    } else {
                        videoCallModel.setP12Cert(null);
                        videoCallModel.setP12CertName("");
                    }
                    if (videoCallNode.hasNode(VIDEO_PEM_CERT_NODE_NAME)) {
                        Node pemCertNode = videoCallNode.getNode(VIDEO_PEM_CERT_NODE_NAME);
                        jcrContent = pemCertNode.getNode("jcr:content");
                        if (jcrContent != null && jcrContent.getProperty("jcr:data") != null) {
                            InputStream isPem = jcrContent.getProperty("jcr:data").getStream();
                            videoCallModel.setPemCert(isPem);
                            videoCallModel.setPemCertName(jcrContent.getProperty("exo:videoCallCertificateFileName").getString());
                        }
                    } else {
                        videoCallModel.setPemCert(null);
                        videoCallModel.setPemCertName("");
                    }
                    videoProfileCache.put((Serializable)((Object)VIDEO_PROFILE_KEY), (Object)videoCallModel);
                }
            }
            catch (LoginException e) {
                LOG.warn((Object)e.getMessage());
            }
            catch (NoSuchWorkspaceException e) {
                LOG.warn((Object)e.getMessage());
            }
            catch (RepositoryException e) {
                LOG.warn((Object)e.getMessage());
            }
        }
        return videoCallModel;
    }

    public String getWeemoKey() {
        String weemoKey = null;
        VideoCallModel videoCallModel = null;
        videoCallModel = videoProfileCache != null && videoProfileCache.get((Serializable)((Object)VIDEO_PROFILE_KEY)) != null ? (VideoCallModel)videoProfileCache.get((Serializable)((Object)VIDEO_PROFILE_KEY)) : this.getVideoCallProfile();
        if (videoCallModel != null) {
            weemoKey = videoCallModel.getWeemoKey();
        }
        return weemoKey;
    }

    public boolean isExistVideoCallProfile() {
        boolean isExist;
        block10: {
            isExist = false;
            VideoCallModel videoCallModel = null;
            if (videoProfileCache != null && videoProfileCache.get((Serializable)((Object)VIDEO_PROFILE_KEY)) != null) {
                videoCallModel = (VideoCallModel)videoProfileCache.get((Serializable)((Object)VIDEO_PROFILE_KEY));
                if (videoCallModel != null) {
                    isExist = true;
                }
            } else {
                SessionProvider sessionProvider = null;
                RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
                sessionProvider = WCMCoreUtils.getSystemSessionProvider();
                try {
                    Session session = sessionProvider.getSession(WORKSPACE_NAME, repositoryService.getCurrentRepository());
                    Node rootNode = session.getRootNode();
                    Node baseNode = rootNode.getNode(BASE_PATH);
                    if (baseNode.hasNode(VIDEOCALL_BASE_PATH)) {
                        isExist = true;
                    }
                }
                catch (LoginException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"isExistVideoCallProfile() failed because of ", (Throwable)e);
                    }
                }
                catch (NoSuchWorkspaceException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"isExistVideoCallProfile() failed because of ", (Throwable)e);
                    }
                }
                catch (RepositoryException e) {
                    if (!LOG.isErrorEnabled()) break block10;
                    LOG.error((Object)"isExistVideoCallProfile() failed because of ", (Throwable)e);
                }
            }
        }
        return isExist;
    }

    public boolean isTurnOffVideoCall() throws Exception {
        VideoCallModel videoCallModel = null;
        videoCallModel = videoProfileCache != null && videoProfileCache.get((Serializable)((Object)VIDEO_PROFILE_KEY)) != null ? (VideoCallModel)videoProfileCache.get((Serializable)((Object)VIDEO_PROFILE_KEY)) : this.getVideoCallProfile();
        if (videoCallModel == null) {
            return true;
        }
        String str = videoCallModel.getDisableVideoCall();
        return Boolean.valueOf(str) != false;
    }

    public boolean isTurnOffVideoCallForUser() throws Exception {
        return this.isTurnOffVideoCallForUser(false);
    }

    public boolean isTurnOffVideoCallForUser(boolean isGroupCall) throws Exception {
        return this.isTurnOffVideoCallForUser(isGroupCall, null);
    }

    public boolean isTurnOffVideoCallForUser(boolean isGroupCall, String user) throws Exception {
        Identity userIdentity;
        boolean isTurnOff = true;
        VideoCallModel videoCallModel = null;
        videoCallModel = videoProfileCache != null && videoProfileCache.get((Serializable)((Object)VIDEO_PROFILE_KEY)) != null ? (VideoCallModel)videoProfileCache.get((Serializable)((Object)VIDEO_PROFILE_KEY)) : this.getVideoCallProfile();
        if (videoCallModel == null) {
            return true;
        }
        String str = videoCallModel.getDisableVideoCall();
        if (Boolean.valueOf(str).booleanValue()) {
            return true;
        }
        String videoCallsPermissions = videoCallModel.getVideoCallPermissions();
        if (StringUtils.isEmpty((String)videoCallsPermissions)) {
            return true;
        }
        String userId = user;
        if (StringUtils.isEmpty((String)user)) {
            userId = ConversationState.getCurrent().getIdentity().getUserId();
        }
        if ((userIdentity = ((IdentityRegistry)WCMCoreUtils.getService(IdentityRegistry.class)).getIdentity(userId)) == null) {
            return true;
        }
        HashMap<String, String> permissionsMap = new HashMap<String, String>();
        String[] arrs = videoCallsPermissions.split(",");
        ArrayList<String> memberships = new ArrayList<String>();
        for (String string : arrs) {
            if (string.split("#").length < 3) continue;
            String permission = string.split("#")[0];
            String value = isGroupCall ? string.split("#")[2] : string.split("#")[1];
            permissionsMap.put(permission, value);
            if (!permission.contains(":")) continue;
            memberships.add(permission);
        }
        if (permissionsMap.get(userId) != null) {
            return Boolean.valueOf((String)permissionsMap.get(userId)) == false;
        }
        UserACL userACL = (UserACL)WCMCoreUtils.getService(UserACL.class);
        for (String string : memberships) {
            boolean value;
            if (!userACL.hasPermission(userIdentity, string) || !(value = Boolean.valueOf((String)permissionsMap.get(string)).booleanValue())) continue;
            return !value;
        }
        return isTurnOff;
    }

    static {
        VIDEO_PROFILE_KEY = "videoCallsProfile" + CommonsUtils.getRepository().getConfiguration().getName();
        BASE_PATH = "exo:applications";
        VIDEOCALL_BASE_PATH = "VideoCallsProfile";
        VIDEOCALL_NODETYPE = "exo:videoCallProfile";
        DISABLEVIDEOCALL_PROP = "exo:disableVideoCall";
        WEEMOKEY_PROP = "exo:weemoKey";
        VIDEO_PERMISSIONS_PROP = "exo:videoCallPermissions";
        VIDEO_PASSPHARSE = "exo:passPhrase";
        VIDEO_AUTH_ID = "exo:authId";
        VIDEO_AUTH_SECRET = "exo:authSecret";
        VIDEO_P12_CERT_NODE_NAME = "p12Cert";
        VIDEO_PEM_CERT_NODE_NAME = "pemCert";
        VIDEO_CERT_MIXIN_NAME = "exo:videoCallCertificate";
        VIDEO_PROFILE_ID = "exo:profileId";
        VIDEO_DOMAIN_ID = "exo:domainId";
        tokenKey = null;
        LOG = ExoLogger.getLogger((String)VideoCallService.class.getName());
    }
}

