/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portlet.videocall;

import java.io.InputStream;
import java.util.Properties;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import juzu.Path;
import juzu.Response;
import juzu.View;
import juzu.request.SecurityContext;
import juzu.template.Template;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.model.videocall.VideoCallModel;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.videocall.AuthService;
import org.exoplatform.services.videocall.VideoCallService;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONObject;

public class VideoCallApplication {
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    String remoteUser_ = null;
    OrganizationService organizationService_;
    SpaceService spaceService_;
    VideoCallService videoCallService_;
    ConversationRegistry conversationRegistry_;

    @Inject
    public VideoCallApplication(OrganizationService organizationService, SpaceService spaceService, VideoCallService videoCallService, ConversationRegistry conversationRegistry) {
        this.organizationService_ = organizationService;
        this.spaceService_ = spaceService;
        this.videoCallService_ = videoCallService;
        this.conversationRegistry_ = conversationRegistry;
    }

    @View
    public Response.Content index(SecurityContext securityContext) throws Exception {
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        HttpSession httpSession = requestContext.getRequest().getSession();
        this.remoteUser_ = securityContext.getRemoteUser();
        VideoCallModel videoCallModel = this.videoCallService_.getVideoCallProfile();
        if (videoCallModel == null) {
            videoCallModel = new VideoCallModel();
        }
        String weemoKey = videoCallModel.getWeemoKey();
        String tokenKey = null;
        tokenKey = httpSession.getAttribute("tokenKey") != null ? httpSession.getAttribute("tokenKey").toString() : this.videoCallService_.getTokenKey();
        AuthService authService = new AuthService();
        if (tokenKey == null) {
            String profile_id = videoCallModel.getProfileId();
            String content = authService.authenticate(null, profile_id);
            if (!StringUtils.isEmpty((CharSequence)content)) {
                JSONObject json = new JSONObject(content);
                tokenKey = json.get("token").toString();
                httpSession.setAttribute("tokenKey", (Object)tokenKey);
                this.videoCallService_.setTokenKey(tokenKey);
            } else {
                tokenKey = "";
                this.videoCallService_.setTokenKey("");
            }
        }
        String videoCallVersion = null;
        InputStream isProperties = this.videoCallService_.getClass().getResourceAsStream("/extension.properties");
        if (isProperties != null) {
            Properties properties = new Properties();
            properties.load(isProperties);
            videoCallVersion = properties.getProperty("videocall.version");
        }
        videoCallVersion = videoCallVersion == null ? "" : videoCallVersion;
        boolean turnOffVideoCallForUser = this.videoCallService_.isTurnOffVideoCallForUser();
        boolean turnOffVideoGroupCallForUser = this.videoCallService_.isTurnOffVideoCallForUser(true);
        boolean turnOffVideoCall = this.videoCallService_.isTurnOffVideoCall();
        boolean isSameUserLogged = false;
        if (!this.remoteUser_.equals("__anonim_") && this.conversationRegistry_.getStateKeys(this.remoteUser_).size() > 1) {
            isSameUserLogged = true;
        }
        return this.index.with().set("user", (Object)this.remoteUser_).set("weemoKey", (Object)weemoKey).set("tokenKey", (Object)tokenKey).set("turnOffVideoCallForUser", (Object)turnOffVideoCallForUser).set("turnOffVideoGroupCallForUser", (Object)turnOffVideoGroupCallForUser).set("turnOffVideoCall", (Object)turnOffVideoCall).set("videoCallVersion", (Object)videoCallVersion).set("isSameUserLogged", (Object)isSameUserLogged).ok();
    }
}

