/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.macro.video;

import java.util.Collections;
import java.util.List;
import org.exoplatform.commons.embedder.Embedder;
import org.exoplatform.commons.embedder.EmbedderFactory;
import org.exoplatform.commons.embedder.ExoMedia;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.wiki.macro.video.VideoMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component(value="video")
public class VideoMacro
extends AbstractMacro<VideoMacroParameters> {
    public static final String MACRO_CATEGORY_OTHER = "Other";
    private static final String DESCRIPTION = "Displays a video";

    public VideoMacro() {
        super("Video", DESCRIPTION, VideoMacroParameters.class);
        this.setDefaultCategory(MACRO_CATEGORY_OTHER);
    }

    public List<Block> execute(VideoMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        StringBuilder rawContent = new StringBuilder(100);
        String src = parameters.getSrc();
        int widthParameter = parameters.getWidth();
        int heightParameter = parameters.getHeight();
        int width = 600;
        int height = 400;
        if (widthParameter > 0) {
            width = widthParameter;
            height = heightParameter > 0 ? heightParameter : (int)((double)width / 1.5);
        } else if (heightParameter > 0) {
            height = heightParameter;
            width = (int)((double)heightParameter * 1.5);
        }
        Embedder embedder = EmbedderFactory.getInstance((String)src);
        ExoMedia exoSocialMedia = embedder.getExoMedia();
        if (exoSocialMedia != null) {
            rawContent.append(exoSocialMedia.getHtml());
        } else {
            int indexQuery = src.indexOf("?");
            String srcWithoutQuery = indexQuery > 0 ? src.substring(0, indexQuery) : src;
            MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
            String mimeType = mimeTypeResolver.getMimeType(srcWithoutQuery);
            rawContent.append("<object width=\"").append(width).append("\" height=\"").append(height).append("\" type=\"").append(mimeType).append("\" data=\"").append(src).append("\"><param name=\"movie\" value=\"").append(src).append("\"></param><param name=\"allowFullScreen\" value=\"true\"></param>");
            rawContent.append("<embed width=\"").append(width).append("\" height=\"").append(height).append("\" type=\"").append(mimeType).append("\" src=\"").append(src).append("\" allowfullscreen=\"true\"></embed>");
            rawContent.append("</object>");
        }
        RawBlock panelBlock = new RawBlock(rawContent.toString(), Syntax.XHTML_1_0);
        return Collections.singletonList(panelBlock);
    }

    public boolean supportsInlineMode() {
        return true;
    }
}

