/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.migration;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.DatabaseException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.NameSpaceService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AttachmentsMigration
implements CustomTaskChange {
    private static final Log LOG = ExoLogger.getLogger(AttachmentsMigration.class);
    private static String PAGE_ATTACHMENTS_COUNT = "select count(*) from WIKI_PAGE_ATTACHMENTS";
    private static String DRAFT_ATTACHMENTS_COUNT = "select count(*) from WIKI_DRAFT_ATTACHMENTS";
    private static String PAGE_ATTACHMENTS_SELECT_QUERY = "select P.ATTACHMENT_ID, P.NAME, P.CREATOR, P.CREATED_DATE, P.UPDATED_DATE, P.MIMETYPE, P.CONTENT from WIKI_PAGE_ATTACHMENTS P where P.ATTACHMENT_ID>= ? and P.ATTACHMENT_ID <?";
    private static String PAGE_ATTACHMENTS_UPDATE_QUERY = "update WIKI_PAGE_ATTACHMENTS set ATTACHMENT_FILE_ID= ? , CREATED_DATE= ?  where ATTACHMENT_ID = ?";
    private static String DRAFT_ATTACHMENTS_SELECT_QUERY = "select P.ATTACHMENT_ID, P.NAME, P.CREATOR, P.CREATED_DATE, P.UPDATED_DATE, P.MIMETYPE, P.CONTENT from WIKI_DRAFT_ATTACHMENTS P  where P.ATTACHMENT_ID>= ? and P.ATTACHMENT_ID <?";
    private static String DRAFT_ATTACHMENTS_UPDATE_QUERY = "update WIKI_DRAFT_ATTACHMENTS set ATTACHMENT_FILE_ID= ? , CREATED_DATE= ? where ATTACHMENT_ID = ?";
    private PreparedStatement findPageAttachment;
    private PreparedStatement findDraftAttachment;
    private PreparedStatement updatePageAttachment;
    private PreparedStatement updateDraftAttachment;
    private PreparedStatement findPageAttachmentCount;
    private PreparedStatement findDraftAttachmentCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Database database) throws CustomChangeException {
        JdbcConnection dbConn = (JdbcConnection)database.getConnection();
        FileService fileService = (FileService)CommonsUtils.getService(FileService.class);
        NameSpaceService nameService = (NameSpaceService)CommonsUtils.getService(NameSpaceService.class);
        ResultSet attachmentSet = null;
        int errorNumber = 0;
        int pageSize = 100;
        int toId = 0;
        long startTime = System.currentTimeMillis();
        boolean autoCommit = false;
        try (PreparedStatement findPageAttachment_ = dbConn.prepareStatement(PAGE_ATTACHMENTS_SELECT_QUERY);
             PreparedStatement findDraftAttachment_ = dbConn.prepareStatement(DRAFT_ATTACHMENTS_SELECT_QUERY);
             PreparedStatement updatePageAttachment_ = dbConn.prepareStatement(PAGE_ATTACHMENTS_UPDATE_QUERY);
             PreparedStatement updateDraftAttachment_ = dbConn.prepareStatement(DRAFT_ATTACHMENTS_UPDATE_QUERY);
             PreparedStatement findPageAttachmentCount_ = dbConn.prepareStatement(PAGE_ATTACHMENTS_COUNT);
             PreparedStatement findDraftAttachmentCount_ = dbConn.prepareStatement(DRAFT_ATTACHMENTS_COUNT);){
            Timestamp createdDate;
            FileItem fileItem;
            Date updatedDate;
            long contentSize;
            byte[] content;
            long id;
            int fromId;
            int start;
            this.findPageAttachment = findPageAttachment_;
            this.findDraftAttachment = findDraftAttachment_;
            this.updatePageAttachment = updatePageAttachment_;
            this.updateDraftAttachment = updateDraftAttachment_;
            this.findPageAttachmentCount = findPageAttachmentCount_;
            this.findDraftAttachmentCount = findDraftAttachmentCount_;
            autoCommit = dbConn.getAutoCommit();
            dbConn.setAutoCommit(false);
            nameService.createNameSpace("wiki", "wiki application files");
            int attachmentSize = this.findPageAttachmentCount() + this.findDraftAttachmentCount();
            int count = 0;
            LOG.info((Object)"=== Start Wiki attachments migration to FILES RDBMS");
            startTime = System.currentTimeMillis();
            boolean hasNext = true;
            while (hasNext) {
                start = count;
                fromId = toId;
                toId = fromId + pageSize;
                attachmentSet = this.findPageAttachment(fromId, toId);
                while (attachmentSet.next()) {
                    ++count;
                    id = attachmentSet.getLong("ATTACHMENT_ID");
                    LOG.info("Start Migration page attachment id {}", new Object[]{id});
                    content = attachmentSet.getBytes("CONTENT");
                    contentSize = 0L;
                    updatedDate = null;
                    if (content != null) {
                        contentSize = content.length;
                    }
                    try {
                        if (attachmentSet.getTimestamp("UPDATED_DATE") != null) {
                            updatedDate = new Date(attachmentSet.getTimestamp("UPDATED_DATE").getTime());
                        }
                        fileItem = new FileItem(null, attachmentSet.getString("NAME"), attachmentSet.getString("MIMETYPE"), "wiki", contentSize, updatedDate, attachmentSet.getString("CREATOR"), false, (InputStream)new ByteArrayInputStream(content));
                        if ((fileItem = fileService.writeFile(fileItem)).getFileInfo().getId() != null) {
                            createdDate = attachmentSet.getTimestamp("CREATED_DATE");
                            this.updatePageAttachment(id, fileItem.getFileInfo().getId(), createdDate);
                            dbConn.commit();
                        }
                        LOG.info("Migration page attachment id {} Done, progress {}/{}", new Object[]{id, count, attachmentSize});
                    }
                    catch (Exception e) {
                        ++errorNumber;
                        LOG.error((Object)("Error while migrate Wiki Page Attachment  ID = " + id + "  data to File RDBMS - Cause : " + e.getMessage()), (Throwable)e);
                    }
                }
                if (count != start) continue;
                hasNext = false;
            }
            hasNext = true;
            toId = 0;
            while (hasNext) {
                start = count;
                fromId = toId;
                toId = fromId + pageSize;
                attachmentSet = this.findDraftAttachment(fromId, toId);
                while (attachmentSet.next()) {
                    ++count;
                    id = attachmentSet.getLong("ATTACHMENT_ID");
                    LOG.info("Start Migration draft attachment id {}", new Object[]{id});
                    content = attachmentSet.getBytes("CONTENT");
                    contentSize = 0L;
                    updatedDate = null;
                    if (content != null) {
                        contentSize = content.length;
                    }
                    try {
                        if (attachmentSet.getTimestamp("UPDATED_DATE") != null) {
                            updatedDate = new Date(attachmentSet.getTimestamp("UPDATED_DATE").getTime());
                        }
                        fileItem = new FileItem(null, attachmentSet.getString("NAME"), attachmentSet.getString("MIMETYPE"), "wiki", contentSize, updatedDate, attachmentSet.getString("CREATOR"), false, (InputStream)new ByteArrayInputStream(content));
                        if ((fileItem = fileService.writeFile(fileItem)).getFileInfo().getId() != null) {
                            createdDate = attachmentSet.getTimestamp("CREATED_DATE");
                            this.updateDraftAttachment(id, fileItem.getFileInfo().getId(), createdDate);
                            dbConn.commit();
                        }
                        LOG.info("Migration draft attachment id {} Done, progress {}/{}", new Object[]{id, count, attachmentSize});
                    }
                    catch (Exception e) {
                        ++errorNumber;
                        LOG.error((Object)("Error while migrate Wiki Draft Attachment ID = " + id + " data to File RDBMS - Cause : " + e.getMessage()), (Throwable)e);
                    }
                }
                if (count != start) continue;
                hasNext = false;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("cannot start Attachments migration  - Cause : " + e.getMessage()), (Throwable)e);
        }
        finally {
            long endTime = System.currentTimeMillis();
            if (errorNumber == 0) {
                LOG.info((Object)"No error during migration");
            } else {
                LOG.info((Object)("Numbers of wiki attachments in error during migration attachment to File Rdbms = " + errorNumber));
            }
            LOG.info((Object)("===  Wiki attachments migration to File RDBMS done in " + (endTime - startTime) + " ms"));
            try {
                attachmentSet.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Error during close ResultSet  - Cause : " + e.getMessage()), (Throwable)e);
            }
            try {
                dbConn.setAutoCommit(autoCommit);
            }
            catch (DatabaseException e) {
                LOG.error((Object)("Error during set AutoCommit  - Cause : " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    private ResultSet findPageAttachment(long from, long to) throws SQLException, DatabaseException {
        this.findPageAttachment.clearParameters();
        this.findPageAttachment.setLong(1, from);
        this.findPageAttachment.setLong(2, to);
        return this.findPageAttachment.executeQuery();
    }

    private ResultSet findDraftAttachment(long from, long to) throws SQLException, DatabaseException {
        this.findDraftAttachment.clearParameters();
        this.findDraftAttachment.setLong(1, from);
        this.findDraftAttachment.setLong(2, to);
        return this.findDraftAttachment.executeQuery();
    }

    private int updatePageAttachment(long id, long fileID, Timestamp created) throws SQLException {
        this.updatePageAttachment.clearParameters();
        this.updatePageAttachment.setLong(1, fileID);
        this.updatePageAttachment.setTimestamp(2, created);
        this.updatePageAttachment.setLong(3, id);
        return this.updatePageAttachment.executeUpdate();
    }

    private int updateDraftAttachment(long id, long fileID, Timestamp created) throws SQLException {
        this.updateDraftAttachment.clearParameters();
        this.updateDraftAttachment.setLong(1, fileID);
        this.updateDraftAttachment.setTimestamp(2, created);
        this.updateDraftAttachment.setLong(3, id);
        return this.updateDraftAttachment.executeUpdate();
    }

    private int findPageAttachmentCount() throws SQLException {
        try (ResultSet count = this.findPageAttachmentCount.executeQuery();){
            if (count.next()) {
                int n = count.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
    }

    private int findDraftAttachmentCount() throws SQLException {
        try (ResultSet count = this.findDraftAttachmentCount.executeQuery();){
            if (count.next()) {
                int n = count.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
    }
}

