/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.es.domain.Document;
import org.exoplatform.addons.es.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.jpa.dao.PageDAO;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.PermissionEntity;
import org.exoplatform.wiki.mow.api.WikiType;
import org.json.simple.JSONObject;

public class WikiPageIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    private static final Log LOGGER = ExoLogger.getExoLogger(WikiPageIndexingServiceConnector.class);
    public static final String TYPE = "wiki-page";
    private final PageDAO dao;

    public WikiPageIndexingServiceConnector(InitParams initParams, PageDAO dao) {
        super(initParams);
        this.dao = dao;
    }

    public String getMapping() {
        JSONObject notAnalyzedField = new JSONObject();
        notAnalyzedField.put((Object)"type", (Object)"string");
        notAnalyzedField.put((Object)"index", (Object)"not_analyzed");
        JSONObject fastVectorHighlighterField = new JSONObject();
        fastVectorHighlighterField.put((Object)"type", (Object)"string");
        fastVectorHighlighterField.put((Object)"term_vector", (Object)"with_positions_offsets");
        fastVectorHighlighterField.put((Object)"store", (Object)true);
        JSONObject postingHighlighterField = new JSONObject();
        postingHighlighterField.put((Object)"type", (Object)"string");
        postingHighlighterField.put((Object)"index_options", (Object)"offsets");
        JSONObject properties = new JSONObject();
        properties.put((Object)"permissions", (Object)notAnalyzedField);
        properties.put((Object)"url", (Object)notAnalyzedField);
        properties.put((Object)"sites", (Object)notAnalyzedField);
        properties.put((Object)"wikiType", (Object)notAnalyzedField);
        properties.put((Object)"wikiOwner", (Object)notAnalyzedField);
        properties.put((Object)"name", (Object)postingHighlighterField);
        properties.put((Object)"title", (Object)postingHighlighterField);
        properties.put((Object)"content", (Object)fastVectorHighlighterField);
        properties.put((Object)"comment", (Object)postingHighlighterField);
        JSONObject mappingProperties = new JSONObject();
        mappingProperties.put((Object)"properties", (Object)properties);
        JSONObject mappingJSON = new JSONObject();
        mappingJSON.put((Object)this.getType(), (Object)mappingProperties);
        return mappingJSON.toJSONString();
    }

    public Document create(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Id is null");
        }
        PageEntity page = (PageEntity)this.dao.find(Long.valueOf(Long.parseLong(id)));
        if (page == null) {
            LOGGER.info("The page entity with id {} doesn't exist.", new Object[]{id});
            return null;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("owner", page.getOwner());
        fields.put("name", page.getName());
        fields.put("content", page.getContent());
        fields.put("title", page.getTitle());
        fields.put("createdDate", String.valueOf(page.getCreatedDate().getTime()));
        fields.put("updatedDate", String.valueOf(page.getUpdatedDate().getTime()));
        fields.put("comment", page.getComment());
        fields.put("wikiType", page.getWiki().getType());
        String wikiOwner = page.getWiki().getOwner();
        if (page.getWiki().getType().toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.dao.validateGroupWikiOwner(wikiOwner);
        }
        fields.put("wikiOwner", wikiOwner);
        return new Document(TYPE, id, page.getUrl(), page.getUpdatedDate(), this.computePermissions(page), fields);
    }

    public Document update(String id) {
        return this.create(id);
    }

    private String[] computePermissions(PageEntity page) {
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add(page.getOwner());
        if (page.getPermissions() != null) {
            for (PermissionEntity permission : page.getPermissions()) {
                permissions.add(permission.getIdentity());
            }
        }
        String[] result = new String[permissions.size()];
        return permissions.toArray(result);
    }

    public List<String> getAllIds(int offset, int limit) {
        ArrayList<String> result;
        List<Long> ids = this.dao.findAllIds(offset, limit);
        if (ids == null) {
            result = new ArrayList<String>(0);
        } else {
            result = new ArrayList(ids.size());
            for (Long id : ids) {
                result.add(String.valueOf(id));
            }
        }
        return result;
    }
}

