/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.writeinldap.listeners;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.writeinldap.services.ActiveDirectoryService;

@Asynchronous
public class UpdateUserEventListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(UpdateUserEventListener.class);

    public void postSave(User user, boolean isNew) throws Exception {
        ExoContainer pcontainer = ExoContainerContext.getCurrentContainer();
        ActiveDirectoryService adService = (ActiveDirectoryService)pcontainer.getComponentInstanceOfType(ActiveDirectoryService.class);
        if (adService.isFeatureEnabled() && !user.getUserName().equals("root") && adService.mustBeUpdated(user, isNew)) {
            LOG.info("User {} is modified from AD, push the modification", new Object[]{user.getUserName()});
            adService.saveModification(user);
        }
    }

    public void postSetEnabled(User user) throws Exception {
        ExoContainer pcontainer = ExoContainerContext.getCurrentContainer();
        ActiveDirectoryService adService = (ActiveDirectoryService)pcontainer.getComponentInstanceOfType(ActiveDirectoryService.class);
        if (adService.isFeatureEnabled() && !user.getUserName().equals("root")) {
            LOG.info("Status change for user {}, push the modification", new Object[]{user.getUserName()});
            adService.setEnabled(user);
        }
    }
}

