/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.model;

import java.time.ZonedDateTime;
import org.exoplatform.agenda.constant.ReminderPeriodType;
import org.exoplatform.agenda.model.EventReminderParameter;

public class EventReminder
extends EventReminderParameter
implements Cloneable {
    private static final long serialVersionUID = -7068947528529938343L;
    private long id;
    private long eventId;
    private long receiverId;
    private volatile ZonedDateTime datetime;

    public EventReminder(long id, long eventId, long receiverId, int before, ReminderPeriodType beforePeriodType, ZonedDateTime datetime) {
        this.id = id;
        this.eventId = eventId;
        this.receiverId = receiverId;
        this.datetime = datetime;
        this.setBefore(before);
        this.setBeforePeriodType(beforePeriodType);
    }

    public EventReminder(long id, long eventId, long receiverId, int before, ReminderPeriodType beforePeriodType) {
        this.id = id;
        this.eventId = eventId;
        this.receiverId = receiverId;
        this.setBefore(before);
        this.setBeforePeriodType(beforePeriodType);
    }

    public EventReminder(long receiverId, int before, ReminderPeriodType beforePeriodType) {
        this.receiverId = receiverId;
        this.setBefore(before);
        this.setBeforePeriodType(beforePeriodType);
    }

    public EventReminder clone() {
        return new EventReminder(this.id, this.eventId, this.receiverId, this.getBefore(), this.getBeforePeriodType(), this.datetime);
    }

    public long getId() {
        return this.id;
    }

    public long getEventId() {
        return this.eventId;
    }

    public long getReceiverId() {
        return this.receiverId;
    }

    public ZonedDateTime getDatetime() {
        return this.datetime;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setEventId(long eventId) {
        this.eventId = eventId;
    }

    public void setReceiverId(long receiverId) {
        this.receiverId = receiverId;
    }

    public void setDatetime(ZonedDateTime datetime) {
        this.datetime = datetime;
    }

    @Override
    public String toString() {
        return "EventReminder(id=" + this.getId() + ", eventId=" + this.getEventId() + ", receiverId=" + this.getReceiverId() + ", datetime=" + this.getDatetime() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventReminder)) {
            return false;
        }
        EventReminder other = (EventReminder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getEventId() != other.getEventId()) {
            return false;
        }
        if (this.getReceiverId() != other.getReceiverId()) {
            return false;
        }
        ZonedDateTime this$datetime = this.getDatetime();
        ZonedDateTime other$datetime = other.getDatetime();
        return !(this$datetime == null ? other$datetime != null : !((Object)this$datetime).equals(other$datetime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EventReminder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $eventId = this.getEventId();
        result = result * 59 + (int)($eventId >>> 32 ^ $eventId);
        long $receiverId = this.getReceiverId();
        result = result * 59 + (int)($receiverId >>> 32 ^ $receiverId);
        ZonedDateTime $datetime = this.getDatetime();
        result = result * 59 + ($datetime == null ? 43 : ((Object)$datetime).hashCode());
        return result;
    }

    public EventReminder() {
    }
}

