/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.model;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.constant.ReminderPeriodType;

public class EventReminderParameter
implements Serializable {
    private static final long serialVersionUID = -2033232204026792697L;
    private static final String SEPARATOR = " ";
    private int before;
    private ReminderPeriodType beforePeriodType;
    private String periodType;

    public EventReminderParameter(int before, ReminderPeriodType beforePeriodType) {
        this.before = before;
        this.beforePeriodType = beforePeriodType;
    }

    public ReminderPeriodType getBeforePeriodType() {
        if (this.beforePeriodType == null && StringUtils.isNotBlank((CharSequence)this.periodType)) {
            this.beforePeriodType = ReminderPeriodType.valueOf(this.periodType);
        }
        return this.beforePeriodType;
    }

    public String toString() {
        return this.before + SEPARATOR + this.beforePeriodType;
    }

    public static EventReminderParameter fromString(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        String[] values = value.split(SEPARATOR);
        EventReminderParameter reminderParameter = new EventReminderParameter();
        reminderParameter.setBefore(Integer.parseInt(values[0]));
        reminderParameter.setBeforePeriodType(ReminderPeriodType.valueOf(values[1]));
        return reminderParameter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventReminderParameter)) {
            return false;
        }
        EventReminderParameter other = (EventReminderParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBefore() != other.getBefore()) {
            return false;
        }
        ReminderPeriodType this$beforePeriodType = this.getBeforePeriodType();
        ReminderPeriodType other$beforePeriodType = other.getBeforePeriodType();
        return !(this$beforePeriodType == null ? other$beforePeriodType != null : !((Object)((Object)this$beforePeriodType)).equals((Object)other$beforePeriodType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventReminderParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBefore();
        ReminderPeriodType $beforePeriodType = this.getBeforePeriodType();
        result = result * 59 + ($beforePeriodType == null ? 43 : ((Object)((Object)$beforePeriodType)).hashCode());
        return result;
    }

    public EventReminderParameter() {
    }

    public int getBefore() {
        return this.before;
    }

    public void setBefore(int before) {
        this.before = before;
    }

    public void setBeforePeriodType(ReminderPeriodType beforePeriodType) {
        this.beforePeriodType = beforePeriodType;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }
}

