/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.model;

import java.util.HashSet;
import java.util.Set;
import org.exoplatform.agenda.constant.AgendaEventModificationType;

public class AgendaEventModification {
    private long eventId;
    private long calendarId;
    private long modifierId;
    private Set<AgendaEventModificationType> modificationTypes;

    public AgendaEventModification(long eventId, long calendarId, long modifierId) {
        this.eventId = eventId;
        this.calendarId = calendarId;
        this.modifierId = modifierId;
    }

    public void addModificationType(AgendaEventModificationType modificationType) {
        if (this.modificationTypes == null) {
            this.modificationTypes = new HashSet<AgendaEventModificationType>();
        }
        this.modificationTypes.add(modificationType);
    }

    public void removeModification(AgendaEventModificationType modificationType) {
        if (this.modificationTypes != null) {
            this.modificationTypes.remove((Object)modificationType);
        }
    }

    public boolean hasModification(AgendaEventModificationType modificationType) {
        return this.modificationTypes != null && this.modificationTypes.contains((Object)modificationType);
    }

    public boolean hasModifiedDate() {
        return this.modificationTypes != null && (this.modificationTypes.contains((Object)AgendaEventModificationType.START_DATE_UPDATED) || this.modificationTypes.contains((Object)AgendaEventModificationType.END_DATE_UPDATED));
    }

    public void addModificationTypes(Set<AgendaEventModificationType> eventModifications) {
        if (eventModifications != null && !eventModifications.isEmpty()) {
            this.modificationTypes.addAll(eventModifications);
        }
    }

    public long getEventId() {
        return this.eventId;
    }

    public long getCalendarId() {
        return this.calendarId;
    }

    public long getModifierId() {
        return this.modifierId;
    }

    public Set<AgendaEventModificationType> getModificationTypes() {
        return this.modificationTypes;
    }

    public void setEventId(long eventId) {
        this.eventId = eventId;
    }

    public void setCalendarId(long calendarId) {
        this.calendarId = calendarId;
    }

    public void setModifierId(long modifierId) {
        this.modifierId = modifierId;
    }

    public void setModificationTypes(Set<AgendaEventModificationType> modificationTypes) {
        this.modificationTypes = modificationTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgendaEventModification)) {
            return false;
        }
        AgendaEventModification other = (AgendaEventModification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEventId() != other.getEventId()) {
            return false;
        }
        if (this.getCalendarId() != other.getCalendarId()) {
            return false;
        }
        if (this.getModifierId() != other.getModifierId()) {
            return false;
        }
        Set<AgendaEventModificationType> this$modificationTypes = this.getModificationTypes();
        Set<AgendaEventModificationType> other$modificationTypes = other.getModificationTypes();
        return !(this$modificationTypes == null ? other$modificationTypes != null : !((Object)this$modificationTypes).equals(other$modificationTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgendaEventModification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $eventId = this.getEventId();
        result = result * 59 + (int)($eventId >>> 32 ^ $eventId);
        long $calendarId = this.getCalendarId();
        result = result * 59 + (int)($calendarId >>> 32 ^ $calendarId);
        long $modifierId = this.getModifierId();
        result = result * 59 + (int)($modifierId >>> 32 ^ $modifierId);
        Set<AgendaEventModificationType> $modificationTypes = this.getModificationTypes();
        result = result * 59 + ($modificationTypes == null ? 43 : ((Object)$modificationTypes).hashCode());
        return result;
    }

    public String toString() {
        return "AgendaEventModification(eventId=" + this.getEventId() + ", calendarId=" + this.getCalendarId() + ", modifierId=" + this.getModifierId() + ", modificationTypes=" + String.valueOf(this.getModificationTypes()) + ")";
    }

    public AgendaEventModification(long eventId, long calendarId, long modifierId, Set<AgendaEventModificationType> modificationTypes) {
        this.eventId = eventId;
        this.calendarId = calendarId;
        this.modifierId = modifierId;
        this.modificationTypes = modificationTypes;
    }

    public AgendaEventModification() {
    }
}

