/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Listener;

public class AgendaEventReminderCleanerListener
extends Listener<Long, Object> {
    private AgendaEventReminderService agendaEventReminderService;
    private AgendaEventService agendaEventService;

    public void onEvent(org.exoplatform.services.listener.Event<Long, Object> event) throws Exception {
        Long eventId = (Long)event.getSource();
        Event agendaEvent = this.getAgendaEventService().getEventById(eventId.longValue());
        if (agendaEvent != null && agendaEvent.getStatus() == EventStatus.CANCELLED) {
            this.getAgendaEventReminderService().removeEventReminders(eventId.longValue());
        }
    }

    public AgendaEventReminderService getAgendaEventReminderService() {
        if (this.agendaEventReminderService == null) {
            this.agendaEventReminderService = (AgendaEventReminderService)ExoContainerContext.getService(AgendaEventReminderService.class);
        }
        return this.agendaEventReminderService;
    }

    public AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)ExoContainerContext.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }
}

