/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.agenda.constant.EventAvailability;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.entity.CalendarEntity;
import org.exoplatform.agenda.entity.EventAttendeeEntity;
import org.exoplatform.agenda.entity.EventRecurrenceEntity;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="AgendaEvent")
@ExoEntity
@Table(name="EXO_AGENDA_EVENT")
@NamedQueries(value={@NamedQuery(name="AgendaEvent.deleteCalendarEvents", query="DELETE FROM AgendaEvent ev WHERE ev.calendar.id = :calendarId"), @NamedQuery(name="AgendaEvent.getExceptionalOccurenceIdsByPeriod", query="SELECT ev.id FROM AgendaEvent ev WHERE ev.parent.id = :parentEventId AND ev.occurrenceId <= :end AND ev.occurrenceId >= :start"), @NamedQuery(name="AgendaEvent.getExceptionalOccurenceIds", query="SELECT ev.id, ev.startDate FROM AgendaEvent ev WHERE ev.parent.id = :parentEventId AND ev.occurrenceId IS NOT NULL ORDER BY ev.startDate ASC"), @NamedQuery(name="AgendaEvent.getExceptionalOccurences", query="SELECT ev FROM AgendaEvent ev WHERE ev.parent.id = :parentEventId AND ev.occurrenceId IS NOT NULL"), @NamedQuery(name="AgendaEvent.getChildEvents", query="SELECT ev.id FROM AgendaEvent ev WHERE ev.parent.id = :parentEventId"), @NamedQuery(name="AgendaEvent.getParentRecurrentEventIds", query="SELECT ev FROM AgendaEvent ev WHERE ev.status = :status AND ev.recurrence.id > 0 AND ev.occurrenceId IS NULL AND ev.startDate < :end AND (ev.endDate IS NULL OR ev.endDate >= :start)")})
public class EventEntity
implements Serializable {
    private static final long serialVersionUID = -597472315530960636L;
    @Id
    @SequenceGenerator(name="SEQ_AGENDA_EVENT_ID", sequenceName="SEQ_AGENDA_EVENT_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_AGENDA_EVENT_ID")
    @Column(name="EVENT_ID")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PARENT_EVENT_ID", referencedColumnName="EVENT_ID")
    private EventEntity parent;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="CALENDAR_ID", referencedColumnName="CALENDAR_ID")
    private CalendarEntity calendar;
    @OneToMany(mappedBy="event", fetch=FetchType.LAZY)
    private List<EventAttendeeEntity> attendees;
    @OneToOne(mappedBy="event", fetch=FetchType.EAGER)
    private EventRecurrenceEntity recurrence;
    @Column(name="OCCURRENCE_ID")
    private Date occurrenceId;
    @Column(name="CREATOR_ID", nullable=false)
    private long creatorId;
    @Column(name="MODIFIER_ID", nullable=false)
    private long modifierId;
    @Column(name="TIMEZONE_ID")
    private String timeZoneId;
    @Column(name="CREATED_DATE", nullable=false)
    private Date createdDate;
    @Column(name="UPDATED_DATE")
    private Date updatedDate;
    @Column(name="ALL_DAY")
    private boolean allDay;
    @Column(name="START_DATE")
    private Date startDate;
    @Column(name="END_DATE")
    private Date endDate;
    @Column(name="SUMMARY")
    private String summary;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="LOCATION")
    private String location;
    @Column(name="COLOR")
    private String color;
    @Column(name="AVAILABILITY", nullable=false)
    private EventAvailability availability;
    @Column(name="STATUS", nullable=false)
    private EventStatus status;
    @Column(name="ALLOW_ATTENDEE_TO_UPDATE", nullable=false)
    private boolean allowAttendeeToUpdate;
    @Column(name="ALLOW_ATTENDEE_TO_INVITE", nullable=false)
    private boolean allowAttendeeToInvite;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EventEntity getParent() {
        return this.parent;
    }

    public void setParent(EventEntity parent) {
        this.parent = parent;
    }

    public CalendarEntity getCalendar() {
        return this.calendar;
    }

    public void setCalendar(CalendarEntity calendar) {
        this.calendar = calendar;
    }

    public EventRecurrenceEntity getRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(EventRecurrenceEntity recurrence) {
        this.recurrence = recurrence;
    }

    public Date getOccurrenceId() {
        return this.occurrenceId;
    }

    public void setOccurrenceId(Date occurrenceId) {
        this.occurrenceId = occurrenceId;
    }

    public long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(long creatorId) {
        this.creatorId = creatorId;
    }

    public long getModifierId() {
        return this.modifierId;
    }

    public void setModifierId(long modifierId) {
        this.modifierId = modifierId;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public void setAllDay(boolean allDay) {
        this.allDay = allDay;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public EventAvailability getAvailability() {
        return this.availability;
    }

    public void setAvailability(EventAvailability availability) {
        this.availability = availability;
    }

    public EventStatus getStatus() {
        return this.status;
    }

    public void setStatus(EventStatus status) {
        this.status = status;
    }

    public boolean isAllowAttendeeToUpdate() {
        return this.allowAttendeeToUpdate;
    }

    public void setAllowAttendeeToUpdate(boolean allowAttendeeToUpdate) {
        this.allowAttendeeToUpdate = allowAttendeeToUpdate;
    }

    public boolean isAllowAttendeeToInvite() {
        return this.allowAttendeeToInvite;
    }

    public void setAllowAttendeeToInvite(boolean allowAttendeeToInvite) {
        this.allowAttendeeToInvite = allowAttendeeToInvite;
    }
}

