/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import java.net.URI;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.exception.AgendaException;
import org.exoplatform.agenda.exception.AgendaExceptionType;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventConference;
import org.exoplatform.agenda.model.EventFilter;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.model.EventSearchResult;
import org.exoplatform.agenda.model.RemoteEvent;
import org.exoplatform.agenda.rest.model.EventAttachmentEntity;
import org.exoplatform.agenda.rest.model.EventAttendeeEntity;
import org.exoplatform.agenda.rest.model.EventEntity;
import org.exoplatform.agenda.rest.model.EventList;
import org.exoplatform.agenda.rest.model.EventReminderEntity;
import org.exoplatform.agenda.rest.model.EventSearchResultEntity;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventAttachmentService;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.AgendaEventConferenceService;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.service.AgendaRemoteEventService;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.agenda.util.EntityBuilder;
import org.exoplatform.agenda.util.RestUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.rest.entity.IdentityEntity;

@Path(value="/v1/agenda/events")
@Api(value="/v1/agenda/events", description="Manages agenda events associated to users and spaces")
public class AgendaEventRest
implements ResourceContainer {
    private static final String AGENDA_APP_URI = "agenda";
    private static final Log LOG = ExoLogger.getLogger(AgendaEventRest.class);
    private IdentityManager identityManager;
    private AgendaCalendarService agendaCalendarService;
    private AgendaEventService agendaEventService;
    private AgendaEventReminderService agendaEventReminderService;
    private AgendaEventAttendeeService agendaEventAttendeeService;
    private AgendaEventAttachmentService agendaEventAttachmentService;
    private AgendaEventConferenceService agendaEventConferenceService;
    private AgendaRemoteEventService agendaRemoteEventService;
    private String defaultSite = null;

    public AgendaEventRest(IdentityManager identityManager, UserPortalConfigService portalConfigService, AgendaCalendarService agendaCalendarService, AgendaEventService agendaEventService, AgendaEventConferenceService agendaEventConferenceService, AgendaRemoteEventService agendaRemoteEventService, AgendaEventAttachmentService agendaEventAttachmentService, AgendaEventReminderService agendaEventReminderService, AgendaEventAttendeeService agendaEventAttendeeService) {
        this.identityManager = identityManager;
        this.agendaCalendarService = agendaCalendarService;
        this.agendaEventService = agendaEventService;
        this.agendaEventReminderService = agendaEventReminderService;
        this.agendaEventAttendeeService = agendaEventAttendeeService;
        this.agendaEventAttachmentService = agendaEventAttachmentService;
        this.agendaEventConferenceService = agendaEventConferenceService;
        this.agendaRemoteEventService = agendaRemoteEventService;
        this.defaultSite = portalConfigService != null && portalConfigService.getDefaultPortal() != null ? portalConfigService.getDefaultPortal() : "dw";
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves the list of events available for an owner of type user or space, identitifed by its identity technical identifier. If no designated owner, all events available for authenticated user will be retrieved.", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response list(@ApiParam(value="Identity technical identifiers of calendar owners", required=false) @QueryParam(value="ownerIds") List<Long> ownerIds, @ApiParam(value="Attendee identity identifier to filter on events where user is attendee", required=true) @QueryParam(value="attendeeIdentityId") long attendeeIdentityId, @ApiParam(value="Properties to expand", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Start datetime using RFC-3339 representation", required=true) @QueryParam(value="start") String start, @ApiParam(value="End datetime using RFC-3339 representation", required=false) @QueryParam(value="end") String end, @ApiParam(value="IANA Time zone identitifer", required=false) @QueryParam(value="timeZoneId") String timeZoneId, @ApiParam(value="Limit of results to return, used only when end date isn't set", required=false, defaultValue="10") @QueryParam(value="limit") int limit, @ApiParam(value="Attendee Response statuses to filter events by attendee response", required=false) @QueryParam(value="responseTypes") List<EventAttendeeResponse> responseTypes) {
        if (StringUtils.isBlank((CharSequence)start)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Start datetime is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)timeZoneId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Time zone is mandatory").build();
        }
        ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
        ZonedDateTime endDatetime = null;
        if (StringUtils.isBlank((CharSequence)end)) {
            if (limit <= 0) {
                limit = 10;
            }
        } else {
            endDatetime = AgendaDateUtils.parseRFC3339ToZonedDateTime(end, userTimeZone);
        }
        ZonedDateTime startDatetime = AgendaDateUtils.parseRFC3339ToZonedDateTime(start, userTimeZone);
        if (endDatetime != null && (endDatetime.isBefore(startDatetime) || endDatetime.equals(startDatetime))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Start date must be before end date").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            EventFilter eventFilter = new EventFilter(attendeeIdentityId, ownerIds, responseTypes, startDatetime, endDatetime, limit);
            List events = this.agendaEventService.getEvents(eventFilter, userTimeZone, userIdentityId);
            HashMap attendeesByParentEventId = new HashMap();
            HashMap attachmentsByParentEventId = new HashMap();
            HashMap conferencesByParentEventId = new HashMap();
            HashMap remindersByParentEventId = new HashMap();
            HashMap remoteEventByParentEventId = new HashMap();
            List expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
            List eventEntities = events.stream().map(event -> {
                EventEntity eventEntity = EntityBuilder.fromEvent(this.agendaCalendarService, this.agendaEventService, this.identityManager, event, userTimeZone);
                if (expandProperties.contains("all") || expandProperties.contains("attendees")) {
                    try {
                        this.fillAttendees(eventEntity, attendeesByParentEventId);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error retrieving event reminders, retrieve event without it", (Throwable)e);
                    }
                }
                if (expandProperties.contains("all") || expandProperties.contains("attachments")) {
                    try {
                        this.fillAttachments(eventEntity, attachmentsByParentEventId);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error retrieving event reminders, retrieve event without it", (Throwable)e);
                    }
                }
                if (expandProperties.contains("all") || expandProperties.contains("conferences")) {
                    try {
                        this.fillConferences(eventEntity, conferencesByParentEventId);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error retrieving event conferences, retrieve event without it", (Throwable)e);
                    }
                }
                if (expandProperties.contains("all") || expandProperties.contains("reminders")) {
                    try {
                        this.fillReminders(eventEntity, userIdentityId, remindersByParentEventId);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error retrieving event reminders, retrieve event without it", (Throwable)e);
                    }
                }
                this.fillRemoteEvent(eventEntity, userIdentityId);
                if (eventEntity.getParent() != null) {
                    this.fillRemoteEvent(eventEntity.getParent(), userIdentityId, remoteEventByParentEventId);
                }
                if (this.isComputedOccurrence(eventEntity)) {
                    this.cleanupAttachedEntitiesIds(eventEntity);
                }
                return eventEntity;
            }).collect(Collectors.toList());
            EventList eventList = new EventList();
            eventList.setEvents(eventEntities);
            eventList.setStart(start);
            eventList.setEnd(end);
            eventList.setLimit(limit);
            return Response.ok((Object)eventList).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized events of owner Id '{}'", new Object[]{RestUtils.getCurrentUser(), ownerIds});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of events", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves an event identified by its technical identifier.", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getEventById(@ApiParam(value="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @ApiParam(value="Properties to expand", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="IANA Time zone identitifer", required=false) @QueryParam(value="timeZoneId") String timeZoneId) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        try {
            List<String> expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
            ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
            EventEntity eventEntity = this.getEventByIdAndUser(eventId, RestUtils.getCurrentUserIdentityId(this.identityManager), userTimeZone, expandProperties);
            if (eventEntity == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)eventEntity).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized event with Id '{}'", new Object[]{currentUser, eventId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving event with id '{}'", new Object[]{eventId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="occurrence/{parentEventId}/{occurrenceId}")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves an event identified by its technical identifier.", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getEventOccurrence(@ApiParam(value="Event technical identifier", required=true) @PathParam(value="parentEventId") long parentEventId, @ApiParam(value="Event technical identifier", required=true) @PathParam(value="occurrenceId") String occurrenceId, @ApiParam(value="Properties to expand", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="IANA Time zone identitifer", required=false) @QueryParam(value="timeZoneId") String timeZoneId) {
        if (parentEventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        if (StringUtils.isBlank((CharSequence)"occurrenceId")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event occurrence identifier is mandatory").build();
        }
        try {
            List<String> expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
            ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
            long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            ZonedDateTime occurrenceDate = AgendaDateUtils.parseRFC3339ToZonedDateTime(occurrenceId, userTimeZone);
            Event event = this.agendaEventService.getEventOccurrence(parentEventId, occurrenceDate, userTimeZone, identityId);
            if (event == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            EventEntity eventEntity = this.getEventEntity(event, userTimeZone, expandProperties);
            return Response.ok((Object)eventEntity).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized event with parentId '{}' and occurrenceId '{}'", new Object[]{RestUtils.getCurrentUser(), parentEventId, occurrenceId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving event with parentId '{}' and occurrenceId '{}'", new Object[]{RestUtils.getCurrentUser(), parentEventId, occurrenceId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/exceptionalOccurrences")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves the list of exceptional occurrences of an event.", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getEventExceptionalOccurrences(@ApiParam(value="Event technical identifier", required=true) @PathParam(value="eventId") long parentEventId, @ApiParam(value="Properties to expand", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="IANA Time zone identitifer", required=false) @QueryParam(value="timeZoneId") String timeZoneId) {
        List expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
            List events = this.agendaEventService.getExceptionalOccurrenceEvents(parentEventId, userTimeZone, userIdentityId);
            List eventEntities = events.stream().map(event -> this.getEventEntity((Event)event, userTimeZone, expandProperties)).collect(Collectors.toList());
            return Response.ok(eventEntities).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized events", new Object[]{RestUtils.getCurrentUser()});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of events", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Create a new event", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createEvent(@ApiParam(value="IANA Time zone identitifer", required=false) @QueryParam(value="timeZoneId") String timeZoneId, @ApiParam(value="Event object to create", required=true) EventEntity eventEntity) {
        if (eventEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.EVENT_MANDATORY.getCompleteMessage()).build();
        }
        if (eventEntity.getCalendar() == null || eventEntity.getCalendar().getOwner() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.CALENDAR_OWNER_NOT_FOUND).build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            Event event = this.createEvent(eventEntity, userIdentityId);
            return this.getEventById(event.getId(), "all", timeZoneId == null ? event.getTimeZoneId().getId() : timeZoneId);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to create an event in calendar '{}'", new Object[]{RestUtils.getCurrentUser(), eventEntity.getCalendar()});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (AgendaException e) {
            return Response.serverError().entity((Object)e.getAgendaExceptionType().getCompleteMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating an event", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Update an existing event", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=404, message="Object not found"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateEvent(@ApiParam(value="Event object to update", required=true) EventEntity eventEntity, @ApiParam(value="IANA Time zone identitifer", required=false) @QueryParam(value="timeZoneId") String timeZoneId) {
        if (eventEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.EVENT_MANDATORY.getCompleteMessage()).build();
        }
        if (eventEntity.getId() <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.EVENT_ID_MANDATORY.getCompleteMessage()).build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            List attachmentEntities;
            this.checkCalendar(eventEntity);
            List attendeeEntities = eventEntity.getAttendees();
            ArrayList<EventAttendee> attendees = null;
            if (attendeeEntities != null && !attendeeEntities.isEmpty()) {
                attendees = new ArrayList<EventAttendee>();
                for (EventAttendeeEntity attendeeEntity : attendeeEntities) {
                    attendees.add(EntityBuilder.toEventAttendee(this.identityManager, eventEntity.getId(), attendeeEntity));
                }
            }
            List attachments = (attachmentEntities = eventEntity.getAttachments()) == null || attachmentEntities.isEmpty() ? null : attachmentEntities.stream().map(EntityBuilder::toEventAttachment).collect(Collectors.toList());
            Event event = EntityBuilder.toEvent(eventEntity);
            List reminderEntities = eventEntity.getReminders();
            ArrayList<EventReminder> reminders = null;
            if (reminderEntities != null && !reminderEntities.isEmpty()) {
                reminders = new ArrayList<EventReminder>();
                for (EventReminderEntity reminderEntity : reminderEntities) {
                    reminders.add(EntityBuilder.toEventReminder(eventEntity.getId(), reminderEntity));
                }
            }
            RemoteEvent remoteEvent = this.getRemoteEvent(eventEntity, userIdentityId);
            this.agendaEventService.updateEvent(event, attendees, eventEntity.getConferences(), attachments, reminders, remoteEvent, eventEntity.isSendInvitation(), userIdentityId);
            return this.getEventById(event.getId(), "all", timeZoneId == null ? event.getTimeZoneId().getId() : timeZoneId);
        }
        catch (AgendaException e) {
            return Response.serverError().entity((Object)e.getAgendaExceptionType().getCompleteMessage()).build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to update a non authorized event", new Object[]{RestUtils.getCurrentUser()});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating an event", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}")
    @PATCH
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Update an attribute of an existing event", httpMethod="PATCH", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=404, message="Object not found"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateEventFields(@ApiParam(value="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @ApiParam(value="Update all event occurrences or only parent occurrence", required=false, defaultValue="false") @QueryParam(value="updateAllOccurrences") boolean updateAllOccurrences, @ApiParam(value="Whether notify attendees about the modification or not", required=false, defaultValue="false") @QueryParam(value="sendInvitations") boolean sendInvitations, @ApiParam(value="Event fields to patch", required=true) MultivaluedMap<String, String> eventFields) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.EVENT_ID_MANDATORY.getCompleteMessage()).build();
        }
        if (eventFields == null || eventFields.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.EVENT_FIELDS_MANDATORY.getCompleteMessage()).build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            Event event = this.agendaEventService.getEventById(eventId, (ZoneId)ZoneOffset.UTC, userIdentityId);
            if (event == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event not found").build();
            }
            if (eventFields.containsKey((Object)"remoteId") || eventFields.containsKey((Object)"remoteProviderId") || eventFields.containsKey((Object)"remoteProviderName")) {
                String remoteId = eventFields.containsKey((Object)"remoteId") ? (String)((List)eventFields.get((Object)"remoteId")).get(0) : null;
                String remoteProviderId = eventFields.containsKey((Object)"remoteProviderId") ? (String)((List)eventFields.get((Object)"remoteProviderId")).get(0) : null;
                String remoteProviderName = eventFields.containsKey((Object)"remoteProviderName") ? (String)((List)eventFields.get((Object)"remoteProviderName")).get(0) : null;
                RemoteEvent remoteEvent = new RemoteEvent(0L, eventId, userIdentityId, remoteId, remoteProviderId == null ? 0L : Long.parseLong(remoteProviderId), remoteProviderName);
                this.agendaRemoteEventService.saveRemoteEvent(eventId, remoteEvent, userIdentityId);
            }
            eventFields.remove((Object)"remoteId");
            eventFields.remove((Object)"remoteProviderId");
            eventFields.remove((Object)"remoteProviderName");
            if (!eventFields.isEmpty()) {
                this.agendaEventService.updateEventFields(eventId, eventFields, updateAllOccurrences, sendInvitations, userIdentityId);
            }
            return Response.noContent().build();
        }
        catch (AgendaException e) {
            return Response.serverError().entity((Object)e.getAgendaExceptionType().getCompleteMessage()).build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to update a non authorized event", new Object[]{RestUtils.getCurrentUser()});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating an event", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{eventId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete an existing event", httpMethod="DELETE", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=404, message="Object not found"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteEvent(@ApiParam(value="Event technical identifier", required=true) @PathParam(value="eventId") long eventId) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event technical identifier must be positive").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            EventEntity eventEntity = this.getEventByIdAndUser(eventId, userIdentityId, null, Collections.singletonList("all"));
            if (eventEntity == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event not found").build();
            }
            this.agendaEventService.deleteEventById(eventId, userIdentityId);
            return Response.ok((Object)eventEntity).build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to delete a non authorized event", new Object[]{RestUtils.getCurrentUser()});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error deleting an event", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/reminders")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieve preferred reminders for currently authenticated user for an event identified by its technical identifier.", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getEventRemindersById(@ApiParam(value="Event technical identifier", required=true) @PathParam(value="eventId") long eventId) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            List reminders = this.agendaEventReminderService.getEventReminders(eventId, identityId);
            if (reminders == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)reminders).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving event reminders with id '{}'", new Object[]{eventId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/reminders")
    @PUT
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Update the list of preferred reminders for authenticated user on a selected event.", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveEventReminders(@ApiParam(value="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @ApiParam(value="Event occurrence identifier", required=true) @QueryParam(value="occurrenceId") String occurrenceId, @ApiParam(value="List of reminders to store on event for currently authenticated user", required=true) List<EventReminder> reminders) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            Event event = this.agendaEventService.getEventById(eventId, null, userIdentityId);
            if (event == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Event with id " + eventId + " is not found")).build();
            }
            ZonedDateTime occurrenceIdDateTime = null;
            if (StringUtils.isBlank((CharSequence)occurrenceId)) {
                this.agendaEventReminderService.saveEventReminders(event, reminders, userIdentityId);
            } else {
                if (event.getRecurrence() == null) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event is not recurrent, no occurrenceId is needed").build();
                }
                occurrenceIdDateTime = AgendaDateUtils.parseRFC3339ToZonedDateTime(occurrenceId, ZoneOffset.UTC);
                Event occurrenceEvent = this.agendaEventService.getExceptionalOccurrenceEvent(eventId, occurrenceIdDateTime);
                if (occurrenceEvent == null) {
                    occurrenceEvent = this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceIdDateTime);
                }
                this.agendaEventReminderService.saveEventReminders(occurrenceEvent, reminders, userIdentityId);
            }
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access reminders for a not authorized event with Id '{}'", new Object[]{userIdentityId, eventId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error updating event reminders with id '{}'", new Object[]{eventId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/response")
    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Retrieves currently authenticated (using token or effectively authenticated) user response to an event.", httpMethod="GET", response=Response.class, produces="text/plain")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Forbidden operation"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getEventResponse(@ApiParam(value="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @ApiParam(value="User token to ", required=false) @QueryParam(value="token") String token) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        try {
            Identity identity = null;
            identity = StringUtils.isNotBlank((CharSequence)token) ? this.agendaEventAttendeeService.decryptUserIdentity(eventId, token, null) : RestUtils.getCurrentUserIdentity(this.identityManager);
            if (identity == null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            long identityId = Long.parseLong(identity.getId());
            EventAttendeeResponse response = this.agendaEventAttendeeService.getEventResponse(eventId, identityId);
            return Response.ok((Object)response.getValue()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access invitation response for a not authorized event with Id '{}'", new Object[]{RestUtils.getCurrentUser(), eventId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving event response with id '{}'", new Object[]{eventId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/response/send")
    @GET
    @ApiOperation(value="Send event invitation response for currently authenticated user (using token or effectively authenticated).", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response sendEventResponse(@ApiParam(value="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @ApiParam(value="Event occurrence identifier", required=true) @QueryParam(value="occurrenceId") String occurrenceId, @ApiParam(value="Response to event invitation. Possible values: ACCEPTED, DECLINED or TENTATIVE.", required=true) @QueryParam(value="response") String responseString, @ApiParam(value="User token used to identify user and his response to apply new reponse even when user is not authenticated", required=false) @QueryParam(value="token") String token, @ApiParam(value="Whether redirect to Event details after applying new response or not", required=false, defaultValue="false") @QueryParam(value="redirect") boolean redirect) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        if (StringUtils.isBlank((CharSequence)responseString)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event response is mandatory").build();
        }
        EventAttendeeResponse response = EventAttendeeResponse.fromValue((String)responseString);
        if (response == null || response == EventAttendeeResponse.NEEDS_ACTION) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event response is not recognized").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        try {
            Identity identity = null;
            if (StringUtils.isNotBlank((CharSequence)token)) {
                identity = this.agendaEventAttendeeService.decryptUserIdentity(eventId, token, response);
                currentUser = identity.getRemoteId();
            } else if (StringUtils.isNotBlank((CharSequence)currentUser)) {
                identity = this.identityManager.getOrCreateIdentity("organization", currentUser);
            }
            if (identity == null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            long identityId = Long.parseLong(identity.getId());
            if (!this.agendaEventAttendeeService.isEventAttendee(eventId, identityId)) {
                throw new IllegalAccessException("User " + currentUser + " isn't attendee of event with id " + eventId);
            }
            ZonedDateTime occurrenceIdDateTime = null;
            if (StringUtils.isNotBlank((CharSequence)occurrenceId)) {
                occurrenceIdDateTime = AgendaDateUtils.parseRFC3339ToZonedDateTime(occurrenceId, ZoneOffset.UTC);
                Event occurrenceEvent = this.agendaEventService.getExceptionalOccurrenceEvent(eventId, occurrenceIdDateTime);
                if (occurrenceEvent == null) {
                    occurrenceEvent = this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceIdDateTime);
                }
                eventId = occurrenceEvent.getId();
            }
            this.agendaEventAttendeeService.sendEventResponse(eventId, identityId, response);
            if (redirect) {
                URI location = new URI("/portal/" + this.defaultSite + "/" + AGENDA_APP_URI + "?eventId=" + eventId);
                return Response.seeOther((URI)location).build();
            }
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to send invitation response for a not authorized event with Id '{}'", new Object[]{currentUser, eventId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error sending event invitation response for event with id '{}'", new Object[]{eventId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="search")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Search the list of events available with query for an owner of type user or space, identified by its identity technical identifier. If no designated owner, all events available for authenticated user will be retrieved.", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response search(@Context UriInfo uriInfo, @ApiParam(value="Term to search", required=true) @QueryParam(value="query") String query, @ApiParam(value="IANA Time zone identitifer", required=false) @QueryParam(value="timeZoneId") String timeZoneId, @ApiParam(value="Properties to expand", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        List expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
        long currentUserId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
        List searchResults = this.agendaEventService.search(currentUserId, userTimeZone, query, offset, limit);
        List results = searchResults.stream().map(searchResult -> this.getEventSearchResultEntity((EventSearchResult)searchResult, userTimeZone, expandProperties)).collect(Collectors.toList());
        return Response.ok(results).build();
    }

    private Event createEvent(EventEntity eventEntity, long userIdentityId) throws AgendaException, IllegalAccessException {
        List attachmentEntities;
        this.checkCalendar(eventEntity);
        this.cleanupAttachedEntitiesIds(eventEntity);
        List attendeeEntities = eventEntity.getAttendees();
        ArrayList<EventAttendee> attendees = null;
        if (attendeeEntities != null && !attendeeEntities.isEmpty()) {
            attendees = new ArrayList<EventAttendee>();
            for (EventAttendeeEntity attendeeEntity : attendeeEntities) {
                IdentityEntity attendeeIdentity = attendeeEntity.getIdentity();
                String attendeeIdString = RestUtils.getIdentityId(attendeeIdentity, this.identityManager);
                if (StringUtils.isBlank((CharSequence)attendeeIdString)) {
                    throw new AgendaException(AgendaExceptionType.ATTENDEE_IDENTITY_NOT_FOUND);
                }
                attendeeIdentity.setId(attendeeIdString);
                attendees.add(EntityBuilder.toEventAttendee(this.identityManager, eventEntity.getId(), attendeeEntity));
            }
        }
        List attachments = (attachmentEntities = eventEntity.getAttachments()) == null || attachmentEntities.isEmpty() ? null : attachmentEntities.stream().map(EntityBuilder::toEventAttachment).collect(Collectors.toList());
        List reminderEntities = eventEntity.getReminders();
        ArrayList<EventReminder> reminders = null;
        if (reminderEntities != null && !reminderEntities.isEmpty()) {
            reminders = new ArrayList<EventReminder>();
            for (EventReminderEntity reminderEntity : reminderEntities) {
                reminders.add(EntityBuilder.toEventReminder(eventEntity.getId(), reminderEntity));
            }
        }
        RemoteEvent remoteEvent = this.getRemoteEvent(eventEntity, userIdentityId);
        return this.agendaEventService.createEvent(EntityBuilder.toEvent(eventEntity), attendees, eventEntity.getConferences(), attachments, reminders, remoteEvent, eventEntity.isSendInvitation(), userIdentityId);
    }

    private void checkCalendar(EventEntity eventEntity) throws AgendaException {
        IdentityEntity identityEntity = eventEntity.getCalendar().getOwner();
        String ownerIdString = RestUtils.getIdentityId(identityEntity, this.identityManager);
        if (StringUtils.isBlank((CharSequence)ownerIdString)) {
            throw new AgendaException(AgendaExceptionType.CALENDAR_OWNER_NOT_FOUND);
        }
        identityEntity.setId(ownerIdString);
        Calendar calendar = this.agendaCalendarService.getOrCreateCalendarByOwnerId(Long.parseLong(ownerIdString));
        if (calendar == null) {
            throw new AgendaException(AgendaExceptionType.CALENDAR_NOT_FOUND);
        }
        if (eventEntity.getCalendar() == null) {
            eventEntity.setCalendar(EntityBuilder.fromCalendar(this.identityManager, calendar));
        } else {
            eventEntity.getCalendar().setId(calendar.getId());
        }
    }

    private EventEntity getEventByIdAndUser(long eventId, long identityId, ZoneId userTimeZone, List<String> expandProperties) throws IllegalAccessException {
        Event event = this.agendaEventService.getEventById(eventId, userTimeZone, identityId);
        return this.getEventEntity(event, userTimeZone, expandProperties);
    }

    private EventEntity getEventEntity(Event event, ZoneId userTimeZone, List<String> expandProperties) {
        if (event == null) {
            return null;
        }
        EventEntity eventEntity = EntityBuilder.fromEvent(this.agendaCalendarService, this.agendaEventService, this.identityManager, event, userTimeZone);
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (expandProperties.contains("all") || expandProperties.contains("attendees")) {
            this.fillAttendees(eventEntity);
        }
        if (expandProperties.contains("all") || expandProperties.contains("attachments")) {
            this.fillAttachments(eventEntity);
        }
        if (expandProperties.contains("all") || expandProperties.contains("conferences")) {
            this.fillConferences(eventEntity);
        }
        if (expandProperties.contains("all") || expandProperties.contains("reminders")) {
            this.fillReminders(eventEntity, userIdentityId);
        }
        this.fillRemoteEvent(eventEntity, userIdentityId);
        if (eventEntity.getParent() != null) {
            this.fillRemoteEvent(eventEntity.getParent(), userIdentityId);
        }
        if (this.isComputedOccurrence(eventEntity)) {
            this.cleanupAttachedEntitiesIds(eventEntity);
        }
        return eventEntity;
    }

    private EventSearchResultEntity getEventSearchResultEntity(EventSearchResult eventSearchResult, ZoneId userTimeZone, List<String> expandProperties) {
        if (eventSearchResult == null) {
            return null;
        }
        EventSearchResultEntity eventSearchResultEntity = EntityBuilder.fromSearchEvent(this.agendaCalendarService, this.agendaEventService, this.identityManager, eventSearchResult, userTimeZone);
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (expandProperties.contains("all") || expandProperties.contains("attendees")) {
            this.fillAttendees((EventEntity)eventSearchResultEntity);
        }
        if (expandProperties.contains("all") || expandProperties.contains("attachments")) {
            this.fillAttachments((EventEntity)eventSearchResultEntity);
        }
        if (expandProperties.contains("all") || expandProperties.contains("conferences")) {
            this.fillConferences((EventEntity)eventSearchResultEntity);
        }
        if (expandProperties.contains("all") || expandProperties.contains("reminders")) {
            this.fillReminders((EventEntity)eventSearchResultEntity, userIdentityId);
        }
        this.fillRemoteEvent((EventEntity)eventSearchResultEntity, userIdentityId);
        if (eventSearchResultEntity.getParent() != null) {
            this.fillRemoteEvent(eventSearchResultEntity.getParent(), userIdentityId);
        }
        if (this.isComputedOccurrence((EventEntity)eventSearchResultEntity)) {
            this.cleanupAttachedEntitiesIds((EventEntity)eventSearchResultEntity);
        }
        return eventSearchResultEntity;
    }

    private void fillAttendees(EventEntity eventEntity, Map<Long, List<EventAttendeeEntity>> attendeesByParentEventId) {
        long eventId;
        boolean computedOccurrence = this.isComputedOccurrence(eventEntity);
        long l = eventId = computedOccurrence ? eventEntity.getParent().getId() : eventEntity.getId();
        if (attendeesByParentEventId.containsKey(eventId)) {
            eventEntity.setAttendees(attendeesByParentEventId.get(eventId));
        } else {
            this.fillAttendees(eventEntity);
            attendeesByParentEventId.put(eventId, eventEntity.getAttendees());
        }
    }

    private void fillAttendees(EventEntity eventEntity) {
        boolean computedOccurrence = this.isComputedOccurrence(eventEntity);
        long eventId = computedOccurrence ? eventEntity.getParent().getId() : eventEntity.getId();
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId);
        List eventAttendeeEntities = eventAttendees == null ? null : eventAttendees.stream().map(eventAttendee -> EntityBuilder.fromEventAttendee(this.identityManager, eventAttendee)).collect(Collectors.toList());
        eventEntity.setAttendees(eventAttendeeEntities);
    }

    private void fillAttachments(EventEntity eventEntity, Map<Long, List<EventAttachmentEntity>> attachmentsByParentEventId) {
        long eventId;
        long l = eventId = this.isComputedOccurrence(eventEntity) ? eventEntity.getParent().getId() : eventEntity.getId();
        if (attachmentsByParentEventId.containsKey(eventId)) {
            eventEntity.setAttachments(attachmentsByParentEventId.get(eventId));
        } else {
            this.fillAttachments(eventEntity);
            attachmentsByParentEventId.put(eventId, eventEntity.getAttachments());
        }
    }

    private void fillAttachments(EventEntity eventEntity) {
        long eventId = this.isComputedOccurrence(eventEntity) ? eventEntity.getParent().getId() : eventEntity.getId();
        List eventAttachments = this.agendaEventAttachmentService.getEventAttachments(eventId);
        List eventAttachmentEntities = eventAttachments == null ? null : eventAttachments.stream().map(EntityBuilder::fromEventAttachment).collect(Collectors.toList());
        eventEntity.setAttachments(eventAttachmentEntities);
    }

    private void fillConferences(EventEntity eventEntity, Map<Long, List<EventConference>> conferencesByParentEventId) {
        long eventId;
        long l = eventId = this.isComputedOccurrence(eventEntity) ? eventEntity.getParent().getId() : eventEntity.getId();
        if (conferencesByParentEventId.containsKey(eventId)) {
            eventEntity.setConferences(conferencesByParentEventId.get(eventId));
        } else {
            this.fillConferences(eventEntity);
            conferencesByParentEventId.put(eventId, eventEntity.getConferences());
        }
    }

    private void fillConferences(EventEntity eventEntity) {
        long eventId = this.isComputedOccurrence(eventEntity) ? eventEntity.getParent().getId() : eventEntity.getId();
        List eventConferences = this.agendaEventConferenceService.getEventConferences(eventId);
        eventEntity.setConferences(eventConferences);
    }

    private void fillReminders(EventEntity eventEntity, long userIdentityId, Map<Long, List<EventReminderEntity>> remindersByParentEventId) {
        long eventId;
        long l = eventId = this.isComputedOccurrence(eventEntity) ? eventEntity.getParent().getId() : eventEntity.getId();
        if (remindersByParentEventId.containsKey(eventId)) {
            eventEntity.setReminders(remindersByParentEventId.get(eventId));
        } else {
            this.fillReminders(eventEntity, userIdentityId);
            remindersByParentEventId.put(eventId, eventEntity.getReminders());
        }
    }

    private void fillRemoteEvent(EventEntity eventEntity, long userIdentityId) {
        if (this.isComputedOccurrence(eventEntity)) {
            return;
        }
        long eventId = eventEntity.getId();
        RemoteEvent remoteEvent = this.agendaRemoteEventService.findRemoteEvent(eventId, userIdentityId);
        if (remoteEvent != null) {
            eventEntity.setRemoteId(remoteEvent.getRemoteId());
            eventEntity.setRemoteProviderId(remoteEvent.getRemoteProviderId());
            eventEntity.setRemoteProviderName(remoteEvent.getRemoteProviderName());
        }
    }

    private void fillRemoteEvent(EventEntity eventEntity, long userIdentityId, Map<Long, RemoteEvent> remoteEventByParentEventId) {
        if (this.isComputedOccurrence(eventEntity)) {
            return;
        }
        long eventId = eventEntity.getId();
        RemoteEvent remoteEvent = null;
        if (remoteEventByParentEventId.containsKey(eventId)) {
            remoteEvent = remoteEventByParentEventId.get(eventId);
        } else {
            remoteEvent = this.agendaRemoteEventService.findRemoteEvent(eventId, userIdentityId);
            remoteEventByParentEventId.put(eventId, remoteEvent);
        }
        if (remoteEvent != null) {
            eventEntity.setRemoteId(remoteEvent.getRemoteId());
            eventEntity.setRemoteProviderId(remoteEvent.getRemoteProviderId());
            eventEntity.setRemoteProviderName(remoteEvent.getRemoteProviderName());
        }
    }

    private RemoteEvent getRemoteEvent(EventEntity eventEntity, long userIdentityId) {
        return new RemoteEvent(0L, eventEntity.getId(), userIdentityId, eventEntity.getRemoteId(), eventEntity.getRemoteProviderId(), eventEntity.getRemoteProviderName());
    }

    private void fillReminders(EventEntity eventEntity, long userIdentityId) {
        long eventId = this.isComputedOccurrence(eventEntity) ? eventEntity.getParent().getId() : eventEntity.getId();
        List eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        List eventReminderEntities = eventReminders == null ? null : eventReminders.stream().map(EntityBuilder::fromEventReminder).collect(Collectors.toList());
        eventEntity.setReminders(eventReminderEntities);
    }

    private boolean isComputedOccurrence(EventEntity eventEntity) {
        return eventEntity.getId() == 0L && eventEntity.getParent() != null;
    }

    private void cleanupAttachedEntitiesIds(EventEntity eventEntity) {
        List reminders;
        List conferences;
        List attachments;
        List attendees = eventEntity.getAttendees();
        if (attendees != null && !attendees.isEmpty()) {
            attendees = attendees.stream().map(attendee -> {
                attendee = attendee.clone();
                attendee.setId(0L);
                return attendee;
            }).collect(Collectors.toList());
            eventEntity.setAttendees(attendees);
        }
        if ((attachments = eventEntity.getAttachments()) != null && !attachments.isEmpty()) {
            attachments = attachments.stream().map(attachment -> {
                attachment = attachment.clone();
                attachment.setId(0L);
                return attachment;
            }).collect(Collectors.toList());
            eventEntity.setAttachments(attachments);
        }
        if ((conferences = eventEntity.getConferences()) != null && !conferences.isEmpty()) {
            conferences = conferences.stream().map(conference -> {
                conference = conference.clone();
                conference.setId(0L);
                return conference;
            }).collect(Collectors.toList());
            eventEntity.setConferences(conferences);
        }
        if ((reminders = eventEntity.getReminders()) != null && !reminders.isEmpty()) {
            reminders = reminders.stream().map(reminder -> {
                reminder = reminder.clone();
                reminder.setId(0L);
                return reminder;
            }).collect(Collectors.toList());
            eventEntity.setReminders(reminders);
        }
    }
}

