/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.notification.builder;

import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.spi.SpaceService;

public class VoteTemplateBuilder
extends AbstractTemplateBuilder {
    private static final Log LOG = ExoLogger.getLogger(VoteTemplateBuilder.class);
    private AgendaEventService agendaEventService;
    private SpaceService spaceService;
    private TemplateProvider templateProvider;
    private ExoContainer container;
    private boolean isPushNotification;
    private PluginKey key;

    public VoteTemplateBuilder(TemplateProvider templateProvider, ExoContainer container, PluginKey key, boolean isPushNotification) {
        this.templateProvider = templateProvider;
        this.container = container;
        this.key = key;
        this.isPushNotification = isPushNotification;
    }

    public Template getTemplateEngine() {
        String templatePath = null;
        try {
            templatePath = (String)this.templateProvider.getTemplateFilePathConfigs().get(this.key);
            String template = TemplateUtils.loadGroovyTemplate((String)templatePath);
            if (StringUtils.isBlank((String)template)) {
                throw new IllegalStateException("Template with path " + templatePath + " wasn't found");
            }
            return new GStringTemplateEngine().createTemplate(template);
        }
        catch (Exception e) {
            LOG.warn("Error while compiling template {}", new Object[]{templatePath, e});
            try {
                return new GStringTemplateEngine().createTemplate("");
            }
            catch (Exception e1) {
                LOG.warn((Object)"Error while creating empty template", (Throwable)e1);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            Event event = this.getEvent(notification);
            if (event == null) {
                MessageInfo messageInfo = null;
                return messageInfo;
            }
            String notificationURL = notification.getValueOwnerParameter("Url");
            if (StringUtils.isBlank((String)notificationURL)) {
                notificationURL = NotificationUtils.getEventURL(event);
            }
            String pushNotificationURL = this.isPushNotification ? notificationURL : null;
            TemplateContext templateContext = NotificationUtils.buildTemplateDatePollParameters(this.getSpaceService(), this.templateProvider, notification);
            MessageInfo messageInfo = NotificationUtils.buildMessageSubjectAndBody(templateContext, notification, pushNotificationURL);
            Throwable exception = templateContext.getException();
            this.logException(notification, exception);
            ctx.setException(exception);
            MessageInfo messageInfo2 = messageInfo;
            return messageInfo2;
        }
        catch (Throwable e) {
            ctx.setException(e);
            this.logException(notification, e);
            MessageInfo messageInfo = null;
            return messageInfo;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
        return false;
    }

    public TemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }

    private final Event getEvent(NotificationInfo notification) {
        String eventIdString = notification.getValueOwnerParameter("eventId");
        if (StringUtils.isBlank((String)eventIdString)) {
            throw new IllegalStateException("Event id is missing in notification");
        }
        long eventId = Long.parseLong(eventIdString);
        if (eventId == 0L) {
            throw new IllegalStateException("Event id is equal to 0 in notification");
        }
        return this.getEventService().getEventById(eventId);
    }

    private void logException(NotificationInfo notification, Throwable e) {
        if (e != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Error building notification content: {}", new Object[]{notification, e});
            } else {
                LOG.warn("Error building notification content: {}, error: {}", new Object[]{notification, e.getMessage()});
            }
        }
    }

    private AgendaEventService getEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)this.container.getComponentInstanceOfType(AgendaEventService.class);
        }
        return this.agendaEventService;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }
}

