/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import java.util.Collections;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.model.AgendaUserSettings;
import org.exoplatform.agenda.model.RemoteProvider;
import org.exoplatform.agenda.service.AgendaEventConferenceService;
import org.exoplatform.agenda.service.AgendaRemoteEventService;
import org.exoplatform.agenda.service.AgendaUserSettingsService;
import org.exoplatform.agenda.service.AgendaWebSocketService;
import org.exoplatform.agenda.util.RestUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/v1/agenda/settings")
@Api(value="/v1/agenda/settings", description="Manages agenda settings associated to users")
public class AgendaSettingsRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(AgendaSettingsRest.class);
    private AgendaUserSettingsService agendaUserSettingsService;
    private AgendaEventConferenceService agendaEventConferenceService;
    private AgendaRemoteEventService agendaRemoteEventService;
    private AgendaWebSocketService agendaWebSocketService;
    private IdentityManager identityManager;

    public AgendaSettingsRest(AgendaUserSettingsService agendaUserSettingsService, AgendaEventConferenceService agendaEventConferenceService, AgendaRemoteEventService agendaRemoteEventService, AgendaWebSocketService agendaWebSocketService, IdentityManager identityManager) {
        this.agendaUserSettingsService = agendaUserSettingsService;
        this.agendaEventConferenceService = agendaEventConferenceService;
        this.agendaRemoteEventService = agendaRemoteEventService;
        this.agendaWebSocketService = agendaWebSocketService;
        this.identityManager = identityManager;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get User agenda settings", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getUserSettings() {
        Identity currentUserIdentity = RestUtils.getCurrentUserIdentity(this.identityManager);
        try {
            long identityId = Long.parseLong(currentUserIdentity.getId());
            AgendaUserSettings agendaUserSettings = this.agendaUserSettingsService.getAgendaUserSettings(identityId);
            String cometdToken = this.agendaWebSocketService.getUserToken(currentUserIdentity.getRemoteId());
            agendaUserSettings.setCometdToken(cometdToken);
            agendaUserSettings.setCometdContextName(this.agendaWebSocketService.getCometdContextName());
            return Response.ok((Object)agendaUserSettings).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving agenda settings for user with id '{}'", new Object[]{currentUserIdentity, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Saves agenda settings for authenticated user", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveUserSettings(@ApiParam(value="User agenda settings to update", required=true) AgendaUserSettings agendaUserSettings) {
        if (agendaUserSettings == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Agenda settings object is mandatory").build();
        }
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            this.agendaUserSettingsService.saveAgendaUserSettings(identityId, agendaUserSettings);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving agenda settings for user with id '{}'", new Object[]{identityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="timeZone")
    @PATCH
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Saves agenda time zone setting for authenticated user", httpMethod="PUT", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveUserTimeZoneSetting(@ApiParam(value="User preferred time zone", required=true) @FormParam(value="timeZoneId") String timeZoneId) {
        if (StringUtils.isBlank((CharSequence)timeZoneId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'timeZoneId' parameter is mandatory").build();
        }
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            AgendaUserSettings agendaUserSettings = this.agendaUserSettingsService.getAgendaUserSettings(identityId);
            agendaUserSettings.setTimeZoneId(timeZoneId);
            this.agendaUserSettingsService.saveAgendaUserSettings(identityId, agendaUserSettings);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving agenda timezone settings for user with id '{}'", new Object[]{identityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="connector/status")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Saves agenda connector status whether enabled or disabled for all users", httpMethod="POST", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveRemoteProviderStatus(@ApiParam(value="Remote connector name", required=true) @FormParam(value="connectorName") String connectorName, @ApiParam(value="Remote connector status", required=true) @FormParam(value="enabled") boolean enabled, @ApiParam(value="Remote connector uses Oauth or not", required=true) @FormParam(value="isOauth") boolean isOauth) {
        if (StringUtils.isBlank((CharSequence)connectorName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'connectorName' parameter is mandatory").build();
        }
        try {
            RemoteProvider remoteProvider = this.agendaRemoteEventService.saveRemoteProviderStatus(connectorName, enabled, isOauth);
            return Response.ok((Object)remoteProvider).build();
        }
        catch (Exception e) {
            LOG.warn("Error saving connector '{}' status", new Object[]{connectorName, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="connector/apiKey")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Saves agenda connector Client API Key that will be accessible by all users to access connector remote API", httpMethod="POST", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveRemoteProviderApiKey(@ApiParam(value="Remote connector name", required=true) @FormParam(value="connectorName") String connectorName, @ApiParam(value="Remote connector Api Key", required=true) @FormParam(value="apiKey") String apiKey) {
        if (StringUtils.isBlank((CharSequence)connectorName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'connectorName' parameter is mandatory").build();
        }
        try {
            RemoteProvider remoteProvider = this.agendaRemoteEventService.saveRemoteProviderApiKey(connectorName, apiKey);
            return Response.ok((Object)remoteProvider).build();
        }
        catch (Exception e) {
            LOG.warn("Error saving connector '{}' apiKey", new Object[]{connectorName, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="webConferencing")
    @POST
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Saves enabled web conferencing provider to use for all users", httpMethod="PUT", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveEnabledWebConferencing(@ApiParam(value="Web conferencing provider name", required=true) @FormParam(value="providerName") String providerName) {
        try {
            providerName = providerName == null ? "" : providerName.trim();
            this.agendaEventConferenceService.saveEnabledWebConferenceProviders(Collections.singletonList(providerName));
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving enabled web conferencing provider '{}' status", new Object[]{providerName, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="connector")
    @PATCH
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Saves agenda connector settings for authenticated user", httpMethod="PUT", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveUserConnectorSettings(@ApiParam(value="User connector name", required=true) @FormParam(value="connectorName") String connectorName, @ApiParam(value="User connector identifier", required=true) @FormParam(value="connectorUserId") String connectorUserId) {
        if (StringUtils.isBlank((CharSequence)connectorName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'connectorName' parameter is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)connectorUserId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'connectorUserId' parameter is mandatory").build();
        }
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            this.agendaUserSettingsService.saveUserConnector(connectorName, connectorUserId, identityId);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving agenda settings for user with id '{}'", new Object[]{identityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="connector")
    @DELETE
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes agenda connector settings for authenticated user", httpMethod="DELETE", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteUserConnectorSettings() {
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            AgendaUserSettings agendaUserSettings = this.agendaUserSettingsService.getAgendaUserSettings(identityId);
            agendaUserSettings.setConnectedRemoteUserId(null);
            agendaUserSettings.setConnectedRemoteProvider(null);
            this.agendaUserSettingsService.saveAgendaUserSettings(identityId, agendaUserSettings);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error deleting agenda connector settings for user with id '{}'", new Object[]{identityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

