/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.model;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.agenda.model.EventAttendee;

public class EventAttendeeList {
    public static final EventAttendeeList EMPTY_ATTENDEE_LIST = new EventAttendeeList(Collections.emptyList());
    private List<EventAttendee> attendees;

    public List<EventAttendee> getEventAttendees() {
        return this.getEventAttendees(null);
    }

    public List<EventAttendee> getEventAttendees(ZonedDateTime occurrenceId) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        if (occurrenceId == null || this.attendees.size() == 1) {
            return this.attendees;
        }
        return this.attendees.stream().filter(eventAttendee -> {
            if (eventAttendee.getFromOccurrenceId() == null && eventAttendee.getUntilOccurrenceId() == null) {
                return true;
            }
            if (eventAttendee.getFromOccurrenceId() == null && eventAttendee.getUntilOccurrenceId() != null) {
                return eventAttendee.getUntilOccurrenceId().isAfter(occurrenceId);
            }
            if (eventAttendee.getFromOccurrenceId() != null && eventAttendee.getUntilOccurrenceId() == null) {
                return eventAttendee.getFromOccurrenceId().isBefore(occurrenceId) || eventAttendee.getFromOccurrenceId().isEqual(occurrenceId);
            }
            return (eventAttendee.getFromOccurrenceId().isBefore(occurrenceId) || eventAttendee.getFromOccurrenceId().isEqual(occurrenceId)) && eventAttendee.getUntilOccurrenceId().isAfter(occurrenceId);
        }).collect(Collectors.toList());
    }

    public List<EventAttendee> getEventAttendees(long identityId) {
        return this.attendees.stream().filter(eventAttendee -> eventAttendee.getIdentityId() == identityId).collect(Collectors.toList());
    }

    public EventAttendee getEventAttendee(long identityId, ZonedDateTime occurrenceId) {
        if (this.isEmpty()) {
            return null;
        }
        if (occurrenceId == null) {
            return this.attendees.stream().filter(eventAttendee -> eventAttendee.getIdentityId() == identityId).findFirst().orElse(null);
        }
        return this.attendees.stream().filter(eventAttendee -> {
            if (eventAttendee.getIdentityId() != identityId) {
                return false;
            }
            if (eventAttendee.getFromOccurrenceId() == null && eventAttendee.getUntilOccurrenceId() == null) {
                return true;
            }
            if (eventAttendee.getFromOccurrenceId() == null && eventAttendee.getUntilOccurrenceId() != null) {
                return eventAttendee.getUntilOccurrenceId().isAfter(occurrenceId);
            }
            if (eventAttendee.getFromOccurrenceId() != null && eventAttendee.getUntilOccurrenceId() == null) {
                return eventAttendee.getFromOccurrenceId().isBefore(occurrenceId) || eventAttendee.getFromOccurrenceId().isEqual(occurrenceId);
            }
            return (eventAttendee.getFromOccurrenceId().isBefore(occurrenceId) || eventAttendee.getFromOccurrenceId().isEqual(occurrenceId)) && eventAttendee.getUntilOccurrenceId().isAfter(occurrenceId);
        }).findFirst().orElse(null);
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.attendees);
    }

    public int size() {
        return this.isEmpty() ? 0 : this.attendees.size();
    }

    public EventAttendeeList(List<EventAttendee> attendees) {
        this.attendees = attendees;
    }

    public void setAttendees(List<EventAttendee> attendees) {
        this.attendees = attendees;
    }
}

