/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.exception.AgendaException;
import org.exoplatform.agenda.exception.AgendaExceptionType;
import org.exoplatform.agenda.model.AgendaUserSettings;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendeeList;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaUserSettingsService;
import org.exoplatform.agenda.storage.AgendaEventAttendeeStorage;
import org.exoplatform.agenda.storage.AgendaEventReminderStorage;
import org.exoplatform.agenda.storage.AgendaEventStorage;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.command.NotificationCommand;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AgendaEventReminderServiceImpl
implements AgendaEventReminderService {
    private static final Log LOG = ExoLogger.getLogger(AgendaEventReminderServiceImpl.class);
    private AgendaUserSettingsService agendaUserSettingsService;
    private AgendaEventReminderStorage reminderStorage;
    private AgendaEventStorage eventStorage;
    private AgendaEventAttendeeStorage attendeeStorage;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ListenerService listenerService;
    private long reminderComputingPeriod = 2L;

    public AgendaEventReminderServiceImpl(AgendaEventReminderStorage reminderStorage, AgendaEventStorage eventStorage, AgendaEventAttendeeStorage attendeeStorage, AgendaUserSettingsService agendaUserSettingsService, IdentityManager identityManager, SpaceService spaceService, ListenerService listenerService, InitParams initParams) {
        this.agendaUserSettingsService = agendaUserSettingsService;
        this.reminderStorage = reminderStorage;
        this.eventStorage = eventStorage;
        this.attendeeStorage = attendeeStorage;
        this.listenerService = listenerService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        ValueParam reminderComputingPeriodParam = initParams.getValueParam("period.computing.days");
        if (reminderComputingPeriodParam != null && reminderComputingPeriodParam.getValue() != null) {
            this.reminderComputingPeriod = Long.parseLong(reminderComputingPeriodParam.getValue());
        }
    }

    public List<EventReminder> getEventReminders(long eventId, long userIdentityId) {
        return this.reminderStorage.getEventReminders(eventId, userIdentityId);
    }

    public List<EventReminder> getEventReminders(long eventId) {
        return this.reminderStorage.getEventReminders(eventId);
    }

    public void saveEventReminders(Event event, List<EventReminder> reminders) {
        ZonedDateTime reminderDate;
        boolean isOccurrence;
        long eventId = event.getId();
        boolean isRecurrentEvent = event.getRecurrence() != null;
        boolean bl = isOccurrence = event.getOccurrence() != null && event.getOccurrence().getId() != null;
        if (isOccurrence) {
            ZonedDateTime occurrenceId = event.getOccurrence().getId();
            reminders = reminders.stream().filter(reminder -> !(reminder.getFromOccurrenceId() != null && !reminder.getFromOccurrenceId().isEqual(occurrenceId) && !reminder.getFromOccurrenceId().isBefore(occurrenceId) || reminder.getUntilOccurrenceId() != null && !reminder.getUntilOccurrenceId().isAfter(occurrenceId))).collect(Collectors.toList());
        }
        List<Object> newReminders = reminders == null ? Collections.emptyList() : reminders;
        for (EventReminder eventReminder : newReminders) {
            eventReminder.setEventId(event.getId());
        }
        List<EventReminder> savedReminders = this.getEventReminders(eventId);
        ArrayList<EventReminder> arrayList = new ArrayList<EventReminder>(savedReminders);
        arrayList.removeAll(newReminders);
        ArrayList<Object> remindersToCreate = new ArrayList<Object>(newReminders);
        remindersToCreate.removeAll(savedReminders);
        ArrayList<EventReminder> remindersToUpdate = new ArrayList<EventReminder>(savedReminders);
        remindersToUpdate.removeAll(arrayList);
        remindersToUpdate.removeAll(remindersToCreate);
        if (!remindersToUpdate.isEmpty()) {
            for (EventReminder eventReminder : remindersToUpdate) {
                try {
                    reminderDate = this.computeReminderDateTime(event, eventReminder);
                    eventReminder.setDatetime(reminderDate);
                    if (!isRecurrentEvent) {
                        eventReminder.setFromOccurrenceId(null);
                        eventReminder.setUntilOccurrenceId(null);
                    }
                    this.reminderStorage.saveEventReminder(eventReminder);
                }
                catch (AgendaException e) {
                    LOG.warn("Error updating reminder of event with id {}", new Object[]{event.getId(), e});
                }
            }
        }
        for (EventReminder eventReminder : arrayList) {
            this.reminderStorage.removeEventReminder(eventReminder.getId());
        }
        if (!remindersToCreate.isEmpty()) {
            for (EventReminder eventReminder : remindersToCreate) {
                EventReminder eventReminder2 = eventReminder.clone();
                try {
                    reminderDate = this.computeReminderDateTime(event, eventReminder2);
                    eventReminder2.setDatetime(reminderDate);
                    eventReminder2.setEventId(eventId);
                    if (!isRecurrentEvent) {
                        eventReminder2.setFromOccurrenceId(null);
                        eventReminder2.setUntilOccurrenceId(null);
                    }
                    this.reminderStorage.saveEventReminder(eventReminder2);
                }
                catch (AgendaException e) {
                    LOG.warn("Error creating reminder of event with id {}", new Object[]{event.getId(), e});
                }
            }
        }
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.reminders.saved", eventId, 0);
    }

    public void saveUpcomingEventReminders(long eventId, ZonedDateTime occurrenceId, List<EventReminder> reminders, long identityId) throws AgendaException {
        Event recurringEvent = this.eventStorage.getEventById(eventId);
        if (recurringEvent.getRecurrence() == null) {
            throw new IllegalStateException("event is not recurrent");
        }
        if (reminders == null) {
            reminders = new ArrayList<EventReminder>();
        } else {
            for (EventReminder eventReminder : reminders) {
                eventReminder.setId(0L);
                eventReminder.setEventId(eventId);
                eventReminder.setFromOccurrenceId(occurrenceId);
                eventReminder.setUntilOccurrenceId(null);
            }
            reminders = new ArrayList<EventReminder>(reminders);
        }
        List<Object> existingReminders = this.getEventReminders(eventId);
        existingReminders = existingReminders.stream().filter(reminder -> reminder.getFromOccurrenceId() == null || reminder.getFromOccurrenceId().isBefore(occurrenceId)).collect(Collectors.toList());
        for (EventReminder eventReminder : existingReminders) {
            if (eventReminder.getUntilOccurrenceId() != null && !eventReminder.getUntilOccurrenceId().isAfter(occurrenceId)) continue;
            eventReminder.setUntilOccurrenceId(occurrenceId);
        }
        reminders.addAll(existingReminders);
        this.saveEventReminders(recurringEvent, occurrenceId, reminders, identityId);
    }

    public Set<AgendaEventModificationType> saveEventReminders(Event event, List<EventReminder> reminders, long identityId) throws AgendaException {
        return this.saveEventReminders(event, null, reminders, identityId);
    }

    public void sendReminders() {
        ZonedDateTime currentMinute = ZonedDateTime.now(ZoneOffset.UTC).withNano(0).withSecond(0);
        ZonedDateTime endCurrentMinute = currentMinute.plusMinutes(1L);
        List<EventReminder> reminders = this.reminderStorage.getEventReminders(currentMinute, endCurrentMinute);
        for (EventReminder eventReminder : reminders) {
            Event event = this.eventStorage.getEventById(eventReminder.getEventId());
            Calendar calendar = ((AgendaCalendarService)ExoContainerContext.getService(AgendaCalendarService.class)).getCalendarById(event.getCalendarId());
            if (event.getRecurrence() != null || calendar == null || calendar.isDeleted()) continue;
            this.sendReminderNotification(eventReminder);
        }
    }

    public void removeEventReminders(long eventId) {
        this.reminderStorage.removeEventReminders(eventId);
    }

    public void removeUserReminders(long eventId, long identityId) {
        this.reminderStorage.removeEventReminders(eventId, identityId);
    }

    public long getReminderComputingPeriod() {
        return this.reminderComputingPeriod;
    }

    public void setReminderComputingPeriod(long reminderComputingPeriod) {
        this.reminderComputingPeriod = reminderComputingPeriod;
    }

    private Set<AgendaEventModificationType> saveEventReminders(Event event, ZonedDateTime fromOccurrenceId, List<EventReminder> reminders, long identityId) throws AgendaException {
        ZonedDateTime reminderDate;
        boolean isRecurrentEvent;
        long eventId = event.getId();
        boolean bl = isRecurrentEvent = event.getRecurrence() != null;
        if (event.getStatus() == EventStatus.CANCELLED) {
            reminders = null;
        }
        List<Object> newReminders = reminders == null ? Collections.emptyList() : reminders;
        for (EventReminder eventReminder : newReminders) {
            eventReminder.setEventId(event.getId());
            eventReminder.setReceiverId(identityId);
        }
        List<EventReminder> savedReminders = this.getEventReminders(eventId, identityId);
        ArrayList<EventReminder> arrayList = new ArrayList<EventReminder>(savedReminders);
        arrayList.removeAll(newReminders);
        ArrayList<Object> remindersToCreate = new ArrayList<Object>(newReminders);
        remindersToCreate.removeAll(savedReminders);
        ArrayList<EventReminder> remindersToUpdate = new ArrayList<EventReminder>(savedReminders);
        remindersToUpdate.removeAll(arrayList);
        remindersToUpdate.removeAll(remindersToCreate);
        if (!remindersToUpdate.isEmpty()) {
            for (EventReminder eventReminder : remindersToUpdate) {
                try {
                    reminderDate = this.computeReminderDateTime(event, eventReminder);
                    eventReminder.setDatetime(reminderDate);
                    if (!isRecurrentEvent) {
                        eventReminder.setFromOccurrenceId(null);
                        eventReminder.setUntilOccurrenceId(null);
                    }
                    this.reminderStorage.saveEventReminder(eventReminder);
                }
                catch (AgendaException e) {
                    LOG.warn("Error updating reminder of event with id {}", new Object[]{event.getId(), e});
                }
            }
        }
        for (EventReminder eventReminder : arrayList) {
            this.reminderStorage.removeEventReminder(eventReminder.getId());
        }
        if (!remindersToCreate.isEmpty()) {
            for (EventReminder eventReminder : remindersToCreate) {
                EventReminder eventReminder2 = eventReminder.clone();
                reminderDate = this.computeReminderDateTime(event, eventReminder2);
                eventReminder2.setId(0L);
                eventReminder2.setDatetime(reminderDate);
                eventReminder2.setReceiverId(identityId);
                eventReminder2.setEventId(eventId);
                if (!isRecurrentEvent) {
                    eventReminder2.setFromOccurrenceId(null);
                    eventReminder2.setUntilOccurrenceId(null);
                }
                this.reminderStorage.saveEventReminder(eventReminder2);
            }
        }
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.reminders.saved", eventId, identityId);
        if (isRecurrentEvent) {
            this.saveExceptionalOccurrencesReminders(eventId, fromOccurrenceId, reminders, identityId);
        }
        HashSet<AgendaEventModificationType> reminderModificationTypes = new HashSet<AgendaEventModificationType>();
        if (!arrayList.isEmpty()) {
            reminderModificationTypes.add(AgendaEventModificationType.REMINDER_DELETED);
        }
        if (!remindersToCreate.isEmpty()) {
            reminderModificationTypes.add(AgendaEventModificationType.REMINDER_ADDED);
        }
        return reminderModificationTypes;
    }

    private void saveExceptionalOccurrencesReminders(long eventId, ZonedDateTime fromOccurrenceId, List<EventReminder> reminders, long identityId) throws AgendaException {
        List<Long> exceptionalOccurenceEventIds = this.eventStorage.getExceptionalOccurenceIds(eventId);
        for (long exceptionalOccurenceEventId : exceptionalOccurenceEventIds) {
            EventAttendeeList eventAttendees = this.attendeeStorage.getEventAttendees(exceptionalOccurenceEventId);
            if (!Utils.isEventAttendee(this.identityManager, this.spaceService, identityId, eventAttendees)) continue;
            Event exceptionalOccurrenceEvent = this.eventStorage.getEventById(exceptionalOccurenceEventId);
            ZonedDateTime exceptionalOccurrenceId = exceptionalOccurrenceEvent.getOccurrence().getId();
            if (fromOccurrenceId != null && exceptionalOccurrenceId.isBefore(fromOccurrenceId)) continue;
            List<EventReminder> occurrenceReminders = null;
            if (reminders != null && !reminders.isEmpty()) {
                occurrenceReminders = reminders.stream().filter(reminder -> !(reminder.getFromOccurrenceId() != null && !reminder.getFromOccurrenceId().isEqual(exceptionalOccurrenceId) && !reminder.getFromOccurrenceId().isBefore(exceptionalOccurrenceId) || reminder.getUntilOccurrenceId() != null && !reminder.getUntilOccurrenceId().isAfter(exceptionalOccurrenceId))).collect(Collectors.toList());
                occurrenceReminders.forEach(reminder -> reminder.setId(0L));
            }
            this.saveEventReminders(exceptionalOccurrenceEvent, occurrenceReminders, identityId);
        }
    }

    private ZonedDateTime computeReminderDateTime(Event event, EventReminder eventReminder) throws AgendaException {
        if (event.getStatus() != EventStatus.CONFIRMED) {
            return null;
        }
        ZonedDateTime eventStartDate = event.getStart();
        if (eventReminder.getBefore() < 0 || eventReminder.getBeforePeriodType() == null) {
            throw new AgendaException(AgendaExceptionType.REMINDER_DATE_CANT_COMPUTE);
        }
        if (event.isAllDay()) {
            ZoneId userTimeZone = event.getTimeZoneId();
            AgendaUserSettings userSettings = this.agendaUserSettingsService.getAgendaUserSettings(eventReminder.getReceiverId());
            if (userSettings != null && userSettings.getTimeZoneId() != null) {
                userTimeZone = ZoneId.of(userSettings.getTimeZoneId());
            } else if (userTimeZone == null) {
                userTimeZone = ZoneOffset.UTC;
            }
            eventStartDate = eventStartDate.toLocalDate().atStartOfDay(userTimeZone);
        }
        ZonedDateTime reminderDate = null;
        reminderDate = eventReminder.getBefore() > 0 ? eventStartDate.minus(eventReminder.getBefore(), eventReminder.getBeforePeriodType().getTemporalUnit()).withZoneSameInstant(ZoneOffset.UTC) : eventStartDate;
        return reminderDate;
    }

    private void sendReminderNotification(EventReminder eventReminder) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationUtils.EVENT_AGENDA_REMINDER, (Object)eventReminder);
        NotificationCommand command = ctx.makeCommand(PluginKey.key((String)"EventReminderNotificationPlugin"));
        ctx.getNotificationExecutor().with(command).execute(ctx);
    }
}

