/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Listener;

public class AgendaEventReminderCleanerListener
extends Listener<AgendaEventModification, Object> {
    private AgendaEventReminderService agendaEventReminderService;
    private AgendaEventService agendaEventService;

    public void onEvent(org.exoplatform.services.listener.Event<AgendaEventModification, Object> event) throws Exception {
        long eventId = ((AgendaEventModification)event.getSource()).getEventId();
        Event agendaEvent = this.getAgendaEventService().getEventById(eventId);
        if (agendaEvent != null && agendaEvent.getStatus() == EventStatus.CANCELLED) {
            this.getAgendaEventReminderService().removeEventReminders(eventId);
        }
    }

    public AgendaEventReminderService getAgendaEventReminderService() {
        if (this.agendaEventReminderService == null) {
            this.agendaEventReminderService = (AgendaEventReminderService)ExoContainerContext.getService(AgendaEventReminderService.class);
        }
        return this.agendaEventReminderService;
    }

    public AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)ExoContainerContext.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }
}

