/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.WebSocketMessage;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class AgendaWebSocketService {
    private static final Log LOG = ExoLogger.getLogger(AgendaWebSocketService.class);
    public static final String COMETD_CHANNEL = "/eXo/Application/Addons/Agenda";
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private AgendaCalendarService agendaCalendarService;
    private ContinuationService continuationService;
    private String cometdContextName;

    public AgendaWebSocketService(SpaceService spaceService, IdentityManager identityManager, AgendaCalendarService agendaCalendarService, ContinuationService continuationService, EXoContinuationBayeux continuationBayeux) {
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.agendaCalendarService = agendaCalendarService;
        this.continuationService = continuationService;
        this.cometdContextName = continuationBayeux.getCometdContextName();
    }

    public void sendMessage(String wsEventName, AgendaEventModification eventModification) {
        long calendarId = eventModification.getCalendarId();
        Calendar calendar = this.agendaCalendarService.getCalendarById(calendarId);
        if (calendar == null) {
            LOG.warn((Object)("Calendar with id " + calendarId + " wasn't found"));
            return;
        }
        long ownerId = calendar.getOwnerId();
        Identity identity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (identity == null) {
            LOG.warn((Object)("Identity with id " + ownerId + " wasn't found"));
            return;
        }
        HashSet<String> recipientUsers = new HashSet<String>();
        String remoteId = identity.getRemoteId();
        if (StringUtils.equals((CharSequence)"organization", (CharSequence)identity.getProviderId())) {
            recipientUsers.add(remoteId);
        } else {
            Space space = this.spaceService.getSpaceByPrettyName(remoteId);
            if (space == null) {
                LOG.warn((Object)("Space with pretty name " + remoteId + " wasn't found"));
                return;
            }
            Collections.addAll(recipientUsers, space.getMembers());
        }
        this.sendMessage(wsEventName, recipientUsers, eventModification);
    }

    public void sendMessage(String wsEventName, Collection<String> recipientUsers, Object ... params) {
        WebSocketMessage messageObject = new WebSocketMessage(wsEventName, params);
        this.sendMessage(messageObject, recipientUsers);
    }

    public void sendMessage(WebSocketMessage messageObject, Collection<String> recipientUsers) {
        String message = messageObject.toString();
        for (String recipientUser : recipientUsers) {
            if (!this.continuationService.isPresent(recipientUser)) continue;
            this.continuationService.sendMessage(recipientUser, COMETD_CHANNEL, (Object)message);
        }
    }

    public String getCometdContextName() {
        return this.cometdContextName;
    }

    public String getUserToken(String username) {
        try {
            return this.continuationService.getUserToken(username);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not retrieve continuation token for user " + username), (Throwable)e);
            return "";
        }
    }
}

