/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.notification.builder;

import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Writer;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.model.AgendaUserSettings;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.service.AgendaUserSettingsService;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.Attachment;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AgendaTemplateBuilder
extends AbstractTemplateBuilder {
    private static final Log LOG = ExoLogger.getLogger(AgendaTemplateBuilder.class);
    private AgendaEventService agendaEventService;
    private AgendaEventAttendeeService agendaEventAttendeeService;
    private AgendaUserSettingsService agendaUserSettingsService;
    private SpaceService spaceService;
    private IdentityManager identityManager;
    private TemplateProvider templateProvider;
    private ExoContainer container;
    private boolean isPushNotification;
    private boolean isWebNotification;
    private PluginKey key;

    public AgendaTemplateBuilder(TemplateProvider templateProvider, ExoContainer container, PluginKey key, boolean pushNotification, boolean webNotification) {
        this.templateProvider = templateProvider;
        this.container = container;
        this.isPushNotification = pushNotification;
        this.isWebNotification = webNotification;
        this.key = key;
    }

    public Template getTemplateEngine() {
        String templatePath = null;
        try {
            templatePath = (String)this.templateProvider.getTemplateFilePathConfigs().get(this.key);
            String template = TemplateUtils.loadGroovyTemplate((String)templatePath);
            if (StringUtils.isBlank((CharSequence)template)) {
                LOG.warn("Template not found {}", new Object[]{templatePath});
                return new GStringTemplateEngine().createTemplate("");
            }
            return new GStringTemplateEngine().createTemplate(template);
        }
        catch (Exception e) {
            LOG.warn("Error while compiling template {}", new Object[]{templatePath, e});
            try {
                return new GStringTemplateEngine().createTemplate("");
            }
            catch (Exception e1) {
                LOG.warn((Object)"Error while creating empty template", (Throwable)e1);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            Event event = this.getEvent(notification);
            String eventModificationType = notification.getValueOwnerParameter("EVENT_MODIFICATION_TYPE");
            if (event == null && !StringUtils.equals((CharSequence)eventModificationType, (CharSequence)AgendaEventModificationType.DELETED.name())) {
                MessageInfo messageInfo = null;
                return messageInfo;
            }
            String notificationURL = notification.getValueOwnerParameter("Url");
            if (StringUtils.isBlank((CharSequence)notificationURL)) {
                notificationURL = NotificationUtils.getEventURL(event);
            }
            String pushNotificationURL = this.isPushNotification ? notificationURL : null;
            String username = notification.getTo();
            long identityId = Utils.getIdentityIdByUsername(this.getIdentityManager(), username);
            String modifierIdentityId = notification.getValueOwnerParameter("MODIFIER_IDENTITY_ID");
            if ((this.isPushNotification || this.isWebNotification) && StringUtils.isNotBlank((CharSequence)modifierIdentityId) && modifierIdentityId.equals(String.valueOf(identityId))) {
                MessageInfo messageInfo = null;
                return messageInfo;
            }
            AgendaUserSettings agendaUserSettings = this.getAgendaUserSettingsService().getAgendaUserSettings(identityId);
            ZoneId timeZone = agendaUserSettings != null && agendaUserSettings.getTimeZoneId() != null ? ZoneId.of(agendaUserSettings.getTimeZoneId()) : (event != null ? event.getTimeZoneId() : ZoneOffset.UTC);
            TemplateContext templateContext = NotificationUtils.buildTemplateParameters(username, this.getSpaceService(), this.getAgendaEventAttendeeService(), this.templateProvider, notification, timeZone);
            MessageInfo messageInfo = new MessageInfo();
            if (pushNotificationURL != null) {
                messageInfo.subject(pushNotificationURL);
            } else {
                messageInfo.subject(notification.getValueOwnerParameter("eventTitle"));
            }
            messageInfo.body(TemplateUtils.processGroovy((TemplateContext)templateContext));
            String ownerId = notification.getValueOwnerParameter("ownerId");
            String eventSummary = notification.getValueOwnerParameter("eventTitle");
            String eventDescription = notification.getValueOwnerParameter("eventDescription");
            String startDateRFC3339 = notification.getValueOwnerParameter("startDate");
            String endDateRFC3339 = notification.getValueOwnerParameter("endDate");
            String eventConference = notification.getValueOwnerParameter("conference");
            String eventModifierId = notification.getValueOwnerParameter("MODIFIER_IDENTITY_ID");
            String eventCreator = notification.getValueOwnerParameter("eventCreator");
            String location = notification.getValueOwnerParameter("eventLocation");
            Locale userLocale = Locale.of(Utils.getUserLanguage(notification.getTo()));
            Attachment attachment = new Attachment();
            byte[] icsFileBytes = Utils.generateIcsFile(ownerId, eventSummary, eventDescription, startDateRFC3339, endDateRFC3339, eventConference, eventModifierId, eventCreator, location, userLocale, timeZone);
            attachment.setInputStream((InputStream)new ByteArrayInputStream(icsFileBytes));
            attachment.setMimeType("text/calendar;charset=utf-8;method=PUBLISH");
            attachment.setName("event.ics");
            messageInfo.addAttachment(attachment);
            Throwable exception = templateContext.getException();
            this.logException(notification, exception);
            ctx.setException(exception);
            MessageInfo messageInfo2 = messageInfo;
            return messageInfo2;
        }
        catch (Throwable e) {
            ctx.setException(e);
            this.logException(notification, e);
            MessageInfo messageInfo = null;
            return messageInfo;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
        return false;
    }

    private final Event getEvent(NotificationInfo notification) {
        String eventIdString = notification.getValueOwnerParameter("eventId");
        if (StringUtils.isBlank((CharSequence)eventIdString)) {
            throw new IllegalStateException("Event id is missing in notification");
        }
        long eventId = Long.parseLong(eventIdString);
        if (eventId == 0L) {
            throw new IllegalStateException("Event id is equal to 0 in notification");
        }
        return this.getEventService().getEventById(eventId);
    }

    private void logException(NotificationInfo notification, Throwable e) {
        if (e != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Error building notification content: {}", new Object[]{notification, e});
            } else {
                LOG.warn("Error building notification content: {}, error: {}", new Object[]{notification, e.getMessage()});
            }
        }
    }

    private AgendaEventService getEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)this.container.getComponentInstanceOfType(AgendaEventService.class);
        }
        return this.agendaEventService;
    }

    private AgendaUserSettingsService getAgendaUserSettingsService() {
        if (this.agendaUserSettingsService == null) {
            this.agendaUserSettingsService = (AgendaUserSettingsService)this.container.getComponentInstanceOfType(AgendaUserSettingsService.class);
        }
        return this.agendaUserSettingsService;
    }

    private AgendaEventAttendeeService getAgendaEventAttendeeService() {
        if (this.agendaEventAttendeeService == null) {
            this.agendaEventAttendeeService = (AgendaEventAttendeeService)this.container.getComponentInstanceOfType(AgendaEventAttendeeService.class);
        }
        return this.agendaEventAttendeeService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)this.container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }
}

