/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.notification.pwa;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AgendaNotificationPwaPlugin
implements PwaNotificationPlugin {
    private static final String AGENDA_NOTIFICATION_PLUGIN_NAME = "agenda.notification.plugin.key";
    private static final String TITLE_LABEL_KEY = "pwa.notification.AgendaNotificationPwaPlugin.title";
    private static final Log LOG = ExoLogger.getLogger(AgendaNotificationPwaPlugin.class);
    private String notificationId;
    private ResourceBundleService resourceBundleService;

    public AgendaNotificationPwaPlugin(InitParams initParams, ResourceBundleService resourceBundleService, SpaceService spaceService) {
        this.resourceBundleService = resourceBundleService;
        ValueParam notificationIdParam = initParams.getValueParam(AGENDA_NOTIFICATION_PLUGIN_NAME);
        if (notificationIdParam == null || StringUtils.isBlank((CharSequence)notificationIdParam.getValue())) {
            throw new IllegalStateException("'agenda.notification.plugin.key' parameter is mandatory");
        }
        this.notificationId = notificationIdParam.getValue();
    }

    public String getId() {
        return this.notificationId;
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        Object key = TITLE_LABEL_KEY;
        String type = notification.getValueOwnerParameter("EVENT_MODIFICATION_TYPE");
        String eventStatus = notification.getValueOwnerParameter("eventStatus");
        switch (type) {
            case "ADDED": {
                key = (String)key + ".created";
                break;
            }
            case "DATES_UPDATED": {
                if (eventStatus.equals("CONFIRMED")) {
                    key = (String)key + ".dates.updated";
                    break;
                }
                if (eventStatus.equals("TENTATIVE")) {
                    key = (String)key + ".datePoll.dates.updated";
                    break;
                }
                key = (String)key + ".canceled";
                break;
            }
            case "UPDATED": {
                if (eventStatus.equals("TENTATIVE")) {
                    key = (String)key + ".datePoll.updated";
                    break;
                }
                key = (String)key + ".updated";
                break;
            }
            case "SWITCHED_EVENT_TO_DATE_POLL": {
                key = (String)key + ".switchedToDatePoll";
                break;
            }
            case "SWITCHED_DATE_POLL_TO_EVENT": {
                key = (String)key + ".switchedToEvent";
                break;
            }
            case "DELETED": {
                if (eventStatus.equals("TENTATIVE")) {
                    key = (String)key + ".datePoll.updated";
                    break;
                }
                key = (String)key + ".canceled";
                break;
            }
            default: {
                key = (String)key + ".canceled";
            }
        }
        String title = this.resourceBundleService.getSharedString((String)key, localeConfig.getLocale()).replace("{0}", notification.getValueOwnerParameter("eventTitle"));
        notificationMessage.setTitle(title);
        notificationMessage.setBody(notification.getValueOwnerParameter("eventTitle"));
        String url = notification.getValueOwnerParameter("Url").replace(CommonsUtils.getCurrentDomain(), "");
        notificationMessage.setUrl(url);
        return notificationMessage;
    }
}

